(*  Title: 	pc-ex-class
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1986  University of Cambridge

Predicate Calculus Examples: Classical
*)

(*Commands for single step proof
  expand (resolve_tac [F_elim] 1);
  expand (cl_step_tac 1);
*)

read_goal SetThy "P | ~(P)  [ H ]";
expand class_tac;

read_goal SetThy "(~ Q ==> ~ P)  ==>  (P==>Q)  [ H ]";
expand class_tac;

(*Peirce's law*)
read_goal SetThy "((P==>Q) ==> P)  ==>  P  [ H ]";
expand class_tac;


read_goal SetThy "(P==>Q) | (Q==>P) [ H ]";
expand class_tac;


read_goal SetThy "(P&Q==>R)  <=>  (P==>R) | (Q==>R)  [ H ]";
expand (unfold_goal_tac ["<=>"]);
expand class_tac;
(*3 secs*)



(*Interesting to contrast the constructive and classical proofs*)

read_goal SetThy "(P & Q) & R  <=>  P & (Q & R)  [ H ]";
expand (unfold_goal_tac ["<=>"]);
expand class_tac;  (*2 secs*)


read_goal SetThy "(P | Q) | R  <=>  P | (Q | R)  [ H ]";
expand (unfold_goal_tac ["<=>"]);
expand class_tac;  (*2 secs*)


(* "Dijkstra's Law" *)
read_goal SetThy "((P <=> Q) <=> R)  ==>  (P <=> (Q <=> R))  [H]";
expand (unfold_goal_tac ["<=>"]);
expand F_elim_tac;
expand (REPEAT (cl_step_tac 1));
(*9 secs
    24 ML--spull
    25 ML--matchcopy---PROJFUN
    26 ML--matchcopy---copyargs
    27 ML--matchcopy---copycons
    27 ML--standardize
    28 ML--@@---copy--
    29 ML--elookup
    29 ML--matchcopy---projenv
    31 ML--maps
    38 --long_integer$<
    43 ML--head_norm_dpair
    49 ML--filter_rules---filtr
    52 ML--eta_norm
    55 ML--head_norm
    64 ML--alphaconv
    71 ML--SIMPL0
    75 --long_integer$=
    86 ML--head_norm---hnorm
    93 ML--maps--
    97 ML--matchcopy
   128 ML--xless
   132 ML--fastarity
   146 ML--xsearch
   598 GARBAGE COLLECTION
Total 2626*)




read_goal SetThy "(P ==> Q | R)  <=>  (P==>Q) | (P==>R)  [ H ]";
expand (unfold_goal_tac ["<=>"]);
expand class_tac;
(*3 secs*)



read_goal SetThy "((ALL x.P'(x)) ==> Q)  <=>  (EXISTS x.P'(x)==>Q)  [H]";
expand (unfold_goal_tac ["<=>"]);
expand class_tac;



read_goal SetThy "(P ==> EXISTS x. Q'(x)) \
\            <=>  (EXISTS x. P ==> Q'(x))  [H]";
expand (unfold_goal_tac ["<=>"]);
expand class_tac;  (*2 secs*)


read_goal SetThy "(ALL x.P'(x)) | Q  <=>  (ALL x. P'(x) | Q)  [H]";
expand (unfold_goal_tac ["<=>"]);
expand class_tac;  (*2 secs*)



(*NOT PROVED-- needs double instantiation of existential quantifier*)
read_goal SetThy "EXISTS x. P'(x) ==> P'(a) & P'(b)  [H]";
read_goal SetThy "EXISTS x. P'(x) ==> ALL x. P'(x)  [H]";
expand class_tac;

(*Fallacies*)
read_goal SetThy "P'(?a) ==> ALL x.P'(x)  [H]";
read_goal SetThy "(P'(?a) ==> ALL x.Q'(x)) ==> ALL x. P'(x) ==> Q'(x)  [H]";
