/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Stack;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PositionChanging;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.EnhancedTreeCellRenderer;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.StringList;
import sidekick.AbstractModeOptionPane;
import sidekick.Asset;
import sidekick.FilteredTreeModel;
import sidekick.IAsset;
import sidekick.ModeOptionsDialog;
import sidekick.SideKick;
import sidekick.SideKickParsedData;
import sidekick.SideKickParser;
import sidekick.SideKickPlugin;
import sidekick.SideKickUpdate;

public class SideKickTree
extends JPanel
implements DefaultFocusComponent {
    private RolloverButton parseBtn;
    private Icon parseIcon;
    private Icon stopIcon;
    private JComboBox parserCombo;
    protected JTree tree;
    protected JTextArea status;
    private JPanel topPanel;
    private JSplitPane splitter;
    private boolean statusShowing = false;
    private Buffer lastParsedBuffer = null;
    private JToolBar filterBox;
    protected JPopupMenu configMenu;
    protected JCheckBoxMenuItem onChange;
    protected JCheckBoxMenuItem followCaret;
    protected JCheckBoxMenuItem onSave;
    protected View view;
    private Timer caretTimer;
    protected SideKickParsedData data;
    private int autoExpandTree = 0;
    private JPanel toolBox;
    private JPanel parserPanel = null;
    private JTextField searchField;

    public SideKickTree(View view, boolean docked) {
        super(new BorderLayout());
        this.view = view;
        this.topPanel = new JPanel(new BorderLayout());
        JToolBar buttonBox = new JToolBar();
        buttonBox.setFloatable(false);
        this.filterBox = new JToolBar();
        this.filterBox.setLayout(new BorderLayout());
        this.filterBox.setFloatable(false);
        this.parseIcon = GUIUtilities.loadIcon((String)"Parse.png");
        this.stopIcon = GUIUtilities.loadIcon((String)jEdit.getProperty((String)"hypersearch-results.stop.icon"));
        this.parseBtn = new RolloverButton(this.parseIcon);
        this.parseBtn.setToolTipText(jEdit.getProperty((String)"sidekick-tree.parse"));
        this.parseBtn.setMargin(new Insets(0, 0, 0, 0));
        this.parseBtn.setRequestFocusEnabled(false);
        this.parseBtn.setEnabled(true);
        ActionHandler ah = new ActionHandler();
        this.parseBtn.addActionListener((ActionListener)ah);
        RolloverButton propsBtn = new RolloverButton(GUIUtilities.loadIcon((String)"ButtonProperties.png"));
        propsBtn.setToolTipText(jEdit.getProperty((String)"sidekick-tree.mode-options"));
        propsBtn.addActionListener((ActionListener)new SideKickProperties());
        this.configMenu = new JPopupMenu("Parse");
        this.followCaret = new JCheckBoxMenuItem("Follow Caret");
        this.configMenu.add(this.followCaret);
        JMenuItem item = new JMenuItem("Parse on...");
        item.setEnabled(false);
        this.configMenu.add(item);
        this.onChange = new JCheckBoxMenuItem("Buffer change");
        this.onChange.setState(SideKick.isParseOnChange());
        this.onSave = new JCheckBoxMenuItem("Buffer save");
        this.onSave.setState(SideKick.isParseOnSave());
        this.configMenu.add(this.onChange);
        this.configMenu.add(this.onSave);
        this.parseBtn.setComponentPopupMenu(this.configMenu);
        this.onChange.addActionListener(ah);
        this.onSave.addActionListener(ah);
        this.followCaret.addActionListener(ah);
        JLabel search = new JLabel(jEdit.getProperty((String)"sidekick-tree.filter.label") + " ");
        this.searchField = new JTextField();
        this.searchField.setToolTipText(jEdit.getProperty((String)"sidekick-tree.filter.tooltip"));
        RolloverButton clearSearchBtn = new RolloverButton(GUIUtilities.loadIcon((String)"22x22/actions/edit-clear.png"));
        clearSearchBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SideKickTree.this.searchField.setText("");
                SideKickTree.this.updateFilter();
            }
        });
        clearSearchBtn.setToolTipText(jEdit.getProperty((String)"sidekick-tree.clear-filter.tooltip"));
        buttonBox.add((Component)this.parseBtn);
        buttonBox.add((Component)propsBtn);
        this.filterBox.add((Component)search, "West");
        this.filterBox.add((Component)this.searchField, "Center");
        this.filterBox.add((Component)clearSearchBtn, "East");
        buttonBox.add(Box.createGlue());
        this.parserCombo = new JComboBox();
        this.reloadParserCombo();
        this.parserCombo.setToolTipText(jEdit.getProperty((String)"sidekick-tree.parsercombo.tooltip"));
        buttonBox.add(this.parserCombo);
        this.parserCombo.addActionListener(ah);
        this.parserCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SideKickTree.this.searchField.setText("");
                SideKickTree.this.updateFilter();
            }
        });
        this.toolBox = new JPanel(new BorderLayout());
        this.toolBox.add("North", buttonBox);
        this.toolBox.add("South", this.filterBox);
        this.topPanel.add("North", this.toolBox);
        TreeModel emptyModel = new DefaultTreeModel(new DefaultMutableTreeNode(null));
        emptyModel = new FilteredTreeModel((DefaultTreeModel)emptyModel, true);
        this.tree = this.buildTree(emptyModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        KeyHandler kh = new KeyHandler();
        this.tree.addKeyListener(kh);
        if (docked) {
            this.tree.addMouseMotionListener(new MouseHandler());
        }
        this.searchField.addKeyListener(kh);
        if (!OperatingSystem.isMacOSLF()) {
            this.tree.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.tree.setVisibleRowCount(10);
        this.tree.setCellRenderer((TreeCellRenderer)((Object)new Renderer()));
        this.topPanel.add("Center", new JScrollPane(this.tree));
        this.status = new JTextArea();
        this.status.setEditable(false);
        this.status.setBackground(jEdit.getColorProperty((String)"view.bgColor"));
        this.status.setForeground(jEdit.getColorProperty((String)"view.fgColor"));
        this.status.setFont(view.getEditPane().getTextArea().getPainter().getFont());
        JScrollPane status_scroller = new JScrollPane(this.status);
        this.splitter = new JSplitPane(0, false, this.topPanel, status_scroller);
        status_scroller.setMinimumSize(new Dimension(0, 30));
        this.splitter.setOneTouchExpandable(true);
        this.splitter.setResizeWeight(1.0);
        int location = this.splitter.getSize().height - this.splitter.getInsets().bottom - this.splitter.getDividerSize() - status_scroller.getMinimumSize().height;
        location = jEdit.getIntegerProperty((String)"sidekick.splitter.location", (int)location);
        this.splitter.setDividerLocation(location);
        this.propertiesChanged();
        CaretHandler caretListener = new CaretHandler();
        EditPane[] editPanes = view.getEditPanes();
        for (int i = 0; i < editPanes.length; ++i) {
            JEditTextArea textArea = editPanes[i].getTextArea();
            textArea.putClientProperty(CaretHandler.class, (Object)caretListener);
            textArea.addCaretListener((CaretListener)caretListener);
        }
        this.update();
    }

    public void showStopButton(final boolean show) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (show && SideKickTree.this.parseIcon.equals(SideKickTree.this.parseBtn.getIcon())) {
                    SideKickTree.this.parseBtn.setToolTipText(jEdit.getProperty((String)"sidekick-tree.stop-parsing"));
                    SideKickTree.this.parseBtn.setIcon(SideKickTree.this.stopIcon);
                } else {
                    SideKickTree.this.parseBtn.setToolTipText(jEdit.getProperty((String)"sidekick-tree.parse"));
                    SideKickTree.this.parseBtn.setIcon(SideKickTree.this.parseIcon);
                }
            }
        });
    }

    public void focusOnDefaultComponent() {
        this.tree.requestFocusInWindow();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        EditBus.addToBus((Object)this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus((Object)this);
    }

    protected void selectPath(TreePath path) {
        this.tree.setSelectionPath(path);
        Rectangle r = this.tree.getPathBounds(path);
        if (r != null) {
            r.width = 1;
            this.tree.scrollRectToVisible(r);
        }
    }

    @EditBus.EBHandler
    public void handleEditPaneUpdate(EditPaneUpdate epu) {
        EditPane editPane = epu.getEditPane();
        if (epu.getWhat() == EditPaneUpdate.CREATED) {
            CaretHandler listener = new CaretHandler();
            JEditTextArea textArea = editPane.getTextArea();
            textArea.putClientProperty(CaretHandler.class, (Object)listener);
            textArea.addCaretListener((CaretListener)listener);
        }
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged msg) {
        this.propertiesChanged();
    }

    @EditBus.EBHandler
    public void handleSideKickUpdate(SideKickUpdate msg) {
        if (msg.getView() == this.view) {
            this.update();
        }
    }

    public void setStatus(String msg) {
        this.status.setText(msg);
    }

    protected void addData(Object obj, Stack<String> keys) {
        if (obj instanceof DefaultMutableTreeNode) {
            FilteredTreeModel model;
            String cur_key;
            DefaultMutableTreeNode node;
            block8: {
                node = (DefaultMutableTreeNode)obj;
                cur_key = "";
                model = (FilteredTreeModel)this.tree.getModel();
                try {
                    Asset a = (Asset)node.getUserObject();
                    if (a != null) {
                        cur_key = a.getName();
                    }
                }
                catch (ClassCastException ex) {
                    if (node.toString() == null) break block8;
                    cur_key = node.toString();
                }
            }
            keys.push(cur_key);
            if (model.isLeaf(node)) {
                for (String key : keys) {
                    model.addSearchKey(node, key);
                }
            }
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                this.addData(e.nextElement(), keys);
            }
            keys.pop();
        } else {
            Log.log((int)1, (Object)this, (Object)"addData called on a node that isn't a treenode!!!!!!!!!");
        }
    }

    protected void updateSearchData() {
        FilteredTreeModel model = (FilteredTreeModel)this.tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        this.addData(root, new Stack<String>());
    }

    protected void update() {
        Object item;
        this.onChange.setState(SideKick.isParseOnChange());
        this.onSave.setState(SideKick.isParseOnSave());
        Buffer parsedBuffer = this.view.getBuffer();
        SideKickParser parser = SideKickPlugin.getParserForBuffer(parsedBuffer);
        if (parser != null && (item = this.parserCombo.getSelectedItem()) != parser.getName()) {
            this.parserCombo.setSelectedItem(parser.getName());
        }
        this.data = SideKickParsedData.getParsedData(this.view);
        if (parser == null || this.data == null) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode(parsedBuffer.getName());
            root.insert(new DefaultMutableTreeNode(jEdit.getProperty((String)"sidekick-tree.not-parsed")), 0);
            this.tree.setModel(new FilteredTreeModel(new DefaultTreeModel(root), true));
            this.lastParsedBuffer = null;
        } else {
            this.tree.setModel(new FilteredTreeModel(this.data.tree, true));
            this.lastParsedBuffer = parsedBuffer;
            if (SideKick.isFollowCaret()) {
                this.expandTreeAt(this.view.getTextArea().getCaretPosition());
            }
        }
        this.updateSearchData();
        if (this.data != null && this.data.expansionModel != null) {
            for (int i = this.tree.getRowCount() - 1; i >= 0; --i) {
                this.tree.collapseRow(i);
            }
            for (Integer row : this.data.expansionModel) {
                this.tree.expandRow(row);
            }
        } else if (this.autoExpandTree == -1) {
            this.expandAll(true);
        } else if (this.autoExpandTree == 0) {
            this.expandAll(false);
        } else if (this.autoExpandTree > 0) {
            this.tree.expandRow(0);
            for (int i = 1; i < this.autoExpandTree; ++i) {
                for (int j = this.tree.getRowCount() - 1; j > 0; --j) {
                    this.tree.expandRow(j);
                }
            }
        }
        if (this.searchField.getText().length() != 0) {
            this.updateFilter();
        }
    }

    public void expandAll(boolean expand) {
        TreeNode root = (TreeNode)this.tree.getModel().getRoot();
        this.expandAll(new TreePath(root), expand);
    }

    private void expandAll(final TreePath parent, final boolean expand) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeNode node = (TreeNode)parent.getLastPathComponent();
                if (node.getChildCount() >= 0) {
                    Enumeration<? extends TreeNode> e = node.children();
                    while (e.hasMoreElements()) {
                        TreeNode n = e.nextElement();
                        TreePath path = parent.pathByAddingChild(n);
                        SideKickTree.this.expandAll(path, expand);
                    }
                }
                if (expand) {
                    SideKickTree.this.tree.expandPath(parent);
                } else {
                    SideKickTree.this.tree.collapsePath(parent);
                }
            }
        });
    }

    protected JTree buildTree(TreeModel model) {
        return new CustomTree(model);
    }

    protected ActionListener buildActionListener() {
        return new ActionHandler();
    }

    protected void propertiesChanged() {
        this.followCaret.setSelected(SideKick.isFollowCaret());
        Mode m = this.view.getBuffer().getMode();
        String mode = m != null ? m.getName() : null;
        this.autoExpandTree = AbstractModeOptionPane.getIntegerProperty(mode, "sidekick-tree.auto-expand-tree-depth", 1);
        if (AbstractModeOptionPane.getBooleanProperty(mode, "sidekick.showStatusWindow.label")) {
            if (!this.statusShowing) {
                this.remove(this.topPanel);
                this.splitter.setTopComponent(this.topPanel);
                this.add(this.splitter);
            }
            this.statusShowing = true;
        } else {
            this.remove(this.splitter);
            this.splitter.remove(this.topPanel);
            this.add(this.topPanel);
            this.statusShowing = false;
        }
        final boolean showFilter = jEdit.getBooleanProperty((String)"sidekick.showFilter", (boolean)true);
        if (showFilter != this.filterBox.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SideKickTree.this.filterBox.setVisible(showFilter);
                    SideKickTree.this.searchField.setEnabled(showFilter);
                }
            });
        }
    }

    public static StringList parserList() {
        Object[] serviceNames = ServiceManager.getServiceNames((String)"sidekick.SideKickParser");
        Arrays.sort(serviceNames, new StandardUtilities.StringCompare(true));
        StringList sl = new StringList();
        sl.add((Object)"None");
        sl.add((Object)"default parser");
        sl.addAll(serviceNames);
        return sl;
    }

    void reloadParserCombo() {
        this.parserCombo.setModel(new DefaultComboBoxModel<String>(SideKickTree.parserList().toArray()));
        SideKickParser currentParser = SideKickPlugin.getParserForBuffer(this.view.getBuffer());
        if (currentParser != null) {
            String name = currentParser.getName();
            if (name == null) {
                name = "default parser";
            }
            this.parserCombo.setSelectedItem(name);
        } else {
            String pp = this.view.getBuffer().getStringProperty("sidekick.parser");
            if (pp == "None") {
                this.parserCombo.setSelectedItem("None");
            } else {
                this.parserCombo.setSelectedItem("default parser");
            }
        }
    }

    void addParserPanel(SideKickParser parser) {
        JPanel newParserPanel = parser.getPanel();
        boolean returnFocusToSearchField = this.searchField.hasFocus();
        if (newParserPanel != this.parserPanel) {
            if (this.parserPanel != null) {
                this.toolBox.remove(this.parserPanel);
                this.parserPanel = null;
            }
            if (newParserPanel != null) {
                this.toolBox.add("West", newParserPanel);
                this.parserPanel = newParserPanel;
            }
        }
        if (returnFocusToSearchField) {
            this.focusOnDefaultComponent();
        }
    }

    void removeParserPanel() {
        if (this.parserPanel != null) {
            this.toolBox.remove(this.parserPanel);
            this.parserPanel = null;
        }
    }

    protected void expandTreeWithDelay() {
        if (this.caretTimer != null) {
            this.caretTimer.stop();
        } else {
            this.caretTimer = new Timer(0, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int caret;
                    JEditTextArea textArea;
                    Selection s;
                    if (!jEdit.getBooleanProperty((String)"sidekick.persistentFilter") && SideKickTree.this.searchField.getText().length() > 0) {
                        SideKickTree.this.searchField.setText("");
                        SideKickTree.this.updateFilter(false);
                    }
                    SideKickTree.this.expandTreeAt((s = (textArea = SideKickTree.this.view.getTextArea()).getSelectionAtOffset(caret = textArea.getCaretPosition())) == null ? caret : s.getStart());
                }
            });
            this.caretTimer.setInitialDelay(500);
            this.caretTimer.setRepeats(false);
        }
        this.caretTimer.start();
    }

    protected void expandTreeAt(int dot) {
        if (this.data == null) {
            return;
        }
        TreePath treePath = this.data.getTreePathForPosition(dot);
        if (treePath != null) {
            this.tree.expandPath(treePath);
            this.tree.setSelectionPath(treePath);
            if (jEdit.getBooleanProperty((String)"sidekick.scrollToVisible")) {
                Rectangle r = this.tree.getPathBounds(treePath);
                if (r != null) {
                    r.width = 1;
                    this.tree.scrollRectToVisible(r);
                } else {
                    this.tree.scrollPathToVisible(treePath);
                }
            }
        }
    }

    protected void expandCurrentNode() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        TreePath path = new TreePath(node.getPath());
        this.tree.expandPath(path);
    }

    protected void collapseCurrentNode() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        TreePath path = new TreePath(node.getPath());
        this.tree.collapsePath(path);
    }

    protected void find_visible_nodes(HashSet<TreePath> set, DefaultMutableTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        if (this.tree.isVisible(path) && this.tree.isExpanded(path)) {
            set.add(new TreePath(node.getPath()));
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                this.find_visible_nodes(set, (DefaultMutableTreeNode)e.nextElement());
            }
        }
    }

    protected void filter_visible_nodes(FilteredTreeModel model, HashSet<TreePath> visible, DefaultMutableTreeNode node) {
        if (!jEdit.getBooleanProperty((String)"sidekick.showFilter")) {
            return;
        }
        TreePath path = new TreePath(node.getPath());
        if (!visible.contains(path)) {
            return;
        }
        this.tree.expandPath(path);
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            this.filter_visible_nodes(model, visible, (DefaultMutableTreeNode)e.nextElement());
        }
    }

    public void updateFilter(boolean with_delay) {
        if (!jEdit.getBooleanProperty((String)"sidekick.showFilter")) {
            return;
        }
        FilteredTreeModel ftm = (FilteredTreeModel)this.tree.getModel();
        if (this.searchField.getText().length() == 0) {
            ftm.clearFilter();
            ftm.reset();
            if (this.autoExpandTree == -1) {
                this.expandAll(true);
            } else if (this.autoExpandTree == 0) {
                this.expandAll(false);
            } else if (this.autoExpandTree > 0) {
                this.tree.expandRow(0);
                for (int i = 1; i < this.autoExpandTree; ++i) {
                    for (int j = this.tree.getRowCount() - 1; j > 0; --j) {
                        this.tree.expandRow(j);
                    }
                }
            }
            if (SideKick.isFollowCaret() && with_delay) {
                this.expandTreeWithDelay();
            }
        } else {
            HashSet<TreePath> visible = new HashSet<TreePath>();
            this.find_visible_nodes(visible, (DefaultMutableTreeNode)ftm.getRoot());
            ftm.filterByText(this.searchField.getText());
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)ftm.getRoot();
            if (jEdit.getBooleanProperty((String)"sidekick.filter-visible-assets")) {
                this.filter_visible_nodes(ftm, visible, root);
            } else {
                this.expandAll(true);
            }
        }
    }

    public void updateFilter() {
        this.updateFilter(true);
    }

    public void setSearchFilter(String text) {
        this.searchField.setText(text);
        this.updateFilter();
    }

    public String getSearchFilter() {
        return this.searchField.getText();
    }

    class Renderer
    extends EnhancedTreeCellRenderer {
        Renderer() {
        }

        protected void configureTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object nodeValue = node.getUserObject();
            if (nodeValue instanceof IAsset) {
                IAsset asset = (IAsset)node.getUserObject();
                this.setText(asset.getShortString());
                this.setIcon(asset.getIcon());
            } else if (node.getParent() == null) {
                this.setIcon(FileCellRenderer.fileIcon);
            } else {
                this.setIcon(null);
            }
        }

        protected TreeCellRenderer newInstance() {
            return new Renderer();
        }
    }

    class SideKickProperties
    implements ActionListener {
        SideKickProperties() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                new ModeOptionsDialog(SideKickTree.this.view);
            }
            catch (Exception ex) {
                Log.log((int)9, (Object)this, (Object)"dialog create failed", (Throwable)ex);
            }
        }
    }

    class MouseHandler
    extends MouseMotionAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            TreePath path = SideKickTree.this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (path == null) {
                SideKickTree.this.view.getStatus().setMessage(null);
            } else {
                Object value = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                if (value instanceof IAsset) {
                    String info = ((IAsset)value).getShortString();
                    SideKickTree.this.view.getStatus().setMessage(info);
                }
            }
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        protected void next() {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)SideKickTree.this.tree.getLastSelectedPathComponent();
            FilteredTreeModel model = (FilteredTreeModel)SideKickTree.this.tree.getModel();
            if (node == null) {
                node = (DefaultMutableTreeNode)model.getRoot();
            }
            if (node.getChildCount() > 0) {
                DefaultMutableTreeNode firstChild = (DefaultMutableTreeNode)node.getFirstChild();
                TreePath path = new TreePath(firstChild.getPath());
                node = SideKickTree.this.tree.isVisible(path) ? firstChild : node.getNextSibling();
            } else {
                DefaultMutableTreeNode next = node.getNextSibling();
                if (next == null) {
                    next = ((DefaultMutableTreeNode)node.getParent()).getNextSibling();
                }
                node = next;
            }
            if (node != null) {
                TreePath p = new TreePath(node.getPath());
                SideKickTree.this.selectPath(p);
            }
        }

        protected void nextLeaf() {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)SideKickTree.this.tree.getLastSelectedPathComponent();
            FilteredTreeModel model = (FilteredTreeModel)SideKickTree.this.tree.getModel();
            if (node == null) {
                node = (DefaultMutableTreeNode)model.getRoot();
            }
            if (model.isLeaf(node)) {
                node = node.getNextLeaf();
            } else {
                Enumeration<TreeNode> e = node.depthFirstEnumeration();
                node = (DefaultMutableTreeNode)e.nextElement();
            }
            if (node != null) {
                while (!(node == null || model.isVisible(node) && SideKickTree.this.tree.isVisible(new TreePath(node.getPath())))) {
                    node = node.getNextLeaf();
                }
                if (node != null) {
                    TreePath p = new TreePath(node.getPath());
                    SideKickTree.this.selectPath(p);
                }
            }
        }

        protected void prev() {
            DefaultMutableTreeNode lastChild;
            TreePath path;
            DefaultMutableTreeNode prev;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)SideKickTree.this.tree.getLastSelectedPathComponent();
            FilteredTreeModel model = (FilteredTreeModel)SideKickTree.this.tree.getModel();
            if (node == null) {
                node = (DefaultMutableTreeNode)model.getRoot();
            }
            node = (prev = node.getPreviousSibling()) == null ? (DefaultMutableTreeNode)node.getParent() : (prev.getChildCount() > 0 ? (SideKickTree.this.tree.isVisible(path = new TreePath((lastChild = (DefaultMutableTreeNode)prev.getLastChild()).getPath())) ? lastChild : prev) : prev);
            if (node != null) {
                TreePath p = new TreePath(node.getPath());
                SideKickTree.this.selectPath(p);
            }
        }

        protected void prevLeaf() {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)SideKickTree.this.tree.getLastSelectedPathComponent();
            FilteredTreeModel model = (FilteredTreeModel)SideKickTree.this.tree.getModel();
            if (node == null) {
                node = (DefaultMutableTreeNode)model.getRoot();
            }
            if (!model.isLeaf(node)) {
                Enumeration<TreeNode> e = node.depthFirstEnumeration();
                node = (DefaultMutableTreeNode)e.nextElement();
            }
            if ((node = node.getPreviousLeaf()) != null) {
                while (!(node == null || model.isVisible(node) && SideKickTree.this.tree.isVisible(new TreePath(node.getPath())))) {
                    node = node.getPreviousLeaf();
                }
                if (node != null) {
                    TreePath p = new TreePath(node.getPath());
                    SideKickTree.this.selectPath(p);
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (SideKickTree.this.caretTimer != null) {
                SideKickTree.this.caretTimer.stop();
            }
            switch (evt.getKeyCode()) {
                case 27: {
                    evt.consume();
                    if (SideKickTree.this.searchField.getText().length() == 0) {
                        SideKickTree.this.view.getDockableWindowManager().hideDockableWindow("sidekick-tree");
                        break;
                    }
                    SideKickTree.this.searchField.setText("");
                    SideKickTree.this.updateFilter();
                    break;
                }
                case 10: {
                    Object value;
                    evt.consume();
                    TreePath path = SideKickTree.this.tree.getSelectionPath();
                    if (path == null || !((value = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof IAsset)) break;
                    IAsset asset = (IAsset)value;
                    JEditTextArea textArea = SideKickTree.this.view.getTextArea();
                    if (evt.isShiftDown()) {
                        textArea.setCaretPosition(asset.getEnd().getOffset());
                        textArea.addToSelection((Selection)new Selection.Range(asset.getStart().getOffset(), asset.getEnd().getOffset() + 1));
                        break;
                    }
                    if (!jEdit.getBooleanProperty((String)"sidekick.persistentFilter") && SideKickTree.this.searchField.getText().length() > 0) {
                        SideKickTree.this.searchField.setText("");
                        SideKickTree.this.updateFilter();
                    }
                    textArea.setCaretPosition(asset.getStart().getOffset());
                    SideKickTree.this.selectPath(path);
                    textArea.requestFocus();
                    break;
                }
                case 8: {
                    evt.consume();
                    if (SideKickTree.this.searchField.getText().length() <= 1) {
                        SideKickTree.this.searchField.setText("");
                    } else {
                        String s = SideKickTree.this.searchField.getText();
                        s = s.substring(0, s.length() - 1);
                        SideKickTree.this.searchField.setText(s);
                    }
                    SideKickTree.this.updateFilter();
                    break;
                }
                case 40: {
                    evt.consume();
                    if (evt.isControlDown()) {
                        this.nextLeaf();
                        break;
                    }
                    this.next();
                    break;
                }
                case 38: {
                    evt.consume();
                    if (evt.isControlDown()) {
                        this.prevLeaf();
                        break;
                    }
                    this.prev();
                    break;
                }
                case 37: {
                    SideKickTree.this.collapseCurrentNode();
                    break;
                }
                case 39: {
                    SideKickTree.this.expandCurrentNode();
                    break;
                }
                case 33: {
                    evt.consume();
                    int offset = SideKickTree.this.tree.getScrollableUnitIncrement(SideKickTree.this.tree.getParent().getBounds(), 1, 0);
                    for (int i = 0; i < offset; ++i) {
                        if (evt.isControlDown()) {
                            this.prevLeaf();
                            continue;
                        }
                        this.prev();
                    }
                    break;
                }
                case 34: {
                    evt.consume();
                    int offset = SideKickTree.this.tree.getScrollableUnitIncrement(SideKickTree.this.tree.getParent().getBounds(), 1, 0);
                    for (int i = 0; i < offset; ++i) {
                        if (evt.isControlDown()) {
                            this.nextLeaf();
                            continue;
                        }
                        this.next();
                    }
                    break;
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent evt) {
            Character c = Character.valueOf(evt.getKeyChar());
            if (Character.isLetterOrDigit(c.charValue()) || " _!@$%^&*()_+-=[]{};':\",.<>/?\\|".indexOf(c.charValue()) != -1) {
                evt.consume();
                SideKickTree.this.searchField.setText(SideKickTree.this.searchField.getText() + c);
                SideKickTree.this.updateFilter();
            }
        }
    }

    class CaretHandler
    implements CaretListener {
        CaretHandler() {
        }

        @Override
        public void caretUpdate(CaretEvent evt) {
            if (!SideKickTree.this.view.getBuffer().equals(SideKickTree.this.lastParsedBuffer)) {
                return;
            }
            if (evt.getSource() == SideKickTree.this.view.getTextArea() && SideKick.isFollowCaret()) {
                SideKickTree.this.expandTreeWithDelay();
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        int level = 0;

        ActionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            ActionHandler actionHandler = this;
            synchronized (actionHandler) {
                if (evt.getSource() == SideKickTree.this.parseBtn) {
                    this.level = 0;
                }
                ++this.level;
                if (this.level > 1) {
                    --this.level;
                    return;
                }
            }
            Buffer b = SideKickTree.this.view.getBuffer();
            jEdit.setIntegerProperty((String)"sidekick.splitter.location", (int)SideKickTree.this.splitter.getDividerLocation());
            if (evt.getSource() == SideKickTree.this.onSave) {
                SideKick.setParseOnSave(SideKickTree.this.onSave.isSelected());
                SideKickTree.this.propertiesChanged();
            }
            if (evt.getSource() == SideKickTree.this.followCaret) {
                boolean v = SideKickTree.this.followCaret.isSelected();
                SideKick.setGlobalFollowCaret(SideKickTree.this.followCaret.isSelected());
                if (v) {
                    SideKickTree.this.onChange.setSelected(true);
                }
                SideKickTree.this.propertiesChanged();
            } else if (evt.getSource() == SideKickTree.this.onChange) {
                boolean v = SideKickTree.this.onChange.isSelected();
                SideKick.setParseOnChange(v);
                if (!v) {
                    SideKickTree.this.followCaret.setSelected(false);
                }
                SideKickTree.this.propertiesChanged();
            } else if (evt.getSource() == SideKickTree.this.parserCombo) {
                Object selectedParser = SideKickTree.this.parserCombo.getSelectedItem();
                if (selectedParser.toString().equals("None")) {
                    b.setProperty("usermode", (Object)Boolean.TRUE);
                    SideKickPlugin.setParserForBuffer(b, selectedParser.toString());
                } else if (selectedParser.toString().equals("default parser")) {
                    b = SideKickTree.this.view.getBuffer();
                    b.setProperty("usermode", (Object)Boolean.FALSE);
                    Mode m = b.getMode();
                    if (m == null) {
                        Log.log((int)9, (Object)this, (Object)("SideKick: can't determine mode of current buffer:" + b));
                    } else {
                        SideKickParser newParser = SideKickPlugin.getParserForMode(m);
                        if (newParser == null) {
                            SideKickPlugin.setParserForBuffer(b, "None");
                        } else {
                            SideKickPlugin.setParserForBuffer(b, newParser.getName());
                        }
                    }
                } else {
                    SideKickPlugin.setParserForBuffer(b, selectedParser.toString());
                    b.setProperty("usermode", (Object)Boolean.TRUE);
                }
                SideKickTree.this.propertiesChanged();
            } else if (evt.getSource() == SideKickTree.this.parseBtn && SideKickTree.this.stopIcon.equals(SideKickTree.this.parseBtn.getIcon())) {
                SideKickPlugin.stop(SideKickTree.this.view);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SideKickTree.this.parseBtn.setIcon(SideKickTree.this.parseIcon);
                        SideKickTree.this.parseBtn.setToolTipText(jEdit.getProperty((String)"sidekick-tree.parse"));
                    }
                });
            }
            if (evt.getSource() == SideKickTree.this.parseBtn || evt.getSource() == SideKickTree.this.parserCombo) {
                if (evt.getSource() == SideKickTree.this.parseBtn) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SideKickTree.this.parseBtn.setIcon(SideKickTree.this.stopIcon);
                            SideKickTree.this.parseBtn.setToolTipText(jEdit.getProperty((String)"sidekick-tree.stop-parsing"));
                        }
                    });
                }
                this.level = 0;
                Object usermode = b.getProperty((Object)"usermode");
                if (usermode == null || usermode == Boolean.FALSE) {
                    SideKickParser sp = SideKickPlugin.getParserForBuffer(b);
                    if (sp == null) {
                        return;
                    }
                    SideKickTree.this.reloadParserCombo();
                }
                SideKickPlugin.parse(SideKickTree.this.view, true);
            }
            --this.level;
        }
    }

    protected class CustomTree
    extends JTree {
        protected CustomTree(TreeModel model) {
            super(model);
        }

        @Override
        public Enumeration<TreePath> getExpandedDescendants(TreePath parent) {
            return null;
        }

        @Override
        protected void processMouseEvent(MouseEvent evt) {
            switch (evt.getID()) {
                case 501: {
                    TreePath path = this.getPathForLocation(evt.getX(), evt.getY());
                    if (path != null) {
                        Object value = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                        if (value instanceof IAsset) {
                            IAsset asset = (IAsset)value;
                            JEditTextArea textArea = SideKickTree.this.view.getTextArea();
                            EditPane editPane = SideKickTree.this.view.getEditPane();
                            if (evt.getClickCount() == 2) {
                                this.doubleClicked(SideKickTree.this.view, asset, path);
                            } else if (evt.isShiftDown()) {
                                this.shiftClick(SideKickTree.this.view, asset, path);
                            } else if (evt.isControlDown()) {
                                this.controlClick(SideKickTree.this.view, asset, path);
                            } else {
                                EditBus.send((EBMessage)new PositionChanging(editPane));
                                textArea.setCaretPosition(asset.getStart().getOffset());
                            }
                        }
                        if (!jEdit.getBooleanProperty((String)"sidekick.persistentFilter") && SideKickTree.this.searchField.getText().length() > 0) {
                            SideKickTree.this.searchField.setText("");
                            SideKickTree.this.updateFilter(false);
                        }
                    }
                    super.processMouseEvent(evt);
                    SideKickTree.this.searchField.requestFocusInWindow();
                    if (path == null) break;
                    SideKickTree.this.selectPath(path);
                    break;
                }
                case 505: {
                    SideKickTree.this.view.getStatus().setMessage(null);
                    super.processMouseEvent(evt);
                    break;
                }
                default: {
                    super.processMouseEvent(evt);
                }
            }
        }

        protected void doubleClicked(View view, IAsset asset, TreePath path) {
        }

        protected void shiftClick(View view, IAsset asset, TreePath path) {
            JEditTextArea textArea = view.getTextArea();
            textArea.setCaretPosition(asset.getEnd().getOffset());
            Selection.Range range = new Selection.Range(asset.getStart().getOffset(), asset.getEnd().getOffset());
            textArea.addToSelection((Selection)range);
        }

        protected void controlClick(View view, IAsset asset, TreePath path) {
            JEditTextArea textArea = view.getTextArea();
            textArea.getDisplayManager().narrow(textArea.getLineOfOffset(asset.getStart().getOffset()), textArea.getLineOfOffset(asset.getEnd().getOffset()));
        }
    }
}

