/*
 * Decompiled with CFR 0.152.
 */
package code2html.line;

public class LineWrapper {
    private int wrapSize = 72;

    public LineWrapper() {
        this(72);
    }

    public LineWrapper(int wrapSize) {
        if (wrapSize > 0) {
            this.wrapSize = wrapSize;
        }
    }

    public int getWrapSize() {
        return this.wrapSize;
    }

    public int[] wrap(int pos, int len) {
        int min = pos / this.wrapSize + 1;
        int max = (pos + len) / this.wrapSize;
        if ((pos + len) % this.wrapSize == 0) {
            --max;
        }
        if (min <= max) {
            int[] wrapArr = new int[max - min + 1 + 2];
            int wrapIdx = 0;
            int i = min;
            int idx = i * this.wrapSize - pos;
            wrapArr[wrapIdx++] = 0;
            while (i <= max) {
                wrapArr[wrapIdx++] = idx;
                ++i;
                idx += this.wrapSize;
            }
            wrapArr[wrapIdx++] = len;
            return wrapArr;
        }
        return null;
    }
}

