/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import isabelle.File$;
import isabelle.Isabelle_System$;
import isabelle.Library$;
import isabelle.Path;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.jfree.chart.JFreeChart;
import scala.Function1;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichFloat$;

public final class Graphics_File$ {
    public static Graphics_File$ MODULE$;

    static {
        new Graphics_File$();
    }

    public void write_png(File file, Function1<Graphics2D, BoxedUnit> paint, int width, int height, int dpi) {
        float scale = (float)dpi / 72.0f;
        int w = RichFloat$.MODULE$.round$extension(Predef$.MODULE$.floatWrapper((float)width * scale));
        int h = RichFloat$.MODULE$.round$extension(Predef$.MODULE$.floatWrapper((float)height * scale));
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics2D gfx = img.createGraphics();
        try {
            gfx.scale(scale, scale);
            paint.apply((Object)gfx);
            ImageIO.write((RenderedImage)img, "png", file);
        }
        finally {
            gfx.dispose();
        }
    }

    public int write_png$default$5() {
        return 72;
    }

    /*
     * WARNING - void declaration
     */
    private FontMapper font_mapper() {
        void var1_1;
        DefaultFontMapper mapper = new DefaultFontMapper();
        Isabelle_System$.MODULE$.fonts(Isabelle_System$.MODULE$.fonts$default$1()).foreach((Function1 & Serializable & scala.Serializable)font -> {
            Graphics_File$.$anonfun$font_mapper$1(mapper, font);
            return BoxedUnit.UNIT;
        });
        return var1_1;
    }

    public void write_pdf(File file, Function1<Graphics2D, BoxedUnit> paint, int width, int height) {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
             Document document = new Document();){
            document.setPageSize(new Rectangle((float)width, (float)height));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)out);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            Graphics2D gfx = tp.createGraphics((float)width, (float)height, this.font_mapper());
            paint.apply((Object)gfx);
            gfx.dispose();
            cb.addTemplate(tp, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
    }

    public void paint_chart(Graphics2D gfx, JFreeChart chart, int width, int height) {
        chart.draw(gfx, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, width, height));
    }

    public void write_chart_png(File file, JFreeChart chart, int width, int height) {
        this.write_png(file, (Function1<Graphics2D, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            Graphics_File$.MODULE$.paint_chart(x$1, chart, width, height);
            return BoxedUnit.UNIT;
        }, width, height, this.write_png$default$5());
    }

    public void write_chart_pdf(File file, JFreeChart chart, int width, int height) {
        this.write_pdf(file, (Function1<Graphics2D, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$2 -> {
            Graphics_File$.MODULE$.paint_chart(x$2, chart, width, height);
            return BoxedUnit.UNIT;
        }, width, height);
    }

    public static final /* synthetic */ void $anonfun$font_mapper$2(DefaultFontMapper mapper$1, Path font$1, String name) {
        DefaultFontMapper.BaseFontParameters parameters = new DefaultFontMapper.BaseFontParameters(File$.MODULE$.platform_path(font$1));
        parameters.encoding = "Identity-H";
        mapper$1.putName(name, parameters);
    }

    public static final /* synthetic */ void $anonfun$font_mapper$1(DefaultFontMapper mapper$1, Path font) {
        Library$.MODULE$.try_unsuffix(".ttf", font.base_name()).foreach((Function1 & Serializable & scala.Serializable)name -> {
            Graphics_File$.$anonfun$font_mapper$2(mapper$1, font, name);
            return BoxedUnit.UNIT;
        });
    }

    private Graphics_File$() {
        MODULE$ = this;
    }
}

