/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Build_Log;
import isabelle.Build_Log$;
import isabelle.Build_Log$Data$;
import isabelle.Build_Log$Prop$;
import isabelle.Build_Log$Session_Status$;
import isabelle.Build_Log$Settings$;
import isabelle.Build_Status;
import isabelle.CSV;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date;
import isabelle.Date$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Graphics_File$;
import isabelle.HTML$;
import isabelle.Isabelle_Cronjob$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Jenkins$;
import isabelle.ML_Statistics;
import isabelle.ML_Statistics$;
import isabelle.No_Progress$;
import isabelle.Options;
import isabelle.Options$;
import isabelle.Par_List$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.PostgreSQL;
import isabelle.Process_Result;
import isabelle.Progress;
import isabelle.Properties$;
import isabelle.SQL;
import isabelle.Time$;
import isabelle.Value$Int$;
import isabelle.XML;
import isabelle.package$;
import java.io.Serializable;
import org.jfree.chart.JFreeChart;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

public final class Build_Status$ {
    public static Build_Status$ MODULE$;
    private final Path default_target_dir;
    private final Tuple2<Object, Object> default_image_size;
    private final int default_history;
    private final Isabelle_Tool isabelle_tool;

    static {
        new Build_Status$();
    }

    public Path default_target_dir() {
        return this.default_target_dir;
    }

    public Tuple2<Object, Object> default_image_size() {
        return this.default_image_size;
    }

    public int default_history() {
        return this.default_history;
    }

    public List<Build_Status.Profile> default_profiles() {
        List<Build_Status.Profile> list = Jenkins$.MODULE$.build_status_profiles();
        return Isabelle_Cronjob$.MODULE$.build_status_profiles().$colon$colon$colon(list);
    }

    public void build_status(Options options, Progress progress, List<Build_Status.Profile> profiles, Set<String> only_sessions, boolean verbose, Path target_dir, boolean ml_statistics, Tuple2<Object, Object> image_size) {
        Set ml_statistics_domain = scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ML_Statistics$.MODULE$.heap_fields(), ML_Statistics$.MODULE$.tasks_fields(), ML_Statistics$.MODULE$.workers_fields()})).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> (List)x$2._2()).toSet();
        Options x$44 = options;
        Progress x$45 = progress;
        List<Build_Status.Profile> x$46 = profiles;
        Set<String> x$47 = only_sessions;
        boolean x$48 = verbose;
        boolean x$49 = ml_statistics;
        Set x$50 = ml_statistics_domain;
        Build_Status.Data data = this.read_data(x$44, x$45, x$46, x$47, x$49, (Function1<String, Object>)x$50, x$48);
        this.present_data(data, progress, target_dir, image_size);
    }

    public Progress build_status$default$2() {
        return No_Progress$.MODULE$;
    }

    public List<Build_Status.Profile> build_status$default$3() {
        return this.default_profiles();
    }

    public Set<String> build_status$default$4() {
        return Predef$.MODULE$.Set().empty();
    }

    public boolean build_status$default$5() {
        return false;
    }

    public Path build_status$default$6() {
        return this.default_target_dir();
    }

    public boolean build_status$default$7() {
        return false;
    }

    public Tuple2<Object, Object> build_status$default$8() {
        return this.default_image_size();
    }

    public String print_version(String isabelle_version, String afp_version, String chapter) {
        List list = ((Option)package$.MODULE$.proper_string().apply((Object)isabelle_version)).map((Function1 & Serializable & scala.Serializable)x$8 -> new StringBuilder(9).append("Isabelle/").append((String)x$8).toString()).toList();
        String string = chapter;
        String string2 = "AFP";
        List body = (!(string != null ? !string.equals(string2) : string2 != null) ? ((Option)package$.MODULE$.proper_string().apply((Object)afp_version)).map((Function1 & Serializable & scala.Serializable)x$9 -> new StringBuilder(4).append("AFP/").append((String)x$9).toString()) : None$.MODULE$).toList().$colon$colon$colon(list);
        return body.isEmpty() ? "" : body.mkString(" (", ", ", ")");
    }

    public String print_version$default$2() {
        return "";
    }

    public String print_version$default$3() {
        return "AFP";
    }

    public Build_Status.Data read_data(Options options, Progress progress, List<Build_Status.Profile> profiles, Set<String> only_sessions, boolean ml_statistics, Function1<String, Object> ml_statistics_domain, boolean verbose) {
        Date date = Date$.MODULE$.now(Date$.MODULE$.now$default$1());
        ObjectRef data_hosts = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        ObjectRef data_stretch = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        ObjectRef data_entries = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        Build_Log.Store store = Build_Log$.MODULE$.store(options);
        package$.MODULE$.using(store.open_database(store.open_database$default$1(), store.open_database$default$2(), store.open_database$default$3(), store.open_database$default$4(), store.open_database$default$5(), store.open_database$default$6(), store.open_database$default$7(), store.open_database$default$8()), (Function1 & Serializable & scala.Serializable)db -> {
            Build_Status$.$anonfun$read_data$2(options, progress, profiles, only_sessions, ml_statistics, ml_statistics_domain, verbose, data_hosts, data_stretch, data_entries, store, db);
            return BoxedUnit.UNIT;
        });
        List sorted_entries = (List)((SeqLike)((Map)data_entries.elem).toList().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Build_Status$.$anonfun$read_data$9(check$ifrefutable$1))).flatMap((Function1 & Serializable & scala.Serializable)x$17 -> {
            Tuple2 tuple2 = x$17;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            Map sessions = (Map)tuple2._2();
            Iterable iterable = Option$.MODULE$.option2Iterable(package$.MODULE$.proper_list((List)((SeqLike)sessions.toList().map((Function1 & Serializable & scala.Serializable)x$15 -> (Build_Status.Session)x$15._2(), List$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)x$16.order()), (Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable & scala.Serializable)sorted_sessions -> {
                List hosts = (List)Build_Status$.get_hosts$1(name, data_hosts).toList().sorted((Ordering)Ordering.String$.MODULE$);
                double stretch = BoxesRunTime.unboxToDouble((Object)((Map)data_stretch$1.elem).apply((Object)name));
                return new Build_Status.Data_Entry(name, (List<String>)hosts, stretch, (List<Build_Status.Session>)sorted_sessions);
            }));
            return iterable;
        }, List$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$18 -> x$18.name(), (Ordering)Ordering.String$.MODULE$);
        return new Build_Status.Data(date, (List<Build_Status.Data_Entry>)sorted_entries);
    }

    public Progress read_data$default$2() {
        return No_Progress$.MODULE$;
    }

    public List<Build_Status.Profile> read_data$default$3() {
        return this.default_profiles();
    }

    public Set<String> read_data$default$4() {
        return Predef$.MODULE$.Set().empty();
    }

    public boolean read_data$default$5() {
        return false;
    }

    public Function1<String, Object> read_data$default$6() {
        return (Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)Build_Status$.$anonfun$read_data$default$6$1(key));
    }

    public boolean read_data$default$7() {
        return false;
    }

    public void present_data(Build_Status.Data data, Progress progress, Path target_dir, Tuple2<Object, Object> image_size) {
        HTML$.MODULE$.write_document(target_dir, "index.html", (List<XML.Tree>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new XML.Elem[]{HTML$.MODULE$.title().apply("Isabelle build status")})), (List<XML.Tree>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new XML.Elem[]{HTML$.MODULE$.chapter().apply("Isabelle build status"), HTML$.MODULE$.par().apply((List<XML.Tree>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new XML.Elem[]{HTML$.MODULE$.description((List<Tuple2<List<XML.Tree>, List<XML.Tree>>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("status date:")), HTML$.MODULE$.text(data.date().toString()))})))}))), HTML$.MODULE$.par().apply((List<XML.Tree>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new XML.Elem[]{HTML$.MODULE$.itemize((List<List<XML.Tree>>)((List)data.entries().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Nil$ nil$;
            Build_Status.Data_Entry data_Entry = x0$1;
            List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new XML.Elem[]{HTML$.MODULE$.link(new StringBuilder(11).append(Build_Status$.clean_name$1(data_Entry.name())).append("/index.html").toString(), HTML$.MODULE$.text(data_Entry.name()))}));
            List<Build_Status.Session> list2 = data_Entry.failed_sessions();
            if (Nil$.MODULE$.equals(list2)) {
                nil$ = Nil$.MODULE$;
            } else {
                List<XML.Tree> list3 = HTML$.MODULE$.break();
                List list4 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new XML.Elem[]{HTML$.MODULE$.span().apply(HTML$.MODULE$.error_message(), HTML$.MODULE$.text("Failed sessions:"))}));
                nil$ = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new XML.Elem[]{HTML$.MODULE$.itemize((List<List<XML.Tree>>)((List)list2.map((Function1 & Serializable & scala.Serializable)s -> s.head().present_errors(s.name()), List$.MODULE$.canBuildFrom())))})).$colon$colon$colon(list4).$colon$colon$colon(list3);
            }
            List list5 = nil$.$colon$colon$colon(list);
            return list5;
        }, List$.MODULE$.canBuildFrom())))})))})), HTML$.MODULE$.write_document$default$5(), HTML$.MODULE$.write_document$default$6(), HTML$.MODULE$.write_document$default$7());
        data.entries().foreach((Function1 & Serializable & scala.Serializable)data_entry -> {
            Build_Status$.$anonfun$present_data$4(data, progress, target_dir, image_size, data_entry);
            return BoxedUnit.UNIT;
        });
    }

    public Progress present_data$default$2() {
        return No_Progress$.MODULE$;
    }

    public Path present_data$default$3() {
        return this.default_target_dir();
    }

    public Tuple2<Object, Object> present_data$default$4() {
        return this.default_image_size();
    }

    public Isabelle_Tool isabelle_tool() {
        return this.isabelle_tool;
    }

    private static final Set get_hosts$1(String data_name, ObjectRef data_hosts$1) {
        return (Set)((Map)data_hosts$1.elem).getOrElse((Object)data_name, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public static final /* synthetic */ void $anonfun$read_data$5(Options options$1, boolean ml_statistics$1, Function1 ml_statistics_domain$1, ObjectRef data_hosts$1, ObjectRef data_stretch$1, ObjectRef data_entries$1, Build_Log.Store store$1, boolean afp$1, Regex Threads_Option$1, Build_Status.Profile profile$1, SQL.Statement stmt) {
        SQL.Result res = stmt.execute_query();
        while (res.next()) {
            Build_Status.Session session;
            int i;
            String string;
            Option<Object> option;
            String session_name = res.string(Build_Log$Data$.MODULE$.session_name());
            String chapter = res.string(Build_Log$Data$.MODULE$.chapter());
            List groups = (List)package$.MODULE$.split_lines().apply((Object)res.string(Build_Log$Data$.MODULE$.groups()));
            String string2 = res.string(Build_Log$Settings$.MODULE$.ISABELLE_BUILD_OPTIONS());
            Option option2 = Threads_Option$1.unapplySeq((CharSequence)string2);
            int n = !option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0 && !(option = Value$Int$.MODULE$.unapply(string = (String)((LinearSeqOptimized)option2.get()).apply(0))).isEmpty() ? (i = BoxesRunTime.unboxToInt((Object)option.get())) : 1;
            int threads1 = n;
            int threads2 = BoxesRunTime.unboxToInt((Object)res.get_int(Build_Log$Data$.MODULE$.threads()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
            int threads = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(threads1), threads2);
            String ml_platform = res.string(Build_Log$Settings$.MODULE$.ML_PLATFORM());
            String data_name = new StringBuilder(0).append(profile$1.description()).append((Object)(ml_platform.startsWith("x86_64") ? ", 64bit" : "")).append((Object)(threads == 1 ? "" : new StringBuilder(10).append(", ").append(threads).append(" threads").toString())).toString();
            res.get_string(Build_Log$Prop$.MODULE$.build_host()).foreach((Function1 & Serializable & scala.Serializable)host -> {
                data_hosts$1.elem = ((Map)data_hosts$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)data_name), (Object)Build_Status$.get_hosts$1(data_name, data_hosts$1).$plus((Object)host)));
                return BoxedUnit.UNIT;
            });
            data_stretch$1.elem = ((Map)data_stretch$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)data_name), (Object)BoxesRunTime.boxToDouble((double)profile$1.stretch(options$1))));
            String isabelle_version = res.string(Build_Log$Prop$.MODULE$.isabelle_version());
            String afp_version = res.string(Build_Log$Prop$.MODULE$.afp_version());
            List<List<Tuple2<String, String>>> x$51 = ml_statistics$1 ? Properties$.MODULE$.uncompress(res.bytes(Build_Log$Data$.MODULE$.ml_statistics()), store$1.xz_cache(), Properties$.MODULE$.uncompress$default$3()) : Nil$.MODULE$;
            Function1 x$52 = ml_statistics_domain$1;
            String x$53 = new StringBuilder(0).append(session_name).append(MODULE$.print_version(isabelle_version, afp_version, chapter)).toString();
            ML_Statistics ml_stats = ML_Statistics$.MODULE$.apply(x$51, x$53, (Function1<String, Object>)x$52);
            Build_Status.Entry entry = new Build_Status.Entry(chapter, res.date(Build_Log$Data$.MODULE$.pull_date(false)), afp$1 ? res.get_date(Build_Log$Data$.MODULE$.pull_date(true)) : None$.MODULE$, isabelle_version, afp_version, res.timing(Build_Log$Data$.MODULE$.timing_elapsed(), Build_Log$Data$.MODULE$.timing_cpu(), Build_Log$Data$.MODULE$.timing_gc()), res.timing(Build_Log$Data$.MODULE$.ml_timing_elapsed(), Build_Log$Data$.MODULE$.ml_timing_cpu(), Build_Log$Data$.MODULE$.ml_timing_gc()), ml_stats.maximum_heap_size(), ml_stats.average_heap_size(), ML_Statistics$.MODULE$.heap_scale(res.long(Build_Log$Data$.MODULE$.heap_size())), Build_Log$Session_Status$.MODULE$.withName(res.string(Build_Log$Data$.MODULE$.status())), Build_Log$.MODULE$.uncompress_errors(res.bytes(Build_Log$Data$.MODULE$.errors()), store$1.xz_cache()));
            Map sessions = (Map)((Map)data_entries$1.elem).getOrElse((Object)data_name, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
            Option option3 = sessions.get((Object)session_name);
            if (None$.MODULE$.equals(option3)) {
                session = new Build_Status.Session(session_name, threads, (List<Build_Status.Entry>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Build_Status.Entry[]{entry})), ml_stats, entry.date());
            } else if (option3 instanceof Some) {
                Tuple2 tuple2;
                Some some = (Some)option3;
                Build_Status.Session old = (Build_Status.Session)some.value();
                Tuple2 tuple22 = tuple2 = entry.date() > old.ml_statistics_date() ? new Tuple2((Object)ml_stats, (Object)BoxesRunTime.boxToLong((long)entry.date())) : new Tuple2((Object)old.ml_statistics(), (Object)BoxesRunTime.boxToLong((long)old.ml_statistics_date()));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ML_Statistics ml_stats1 = (ML_Statistics)tuple2._1();
                long ml_stats1_date = tuple2._2$mcJ$sp();
                Tuple2 tuple23 = new Tuple2((Object)ml_stats1, (Object)BoxesRunTime.boxToLong((long)ml_stats1_date));
                Tuple2 tuple24 = tuple23;
                ML_Statistics ml_stats12 = (ML_Statistics)tuple24._1();
                long ml_stats1_date2 = tuple24._2$mcJ$sp();
                Build_Status.Entry entry2 = entry;
                session = new Build_Status.Session(session_name, threads, (List<Build_Status.Entry>)old.entries().$colon$colon((Object)entry2), ml_stats12, ml_stats1_date2);
            } else {
                throw new MatchError((Object)option3);
            }
            Build_Status.Session session2 = session;
            if (afp$1) {
                String string3 = chapter;
                String string4 = "AFP";
                if (string3 != null ? !string3.equals(string4) : string4 != null) continue;
            }
            if (profile$1.slow() && !groups.contains((Object)"slow")) continue;
            data_entries$1.elem = ((Map)data_entries$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)data_name), (Object)sessions.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)session_name), (Object)session2))));
        }
    }

    public static final /* synthetic */ void $anonfun$read_data$4(Options options$1, Progress progress$1, Set only_sessions$1, boolean ml_statistics$1, Function1 ml_statistics_domain$1, boolean verbose$1, ObjectRef data_hosts$1, ObjectRef data_stretch$1, ObjectRef data_entries$1, Build_Log.Store store$1, PostgreSQL.Database db$1, Build_Status.Profile profile) {
        progress$1.echo(new StringBuilder(6).append("input ").append(package$.MODULE$.quote().apply((Object)profile.description())).toString());
        boolean afp = profile.afp();
        List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SQL.Column[]{Build_Log$Data$.MODULE$.pull_date(false), Build_Log$Data$.MODULE$.pull_date(true), Build_Log$Prop$.MODULE$.build_host(), Build_Log$Prop$.MODULE$.isabelle_version(), Build_Log$Prop$.MODULE$.afp_version(), Build_Log$Settings$.MODULE$.ISABELLE_BUILD_OPTIONS(), Build_Log$Settings$.MODULE$.ML_PLATFORM(), Build_Log$Data$.MODULE$.session_name(), Build_Log$Data$.MODULE$.chapter(), Build_Log$Data$.MODULE$.groups(), Build_Log$Data$.MODULE$.threads(), Build_Log$Data$.MODULE$.timing_elapsed(), Build_Log$Data$.MODULE$.timing_cpu(), Build_Log$Data$.MODULE$.timing_gc(), Build_Log$Data$.MODULE$.ml_timing_elapsed(), Build_Log$Data$.MODULE$.ml_timing_cpu(), Build_Log$Data$.MODULE$.ml_timing_gc(), Build_Log$Data$.MODULE$.heap_size(), Build_Log$Data$.MODULE$.status(), Build_Log$Data$.MODULE$.errors()}));
        List columns = (ml_statistics$1 ? List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SQL.Column[]{Build_Log$Data$.MODULE$.ml_statistics()})) : Nil$.MODULE$).$colon$colon$colon(list);
        Regex Threads_Option = new StringOps(Predef$.MODULE$.augmentString("threads\\s*=\\s*(\\d+)")).r();
        String sql = profile.select(options$1, (List<SQL.Column>)columns, (Set<String>)only_sessions$1);
        if (verbose$1) {
            progress$1.echo(sql);
        }
        db$1.using_statement(sql, (Function1 & Serializable & scala.Serializable)stmt -> {
            Build_Status$.$anonfun$read_data$5(options$1, ml_statistics$1, ml_statistics_domain$1, data_hosts$1, data_stretch$1, data_entries$1, store$1, afp, Threads_Option, profile, stmt);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$read_data$2(Options options$1, Progress progress$1, List profiles$1, Set only_sessions$1, boolean ml_statistics$1, Function1 ml_statistics_domain$1, boolean verbose$1, ObjectRef data_hosts$1, ObjectRef data_stretch$1, ObjectRef data_entries$1, Build_Log.Store store$1, PostgreSQL.Database db) {
        ((List)profiles$1.sortBy((Function1 & Serializable & scala.Serializable)x$11 -> x$11.description(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)profile -> {
            Build_Status$.$anonfun$read_data$4(options$1, progress$1, only_sessions$1, ml_statistics$1, ml_statistics_domain$1, verbose$1, data_hosts$1, data_stretch$1, data_entries$1, store$1, db, profile);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$read_data$9(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$read_data$default$6$1(String key) {
        return true;
    }

    public static final /* synthetic */ String $anonfun$present_data$1(char c) {
        return c == ' ' || c == '/' ? Predef$.MODULE$.augmentString("_") : (c == ',' ? Predef$.MODULE$.augmentString("") : Predef$.MODULE$.augmentString(((Object)BoxesRunTime.boxToCharacter((char)c)).toString()));
    }

    private static final String clean_name$1(String name) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(name)).flatMap((Function1 & Serializable & scala.Serializable)c -> new StringOps(Build_Status$.$anonfun$present_data$1(BoxesRunTime.unboxToChar((Object)c))), Predef$.MODULE$.StringCanBuildFrom());
    }

    private static final Option print_heap$1(long x) {
        return x == 0L ? None$.MODULE$ : new Some((Object)new StringBuilder(2).append(((Object)BoxesRunTime.boxToLong((long)x)).toString()).append(" M").toString());
    }

    private static final String plot_name$1(String kind, Build_Status.Session session$1) {
        return new StringBuilder(5).append(session$1.name()).append("_").append(kind).append(".png").toString();
    }

    public static final /* synthetic */ double $anonfun$present_data$10(double x0$2, Build_Status.Entry x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)x0$2), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double m = tuple2._1$mcD$sp();
        Build_Status.Entry entry = (Build_Status.Entry)tuple2._2();
        double d = RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(m), Time$.MODULE$.minutes$extension(entry.timing().elapsed()))), Time$.MODULE$.minutes$extension(entry.timing().resources()))), Time$.MODULE$.minutes$extension(entry.ml_timing().elapsed()))), Time$.MODULE$.minutes$extension(entry.ml_timing().resources()));
        return d;
    }

    private static final Build_Status.Image gnuplot$1(String plot_name, List plots, String range, String data_name$2, int image_height$1, int image_width_stretch$1, Path dir$1, Build_Status.Session session$1, Path data_file$1, Path gnuplot_file$1) {
        Build_Status.Image image = new Build_Status.Image(plot_name, image_width_stretch$1, image_height$1);
        File$.MODULE$.write(gnuplot_file$1, (CharSequence)new StringBuilder(143).append("\nset terminal png size ").append(image.width()).append(",").append(image.height()).append("\nset output ").append(package$.MODULE$.quote().apply((Object)File$.MODULE$.standard_path(dir$1.$plus(image.path())))).append("\nset xdata time\nset timefmt \"%s\"\nset format x \"%d-%b\"\nset xlabel ").append(package$.MODULE$.quote().apply((Object)session$1.name())).append(" noenhanced\nset key left bottom\nplot [] ").append(range).append(" ").append(((TraversableOnce)plots.map((Function1 & Serializable & scala.Serializable)s -> new StringBuilder(1).append((String)package$.MODULE$.quote().apply((Object)data_file$1.implode())).append(" ").append((String)s).toString(), List$.MODULE$.canBuildFrom())).mkString(", ")).append("\n").toString());
        Process_Result result = Isabelle_System$.MODULE$.bash(new StringBuilder(20).append("\"$ISABELLE_GNUPLOT\" ").append(File$.MODULE$.bash_path(gnuplot_file$1)).toString(), Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9());
        Object object = !result.ok() ? result.error(new StringBuilder(20).append("Gnuplot failed for ").append(data_name$2).append("/").append(plot_name).toString()).check() : BoxedUnit.UNIT;
        return image;
    }

    private static final Build_Status.Image jfreechart$1(String plot_name, Tuple2 fields, int image_width$1, int image_height$1, Path dir$1, Build_Status.Session session$1) {
        Build_Status.Image image = new Build_Status.Image(plot_name, image_width$1, image_height$1);
        JFreeChart chart = session$1.ml_statistics().chart(new StringBuilder(2).append((String)fields._1()).append(": ").append(session$1.ml_statistics().heading()).toString(), (List<String>)((List)fields._2()));
        Graphics_File$.MODULE$.write_chart_png(dir$1.$plus(image.path()).file(), chart, image.width(), image.height());
        return image;
    }

    public static final /* synthetic */ void $anonfun$present_data$4(Build_Status.Data data$1, Progress progress$2, Path target_dir$1, Tuple2 image_size$1, Build_Status.Data_Entry data_entry) {
        String data_name = data_entry.name();
        Tuple2 tuple2 = image_size$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int image_width = tuple2._1$mcI$sp();
        int image_height = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(image_width, image_height);
        Tuple2.mcII.sp sp3 = sp2;
        int image_width2 = sp3._1$mcI$sp();
        int image_height2 = sp3._2$mcI$sp();
        int image_width_stretch = (int)((double)image_width2 * data_entry.stretch());
        progress$2.echo(new StringBuilder(7).append("output ").append(package$.MODULE$.quote().apply((Object)data_name)).toString());
        Path dir = target_dir$1.$plus(Path$.MODULE$.basic(Build_Status$.clean_name$1(data_name)));
        Isabelle_System$.MODULE$.mkdirs(dir);
        Map data_files = ((TraversableOnce)data_entry.sessions().map((Function1 & Serializable & scala.Serializable)session -> {
            CSV.File csv_file = session.make_csv();
            csv_file.write(dir);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)session.name()), (Object)csv_file);
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map session_plots = Par_List$.MODULE$.map((Function1 & Serializable & scala.Serializable)session -> (Tuple2)Isabelle_System$.MODULE$.with_tmp_file(session.name(), "data", (Function1 & Serializable & scala.Serializable)data_file -> (Tuple2)Isabelle_System$.MODULE$.with_tmp_file(session.name(), "gnuplot", (Function1 & Serializable & scala.Serializable)gnuplot_file -> {
            Nil$ nil$;
            Nil$ nil$2;
            List list;
            File$.MODULE$.write((Path)data_file, (CharSequence)package$.MODULE$.cat_lines().apply(session.finished_entries().map((Function1 & Serializable & scala.Serializable)entry -> List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{entry.date(), Time$.MODULE$.minutes$extension(entry.timing().elapsed()), Time$.MODULE$.minutes$extension(entry.timing().resources()), Time$.MODULE$.minutes$extension(entry.ml_timing().elapsed()), Time$.MODULE$.minutes$extension(entry.ml_timing().resources()), entry.maximum_heap(), entry.average_heap(), entry.stored_heap()})).mkString(" "), List$.MODULE$.canBuildFrom())));
            double d = 0.0;
            double max_time = RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(BoxesRunTime.unboxToDouble((Object)session.finished_entries().$div$colon((Object)BoxesRunTime.boxToDouble((double)d), (Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> BoxesRunTime.boxToDouble((double)Build_Status$.$anonfun$present_data$10(BoxesRunTime.unboxToDouble((Object)x0$2), x1$1))))), 0.1) * 1.1;
            String timing_range = new StringBuilder(4).append("[0:").append(max_time).append("]").toString();
            List plots1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" using 1:2 smooth sbezier title \"elapsed time (smooth)\" ", " using 1:2 smooth csplines title \"elapsed time\" "}));
            List plots2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" using 1:3 smooth sbezier title \"cpu time (smooth)\" ", " using 1:3 smooth csplines title \"cpu time\" "}));
            if (session.threads() == 1) {
                list = plots1;
            } else {
                List list2 = plots1;
                list = plots2.$colon$colon$colon(list2);
            }
            List timing_plots = list;
            List ml_timing_plots = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" using 1:4 smooth sbezier title \"ML elapsed time (smooth)\" ", " using 1:4 smooth csplines title \"ML elapsed time\" ", " using 1:5 smooth sbezier title \"ML cpu time (smooth)\" ", " using 1:5 smooth csplines title \"ML cpu time\" "}));
            List heap_plots = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" using 1:6 smooth sbezier title \"maximum heap (smooth)\" ", " using 1:6 smooth csplines title \"maximum heap\" ", " using 1:7 smooth sbezier title \"average heap (smooth)\" ", " using 1:7 smooth csplines title \"average heap\" ", " using 1:8 smooth sbezier title \"stored heap (smooth)\" ", " using 1:8 smooth csplines title \"stored heap\" "}));
            Nil$ nil$3 = session.check_timing() ? List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Build_Status.Image[]{Build_Status$.gnuplot$1(Build_Status$.plot_name$1("timing", session), timing_plots, timing_range, data_name, image_height2, image_width_stretch, dir, session, data_file, gnuplot_file), Build_Status$.gnuplot$1(Build_Status$.plot_name$1("ml_timing", session), ml_timing_plots, timing_range, data_name, image_height2, image_width_stretch, dir, session, data_file, gnuplot_file)})) : Nil$.MODULE$;
            Object object = nil$2 = session.check_heap() ? List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Build_Status.Image[]{Build_Status$.gnuplot$1(Build_Status$.plot_name$1("heap", session), heap_plots, "[0:]", data_name, image_height2, image_width_stretch, dir, session, data_file, gnuplot_file)})) : Nil$.MODULE$;
            if (session.ml_statistics().content().nonEmpty()) {
                List list3 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Build_Status.Image[]{Build_Status$.jfreechart$1(Build_Status$.plot_name$1("heap_chart", session), ML_Statistics$.MODULE$.heap_fields(), image_width2, image_height2, dir, session)}));
                nil$ = (session.threads() > 1 ? List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Build_Status.Image[]{Build_Status$.jfreechart$1(Build_Status$.plot_name$1("tasks_chart", session), ML_Statistics$.MODULE$.tasks_fields(), image_width2, image_height2, dir, session), Build_Status$.jfreechart$1(Build_Status$.plot_name$1("workers_chart", session), ML_Statistics$.MODULE$.workers_fields(), image_width2, image_height2, dir, session)})) : Nil$.MODULE$).$colon$colon$colon(list3);
            } else {
                nil$ = Nil$.MODULE$;
            }
            List images = nil$.$colon$colon$colon((List)nil$2).$colon$colon$colon((List)nil$3);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)session.name()), (Object)images);
        })), data_entry.sessions()).toMap(Predef$.MODULE$.$conforms());
        XML.Elem elem = HTML$.MODULE$.chapter().apply(new StringBuilder(26).append("Isabelle build status for ").append(data_name).toString());
        XML.Elem elem2 = HTML$.MODULE$.par().apply((List<XML.Tree>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new XML.Elem[]{HTML$.MODULE$.description((List<Tuple2<List<XML.Tree>, List<XML.Tree>>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("status date:")), HTML$.MODULE$.text(data$1.date().toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("build host:")), HTML$.MODULE$.text((String)package$.MODULE$.commas().apply(data_entry.hosts())))})))})));
        XML.Elem elem3 = HTML$.MODULE$.par().apply((List<XML.Tree>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new XML.Elem[]{HTML$.MODULE$.itemize((List<List<XML.Tree>>)((List)data_entry.sessions().map((Function1 & Serializable & scala.Serializable)session -> {
            XML.Elem elem = HTML$.MODULE$.link(new StringBuilder(9).append("#session_").append(session.name()).toString(), HTML$.MODULE$.text(session.name()));
            return HTML$.MODULE$.text(new StringBuilder(3).append(" (").append(session.head().timing().message_resources()).append(")").toString()).$colon$colon((Object)elem);
        }, List$.MODULE$.canBuildFrom())))})));
        HTML$.MODULE$.write_document(dir, "index.html", (List<XML.Tree>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new XML.Elem[]{HTML$.MODULE$.title().apply(new StringBuilder(26).append("Isabelle build status for ").append(data_name).toString())})), (List<XML.Tree>)((List)data_entry.sessions().flatMap((Function1 & Serializable & scala.Serializable)session -> {
            XML.Elem[] elemArray = new XML.Elem[2];
            elemArray[0] = HTML$.MODULE$.section().apply(HTML$.MODULE$.id(new StringBuilder(8).append("session_").append(session.name()).toString()), session.name());
            List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("data:")), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new XML.Elem[]{HTML$.MODULE$.link(((CSV.File)data_files.apply((Object)session.name())).file_name(), HTML$.MODULE$.text("CSV"))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("timing:")), HTML$.MODULE$.text(session.head().timing().message_resources())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("ML timing:")), HTML$.MODULE$.text(session.head().ml_timing().message_resources()))}));
            List list2 = Build_Status$.print_heap$1(session.head().maximum_heap()).map((Function1 & Serializable & scala.Serializable)s -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("maximum heap:")), HTML$.MODULE$.text((String)s))).toList();
            List list3 = Build_Status$.print_heap$1(session.head().average_heap()).map((Function1 & Serializable & scala.Serializable)s -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("average heap:")), HTML$.MODULE$.text((String)s))).toList();
            List list4 = Build_Status$.print_heap$1(session.head().stored_heap()).map((Function1 & Serializable & scala.Serializable)s -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("stored heap:")), HTML$.MODULE$.text((String)s))).toList();
            List list5 = ((Option)package$.MODULE$.proper_string().apply((Object)session.head().isabelle_version())).map((Function1 & Serializable & scala.Serializable)s -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("Isabelle version:")), HTML$.MODULE$.text((String)s))).toList();
            XML.Elem elem = HTML$.MODULE$.description((List<Tuple2<List<XML.Tree>, List<XML.Tree>>>)((Option)package$.MODULE$.proper_string().apply((Object)session.head().afp_version())).map((Function1 & Serializable & scala.Serializable)s -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(HTML$.MODULE$.text("AFP version:")), HTML$.MODULE$.text((String)s))).toList().$colon$colon$colon(list5).$colon$colon$colon(list4).$colon$colon$colon(list3).$colon$colon$colon(list2).$colon$colon$colon(list));
            elemArray[1] = HTML$.MODULE$.par().apply((List<XML.Tree>)((List)((List)session_plots.getOrElse((Object)session.name(), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)image -> HTML$.MODULE$.size(image.width() / 2, image.height() / 2, HTML$.MODULE$.image(image.name(), HTML$.MODULE$.image$default$2())), List$.MODULE$.canBuildFrom())).$colon$colon((Object)elem));
            return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])elemArray));
        }, List$.MODULE$.canBuildFrom())).$colon$colon((Object)elem3).$colon$colon((Object)elem2).$colon$colon((Object)elem), HTML$.MODULE$.write_document$default$5(), HTML$.MODULE$.write_document$default$6(), HTML$.MODULE$.write_document$default$7());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$isabelle_tool$7(ObjectRef image_size$2, String arg) {
        List list = (List)((List)package$.MODULE$.space_explode().apply((Object)BoxesRunTime.boxToCharacter((char)'x'), (Object)arg)).map((Function1 & Serializable & scala.Serializable)x$39 -> BoxesRunTime.boxToInteger((int)Value$Int$.MODULE$.parse(x$39)), List$.MODULE$.canBuildFrom());
        Some some = List$.MODULE$.unapplySeq((Seq)list);
        if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
            int w = BoxesRunTime.unboxToInt((Object)((LinearSeqOptimized)some.get()).apply(0));
            int h = BoxesRunTime.unboxToInt((Object)((LinearSeqOptimized)some.get()).apply(1));
            if (w > 0 && h > 0) {
                image_size$2.elem = new Tuple2.mcII.sp(w, h);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = (BoxedUnit)package$.MODULE$.error().apply((Object)new StringBuilder(26).append("Error bad PNG image size: ").append(package$.MODULE$.quote().apply((Object)arg)).toString());
    }

    public static final /* synthetic */ void $anonfun$isabelle_tool$1(List args) {
        ObjectRef target_dir = ObjectRef.create((Object)MODULE$.default_target_dir());
        BooleanRef ml_statistics = BooleanRef.create((boolean)false);
        ObjectRef only_sessions = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        ObjectRef options = ObjectRef.create((Object)Options$.MODULE$.init(Options$.MODULE$.init$default$1(), Options$.MODULE$.init$default$2()));
        ObjectRef image_size = ObjectRef.create(MODULE$.default_image_size());
        BooleanRef verbose = BooleanRef.create((boolean)false);
        Getopts getopts = Getopts$.MODULE$.apply(new StringBuilder(573).append("\nUsage: isabelle build_status [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default ").append(MODULE$.default_target_dir()).append(")\n    -M           include full ML statistics\n    -S SESSIONS  only given SESSIONS (comma separated)\n    -l DAYS      length of relevant history (default ").append(((Options)options.elem).int().apply("build_log_history")).append(")\n    -o OPTION    override Isabelle system OPTION (via NAME=VAL or NAME)\n    -s WxH       size of PNG image (default ").append(((Tuple2)image_size.elem)._1$mcI$sp()).append("x").append(((Tuple2)image_size.elem)._2$mcI$sp()).append(")\n    -v           verbose\n\n  Present performance statistics from build log database, which is specified\n  via system options build_log_database_host, build_log_database_user,\n  build_log_history etc.\n").toString(), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"D:"), (Function1 & Serializable & scala.Serializable)arg -> {
            target_dir.elem = Path$.MODULE$.explode(arg);
            return BoxedUnit.UNIT;
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"M"), (Function1 & Serializable & scala.Serializable)x$38 -> {
            ml_statistics.elem = true;
            return BoxedUnit.UNIT;
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"S:"), (Function1 & Serializable & scala.Serializable)arg -> {
            only_sessions.elem = ((TraversableOnce)package$.MODULE$.space_explode().apply((Object)BoxesRunTime.boxToCharacter((char)','), (Object)arg)).toSet();
            return BoxedUnit.UNIT;
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"l:"), (Function1 & Serializable & scala.Serializable)arg -> {
            options.elem = ((Options)options.elem).$plus(new StringBuilder(18).append("build_log_history=").append(arg).toString());
            return BoxedUnit.UNIT;
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"o:"), (Function1 & Serializable & scala.Serializable)arg -> {
            options.elem = ((Options)options.elem).$plus(arg);
            return BoxedUnit.UNIT;
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"s:"), (Function1 & Serializable & scala.Serializable)arg -> {
            Build_Status$.$anonfun$isabelle_tool$7(image_size, arg);
            return BoxedUnit.UNIT;
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Function1 & Serializable & scala.Serializable)x$40 -> {
            verbose.elem = true;
            return BoxedUnit.UNIT;
        })}));
        List<String> more_args = getopts.apply((List<String>)args);
        if (more_args.nonEmpty()) {
            throw getopts.usage();
        }
        Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2());
        Options x$54 = (Options)options.elem;
        Console_Progress x$55 = progress;
        Set x$56 = (Set)only_sessions.elem;
        boolean x$57 = verbose.elem;
        Path x$58 = (Path)target_dir.elem;
        boolean x$59 = ml_statistics.elem;
        Tuple2 x$60 = (Tuple2)image_size.elem;
        List<Build_Status.Profile> x$61 = MODULE$.build_status$default$3();
        MODULE$.build_status(x$54, x$55, x$61, (Set<String>)x$56, x$57, x$58, x$59, (Tuple2<Object, Object>)x$60);
    }

    private Build_Status$() {
        MODULE$ = this;
        this.default_target_dir = Path$.MODULE$.explode("build_status");
        this.default_image_size = new Tuple2.mcII.sp(800, 600);
        this.default_history = 30;
        this.isabelle_tool = new Isabelle_Tool("build_status", "present recent build status information from database", (Function1<List<String>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)args -> {
            Build_Status$.$anonfun$isabelle_tool$1(args);
            return BoxedUnit.UNIT;
        }, true);
    }
}

