/*
 * Decompiled with CFR 0.152.
 */
package code2html.impl.latex;

import code2html.generic.Style;
import java.awt.Color;
import java.util.HashMap;
import org.gjt.sp.jedit.syntax.SyntaxStyle;

public class LatexStyle
extends Style {
    private static HashMap<String, String> map = new HashMap();

    public String format(int styleId, SyntaxStyle style, String text) {
        StringBuffer buf = new StringBuffer();
        buf.append("\\syntax").append(LatexStyle.getCleanStyle(styleId)).append("{").append(text).append("}");
        String formattedText = buf.toString();
        return this.getLinkText(styleId, text, formattedText);
    }

    public String style(int styleId, SyntaxStyle style) {
        StringBuffer buf = new StringBuffer();
        buf.append("\\newcommand{\\syntax" + LatexStyle.getCleanStyle(styleId) + "}[1]{");
        StringBuffer brackets = new StringBuffer();
        brackets.append("}");
        Color c = style.getBackgroundColor();
        if (c != null) {
            buf.append("\\colorbox[rgb]{");
            buf.append((double)c.getRed() / 255.0 + ",");
            buf.append((double)c.getGreen() / 255.0 + ",");
            buf.append((double)c.getBlue() / 255.0 + "}{");
            brackets.append("}");
        }
        buf.append("\\textcolor[rgb]{");
        c = style.getForegroundColor();
        if (c != null) {
            buf.append((double)c.getRed() / 255.0 + ",");
            buf.append((double)c.getGreen() / 255.0 + ",");
            buf.append((double)c.getBlue() / 255.0 + "}{");
        }
        brackets.append("}");
        if (style.getFont().isBold()) {
            buf.append("\\textbf{");
            brackets.append("}");
        }
        if (style.getFont().isItalic()) {
            buf.append("{\\it ");
            brackets.append("}");
        }
        buf.append("#1").append(brackets.toString()).append("\n");
        return buf.toString();
    }

    public static String getCleanStyle(int id) {
        return LatexStyle.getCleanStyle(LatexStyle.getTokenString(id));
    }

    public static String getCleanStyle(String str) {
        if (map.isEmpty() || !map.containsKey(str)) {
            String str_ = LatexStyle.cleanStyle(str);
            map.put(str, str_);
        }
        return map.get(str);
    }

    private static String cleanStyle(String str) {
        String out = str;
        for (int i = 1; i < 5; ++i) {
            out = out.replaceAll(i + "", "" + (char)(64 + i));
        }
        return out;
    }

    public String getMode() {
        return "latex";
    }
}

