/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bufferio;

import java.io.InputStream;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bufferio.BufferIORequest;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.AwtRunnableQueue;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.SegmentBuffer;

public class BufferInsertRequest
extends BufferIORequest {
    public BufferInsertRequest(View view, Buffer buffer, Object session, VFS vfs, String path) {
        super(view, buffer, session, vfs, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void _run() {
        InputStream in = null;
        try {
            Object[] args = new String[]{this.vfs.getFileName(this.path)};
            this.setStatus(jEdit.getProperty("vfs.status.load", args));
            this.setCancellable(true);
            this.path = this.vfs._canonPath(this.session, this.path, this.view);
            VFSFile entry = this.vfs._getFile(this.session, this.path, this.view);
            long length = entry != null ? entry.getLength() : 0L;
            in = this.vfs._createInputStream(this.session, this.path, false, this.view);
            if (in == null) {
                IOUtilities.closeQuietly(in);
                this.endSessionQuietly();
                return;
            }
            final SegmentBuffer seg = this.read(this.autodetect(in), length, true);
            AwtRunnableQueue.INSTANCE.runAfterIoTasks(new Runnable(){

                @Override
                public void run() {
                    BufferInsertRequest.this.view.getTextArea().setSelectedText(seg.toString());
                }
            });
            IOUtilities.closeQuietly(in);
        }
        catch (InterruptedException e) {
            this.buffer.setBooleanProperty("BufferIORequest__error", true);
            Thread.currentThread().interrupt();
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Exception e2) {
                Log.log(9, this, e2);
                Object[] pp = new String[]{e2.toString()};
                VFSManager.error(this.view, this.path, "ioerror.read-error", pp);
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
                return;
            }
        }
        finally {
            IOUtilities.closeQuietly(in);
            this.endSessionQuietly();
        }
        this.endSessionQuietly();
        return;
    }
}

