/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Build_Log$Data$;
import isabelle.Build_Log$Jenkins$;
import isabelle.Build_Log$Prop$;
import isabelle.Build_Log$Session_Status$;
import isabelle.Build_Status;
import isabelle.Isabelle_System$;
import isabelle.JSON$;
import isabelle.Jenkins;
import isabelle.No_Progress$;
import isabelle.Par_List$;
import isabelle.Path;
import isabelle.Progress;
import isabelle.SQL$;
import isabelle.Sessions;
import isabelle.Sessions$;
import isabelle.Url$;
import isabelle.package$;
import java.io.Serializable;
import java.net.URL;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class Jenkins$ {
    public static Jenkins$ MODULE$;
    private final List<String> build_log_jobs;
    private final List<Build_Status.Profile> build_status_profiles;

    static {
        new Jenkins$();
    }

    public String root() {
        return Isabelle_System$.MODULE$.getenv_strict("ISABELLE_JENKINS_ROOT", Isabelle_System$.MODULE$.getenv_strict$default$2());
    }

    public Object invoke(String url, Seq<String> args) {
        Object object;
        String req = url + "/api/json?" + args.mkString("&");
        String result = Url$.MODULE$.read(req);
        try {
            object = JSON$.MODULE$.parse(result);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<String> option = package$.MODULE$.ERROR().unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Object object2 = package$.MODULE$.error().apply((Object)("Malformed JSON from " + package$.MODULE$.quote().apply((Object)req)));
            object = object2;
        }
        return object;
    }

    public List<String> build_job_names() {
        return (List)((List)JSON$.MODULE$.array(this.invoke(this.root(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), "jobs").getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)job -> Option$.MODULE$.option2Iterable(JSON$.MODULE$.string(job, "_class").withFilter((Function1 & Serializable & scala.Serializable)_class -> BoxesRunTime.boxToBoolean((boolean)Jenkins$.$anonfun$build_job_names$3(_class))).flatMap((Function1 & Serializable & scala.Serializable)_class -> JSON$.MODULE$.string(job, "name").map((Function1 & Serializable & scala.Serializable)name -> name))), List$.MODULE$.canBuildFrom());
    }

    public void download_logs(List<String> job_names, Path dir, Progress progress) {
        Sessions.Store store = Sessions$.MODULE$.store(Sessions$.MODULE$.store$default$1());
        List infos = (List)job_names.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.build_job_infos((String)x$1), List$.MODULE$.canBuildFrom());
        Par_List$.MODULE$.map((Function1 & Serializable & scala.Serializable)info -> {
            info.download_log(store, dir, progress);
            return BoxedUnit.UNIT;
        }, infos);
    }

    public Progress download_logs$default$3() {
        return No_Progress$.MODULE$;
    }

    public List<String> build_log_jobs() {
        return this.build_log_jobs;
    }

    public List<Build_Status.Profile> build_status_profiles() {
        return this.build_status_profiles;
    }

    public List<Jenkins.Job_Info> build_job_infos(String job_name) {
        Regex Session_Log = new Regex("^.*/log/([^/]+)\\.(db|gz)$", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        String string = job_name;
        String string2 = "identify";
        boolean identify = !(string != null ? !string.equals(string2) : string2 != null);
        String job = identify ? "isabelle-nightly-slow" : job_name;
        List infos = (List)((List)JSON$.MODULE$.array(this.invoke(this.root() + "/job/" + job, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tree=allBuilds[number,timestamp,artifacts[*]]"})), "allBuilds").getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)build -> Option$.MODULE$.option2Iterable(JSON$.MODULE$.int(build, "number").flatMap((Function1 & Serializable & scala.Serializable)number -> Jenkins$.$anonfun$build_job_infos$3(job_name, Session_Log, identify, job, build, BoxesRunTime.unboxToInt((Object)number)))), List$.MODULE$.canBuildFrom());
        return (List)infos.sortBy((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToLong((long)Jenkins$.$anonfun$build_job_infos$10(info)), (Ordering)Ordering.Long$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$build_job_names$3(String _class) {
        String string = _class;
        String string2 = "hudson.model.FreeStyleProject";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$build_job_infos$8(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ Jenkins.Job_Info $anonfun$build_job_infos$4(String job_name$1, Regex Session_Log$1, boolean identify$1, String job$1, Object build$1, int number$1, long timestamp) {
        String job_prefix = MODULE$.root() + "/job/" + job$1 + "/" + number$1;
        URL main_log = Url$.MODULE$.apply(job_prefix + "/consoleText");
        Nil$ session_logs = identify$1 ? Nil$.MODULE$ : (List)((List)JSON$.MODULE$.array(build$1, "artifacts").getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)artifact -> Option$.MODULE$.option2Iterable(JSON$.MODULE$.string(artifact, "relativePath").flatMap((Function1 & Serializable & scala.Serializable)log_path -> {
            None$ none$;
            String string = log_path;
            Option option = Session_Log$1.unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                String a = (String)((LinearSeqOptimized)option.get()).apply(0);
                String b = (String)((LinearSeqOptimized)option.get()).apply(1);
                none$ = new Some((Object)new Tuple2((Object)a, (Object)b));
            } else {
                none$ = None$.MODULE$;
            }
            return none$.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Jenkins$.$anonfun$build_job_infos$8(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$6 -> {
                Tuple2 tuple2 = x$6;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String name = (String)tuple2._1();
                String ext = (String)tuple2._2();
                Tuple3 tuple3 = new Tuple3((Object)name, (Object)ext, (Object)Url$.MODULE$.apply(job_prefix + "/artifact/" + log_path));
                return tuple3;
            });
        })), List$.MODULE$.canBuildFrom());
        return new Jenkins.Job_Info(job_name$1, identify$1, timestamp, main_log, (List<Tuple3<String, String, URL>>)session_logs);
    }

    public static final /* synthetic */ Option $anonfun$build_job_infos$3(String job_name$1, Regex Session_Log$1, boolean identify$1, String job$1, Object build$1, int number) {
        return JSON$.MODULE$.long(build$1, "timestamp").map((Function1 & Serializable & scala.Serializable)timestamp -> Jenkins$.$anonfun$build_job_infos$4(job_name$1, Session_Log$1, identify$1, job$1, build$1, number, BoxesRunTime.unboxToLong((Object)timestamp)));
    }

    public static final /* synthetic */ long $anonfun$build_job_infos$10(Jenkins.Job_Info info) {
        return -info.timestamp();
    }

    private Jenkins$() {
        MODULE$ = this;
        this.build_log_jobs = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"isabelle-nightly-benchmark", "isabelle-nightly-slow"}));
        this.build_status_profiles = (List)this.build_log_jobs().map((Function1 & Serializable & scala.Serializable)job_name -> new Build_Status.Profile("jenkins " + job_name, 0, Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)Build_Log$Prop$.MODULE$.build_engine()), " = ") + SQL$.MODULE$.string(Build_Log$Jenkins$.MODULE$.engine()) + " AND " + Build_Log$Data$.MODULE$.session_name() + " <> " + SQL$.MODULE$.string("Pure") + " AND " + Build_Log$Data$.MODULE$.status() + " = " + SQL$.MODULE$.string(Build_Log$Session_Status$.MODULE$.finished().toString()) + " AND " + Build_Log$Data$.MODULE$.log_name() + " LIKE " + SQL$.MODULE$.string("%" + job_name)), List$.MODULE$.canBuildFrom());
    }
}

