/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.print;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.HashMap;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.print.BufferPrinter1_7;
import org.gjt.sp.jedit.print.Range;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;

public class PageBreakExtension
extends TextAreaExtension
implements EBComponent {
    private JEditTextArea textArea;
    private boolean showPageBreak;
    private Color pageBreakColor;
    private HashMap<Integer, Range> pages = null;

    public PageBreakExtension(JEditTextArea textArea) {
        this.textArea = textArea;
        textArea.getPainter().addExtension(-20, this);
        this.showPageBreak = jEdit.getBooleanProperty("view.pageBreaks", false);
        this.pageBreakColor = jEdit.getColorProperty("view.pageBreaksColor");
        EditBus.addToBus(this);
    }

    private void loadPageRanges() {
        if (this.showPageBreak) {
            View view = this.textArea.getView();
            Buffer buffer = (Buffer)this.textArea.getBuffer();
            this.pages = BufferPrinter1_7.getPageRanges(view, buffer, null);
        } else {
            this.pages = null;
        }
    }

    @Override
    public void handleMessage(EBMessage msg) {
        BufferUpdate bu;
        if (msg instanceof PropertiesChanged) {
            this.showPageBreak = jEdit.getBooleanProperty("view.pageBreaks");
            this.pageBreakColor = jEdit.getColorProperty("view.pageBreaksColor");
            this.loadPageRanges();
        } else if (msg instanceof EditPaneUpdate) {
            EditPaneUpdate epu = (EditPaneUpdate)msg;
            if (EditPaneUpdate.BUFFER_CHANGED.equals(epu.getWhat()) && epu.getEditPane().getBuffer().isLoaded()) {
                this.loadPageRanges();
            }
        } else if (msg instanceof BufferUpdate && (BufferUpdate.SAVED.equals((bu = (BufferUpdate)msg).getWhat()) || BufferUpdate.LOADED.equals(bu.getWhat()))) {
            this.loadPageRanges();
        }
    }

    public Color getPageBreakColor() {
        return this.pageBreakColor;
    }

    public void setPageBreakColor(Color pageBreakColor) {
        this.pageBreakColor = pageBreakColor;
    }

    public boolean isPageBreakEnabled() {
        return this.showPageBreak;
    }

    public void setPageBreakEnabled(boolean pageBreak) {
        this.showPageBreak = pageBreak;
    }

    @Override
    public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
        if (this.showPageBreak) {
            if (this.pages == null || this.pages.isEmpty()) {
                this.loadPageRanges();
                if (this.pages == null || this.pages.isEmpty()) {
                    return;
                }
            }
            gfx.setColor(this.pageBreakColor);
            for (int page = 1; page < this.pages.size(); ++page) {
                Range range = this.pages.get(page);
                if (range.getEnd() != physicalLine || this.textArea.getLineEndOffset(physicalLine) != end) continue;
                gfx.drawLine(0, y += gfx.getFontMetrics().getHeight(), this.textArea.getPainter().getWidth(), y);
            }
        }
    }
}

