/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Dimension;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.DockableWindowContainer;
import org.gjt.sp.jedit.gui.DockableWindowManagerImpl;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.GenericGUIUtilities;

public class FloatingWindowContainer
extends JDialog
implements DockableWindowContainer,
PropertyChangeListener {
    String dockableName = null;
    private final DockableWindowManagerImpl dockableWindowManager;
    private final boolean clone;
    private DockableWindowManagerImpl.Entry entry;
    private final JButton menu;

    public FloatingWindowContainer(DockableWindowManagerImpl dockableWindowManager, boolean clone) {
        super(dockableWindowManager.getView());
        this.dockableWindowManager = dockableWindowManager;
        dockableWindowManager.addPropertyChangeListener(this);
        this.clone = clone;
        this.setIconImage(GUIUtilities.getPluginIcon());
        this.setDefaultCloseOperation(2);
        Box caption = new Box(0);
        this.menu = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("dropdown-arrow.icon")));
        caption.add(this.menu);
        this.menu.addMouseListener(new MouseHandler());
        this.menu.setToolTipText(jEdit.getProperty("docking.menu.label"));
        Box separatorBox = new Box(1);
        separatorBox.add(Box.createVerticalStrut(3));
        separatorBox.add(new JSeparator(0));
        separatorBox.add(Box.createVerticalStrut(3));
        caption.add(separatorBox);
        this.getContentPane().add("North", caption);
    }

    @Override
    public void register(DockableWindowManagerImpl.Entry entry) {
        this.entry = entry;
        this.dockableName = entry.factory.name;
        this.setTitle(entry.shortTitle());
        this.getContentPane().add("Center", entry.win);
        this.pack();
        View parent = this.dockableWindowManager.getView();
        GUIUtilities.loadGeometry(this, parent, this.dockableName);
        KeyListener listener = this.dockableWindowManager.closeListener(this.dockableName);
        this.addKeyListener(listener);
        this.getContentPane().addKeyListener(listener);
        this.menu.addKeyListener(listener);
        entry.win.addKeyListener(listener);
        this.setVisible(true);
        if (!entry.win.isVisible()) {
            entry.win.setVisible(true);
        }
    }

    @Override
    public void remove(DockableWindowManagerImpl.Entry entry) {
        this.dispose();
    }

    @Override
    public void unregister(DockableWindowManagerImpl.Entry entry) {
        this.entry = null;
        entry.btn = null;
        entry.container = null;
        super.dispose();
    }

    @Override
    public void show(final DockableWindowManagerImpl.Entry entry) {
        if (entry == null) {
            this.dispose();
        } else {
            this.setTitle(entry.longTitle());
            this.toFront();
            this.requestFocus();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (entry.win instanceof DefaultFocusComponent) {
                        ((DefaultFocusComponent)((Object)entry.win)).focusOnDefaultComponent();
                    } else {
                        entry.win.requestFocus();
                    }
                }
            });
        }
    }

    @Override
    public boolean isVisible(DockableWindowManagerImpl.Entry entry) {
        return true;
    }

    @Override
    public void dispose() {
        GUIUtilities.saveGeometry(this, this.dockableWindowManager.getView(), this.dockableName);
        if (this.entry != null) {
            this.entry.container = null;
            this.entry.win = null;
        }
        super.dispose();
    }

    public DockableWindowManagerImpl getDockableWindowManager() {
        return this.dockableWindowManager;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.dockableName == null) {
            return;
        }
        String pn = evt.getPropertyName();
        if (pn.startsWith(this.dockableName) && pn.endsWith("title")) {
            this.setTitle(evt.getNewValue().toString());
        }
    }

    class MouseHandler
    extends MouseAdapter {
        JPopupMenu popup;

        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (this.popup != null && this.popup.isVisible()) {
                this.popup.setVisible(false);
            } else {
                this.popup = FloatingWindowContainer.this.dockableWindowManager.createPopupMenu(FloatingWindowContainer.this, ((FloatingWindowContainer)FloatingWindowContainer.this).entry.factory.name, FloatingWindowContainer.this.clone);
                GenericGUIUtilities.showPopupMenu(this.popup, FloatingWindowContainer.this.menu, FloatingWindowContainer.this.menu.getX(), FloatingWindowContainer.this.menu.getY() + FloatingWindowContainer.this.menu.getHeight(), false);
            }
        }
    }
}

