/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.CompletionPopup;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.visitors.JEditVisitorAdapter;
import org.gjt.sp.util.StandardUtilities;

public class CompleteWord
extends CompletionPopup {
    private View view;
    private JEditTextArea textArea;
    private Buffer buffer;
    private String word;
    private String noWordSep;

    public static void completeWord(View view) {
        JEditTextArea textArea = view.getTextArea();
        Buffer buffer = view.getBuffer();
        int caretLine = textArea.getCaretLine();
        int caret = textArea.getCaretPosition();
        if (!buffer.isEditable()) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        KeywordMap keywordMap = buffer.getKeywordMapAtOffset(caret);
        String noWordSep = CompleteWord.getNonAlphaNumericWordChars(buffer, keywordMap);
        String word = CompleteWord.getWordToComplete(buffer, caretLine, caret, noWordSep);
        if (word == null) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        Object[] completions = CompleteWord.getCompletions(buffer, word, caret);
        if (completions.length == 0) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
        } else if (completions.length == 1) {
            Completion c = completions[0];
            if (c.text.equals(word)) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
            } else {
                textArea.replaceSelection(c.text.substring(word.length()));
            }
        } else {
            String longestPrefix = MiscUtilities.getLongestPrefix(completions, keywordMap != null && keywordMap.getIgnoreCase());
            if (word.length() < longestPrefix.length()) {
                buffer.insert(caret, longestPrefix.substring(word.length()));
            }
            textArea.scrollToCaret(false);
            Point location = textArea.offsetToXY(caret - word.length());
            location.y += textArea.getPainter().getLineHeight();
            SwingUtilities.convertPointToScreen(location, textArea.getPainter());
            new CompleteWord(view, longestPrefix, (Completion[])completions, location, noWordSep);
        }
    }

    public CompleteWord(View view, String word, Completion[] completions, Point location, String noWordSep) {
        super(view, location);
        this.noWordSep = noWordSep;
        this.view = view;
        this.textArea = view.getTextArea();
        this.buffer = view.getBuffer();
        this.word = word;
        this.reset(new Words(completions), true);
    }

    private static String getNonAlphaNumericWordChars(Buffer buffer, KeywordMap keywordMap) {
        String keywordNoWordSep;
        String noWordSep = buffer.getStringProperty("noWordSep");
        if (noWordSep == null) {
            noWordSep = "";
        }
        if (keywordMap != null && (keywordNoWordSep = keywordMap.getNonAlphaNumericChars()) != null) {
            noWordSep = noWordSep + keywordNoWordSep;
        }
        return noWordSep;
    }

    private static String getWordToComplete(Buffer buffer, int caretLine, int caret, String noWordSep) {
        CharSequence line = buffer.getLineSegment(caretLine);
        int dot = caret - buffer.getLineStartOffset(caretLine);
        if (dot == 0) {
            return null;
        }
        char ch = line.charAt(dot - 1);
        if (!Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1) {
            return null;
        }
        int wordStart = TextUtilities.findWordStart(line, dot - 1, noWordSep);
        CharSequence word = line.subSequence(wordStart, dot);
        if (word.length() == 0) {
            return null;
        }
        return word.toString();
    }

    private static Collection<Buffer> getVisibleBuffers() {
        final HashSet<Buffer> buffers = new HashSet<Buffer>();
        jEdit.visit(new JEditVisitorAdapter(){

            @Override
            public void visit(EditPane editPane) {
                buffers.add(editPane.getBuffer());
            }
        });
        return buffers;
    }

    private static Completion[] getCompletions(Buffer buffer, String word, int caret) {
        TreeSet<Completion> completions = new TreeSet<Completion>(new StandardUtilities.StringCompare());
        KeywordMap keywordMap = buffer.getKeywordMapAtOffset(caret);
        String noWordSep = CompleteWord.getNonAlphaNumericWordChars(buffer, keywordMap);
        Collection<Buffer> sourceBuffers = jEdit.getBooleanProperty("completeFromAllBuffers") ? Arrays.asList(jEdit.getBuffers()) : CompleteWord.getVisibleBuffers();
        for (Buffer b : sourceBuffers) {
            KeywordMap _keywordMap = b == buffer ? keywordMap : null;
            int offset = b == buffer ? caret : 0;
            CompleteWord.getCompletions(b, word, keywordMap, noWordSep, offset, completions);
        }
        Completion[] completionArray = completions.toArray(new Completion[completions.size()]);
        return completionArray;
    }

    private static void getCompletions(Buffer buffer, String word, KeywordMap keywordMap, String noWordSep, int caret, Set<Completion> completions) {
        int wordLen = word.length();
        if (keywordMap != null) {
            String[] keywords;
            for (String _keyword : keywords = keywordMap.getKeywords()) {
                Completion keyword;
                if (!_keyword.regionMatches(keywordMap.getIgnoreCase(), 0, word, 0, wordLen) || completions.contains(keyword = new Completion(_keyword, true))) continue;
                completions.add(keyword);
            }
        }
        for (int i = 0; i < buffer.getLineCount(); ++i) {
            String _word;
            Completion comp;
            CharSequence line = buffer.getLineSegment(i);
            int start = buffer.getLineStartOffset(i);
            if (StandardUtilities.startsWith(line, word) && caret != start + word.length() && !completions.contains(comp = new Completion(_word = CompleteWord.completeWord(line, 0, noWordSep), false))) {
                completions.add(comp);
            }
            int len = line.length() - word.length();
            for (int j = 0; j < len; ++j) {
                String _word2;
                Completion comp2;
                char c = line.charAt(j);
                if (Character.isLetterOrDigit(c) || noWordSep.indexOf(c) != -1 || !StandardUtilities.regionMatches(line, j + 1, word, 0, wordLen) || caret == start + j + word.length() + 1 || completions.contains(comp2 = new Completion(_word2 = CompleteWord.completeWord(line, j + 1, noWordSep), false))) continue;
                completions.add(comp2);
            }
        }
    }

    private static String completeWord(CharSequence line, int offset, String noWordSep) {
        int wordEnd = TextUtilities.findWordEnd(line, offset + 1, noWordSep);
        return line.subSequence(offset, wordEnd).toString();
    }

    private void resetWords(String newWord) {
        int caret = this.textArea.getCaretPosition();
        Completion[] completions = CompleteWord.getCompletions(this.buffer, newWord, caret);
        if (completions.length > 0) {
            this.word = newWord;
            this.reset(new Words(completions), true);
        } else {
            this.dispose();
        }
    }

    @Override
    protected void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 8) {
            this.textArea.backspace();
            e.consume();
            if (this.word.length() == 1) {
                this.dispose();
            } else {
                this.resetWords(this.word.substring(0, this.word.length() - 1));
            }
        }
    }

    @Override
    protected void keyTyped(KeyEvent e) {
        char ch = e.getKeyChar();
        if (jEdit.getBooleanProperty("insertCompletionWithDigit") && Character.isDigit(ch)) {
            int index = ch - 48;
            index = index == 0 ? 9 : --index;
            if (index < this.getCandidates().getSize()) {
                this.setSelectedIndex(index);
                if (this.doSelectedCompletion()) {
                    e.consume();
                    this.dispose();
                }
                return;
            }
        }
        if (ch != '\b' && ch != '\t') {
            if (!Character.isLetterOrDigit(ch) && this.noWordSep.indexOf(ch) == -1) {
                this.doSelectedCompletion();
                this.textArea.userInput(ch);
                e.consume();
                this.dispose();
                return;
            }
            this.textArea.userInput(ch);
            e.consume();
            this.resetWords(this.word + ch);
        }
    }

    private class Words
    implements CompletionPopup.Candidates {
        private final DefaultListCellRenderer renderer = new DefaultListCellRenderer();
        private final Completion[] completions;

        public Words(Completion[] completions) {
            this.completions = completions;
        }

        @Override
        public int getSize() {
            return this.completions.length;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public void complete(int index) {
            String insertion = this.completions[index].toString().substring(CompleteWord.this.word.length());
            CompleteWord.this.textArea.replaceSelection(insertion);
        }

        @Override
        public Component getCellRenderer(JList list, int index, boolean isSelected, boolean cellHasFocus) {
            this.renderer.getListCellRendererComponent((JList<?>)list, (Object)null, index, isSelected, cellHasFocus);
            Completion comp = this.completions[index];
            String text = comp.text;
            Font font = list.getFont();
            if (index < 9) {
                text = index + 1 + ": " + text;
            } else if (index == 9) {
                text = "0: " + text;
            }
            if (comp.keyword) {
                font = font.deriveFont(1);
            }
            this.renderer.setText(text);
            this.renderer.setFont(font);
            return this.renderer;
        }

        @Override
        public String getDescription(int index) {
            return null;
        }
    }

    private static class Completion {
        final String text;
        final boolean keyword;

        Completion(String text, boolean keyword) {
            this.text = text;
            this.keyword = keyword;
        }

        public String toString() {
            return this.text;
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Completion) {
                return ((Completion)obj).text.equals(this.text);
            }
            return false;
        }
    }
}

