/*
 * Decompiled with CFR 0.152.
 */
package console;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class DirectoryStack {
    LinkedList<String> mList = new LinkedList();
    private static Pattern makeEntering;
    private static Pattern makeLeaving;

    public boolean processLine(String line) {
        Matcher match = makeEntering.matcher(line);
        if (match.find()) {
            String enteringDir = match.group(1);
            this.push(enteringDir);
            return true;
        }
        match = makeLeaving.matcher(line);
        if (match.find() && !this.isEmpty()) {
            this.pop();
            return true;
        }
        return false;
    }

    public String current() {
        return this.mList.getLast();
    }

    public void push(String v) {
        if (v != null) {
            this.mList.add(v);
        }
    }

    public boolean isEmpty() {
        return this.mList.isEmpty();
    }

    public String pop() {
        if (this.mList.size() < 1) {
            return null;
        }
        String retval = this.mList.removeLast();
        return retval;
    }

    public static void main(String[] args) {
        DirectoryStack ds = new DirectoryStack();
        ds.push("Hello");
        ds.push("there");
        System.out.println(ds.pop());
        System.out.println(ds.pop());
        System.out.println(ds.pop());
    }

    static {
        try {
            makeEntering = Pattern.compile(jEdit.getProperty((String)"console.error.make.entering"));
            makeLeaving = Pattern.compile(jEdit.getProperty((String)"console.error.make.leaving"));
        }
        catch (PatternSyntaxException re) {
            Log.log((int)9, DirectoryStack.class, (Object)re);
        }
    }
}

