/*
 * Decompiled with CFR 0.152.
 */
package common.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;

public class VFSPathFileList
extends JPanel {
    private JList searchList;
    private DefaultListModel model;
    private JButton add;
    private JButton remove;
    private String pathProperty;
    private JScrollPane scroll;

    public VFSPathFileList() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BoxLayout(this, 1));
        this.model = new DefaultListModel();
        this.searchList = new JList(this.model);
        this.searchList.setPrototypeCellValue("a");
        this.add = new JButton(jEdit.getProperty((String)"common.add"));
        this.remove = new JButton(jEdit.getProperty((String)"common.remove"));
        MyActionListener actionListener = new MyActionListener();
        this.add.addActionListener(actionListener);
        this.remove.addActionListener(actionListener);
        Box box = Box.createHorizontalBox();
        box.add(this.add);
        box.add(Box.createHorizontalStrut(6));
        box.add(this.remove);
        box.add(Box.createHorizontalGlue());
        this.scroll = new JScrollPane(this.searchList);
        this.add(this.scroll);
        this.add(box);
    }

    public VFSPathFileList(String pathProperty) {
        this();
        this.pathProperty = pathProperty;
        this.scroll.setBorder(BorderFactory.createTitledBorder(jEdit.getProperty((String)(pathProperty + ".label"))));
        String property = jEdit.getProperty((String)pathProperty, (String)"");
        StringTokenizer tokenizer = new StringTokenizer(property, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            this.addPath(s);
        }
    }

    public void save() {
        if (this.pathProperty != null) {
            jEdit.setProperty((String)this.pathProperty, (String)this.getPaths());
        }
    }

    public String getPaths() {
        int size = this.model.size();
        ArrayList<String> paths = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            String path = (String)this.model.getElementAt(i);
            paths.add(path);
        }
        return TextUtilities.join(paths, (String)File.pathSeparator);
    }

    private void addPath(String path) {
        if (path != null && !path.isEmpty() && !this.model.contains(path)) {
            this.model.addElement(path);
        }
    }

    private class MyActionListener
    implements ActionListener {
        private String lastBrowserDialog;

        private MyActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int selectedIndex;
            String[] strings;
            if (e.getSource() == VFSPathFileList.this.add && (strings = GUIUtilities.showVFSFileDialog((View)jEdit.getActiveView(), (String)this.lastBrowserDialog, (int)3, (boolean)true)) != null) {
                String[] arr$ = strings;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String string;
                    this.lastBrowserDialog = string = arr$[i$];
                    VFSPathFileList.this.addPath(string);
                }
            }
            if (e.getSource() == VFSPathFileList.this.remove && (selectedIndex = VFSPathFileList.this.searchList.getSelectedIndex()) != -1) {
                VFSPathFileList.this.model.remove(selectedIndex);
            }
        }
    }
}

