/*
 * Decompiled with CFR 0.152.
 */
package code2html.impl.htmlcss;

import code2html.generic.Style;
import java.awt.Color;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.util.SyntaxUtilities;

public class HtmlCssStyle
extends Style {
    public String format(int styleId, SyntaxStyle style, String text) {
        StringBuffer buf = new StringBuffer();
        buf.append("<span class=\"syntax-" + HtmlCssStyle.getTokenString(styleId) + "\">").append(text).append("</span>");
        String formattedText = buf.toString();
        return this.getLinkText(styleId, text, formattedText);
    }

    public String style(int styleId, SyntaxStyle style) {
        if (style == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(".syntax-" + HtmlCssStyle.getTokenString(styleId) + " {\n");
        Color c = style.getBackgroundColor();
        if (c != null) {
            buf.append("  background: ").append(SyntaxUtilities.getColorHexString((Color)c)).append(";\n");
        }
        if ((c = style.getForegroundColor()) != null) {
            buf.append("  color: ").append(SyntaxUtilities.getColorHexString((Color)c)).append(";\n");
        }
        if (style.getFont().isBold()) {
            buf.append("  font-weight: bold;\n");
        }
        if (style.getFont().isItalic()) {
            buf.append("  font-style: italic;\n");
        }
        buf.append("}\n");
        if (this.doLinks) {
            buf.append("a{\n");
            buf.append("  text-decoration:none;");
            buf.append("}\n");
        }
        return buf.toString();
    }

    public String getMode() {
        return "css";
    }
}

