/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginListHandler;
import org.gjt.sp.jedit.pluginmgr.Roster;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.Task;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

class PluginList {
    public static final int GZIP_MAGIC_1 = 31;
    public static final int GZIP_MAGIC_2 = 139;
    public static final long MILLISECONDS_PER_MINUTE = 60000L;
    final List<Plugin> plugins = new ArrayList<Plugin>();
    final Map<String, Plugin> pluginHash = new HashMap<String, Plugin>();
    final List<PluginSet> pluginSets = new ArrayList<PluginSet>();
    private final String id = jEdit.getProperty("plugin-manager.mirror.id");
    private String cachedURL;
    private final Task task;
    String gzipURL;

    PluginList(Task task) {
        this.task = task;
        this.readPluginList(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readPluginList(boolean allowRetry) {
        boolean downloadIt;
        String mirror = PluginList.buildMirror(this.id);
        if (mirror == null) {
            return;
        }
        this.gzipURL = jEdit.getProperty("plugin-manager.export-url");
        this.gzipURL = this.gzipURL + "?mirror=" + mirror;
        String path = null;
        if (jEdit.getSettingsDirectory() == null) {
            this.cachedURL = this.gzipURL;
        } else {
            path = jEdit.getSettingsDirectory() + File.separator + "pluginMgr-Cached.xml.gz";
            this.cachedURL = "file:///" + path;
        }
        boolean bl = downloadIt = !this.id.equals(jEdit.getProperty("plugin-manager.mirror.cached-id"));
        if (path != null) {
            try {
                long interval;
                long currentTime;
                long age;
                File f = new File(path);
                if (!f.canRead()) {
                    downloadIt = true;
                }
                if ((age = (currentTime = System.currentTimeMillis()) - f.lastModified()) > (interval = (long)jEdit.getIntegerProperty("plugin-manager.list-cache.minutes", 5) * 60000L)) {
                    Log.log(3, this, "PluginList cached copy too old. Downloading from mirror. ");
                    downloadIt = true;
                }
            }
            catch (Exception e) {
                Log.log(3, this, "No cached copy. Downloading from mirror. ");
                downloadIt = true;
            }
        }
        if (downloadIt && this.cachedURL != this.gzipURL) {
            this.downloadPluginList();
        }
        FilterInputStream in = null;
        InputStream inputStream = null;
        try {
            if (this.cachedURL != this.gzipURL) {
                Log.log(3, this, "Using cached pluginlist");
            }
            inputStream = new URL(this.cachedURL).openStream();
            XMLReader parser = XMLReaderFactory.createXMLReader();
            PluginListHandler handler = new PluginListHandler(this, this.cachedURL);
            in = new BufferedInputStream(inputStream);
            if (((InputStream)in).markSupported()) {
                ((InputStream)in).mark(2);
                int b1 = ((InputStream)in).read();
                int b2 = ((InputStream)in).read();
                ((InputStream)in).reset();
                if (b1 == 31 && b2 == 139) {
                    in = new GZIPInputStream(in);
                }
            }
            InputSource isrc = new InputSource(new InputStreamReader((InputStream)in, "UTF8"));
            isrc.setSystemId("jedit.jar");
            parser.setContentHandler(handler);
            parser.setDTDHandler(handler);
            parser.setEntityResolver(handler);
            parser.setErrorHandler(handler);
            parser.parse(isrc);
        }
        catch (Exception e) {
            block16: {
                try {
                    Log.log(9, this, "readpluginlist: error", e);
                    if (!this.cachedURL.startsWith("file:///")) break block16;
                    Log.log(1, this, "Unable to read plugin list, deleting cached file and try again");
                    new File(this.cachedURL.substring(8)).delete();
                    if (!allowRetry) break block16;
                    this.plugins.clear();
                    this.pluginHash.clear();
                    this.pluginSets.clear();
                    this.readPluginList(false);
                }
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly(in);
                    IOUtilities.closeQuietly(inputStream);
                    throw throwable;
                }
            }
            IOUtilities.closeQuietly(in);
            IOUtilities.closeQuietly(inputStream);
        }
        IOUtilities.closeQuietly(in);
        IOUtilities.closeQuietly(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void downloadPluginList() {
        BufferedInputStream is = null;
        BufferedOutputStream out = null;
        try {
            this.task.setStatus(jEdit.getProperty("plugin-manager.list-download"));
            URL downloadURL = new URL(this.gzipURL);
            HttpURLConnection c = (HttpURLConnection)downloadURL.openConnection();
            if (c.getResponseCode() == 407) {
                GUIUtilities.error(jEdit.getActiveView(), "plugin-manager.list-download.need-password", new Object[0]);
                Log.log(9, this, "CacheRemotePluginList: proxy requires authentication");
            } else if (c.getResponseCode() == 200) {
                InputStream inputStream = c.getInputStream();
                String fileName = this.cachedURL.replaceFirst("file:///", "");
                out = new BufferedOutputStream(new FileOutputStream(fileName));
                long start = System.currentTimeMillis();
                is = new BufferedInputStream(inputStream);
                IOUtilities.copyStream(4096, null, is, out, false);
                jEdit.setProperty("plugin-manager.mirror.cached-id", this.id);
                Log.log(3, this, "Updated cached pluginlist " + (System.currentTimeMillis() - start));
            } else {
                GUIUtilities.error(jEdit.getActiveView(), "plugin-manager.list-download.generic-error", new Object[]{c.getResponseCode(), c.getResponseMessage()});
                Log.log(9, this, "CacheRemotePluginList: HTTP error: " + c.getResponseCode() + c.getResponseMessage());
            }
        }
        catch (UnknownHostException e) {
            GUIUtilities.error(jEdit.getActiveView(), "plugin-manager.list-download.disconnected", new Object[]{e.getMessage()});
            Log.log(9, this, "CacheRemotePluginList: error", e);
        }
        catch (Exception e) {
            Log.log(9, this, "CacheRemotePluginList: error", e);
        }
        finally {
            IOUtilities.closeQuietly(out);
            IOUtilities.closeQuietly(is);
        }
    }

    void addPlugin(Plugin plugin) {
        plugin.checkIfInstalled();
        this.plugins.add(plugin);
        this.pluginHash.put(plugin.name, plugin);
    }

    void addPluginSet(PluginSet set) {
        this.pluginSets.add(set);
    }

    void finished() {
        for (Plugin plugin : this.plugins) {
            for (int j = 0; j < plugin.branches.size(); ++j) {
                Branch branch = plugin.branches.get(j);
                for (int k = 0; k < branch.deps.size(); ++k) {
                    Dependency dep = branch.deps.get(k);
                    if (!dep.what.equals("plugin")) continue;
                    dep.plugin = this.pluginHash.get(dep.pluginName);
                }
            }
        }
    }

    void dump() {
        for (Plugin plugin : this.plugins) {
            System.err.println(plugin);
            System.err.println();
        }
    }

    String getMirrorId() {
        return this.id;
    }

    private static String buildMirror(String id) {
        if (id != null && !id.equals("NONE")) {
            return id;
        }
        try {
            return PluginList.getAutoSelectedMirror();
        }
        catch (Exception e) {
            GUIUtilities.error(jEdit.getActiveView(), "plugin-manager.list-download.mirror-autoselect-error", new Object[]{e});
            Log.log(1, PluginList.class, "Getting auto-selected mirror: error", e);
            return null;
        }
    }

    private static String getAutoSelectedMirror() throws IOException {
        String samplerUrl = "http://sourceforge.net/projects/jedit/files/latest/download";
        HttpURLConnection connection = (HttpURLConnection)new URL("http://sourceforge.net/projects/jedit/files/latest/download").openConnection();
        connection.setInstanceFollowRedirects(false);
        int response = connection.getResponseCode();
        if (response != 302) {
            throw new RuntimeException("Unexpected response: " + response + ": from " + "http://sourceforge.net/projects/jedit/files/latest/download");
        }
        String redirected = connection.getHeaderField("Location");
        if (redirected == null) {
            throw new RuntimeException("Missing Location header: http://sourceforge.net/projects/jedit/files/latest/download");
        }
        String prefix = "use_mirror=";
        int found = redirected.lastIndexOf("use_mirror=");
        if (found == -1) {
            throw new RuntimeException("Mirror prefix \"use_mirror\" was not found in redirected URL: " + redirected);
        }
        int start = found + "use_mirror=".length();
        int end = redirected.indexOf(38, start);
        return end != -1 ? redirected.substring(start, end) : redirected.substring(start);
    }

    static class Dependency {
        final String what;
        final String from;
        final String to;
        final String pluginName;
        Plugin plugin;

        Dependency(String what, String from, String to, String pluginName) {
            this.what = what;
            this.from = from;
            this.to = to;
            this.pluginName = pluginName;
        }

        boolean isSatisfied() {
            if (this.what.equals("plugin")) {
                for (int i = 0; i < this.plugin.branches.size(); ++i) {
                    String installedVersion = this.plugin.getInstalledVersion();
                    if (installedVersion == null || this.from != null && StandardUtilities.compareStrings(installedVersion, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(installedVersion, this.to, false) > 0) continue;
                    return true;
                }
                return false;
            }
            if (this.what.equals("jdk")) {
                String javaVersion = System.getProperty("java.version").substring(0, 3);
                return !(this.from != null && StandardUtilities.compareStrings(javaVersion, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(javaVersion, this.to, false) > 0);
            }
            if (this.what.equals("jedit")) {
                String build = jEdit.getBuild();
                return !(this.from != null && StandardUtilities.compareStrings(build, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(build, this.to, false) > 0);
            }
            Log.log(9, this, "Invalid dependency: " + this.what);
            return false;
        }

        boolean canSatisfy() {
            if (this.isSatisfied()) {
                return true;
            }
            if (this.what.equals("plugin")) {
                return this.plugin.canBeInstalled();
            }
            return false;
        }

        void satisfy(Roster roster, String installDirectory, boolean downloadSource) {
            if (this.what.equals("plugin")) {
                String installedVersion = this.plugin.getInstalledVersion();
                for (int i = 0; i < this.plugin.branches.size(); ++i) {
                    Branch branch = this.plugin.branches.get(i);
                    if (installedVersion != null && StandardUtilities.compareStrings(installedVersion, branch.version, false) >= 0 || this.from != null && StandardUtilities.compareStrings(branch.version, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(branch.version, this.to, false) > 0) continue;
                    this.plugin.install(roster, installDirectory, downloadSource);
                    return;
                }
            }
        }

        public String toString() {
            return "[what=" + this.what + ",from=" + this.from + ",to=" + this.to + ",plugin=" + this.plugin + ']';
        }
    }

    static class Branch {
        String version;
        String date;
        int downloadSize;
        String download;
        int downloadSourceSize;
        String downloadSource;
        boolean obsolete;
        final List<Dependency> deps = new ArrayList<Dependency>();

        Branch() {
        }

        boolean canSatisfyDependencies() {
            for (Dependency dep : this.deps) {
                if (dep.canSatisfy()) continue;
                return false;
            }
            return true;
        }

        void satisfyDependencies(Roster roster, String installDirectory, boolean downloadSource) {
            for (Dependency dep : this.deps) {
                dep.satisfy(roster, installDirectory, downloadSource);
            }
        }

        public String depsToString() {
            StringBuilder sb = new StringBuilder();
            for (Dependency dep : this.deps) {
                if (!"plugin".equals(dep.what) || dep.pluginName == null) continue;
                sb.append(dep.pluginName).append('\n');
            }
            return sb.toString();
        }

        public String toString() {
            return "[version=" + this.version + ",download=" + this.download + ",obsolete=" + this.obsolete + ",deps=" + this.deps + ']';
        }
    }

    public static class Plugin {
        String jar;
        String name;
        String description;
        String author;
        final List<Branch> branches = new ArrayList<Branch>();

        void checkIfInstalled() {
        }

        String getInstalledVersion() {
            PluginJAR[] jars = jEdit.getPluginJARs();
            for (int i = 0; i < jars.length; ++i) {
                String path = jars[i].getPath();
                if (!MiscUtilities.getFileName(path).equals(this.jar)) continue;
                EditPlugin plugin = jars[i].getPlugin();
                if (plugin != null) {
                    return jEdit.getProperty("plugin." + plugin.getClassName() + ".version");
                }
                return null;
            }
            return null;
        }

        String getInstalledPath() {
            PluginJAR[] jars = jEdit.getPluginJARs();
            for (int i = 0; i < jars.length; ++i) {
                String path = jars[i].getPath();
                if (!MiscUtilities.getFileName(path).equals(this.jar)) continue;
                return path;
            }
            return null;
        }

        Branch getCompatibleBranch() {
            for (Branch branch : this.branches) {
                if (!branch.canSatisfyDependencies()) continue;
                return branch;
            }
            return null;
        }

        boolean canBeInstalled() {
            Branch branch = this.getCompatibleBranch();
            return branch != null && !branch.obsolete && branch.canSatisfyDependencies();
        }

        void install(Roster roster, String installDirectory, boolean downloadSource) {
            String installed = this.getInstalledPath();
            Branch branch = this.getCompatibleBranch();
            if (branch.obsolete) {
                if (installed != null) {
                    roster.addRemove(installed);
                }
                return;
            }
            if (installed != null) {
                installDirectory = MiscUtilities.getParentOfPath(installed);
            }
            roster.addInstall(installed, downloadSource ? branch.downloadSource : branch.download, installDirectory, downloadSource ? branch.downloadSourceSize : branch.downloadSize);
        }

        public String toString() {
            return this.name;
        }
    }

    static class PluginSet {
        String name;
        final List<String> plugins = new ArrayList<String>();

        PluginSet() {
        }

        public String toString() {
            return this.plugins.toString();
        }
    }
}

