/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.MirrorListHandler;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ProgressObserver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class MirrorList {
    private String xml;
    private final List<Mirror> mirrors = new ArrayList<Mirror>();

    public MirrorList(boolean download, ProgressObserver observer) throws Exception {
        Mirror none = new Mirror();
        none.id = "NONE";
        none.continent = "";
        none.country = "";
        none.location = "";
        none.description = "";
        this.mirrors.add(none);
        String path = jEdit.getProperty("plugin-manager.mirror-url");
        MirrorListHandler handler = new MirrorListHandler(this, path);
        if (download) {
            Log.log(5, this, "Loading mirror list from internet");
            this.downloadXml(path);
        } else {
            Log.log(5, this, "Loading mirror list from cache");
            this.readXml();
        }
        if (this.xml == null) {
            return;
        }
        observer.setValue(1L);
        BufferedReader in = new BufferedReader(new StringReader(this.xml));
        InputSource isrc = new InputSource(in);
        isrc.setSystemId("jedit.jar");
        XMLReader parser = XMLReaderFactory.createXMLReader();
        parser.setContentHandler(handler);
        parser.setDTDHandler(handler);
        parser.setEntityResolver(handler);
        parser.setErrorHandler(handler);
        parser.parse(isrc);
        observer.setValue(2L);
    }

    public String getXml() {
        return this.xml;
    }

    public List<Mirror> getMirrors() {
        return this.mirrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readXml() throws IOException {
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory == null) {
            return;
        }
        File mirrorList = new File(MiscUtilities.constructPath(settingsDirectory, "mirrorList.xml"));
        if (!mirrorList.exists()) {
            return;
        }
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(mirrorList));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtilities.copyStream(null, inputStream, out, false);
            this.xml = out.toString();
        }
        catch (Throwable throwable) {
            IOUtilities.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtilities.closeQuietly(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadXml(String path) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = new URL(path).openStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtilities.copyStream(null, inputStream, out, false);
            this.xml = out.toString();
        }
        catch (Throwable throwable) {
            IOUtilities.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtilities.closeQuietly(inputStream);
    }

    void add(Mirror mirror) {
        this.mirrors.add(mirror);
    }

    void finished() {
        Collections.sort(this.mirrors, new MirrorCompare());
    }

    private static class MirrorCompare
    implements Comparator<Mirror> {
        private MirrorCompare() {
        }

        @Override
        public int compare(Mirror m1, Mirror m2) {
            int result = m1.continent.compareToIgnoreCase(m2.continent);
            if (result == 0 && (result = m1.country.compareToIgnoreCase(m2.country)) == 0 && (result = m1.location.compareToIgnoreCase(m2.location)) == 0) {
                return m1.description.compareToIgnoreCase(m2.description);
            }
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof MirrorCompare;
        }
    }

    public static class Mirror {
        public static final String NONE = "NONE";
        public String id;
        public String description;
        public String location;
        public String country;
        public String continent;
    }
}

