/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.FieldPosition;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.TaskListener;
import org.gjt.sp.util.TaskManager;

public class TaskMonitorWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        TaskMonitorWidget widget = new TaskMonitorWidget(view);
        widget.getComponent().setToolTipText(jEdit.getProperty("statusbar.task-monitor.tooltip"));
        return widget;
    }

    private static class TaskMonitorWidget
    extends JLabel
    implements Widget,
    TaskListener {
        private final MessageFormat messageFormat;
        private final Object[] args;
        private final StringBuffer stringBuffer;
        private FieldPosition fieldPosition;

        private TaskMonitorWidget(final View view) {
            this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.setFont(this.getFont().deriveFont(1));
            String property = jEdit.getProperty("statusbar.task-monitor.template");
            this.args = new Object[1];
            this.messageFormat = new MessageFormat(property);
            this.fieldPosition = new FieldPosition(0);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        view.getDockableWindowManager().showDockableWindow("task-monitor");
                    }
                }
            });
            this.stringBuffer = new StringBuffer();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            TaskManager.instance.addTaskListener(this);
            this.update();
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            TaskManager.instance.removeTaskListener(this);
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        @Override
        public void propertiesChanged() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update() {
            int count = TaskManager.instance.countTasks();
            if (count == 0) {
                this.setIcon(null);
                this.setText(null);
            } else {
                MessageFormat messageFormat = this.messageFormat;
                synchronized (messageFormat) {
                    this.setIcon(GUIUtilities.loadIcon("loader.gif"));
                    this.args[0] = count;
                    this.setText(this.messageFormat.format(this.args, this.stringBuffer, this.fieldPosition).toString());
                    this.stringBuffer.setLength(0);
                }
            }
        }

        @Override
        public void waiting(Task task) {
            this.update();
        }

        @Override
        public void running(Task task) {
            this.update();
        }

        @Override
        public void done(Task task) {
            this.update();
        }

        @Override
        public void statusUpdated(Task task) {
            this.update();
        }

        @Override
        public void maximumUpdated(Task task) {
            this.update();
        }

        @Override
        public void valueUpdated(Task task) {
            this.update();
        }
    }
}

