/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.indent.DeepIndentRule;
import org.gjt.sp.jedit.indent.IndentRule;
import org.gjt.sp.jedit.indent.IndentRuleFactory;
import org.gjt.sp.jedit.indent.WhitespaceRule;
import org.gjt.sp.jedit.syntax.ModeProvider;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class Mode {
    protected final String name;
    protected final Map<String, Object> props;
    private Matcher firstlineMatcher;
    private Matcher filepathMatcher;
    protected TokenMarker marker;
    private List<IndentRule> indentRules;
    private String electricKeys;
    private boolean ignoreWhitespace;

    public Mode(String name) {
        this.name = name;
        this.ignoreWhitespace = true;
        this.props = new Hashtable<String, Object>();
    }

    public void init() {
        try {
            this.filepathMatcher = null;
            String filenameGlob = (String)this.getProperty("filenameGlob");
            if (filenameGlob != null && !filenameGlob.isEmpty()) {
                String filepathRE = StandardUtilities.globToRE(filenameGlob);
                filepathRE = filepathRE.contains("/") || filepathRE.contains("\\\\") ? filepathRE.replaceAll("/|\\\\\\\\", "[/\\\\\\\\]") : String.format("(?:.*[/\\\\])?%s", filepathRE);
                this.filepathMatcher = Pattern.compile(filepathRE, 2).matcher("");
            }
            this.firstlineMatcher = null;
            String firstlineGlob = (String)this.getProperty("firstlineGlob");
            if (firstlineGlob != null && !firstlineGlob.isEmpty()) {
                this.firstlineMatcher = Pattern.compile(StandardUtilities.globToRE(firstlineGlob), 2).matcher("");
            }
        }
        catch (PatternSyntaxException re) {
            Log.log(9, this, "Invalid filename/firstline globs in mode " + this.name);
            Log.log(9, this, re);
        }
        this.marker = null;
    }

    public TokenMarker getTokenMarker() {
        this.loadIfNecessary();
        return this.marker;
    }

    public void setTokenMarker(TokenMarker marker) {
        this.marker = marker;
    }

    public void loadIfNecessary() {
        if (this.marker == null) {
            ModeProvider.instance.loadMode(this);
            if (this.marker == null) {
                Log.log(9, this, "Mode not correctly loaded, token marker is still null");
            }
        }
    }

    public Object getProperty(String key) {
        return this.props.get(key);
    }

    public boolean getBooleanProperty(String key) {
        Object value = this.getProperty(key);
        return StandardUtilities.getBoolean(value, false);
    }

    public void setProperty(String key, Object value) {
        this.props.put(key, value);
    }

    public void unsetProperty(String key) {
        this.props.remove(key);
    }

    public void setProperties(Map props) {
        if (props == null) {
            return;
        }
        this.ignoreWhitespace = !"false".equalsIgnoreCase((String)props.get("ignoreWhitespace"));
        this.props.putAll(props);
    }

    public boolean accept(String fileName, String firstLine) {
        return this.accept(null, fileName, firstLine);
    }

    public boolean accept(String filePath, String fileName, String firstLine) {
        return this.acceptFile(filePath, fileName) || this.acceptIdentical(filePath, fileName) || this.acceptFirstLine(firstLine);
    }

    @Deprecated
    public boolean acceptFilename(String fileName) {
        return this.acceptFile(null, fileName);
    }

    public boolean acceptFile(String filePath, String fileName) {
        if (this.filepathMatcher == null) {
            return false;
        }
        return fileName != null && this.filepathMatcher.reset(fileName).matches() || filePath != null && this.filepathMatcher.reset(filePath).matches();
    }

    public boolean acceptFilenameIdentical(String fileName) {
        return this.acceptIdentical(null, fileName);
    }

    public boolean acceptIdentical(String filePath, String fileName) {
        String filenameGlob = (String)this.getProperty("filenameGlob");
        if (filenameGlob == null) {
            return false;
        }
        if (fileName != null && fileName.equalsIgnoreCase(filenameGlob)) {
            return true;
        }
        if (filePath != null) {
            int lastWindowsPos;
            int lastUnixPos = filePath.lastIndexOf(47);
            int index = Math.max(lastUnixPos, lastWindowsPos = filePath.lastIndexOf(92));
            String filename = filePath.substring(index + 1);
            return filename != null && filename.equalsIgnoreCase(filenameGlob);
        }
        return false;
    }

    public boolean acceptFirstLine(String firstLine) {
        if (this.firstlineMatcher == null) {
            return false;
        }
        return firstLine != null && this.firstlineMatcher.reset(firstLine).matches();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean getIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    public synchronized List<IndentRule> getIndentRules() {
        if (this.indentRules == null) {
            this.initIndentRules();
        }
        return this.indentRules;
    }

    public synchronized boolean isElectricKey(char ch) {
        if (this.electricKeys == null) {
            String[] props = new String[]{"indentOpenBrackets", "indentCloseBrackets", "electricKeys"};
            StringBuilder buf = new StringBuilder();
            for (String prop1 : props) {
                String prop = (String)this.getProperty(prop1);
                if (prop == null) continue;
                buf.append(prop);
            }
            this.electricKeys = buf.toString();
        }
        return this.electricKeys.indexOf(ch) >= 0;
    }

    private void initIndentRules() {
        String unalignedOpenBrackets;
        String[] bracketProps;
        LinkedList<IndentRule> rules = new LinkedList<IndentRule>();
        String[] regexpProps = new String[]{"indentNextLine", "indentNextLines"};
        for (int i = 0; i < regexpProps.length; ++i) {
            IndentRule rule = this.createRegexpIndentRule(regexpProps[i]);
            if (rule == null) continue;
            rules.add(rule);
        }
        for (String bracketProp : bracketProps = new String[]{"indentOpenBracket", "indentCloseBracket", "unalignedOpenBracket", "unalignedCloseBracket"}) {
            this.createBracketIndentRules(bracketProp, rules);
        }
        String[] finalProps = new String[]{"unindentThisLine", "unindentNextLines"};
        for (int i = 0; i < finalProps.length; ++i) {
            IndentRule rule = this.createRegexpIndentRule(finalProps[i]);
            if (rule == null) continue;
            rules.add(rule);
        }
        if (this.getBooleanProperty("deepIndent") && (unalignedOpenBrackets = (String)this.getProperty("unalignedOpenBrackets")) != null) {
            for (int i = 0; i < unalignedOpenBrackets.length(); ++i) {
                char openChar = unalignedOpenBrackets.charAt(i);
                char closeChar = TextUtilities.getComplementaryBracket(openChar, null);
                if (closeChar == '\u0000') continue;
                rules.add(new DeepIndentRule(openChar, closeChar));
            }
        }
        if (!this.getIgnoreWhitespace()) {
            rules.add(new WhitespaceRule());
        }
        this.indentRules = Collections.unmodifiableList(rules);
    }

    private IndentRule createRegexpIndentRule(String prop) {
        String value = (String)this.getProperty(prop);
        try {
            if (value != null) {
                Method m = IndentRuleFactory.class.getMethod(prop, String.class);
                return (IndentRule)m.invoke(null, value);
            }
        }
        catch (Exception e) {
            Log.log(9, this, "Bad indent rule " + prop + '=' + value + ':');
            Log.log(9, this, e);
        }
        return null;
    }

    private void createBracketIndentRules(String prop, List<IndentRule> rules) {
        String value = (String)this.getProperty(prop + 's');
        try {
            if (value != null) {
                for (int i = 0; i < value.length(); ++i) {
                    char ch = value.charAt(i);
                    Method m = IndentRuleFactory.class.getMethod(prop, Character.TYPE);
                    rules.add((IndentRule)m.invoke(null, Character.valueOf(ch)));
                }
            }
        }
        catch (Exception e) {
            Log.log(9, this, "Bad indent rule " + prop + '=' + value + ':');
            Log.log(9, this, e);
        }
    }
}

