/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.jEdit;
import sidekick.SideKick;

public class SideKickOptionPane
extends AbstractOptionPane {
    public static final String SHOW_TOOL_BAR = "sidekick.showToolBar";
    public static final String SPLIT_COMBO = "sidekick.splitCombo";
    public static final String SINGLE_ICON_IN_COMBO = "sidekick.singleIconInCombo";
    private JCheckBox bufferChangeParse;
    private JCheckBox bufferSaveParse;
    private JCheckBox keystrokeParse;
    private JSlider autoParseDelay;
    private JCheckBox treeFollowsCaret;
    private JCheckBox scrollToVisible;
    private JComboBox autoExpandTreeDepth;
    private JCheckBox completeInstantToggle;
    private JCheckBox completeDelayToggle;
    private JSlider completeDelay;
    private JCheckBox autoCompletePopupGetFocus;
    private JCheckBox showToolBar;
    private JCheckBox splitCombo;
    private JCheckBox singleIconInCombo;
    private JCheckBox showToolTips;
    private JCheckBox showStatusWindow;
    private JTextField acceptChars;
    private JTextField insertChars;
    private JCheckBox persistentFilter;
    private JCheckBox showFilter;
    private JCheckBox filterVisibleAssets;

    public SideKickOptionPane() {
        super("sidekick");
    }

    protected void _init() {
        int autoParseDelayValue;
        JPanel toolbarPanel = new JPanel(new GridLayout(0, 1));
        toolbarPanel.setBorder(new TitledBorder(jEdit.getProperty((String)"options.sidekick.toolBar.label")));
        this.addComponent(toolbarPanel);
        this.showToolBar = new JCheckBox(jEdit.getProperty((String)"options.sidekick.showToolBar.label"));
        this.showToolBar.setSelected(jEdit.getBooleanProperty((String)SHOW_TOOL_BAR));
        toolbarPanel.add(this.showToolBar);
        this.splitCombo = new JCheckBox(jEdit.getProperty((String)"options.sidekick.splitCombo.label"));
        this.splitCombo.setSelected(jEdit.getBooleanProperty((String)SPLIT_COMBO));
        toolbarPanel.add(this.splitCombo);
        this.singleIconInCombo = new JCheckBox(jEdit.getProperty((String)"options.sidekick.singleIconInCombo.label"));
        this.singleIconInCombo.setSelected(jEdit.getBooleanProperty((String)SINGLE_ICON_IN_COMBO));
        toolbarPanel.add(this.singleIconInCombo);
        this.showToolTips = new JCheckBox(jEdit.getProperty((String)"options.sidekick.showToolTips.label"));
        this.addComponent(this.showToolTips);
        this.showToolTips.setSelected(jEdit.getBooleanProperty((String)"sidekick.showToolTips"));
        this.showStatusWindow = new JCheckBox(jEdit.getProperty((String)"options.sidekick.showStatusWindow.label"));
        this.addComponent(this.showStatusWindow);
        this.showStatusWindow.setSelected(jEdit.getBooleanProperty((String)"sidekick.showStatusWindow"));
        this.treeFollowsCaret = new JCheckBox(jEdit.getProperty((String)"options.sidekick.tree-follows-caret"));
        this.addComponent(this.treeFollowsCaret);
        this.treeFollowsCaret.setSelected(SideKick.isGlobalFollowCaret());
        this.treeFollowsCaret.addActionListener(new ActionHandler());
        this.scrollToVisible = new JCheckBox(jEdit.getProperty((String)"options.sidekick.scrollToVisible.label"));
        this.addComponent(this.scrollToVisible);
        this.scrollToVisible.setSelected(jEdit.getBooleanProperty((String)"sidekick.scrollToVisible"));
        this.showFilter = new JCheckBox(jEdit.getProperty((String)"options.sidekick.showFilter.label", (String)"Show filter text box"));
        this.addComponent(this.showFilter);
        this.showFilter.setSelected(jEdit.getBooleanProperty((String)"sidekick.showFilter", (boolean)true));
        JPanel filterOptionPanel = new JPanel(new GridLayout(2, 1));
        filterOptionPanel.setBorder(BorderFactory.createEmptyBorder(0, 21, 0, 0));
        this.persistentFilter = new JCheckBox(jEdit.getProperty((String)"options.sidekick.persistentFilter.label"));
        filterOptionPanel.add(this.persistentFilter);
        this.persistentFilter.setSelected(jEdit.getBooleanProperty((String)"sidekick.persistentFilter"));
        this.filterVisibleAssets = new JCheckBox(jEdit.getProperty((String)"options.sidekick.filter-visible-assets.label"));
        filterOptionPanel.add(this.filterVisibleAssets);
        this.filterVisibleAssets.setSelected(jEdit.getBooleanProperty((String)"sidekick.filter-visible-assets"));
        this.addComponent(filterOptionPanel);
        this.showFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SideKickOptionPane.this.persistentFilter.setEnabled(SideKickOptionPane.this.showFilter.isSelected());
                SideKickOptionPane.this.filterVisibleAssets.setEnabled(SideKickOptionPane.this.showFilter.isSelected());
            }
        });
        this.autoExpandTreeDepth = new JComboBox();
        this.addComponent(jEdit.getProperty((String)"options.sidekick.auto-expand-tree-depth"), this.autoExpandTreeDepth);
        this.autoExpandTreeDepth.addActionListener(new ActionHandler());
        this.autoExpandTreeDepth.addItem(jEdit.getProperty((String)"options.sidekick.all", (String)"All"));
        for (int i = 0; i <= 10; ++i) {
            this.autoExpandTreeDepth.addItem(String.valueOf(i));
        }
        String depth = String.valueOf(jEdit.getIntegerProperty((String)"sidekick-tree.auto-expand-tree-depth", (int)1));
        this.autoExpandTreeDepth.setSelectedItem(depth);
        JPanel parsingSettings = new JPanel();
        parsingSettings.setBorder(new TitledBorder("Auto parsing Settings"));
        parsingSettings.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        parsingSettings.add((Component)buttonPanel, "North");
        this.bufferChangeParse = new JCheckBox(jEdit.getProperty((String)"options.sidekick.buffer-change-parse"));
        buttonPanel.add(this.bufferChangeParse);
        this.bufferChangeParse.setSelected(SideKick.isParseOnChange());
        this.bufferChangeParse.addActionListener(new ActionHandler());
        this.bufferSaveParse = new JCheckBox(jEdit.getProperty((String)"options.sidekick.buffer-save-parse"));
        buttonPanel.add(this.bufferSaveParse);
        this.bufferSaveParse.setSelected(SideKick.isParseOnSave());
        this.bufferSaveParse.addActionListener(new ActionHandler());
        this.keystrokeParse = new JCheckBox(jEdit.getProperty((String)"options.sidekick.keystroke-parse"));
        buttonPanel.add(this.keystrokeParse);
        this.keystrokeParse.setSelected(jEdit.getBooleanProperty((String)"buffer.sidekick.keystroke-parse"));
        this.keystrokeParse.addActionListener(new ActionHandler());
        try {
            autoParseDelayValue = Integer.parseInt(jEdit.getProperty((String)"sidekick.auto-parse-delay"));
        }
        catch (NumberFormatException nf) {
            autoParseDelayValue = 1500;
        }
        parsingSettings.add((Component)new JLabel(jEdit.getProperty((String)"options.sidekick.auto-parse-delay")), "Center");
        this.autoParseDelay = new JSlider(200, 3000, autoParseDelayValue);
        parsingSettings.add((Component)this.autoParseDelay, "South");
        this.addComponent(parsingSettings);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        for (int i = 500; i <= 3000; i += 500) {
            labelTable.put(new Integer(i), new JLabel(String.valueOf((double)i / 1000.0)));
        }
        this.autoParseDelay.setLabelTable(labelTable);
        this.autoParseDelay.setPaintLabels(true);
        this.autoParseDelay.setMajorTickSpacing(500);
        this.autoParseDelay.setPaintTicks(true);
        this.autoParseDelay.setEnabled(this.keystrokeParse.isSelected());
        JPanel codeCompletionsPanel = new JPanel();
        codeCompletionsPanel.setBorder(new TitledBorder(jEdit.getProperty((String)"options.sidekick.code-completion.label")));
        codeCompletionsPanel.setLayout(new BorderLayout());
        JPanel completionsCheckboxes = new JPanel();
        completionsCheckboxes.setLayout(new FlowLayout());
        this.completeInstantToggle = new JCheckBox(jEdit.getProperty((String)"options.sidekick.complete-instant.toggle"));
        completionsCheckboxes.add(this.completeInstantToggle);
        this.completeInstantToggle.setSelected(jEdit.getBooleanProperty((String)"sidekick.complete-instant.toggle"));
        this.completeInstantToggle.addActionListener(new ActionHandler());
        this.completeDelayToggle = new JCheckBox(jEdit.getProperty((String)"options.sidekick.complete-delay.toggle"));
        completionsCheckboxes.add(this.completeDelayToggle);
        this.completeDelayToggle.setSelected(jEdit.getBooleanProperty((String)"sidekick.complete-delay.toggle"));
        this.completeDelayToggle.addActionListener(new ActionHandler());
        codeCompletionsPanel.add((Component)completionsCheckboxes, "North");
        int completeDelayValue = jEdit.getIntegerProperty((String)"sidekick.complete-delay", (int)500);
        codeCompletionsPanel.add((Component)new JLabel(jEdit.getProperty((String)"options.sidekick.complete-delay")), "Center");
        this.completeDelay = new JSlider(0, 1500, completeDelayValue);
        codeCompletionsPanel.add((Component)this.completeDelay, "South");
        this.addComponent(codeCompletionsPanel);
        this.autoCompletePopupGetFocus = new JCheckBox(jEdit.getProperty((String)"options.sidekick.auto-complete-popup-get-focus"), jEdit.getBooleanProperty((String)"sidekick.auto-complete-popup-get-focus"));
        this.addComponent(this.autoCompletePopupGetFocus);
        labelTable = new Hashtable();
        for (int i = 0; i <= 1500; i += 250) {
            labelTable.put(new Integer(i), new JLabel(String.valueOf((double)i / 1000.0)));
        }
        this.completeDelay.setLabelTable(labelTable);
        this.completeDelay.setPaintLabels(true);
        this.completeDelay.setMajorTickSpacing(250);
        this.completeDelay.setPaintTicks(true);
        this.completeDelay.setEnabled(this.completeDelayToggle.isSelected());
        this.acceptChars = new JTextField(jEdit.getProperty((String)"sidekick.complete-popup.accept-characters"));
        this.addComponent(jEdit.getProperty((String)"options.sidekick.complete-popup.accept-characters"), this.acceptChars);
        this.insertChars = new JTextField(jEdit.getProperty((String)"sidekick.complete-popup.insert-characters"));
        this.addComponent(jEdit.getProperty((String)"options.sidekick.complete-popup.insert-characters"), this.insertChars);
    }

    protected void _save() {
        SideKick.setParseOnSave(this.bufferSaveParse.isSelected());
        SideKick.setParseOnChange(this.bufferChangeParse.isSelected());
        jEdit.setBooleanProperty((String)"buffer.sidekick.keystroke-parse", (boolean)this.keystrokeParse.isSelected());
        jEdit.setProperty((String)"sidekick.auto-parse-delay", (String)String.valueOf(this.autoParseDelay.getValue()));
        SideKick.setGlobalFollowCaret(this.treeFollowsCaret.isSelected());
        jEdit.setBooleanProperty((String)SHOW_TOOL_BAR, (boolean)this.showToolBar.isSelected());
        jEdit.setBooleanProperty((String)SPLIT_COMBO, (boolean)this.splitCombo.isSelected());
        jEdit.setBooleanProperty((String)SINGLE_ICON_IN_COMBO, (boolean)this.singleIconInCombo.isSelected());
        jEdit.setBooleanProperty((String)"sidekick.showToolTips", (boolean)this.showToolTips.isSelected());
        jEdit.setBooleanProperty((String)"sidekick.showStatusWindow", (boolean)this.showStatusWindow.isSelected());
        jEdit.setBooleanProperty((String)"sidekick.scrollToVisible", (boolean)this.scrollToVisible.isSelected());
        jEdit.setBooleanProperty((String)"sidekick.showFilter", (boolean)this.showFilter.isSelected());
        jEdit.setBooleanProperty((String)"sidekick.persistentFilter", (boolean)this.persistentFilter.isSelected());
        jEdit.setBooleanProperty((String)"sidekick.filter-visible-assets", (boolean)this.filterVisibleAssets.isSelected());
        int depth = 0;
        String value = (String)this.autoExpandTreeDepth.getSelectedItem();
        depth = value.equals(jEdit.getProperty((String)"options.sidekick.all", (String)"All")) ? -1 : Integer.parseInt(value);
        jEdit.setIntegerProperty((String)"sidekick-tree.auto-expand-tree-depth", (int)depth);
        jEdit.setBooleanProperty((String)"sidekick.complete-instant.toggle", (boolean)this.completeInstantToggle.isSelected());
        jEdit.setBooleanProperty((String)"sidekick.complete-delay.toggle", (boolean)this.completeDelayToggle.isSelected());
        jEdit.setIntegerProperty((String)"sidekick.complete-delay", (int)this.completeDelay.getValue());
        jEdit.setBooleanProperty((String)"sidekick.auto-complete-popup-get-focus", (boolean)this.autoCompletePopupGetFocus.isSelected());
        jEdit.setProperty((String)"sidekick.complete-popup.accept-characters", (String)this.acceptChars.getText());
        jEdit.setProperty((String)"sidekick.complete-popup.insert-characters", (String)this.insertChars.getText());
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == SideKickOptionPane.this.keystrokeParse) {
                SideKickOptionPane.this.autoParseDelay.setEnabled(SideKickOptionPane.this.keystrokeParse.isSelected());
                if (SideKickOptionPane.this.keystrokeParse.isSelected()) {
                    SideKickOptionPane.this.bufferChangeParse.setSelected(true);
                }
                SideKickOptionPane.this.bufferSaveParse.setSelected(true);
            } else if (source == SideKickOptionPane.this.completeDelayToggle) {
                SideKickOptionPane.this.completeDelay.setEnabled(SideKickOptionPane.this.completeDelayToggle.isSelected());
            }
        }
    }
}

