/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.buffer.JEditBuffer;

public class IndentFoldHandler
extends FoldHandler {
    public IndentFoldHandler() {
        super("indent");
    }

    private int getLeadingWhitespaceWidth(Segment seg, int tabSize) {
        int offset = seg.offset;
        int count = seg.count;
        int whitespace = 0;
        block4: for (int i = 0; i < count; ++i) {
            switch (seg.array[offset + i]) {
                case ' ': {
                    ++whitespace;
                    continue block4;
                }
                case '\t': {
                    whitespace += tabSize - whitespace % tabSize;
                    continue block4;
                }
                default: {
                    return whitespace;
                }
            }
        }
        return -1;
    }

    @Override
    public int getFoldLevel(JEditBuffer buffer, int lineIndex, Segment seg) {
        int tabSize = buffer.getTabSize();
        int prevLevel = 0;
        for (int index = lineIndex; index < buffer.getLineCount(); ++index) {
            buffer.getLineText(index, seg);
            int whitespace = this.getLeadingWhitespaceWidth(seg, tabSize);
            if (whitespace >= 0) {
                return whitespace > prevLevel ? whitespace : prevLevel;
            }
            if (index == 0) {
                return 0;
            }
            if (index != lineIndex) continue;
            prevLevel = buffer.getFoldLevel(lineIndex - 1);
        }
        return prevLevel;
    }

    @Override
    public List<Integer> getPrecedingFoldLevels(JEditBuffer buffer, int lineIndex, Segment seg, int lineFoldLevel) {
        int index;
        ArrayList<Integer> precedingFoldLevels = new ArrayList<Integer>();
        int tabSize = buffer.getTabSize();
        int whitespace = 0;
        for (index = lineIndex - 1; index > 0; --index) {
            buffer.getLineText(index, seg);
            whitespace = this.getLeadingWhitespaceWidth(seg, tabSize);
            if (whitespace >= 0) break;
        }
        int max = lineFoldLevel > whitespace ? lineFoldLevel : whitespace;
        ++index;
        while (index < lineIndex) {
            precedingFoldLevels.add(max);
            ++index;
        }
        return precedingFoldLevels;
    }
}

