/*
 * Decompiled with CFR 0.152.
 */
package common.gui.pathbuilder;

import common.gui.pathbuilder.PathBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.gjt.sp.jedit.jEdit;

public class PathBuilderDialog
extends JDialog
implements ActionListener {
    private boolean result = false;
    private PathBuilder pathBuilder;
    private JButton jok;
    private JButton jcancel;

    public PathBuilderDialog(Dialog parent, String title) {
        super(parent, title, true);
        this.init(null);
    }

    public PathBuilderDialog(Dialog parent, String title, String pathBuilderTitle) {
        super(parent, title, true);
        this.init(pathBuilderTitle);
    }

    public PathBuilderDialog(Frame parent, String title) {
        super(parent, title, true);
        this.init(null);
    }

    public PathBuilderDialog(Frame parent, String title, String pathBuilderTitle) {
        super(parent, title, true);
        this.init(pathBuilderTitle);
    }

    private void init(String pathBuilderTitle) {
        String okString = jEdit.getProperty((String)"common.ok");
        String cancelString = jEdit.getProperty((String)"common.cancel");
        this.jok = new JButton(okString);
        this.jcancel = new JButton(cancelString);
        this.jok.addActionListener(this);
        this.jcancel.addActionListener(this);
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(17, 0, 0, 0));
        panel.add(this.jok);
        panel.add(this.jcancel);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.pathBuilder = pathBuilderTitle == null ? new PathBuilder() : new PathBuilder(pathBuilderTitle);
        contentPane.add((Component)this.pathBuilder, "Center");
        contentPane.add((Component)panel, "South");
        this.setContentPane(contentPane);
        this.pack();
        this.center();
    }

    private void center() {
        if (this.getOwner() == null) {
            return;
        }
        Rectangle ownerBounds = this.getOwner().getBounds();
        Dimension mySize = this.getSize();
        int x = ownerBounds.x + (ownerBounds.width - mySize.width) / 2;
        x = x < 0 ? 0 : x;
        int y = ownerBounds.y + (ownerBounds.height - mySize.height) / 2;
        y = y < 0 ? 0 : y;
        this.setLocation(x, y);
    }

    public boolean getResult() {
        return this.result;
    }

    public PathBuilder getPathBuilder() {
        return this.pathBuilder;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source.equals(this.jok)) {
            this.result = true;
            this.dispose();
        } else if (source.equals(this.jcancel)) {
            this.dispose();
        }
    }
}

