/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLSelectElementImpl;
import org.lobobrowser.html.renderer.BaseInputControl;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.util.gui.WrapperLayout;
import org.w3c.dom.html2.HTMLOptionElement;

class InputSelectControl
extends BaseInputControl {
    private final JComboBox comboBox;
    private final JList list;
    private final DefaultListModel listModel;
    private boolean inSelectionEvent;
    private static final int STATE_NONE = 0;
    private static final int STATE_COMBO = 1;
    private static final int STATE_LIST = 2;
    private int state = 0;
    private boolean suspendSelections = false;
    private int selectedIndex = -1;

    public InputSelectControl(final HTMLBaseInputElement hTMLBaseInputElement) {
        super(hTMLBaseInputElement);
        this.setLayout(WrapperLayout.getInstance());
        final JComboBox jComboBox = new JComboBox();
        jComboBox.addItemListener(new ItemListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void itemStateChanged(ItemEvent itemEvent) {
                block6: {
                    OptionItem optionItem = (OptionItem)itemEvent.getItem();
                    if (optionItem == null) break block6;
                    switch (itemEvent.getStateChange()) {
                        case 1: {
                            if (InputSelectControl.this.suspendSelections) break;
                            InputSelectControl.this.inSelectionEvent = true;
                            try {
                                int n = jComboBox.getSelectedIndex();
                                HTMLSelectElementImpl hTMLSelectElementImpl = (HTMLSelectElementImpl)hTMLBaseInputElement;
                                hTMLSelectElementImpl.setSelectedIndex(n);
                            }
                            finally {
                                InputSelectControl.this.inSelectionEvent = false;
                            }
                            HtmlController.getInstance().onChange(hTMLBaseInputElement);
                            break;
                        }
                    }
                }
            }
        });
        final DefaultListModel defaultListModel = new DefaultListModel();
        final JList jList = new JList(defaultListModel);
        this.listModel = defaultListModel;
        jList.setSelectionMode(2);
        jList.addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting() && !InputSelectControl.this.suspendSelections) {
                    boolean bl = false;
                    InputSelectControl.this.inSelectionEvent = true;
                    try {
                        int n = defaultListModel.getSize();
                        for (int i = 0; i < n; ++i) {
                            boolean bl2;
                            boolean bl3;
                            OptionItem optionItem = (OptionItem)defaultListModel.get(i);
                            if (optionItem == null || (bl3 = optionItem.isSelected()) == (bl2 = jList.isSelectedIndex(i))) continue;
                            bl = true;
                            optionItem.setSelected(bl2);
                        }
                    }
                    finally {
                        InputSelectControl.this.inSelectionEvent = false;
                    }
                    if (bl) {
                        HtmlController.getInstance().onChange(hTMLBaseInputElement);
                    }
                }
            }
        });
        this.comboBox = jComboBox;
        this.list = jList;
        this.resetItemList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void resetItemList() {
        Object object;
        HTMLSelectElementImpl hTMLSelectElementImpl = (HTMLSelectElementImpl)this.controlElement;
        boolean bl = hTMLSelectElementImpl.getMultiple();
        if (bl && this.state != 2) {
            this.state = 2;
            this.removeAll();
            object = new JScrollPane(this.list);
            this.add((Component)object);
        } else if (!bl && this.state != 1) {
            this.state = 1;
            this.removeAll();
            this.add(this.comboBox);
        }
        this.suspendSelections = true;
        try {
            object = hTMLSelectElementImpl.getOptions();
            if (this.state == 1) {
                void object3;
                Object object2;
                JComboBox jComboBox = this.comboBox;
                HTMLOptionElement hTMLOptionElement = null;
                int n = hTMLSelectElementImpl.getSelectedIndex();
                if (n != -1) {
                    int n2 = object.getLength();
                    for (int i = 0; i < n2; ++i) {
                        object2 = (HTMLOptionElement)object.item(i);
                        if (i != n) continue;
                        hTMLOptionElement = object2;
                    }
                }
                jComboBox.removeAllItems();
                OptionItem optionItem = null;
                OptionItem optionItem2 = null;
                object2 = null;
                int n3 = object.getLength();
                boolean i = false;
                while (object3 < n3) {
                    HTMLOptionElement hTMLOptionElement2 = (HTMLOptionElement)object.item((int)object3);
                    if (hTMLOptionElement2 != null) {
                        OptionItem optionItem3 = new OptionItem(hTMLOptionElement2);
                        if (object2 == null) {
                            object2 = optionItem3;
                            jComboBox.addItem(optionItem3);
                            hTMLSelectElementImpl.setSelectedIndex(-1);
                            if (hTMLOptionElement != null) {
                                hTMLOptionElement.setSelected(true);
                            }
                        } else {
                            jComboBox.addItem(optionItem3);
                        }
                        if (hTMLOptionElement2.getSelected()) {
                            optionItem2 = optionItem3;
                        }
                        if (hTMLOptionElement2.getDefaultSelected()) {
                            optionItem = optionItem3;
                        }
                    }
                    ++object3;
                }
                if (optionItem2 != null) {
                    jComboBox.setSelectedItem(optionItem2);
                } else if (optionItem != null) {
                    jComboBox.setSelectedItem(optionItem);
                } else if (object2 != null) {
                    jComboBox.setSelectedItem(object2);
                }
            } else {
                JList jList = this.list;
                LinkedList<Integer> linkedList = null;
                LinkedList<Integer> linkedList2 = null;
                OptionItem optionItem = null;
                DefaultListModel defaultListModel = this.listModel;
                defaultListModel.clear();
                int n = object.getLength();
                for (int i = 0; i < n; ++i) {
                    HTMLOptionElement hTMLOptionElement = (HTMLOptionElement)object.item(i);
                    OptionItem optionItem4 = new OptionItem(hTMLOptionElement);
                    if (optionItem == null) {
                        optionItem = optionItem4;
                        defaultListModel.addElement(optionItem4);
                        jList.setSelectedIndex(-1);
                    } else {
                        defaultListModel.addElement(optionItem4);
                    }
                    if (hTMLOptionElement.getSelected()) {
                        if (linkedList2 == null) {
                            linkedList2 = new LinkedList<Integer>();
                        }
                        linkedList2.add(new Integer(i));
                    }
                    if (!hTMLOptionElement.getDefaultSelected()) continue;
                    if (linkedList == null) {
                        linkedList = new LinkedList<Integer>();
                    }
                    linkedList.add(new Integer(i));
                }
                if (linkedList2 != null && linkedList2.size() != 0) {
                    for (Integer n2 : linkedList2) {
                        jList.addSelectionInterval(n2, n2);
                    }
                } else if (linkedList != null && linkedList.size() != 0) {
                    for (Integer n3 : linkedList) {
                        jList.addSelectionInterval(n3, n3);
                    }
                }
            }
        }
        finally {
            this.suspendSelections = false;
        }
    }

    public void reset(int n, int n2) {
        super.reset(n, n2);
        this.resetItemList();
    }

    public String getValue() {
        if (this.state == 1) {
            OptionItem optionItem = (OptionItem)this.comboBox.getSelectedItem();
            return optionItem == null ? null : optionItem.getValue();
        }
        OptionItem optionItem = (OptionItem)this.list.getSelectedValue();
        return optionItem == null ? null : optionItem.getValue();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedIndex(int n) {
        this.selectedIndex = n;
        boolean bl = this.suspendSelections;
        this.suspendSelections = true;
        try {
            if (!this.inSelectionEvent) {
                if (this.state == 1) {
                    int n2;
                    JComboBox jComboBox = this.comboBox;
                    if (jComboBox.getSelectedIndex() != n && n < (n2 = jComboBox.getItemCount())) {
                        jComboBox.setSelectedIndex(n);
                    }
                } else {
                    int n3;
                    JList jList = this.list;
                    int[] nArray = jList.getSelectedIndices();
                    if ((nArray == null || nArray.length != 1 || nArray[0] != n) && n < (n3 = this.listModel.getSize())) {
                        jList.setSelectedIndex(n);
                    }
                }
            }
        }
        finally {
            this.suspendSelections = bl;
        }
    }

    public int getVisibleSize() {
        return this.comboBox.getMaximumRowCount();
    }

    public void setVisibleSize(int n) {
        this.comboBox.setMaximumRowCount(n);
    }

    public void resetInput() {
        this.list.setSelectedIndex(-1);
        this.comboBox.setSelectedIndex(-1);
    }

    public String[] getValues() {
        if (this.state == 1) {
            String[] stringArray;
            OptionItem optionItem = (OptionItem)this.comboBox.getSelectedItem();
            if (optionItem == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = optionItem.getValue();
            }
            return stringArray;
        }
        Object[] objectArray = this.list.getSelectedValues();
        if (objectArray == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < objectArray.length; ++i) {
            OptionItem optionItem = (OptionItem)objectArray[i];
            arrayList.add(optionItem.getValue());
        }
        return arrayList.toArray(new String[0]);
    }

    private static class OptionItem {
        private final HTMLOptionElement option;
        private final String caption;

        public OptionItem(HTMLOptionElement hTMLOptionElement) {
            this.option = hTMLOptionElement;
            String string = hTMLOptionElement.getLabel();
            this.caption = string == null ? hTMLOptionElement.getText() : string;
        }

        public void setSelected(boolean bl) {
            this.option.setSelected(bl);
        }

        public boolean isSelected() {
            return this.option.getSelected();
        }

        public String toString() {
            return this.caption;
        }

        public String getValue() {
            String string = this.option.getValue();
            if (string == null) {
                string = this.option.getText();
            }
            return string;
        }
    }
}

