/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.buffer.IndentFoldHandler;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.textarea.BufferHandler;
import org.gjt.sp.jedit.textarea.ElasticTabStopBufferListener;
import org.gjt.sp.jedit.textarea.FirstLine;
import org.gjt.sp.jedit.textarea.RangeMap;
import org.gjt.sp.jedit.textarea.ScreenLineManager;
import org.gjt.sp.jedit.textarea.ScrollLineCount;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;

public class DisplayManager {
    private static final Map<JEditBuffer, List<DisplayManager>> bufferMap = new HashMap<JEditBuffer, List<DisplayManager>>();
    final FirstLine firstLine;
    final ScrollLineCount scrollLineCount;
    final ScreenLineManager screenLineMgr;
    final RangeMap folds;
    private boolean initialized;
    private boolean inUse;
    private final JEditBuffer buffer;
    private final TextArea textArea;
    private final BufferHandler bufferHandler;
    private final ElasticTabStopBufferListener elasticTabStopListener;

    static DisplayManager getDisplayManager(JEditBuffer buffer, TextArea textArea) {
        DisplayManager dmgr;
        List<DisplayManager> l = bufferMap.get(buffer);
        if (l == null) {
            l = new LinkedList<DisplayManager>();
            bufferMap.put(buffer, l);
        }
        DisplayManager copy = null;
        Iterator<DisplayManager> liter = l.iterator();
        while (liter.hasNext()) {
            copy = dmgr = liter.next();
            if (dmgr.inUse || dmgr.textArea != textArea) continue;
            dmgr.inUse = true;
            return dmgr;
        }
        dmgr = new DisplayManager(buffer, textArea, copy);
        dmgr.inUse = true;
        l.add(dmgr);
        return dmgr;
    }

    void release() {
        this.inUse = false;
    }

    public static void bufferClosed(JEditBuffer buffer) {
        bufferMap.remove(buffer);
    }

    static void textAreaDisposed(TextArea textArea) {
        for (List<DisplayManager> l : bufferMap.values()) {
            Iterator<DisplayManager> liter = l.iterator();
            while (liter.hasNext()) {
                DisplayManager dmgr = liter.next();
                if (dmgr.textArea != textArea) continue;
                dmgr.dispose();
                liter.remove();
            }
        }
    }

    public JEditBuffer getBuffer() {
        return this.buffer;
    }

    public final boolean isLineVisible(int line) {
        return this.folds.search(line) % 2 == 0;
    }

    public boolean isOutsideNarrowing(int line) {
        if (line < this.getFirstVisibleLine()) {
            return true;
        }
        if (line > this.getLastVisibleLine()) {
            int lastVisible = this.getLastVisibleLine();
            int lastVisibleLevel = this.buffer.getFoldLevel(lastVisible);
            if (this.buffer.getFoldLevel(line) <= lastVisibleLevel) {
                return true;
            }
            for (int i = lastVisible + 1; i <= line; ++i) {
                if (this.buffer.getFoldLevel(i) > lastVisibleLevel) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public int getFirstVisibleLine() {
        return this.folds.first();
    }

    public int getLastVisibleLine() {
        return this.folds.last();
    }

    public int getNextVisibleLine(int line) {
        if (line < 0 || line >= this.buffer.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(line);
        }
        return this.folds.next(line);
    }

    public int getPrevVisibleLine(int line) {
        if (line < 0 || line >= this.buffer.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(line);
        }
        return this.folds.prev(line);
    }

    public final int getScreenLineCount(int line) {
        this.updateScreenLineCount(line);
        return this.screenLineMgr.getScreenLineCount(line);
    }

    public final int getScrollLineCount() {
        return this.scrollLineCount.getScrollLine();
    }

    public void collapseFold(int line) {
        int lineCount = this.buffer.getLineCount();
        int end = lineCount - 1;
        if (line != 0 && line != lineCount - 1 && this.buffer.isFoldStart(line) && !this.isLineVisible(line + 1)) {
            --line;
        }
        int initialFoldLevel = this.buffer.getFoldLevel(line);
        int start = 0;
        if (line != lineCount - 1 && this.buffer.getFoldLevel(line + 1) > initialFoldLevel) {
            start = line + 1;
            for (int i = line + 1; i < lineCount; ++i) {
                if (this.buffer.getFoldLevel(i) > initialFoldLevel) continue;
                end = i - 1;
                break;
            }
        } else {
            int i;
            boolean ok = false;
            for (i = line - 1; i >= 0; --i) {
                if (this.buffer.getFoldLevel(i) >= initialFoldLevel) continue;
                start = i + 1;
                ok = true;
                break;
            }
            if (!ok) {
                return;
            }
            for (i = line + 1; i < lineCount; ++i) {
                if (this.buffer.getFoldLevel(i) >= initialFoldLevel) continue;
                end = i - 1;
                break;
            }
        }
        this.hideLineRange(start, end);
        this.notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
    }

    public int expandFold(int line, boolean fully) {
        MutableInteger firstSubfold = new MutableInteger(-1);
        boolean unfolded = this._expandFold(line, fully, firstSubfold);
        if (unfolded) {
            this.textArea.foldStructureChanged();
        }
        return firstSubfold.get();
    }

    public void expandAllFolds() {
        this.showLineRange(0, this.buffer.getLineCount() - 1);
        this.notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
    }

    public void expandFolds(char digit) {
        if (digit < '1' || digit > '9') {
            Toolkit.getDefaultToolkit().beep();
        } else {
            this.expandFolds(digit - 49 + 1);
        }
    }

    public void expandFolds(int foldLevel, boolean update) {
        if (this.buffer.getFoldHandler() instanceof IndentFoldHandler) {
            foldLevel = (foldLevel - 1) * this.buffer.getIndentSize() + 1;
        }
        int lineCount = this.buffer.getLineCount();
        int end = lineCount - 1;
        this.showLineRange(0, end);
        int leastFolded = -1;
        int firstInvisible = 0;
        for (int i = 0; i < lineCount; ++i) {
            int level = this.buffer.getFoldLevel(i);
            if (leastFolded == -1 || level < leastFolded) {
                leastFolded = level;
            }
            if (level >= foldLevel && level != leastFolded) continue;
            if (firstInvisible != i) {
                this.hideLineRange(firstInvisible, i - 1);
            }
            firstInvisible = i + 1;
        }
        if (firstInvisible != lineCount) {
            this.hideLineRange(firstInvisible, end);
        }
        this.notifyScreenLineChanges();
        if (update && this.textArea.getDisplayManager() == this) {
            this.textArea.foldStructureChanged();
        }
    }

    public void expandFolds(int foldLevel) {
        this.expandFolds(foldLevel, true);
    }

    public void narrow(int start, int end) {
        int lineCount = this.buffer.getLineCount();
        if (start > end || start < 0 || end >= lineCount) {
            throw new ArrayIndexOutOfBoundsException(start + ", " + end);
        }
        if (start < this.getFirstVisibleLine() || end > this.getLastVisibleLine()) {
            this.expandAllFolds();
        }
        if (start != 0) {
            this.hideLineRange(0, start - 1);
        }
        if (end != lineCount - 1) {
            this.hideLineRange(end + 1, lineCount - 1);
        }
        if (start != lineCount - 1 && !this.isLineVisible(start + 1)) {
            this.expandFold(start, false);
        }
        this.textArea.fireNarrowActive();
        this.notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
    }

    void init() {
        assert (this.textArea.getDisplayManager() == this);
        if (this.buffer.isLoading()) {
            return;
        }
        if (!this.initialized) {
            this.folds.reset(this.buffer.getLineCount());
            this.resetAnchors();
            int collapseFolds = this.buffer.getIntegerProperty("collapseFolds", 0);
            if (collapseFolds != 0) {
                this.expandFolds(collapseFolds);
            }
            this.initialized = true;
        } else {
            this.resetAnchors();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyScreenLineChanges() {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "notifyScreenLineChanges()");
        }
        assert (this.textArea.getDisplayManager() == this);
        try {
            if (this.firstLine.isCallReset()) {
                this.firstLine.reset();
            } else if (this.firstLine.isCallChanged()) {
                this.firstLine.changed();
            }
            if (this.scrollLineCount.isCallReset()) {
                this.scrollLineCount.reset();
                this.firstLine.ensurePhysicalLineIsVisible();
            } else if (this.scrollLineCount.isCallChanged()) {
                this.scrollLineCount.changed();
            }
            if (this.firstLine.isCallChanged() || this.scrollLineCount.isCallReset() || this.scrollLineCount.isCallChanged()) {
                this.textArea.updateScrollBar();
                this.textArea.recalculateLastPhysicalLine();
            }
        }
        finally {
            this.firstLine.resetCallState();
            this.scrollLineCount.resetCallState();
        }
    }

    void setFirstLine(int currentFirstLine, int newFirstLine) {
        int visibleLines = this.textArea.getVisibleLines();
        if (newFirstLine >= currentFirstLine + visibleLines) {
            this.firstLine.scrollDown(newFirstLine - currentFirstLine);
            this.textArea.chunkCache.invalidateAll();
        } else if (newFirstLine <= currentFirstLine - visibleLines) {
            this.firstLine.scrollUp(currentFirstLine - newFirstLine);
            this.textArea.chunkCache.invalidateAll();
        } else if (newFirstLine > currentFirstLine) {
            this.firstLine.scrollDown(newFirstLine - currentFirstLine);
            this.textArea.chunkCache.scrollDown(newFirstLine - currentFirstLine);
        } else if (newFirstLine < currentFirstLine) {
            this.firstLine.scrollUp(currentFirstLine - newFirstLine);
            this.textArea.chunkCache.scrollUp(currentFirstLine - newFirstLine);
        }
        this.notifyScreenLineChanges();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setFirstPhysicalLine(int amount, int skew) {
        int currentFirstLine = this.textArea.getFirstLine();
        if (amount == 0) {
            if ((skew -= this.firstLine.getSkew()) < 0) {
                this.firstLine.scrollUp(-skew);
            } else {
                if (skew <= 0) return;
                this.firstLine.scrollDown(skew);
            }
        } else if (amount > 0) {
            this.firstLine.physDown(amount, skew);
        } else if (amount < 0) {
            this.firstLine.physUp(-amount, skew);
        }
        int firstLine = this.textArea.getFirstLine();
        int visibleLines = this.textArea.getVisibleLines();
        if (firstLine != currentFirstLine) {
            if (firstLine >= currentFirstLine + visibleLines || firstLine <= currentFirstLine - visibleLines) {
                this.textArea.chunkCache.invalidateAll();
            } else if (firstLine > currentFirstLine) {
                this.textArea.chunkCache.scrollDown(firstLine - currentFirstLine);
            } else if (firstLine < currentFirstLine) {
                this.textArea.chunkCache.scrollUp(currentFirstLine - firstLine);
            }
        }
        this.notifyScreenLineChanges();
    }

    void invalidateScreenLineCounts() {
        this.screenLineMgr.invalidateScreenLineCounts();
        this.firstLine.setCallReset(true);
        this.scrollLineCount.setCallReset(true);
    }

    void updateScreenLineCount(int line) {
        assert (this.textArea.getDisplayManager() == this);
        if (!this.screenLineMgr.isScreenLineCountValid(line)) {
            int newCount = this.textArea.chunkCache.getLineSubregionCount(line);
            assert (newCount > 0);
            this.setScreenLineCount(line, newCount);
        }
    }

    void bufferLoaded() {
        this.initialized = false;
        this.folds.reset(this.buffer.getLineCount());
        this.screenLineMgr.reset();
        if (this.textArea.getDisplayManager() == this) {
            this.textArea.propertiesChanged();
            this.init();
        }
    }

    void foldHandlerChanged() {
        if (this.buffer.isLoading()) {
            return;
        }
        this.initialized = false;
        this.folds.reset(this.buffer.getLineCount());
        if (this.textArea.getDisplayManager() == this) {
            this.init();
        }
    }

    private DisplayManager(JEditBuffer buffer, TextArea textArea, DisplayManager copy) {
        this.buffer = buffer;
        this.screenLineMgr = new ScreenLineManager(buffer);
        this.textArea = textArea;
        this.scrollLineCount = new ScrollLineCount(this, textArea);
        this.firstLine = new FirstLine(this, textArea);
        this.bufferHandler = new BufferHandler(this, textArea, buffer);
        this.elasticTabStopListener = new ElasticTabStopBufferListener(textArea);
        buffer.addBufferListener(this.elasticTabStopListener, 1);
        buffer.addBufferListener(this.bufferHandler, 1);
        if (copy != null) {
            this.folds = new RangeMap(copy.folds);
            this.initialized = true;
        } else {
            this.folds = new RangeMap();
            this.folds.reset(0);
        }
    }

    private void resetAnchors() {
        this.firstLine.setCallReset(true);
        this.scrollLineCount.setCallReset(true);
        this.notifyScreenLineChanges();
    }

    private void dispose() {
        this.buffer.removeBufferListener(this.bufferHandler);
        this.buffer.removeBufferListener(this.elasticTabStopListener);
    }

    private void showLineRange(int start, int end) {
        if (Debug.FOLD_VIS_DEBUG) {
            Log.log(1, this, "showLineRange(" + start + ',' + end + ')');
        }
        for (int i = start; i <= end; ++i) {
            if (this.isLineVisible(i)) continue;
            int screenLines = this.getScreenLineCount(i);
            if (this.firstLine.getPhysicalLine() >= i) {
                this.firstLine.moveScrollLine(screenLines);
            }
            this.scrollLineCount.moveScrollLine(screenLines);
        }
        this.folds.show(start, end);
    }

    private void hideLineRange(int start, int end) {
        int physicalLine;
        if (Debug.FOLD_VIS_DEBUG) {
            Log.log(1, this, "hideLineRange(" + start + ',' + end + ')');
        }
        if (!this.isLineVisible(physicalLine = start)) {
            physicalLine = this.getNextVisibleLine(physicalLine);
        }
        int scrollLines = 0;
        while (physicalLine != -1 && physicalLine <= end) {
            int screenLines = this.getScreenLineCount(physicalLine);
            if (physicalLine < this.firstLine.getPhysicalLine()) {
                this.firstLine.setSkew(0);
                this.firstLine.moveScrollLine(-screenLines);
            }
            scrollLines -= screenLines;
            physicalLine = this.getNextVisibleLine(physicalLine);
        }
        this.scrollLineCount.moveScrollLine(scrollLines);
        this.folds.hide(start, end);
        if (!this.isLineVisible(this.firstLine.getPhysicalLine())) {
            int firstVisible = this.getFirstVisibleLine();
            if (this.firstLine.getPhysicalLine() < firstVisible) {
                this.firstLine.setPhysicalLine(firstVisible);
                this.firstLine.setScrollLine(0);
            } else {
                this.firstLine.setPhysicalLine(this.getPrevVisibleLine(this.firstLine.getPhysicalLine()));
                this.firstLine.moveScrollLine(-this.getScreenLineCount(this.firstLine.getPhysicalLine()));
            }
        }
    }

    private void setScreenLineCount(int line, int count) {
        assert (count > 0);
        this.screenLineMgr.setScreenLineCount(line, count);
    }

    private boolean _expandFold(int line, boolean fully, MutableInteger firstSubfold) {
        int i;
        int start;
        boolean unfolded = false;
        int lineCount = this.buffer.getLineCount();
        int end = lineCount - 1;
        while (!this.isLineVisible(line)) {
            int prevLine = this.folds.lookup(this.folds.search(line)) - 1;
            if (!this.isLineVisible(prevLine)) {
                return unfolded;
            }
            unfolded |= this._expandFold(prevLine, fully, firstSubfold);
            if (this.isLineVisible(prevLine + 1)) continue;
            return unfolded;
        }
        if (line == lineCount - 1 || this.isLineVisible(line + 1) && !fully) {
            return unfolded;
        }
        int initialFoldLevel = this.buffer.getFoldLevel(line);
        if (this.buffer.getFoldLevel(line + 1) > initialFoldLevel) {
            start = line;
            if (!this.isLineVisible(line + 1) && this.folds.search(line + 1) != this.folds.count() - 1) {
                int index = this.folds.search(line + 1);
                end = this.folds.lookup(index + 1) - 1;
            } else {
                for (i = line + 1; i < lineCount; ++i) {
                    if (this.buffer.getFoldLevel(i) > initialFoldLevel) continue;
                    end = i - 1;
                    break;
                }
            }
        } else {
            if (!fully) {
                return unfolded;
            }
            for (start = line; start > 0 && this.buffer.getFoldLevel(start) >= initialFoldLevel; --start) {
            }
            initialFoldLevel = this.buffer.getFoldLevel(start);
            for (i = line + 1; i < lineCount; ++i) {
                if (this.buffer.getFoldLevel(i) > initialFoldLevel) continue;
                end = i - 1;
                break;
            }
        }
        if (fully) {
            this.showLineRange(start, end);
        } else {
            boolean foundSubfold = false;
            int i2 = start + 1;
            while (i2 <= end) {
                if (!foundSubfold && this.buffer.isFoldStart(i2)) {
                    firstSubfold.set(i2);
                    foundSubfold = true;
                }
                this.showLineRange(i2, i2);
                int fold = this.buffer.getFoldLevel(i2);
                ++i2;
                while (i2 <= end && this.buffer.getFoldLevel(i2) > fold) {
                    ++i2;
                }
            }
        }
        unfolded = true;
        this.notifyScreenLineChanges();
        return unfolded;
    }

    private class MutableInteger {
        private int value;

        MutableInteger(int value) {
            this.value = value;
        }

        public void set(int value) {
            this.value = value;
        }

        public int get() {
            return this.value;
        }
    }
}

