/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.Dialog;
import java.awt.Frame;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.OptionGroup;
import org.gjt.sp.jedit.gui.OptionsDialog;
import org.gjt.sp.jedit.jEdit;

public class PluginOptions
extends OptionsDialog {
    private OptionGroup pluginsGroup;

    public PluginOptions(Frame frame) {
        super(frame, "plugin-options", jEdit.getProperty("plugin-options.last"));
    }

    public PluginOptions(Frame frame, String pane) {
        super(frame, "plugin-options", pane);
    }

    public PluginOptions(Dialog dialog) {
        super(dialog, "plugin-options", jEdit.getProperty("plugin-options.last"));
    }

    public PluginOptions(Dialog dialog, String pane) {
        super(dialog, "plugin-options", pane);
    }

    @Override
    protected OptionsDialog.OptionTreeModel createOptionTreeModel() {
        OptionsDialog.OptionTreeModel paneTreeModel = new OptionsDialog.OptionTreeModel();
        OptionGroup rootGroup = (OptionGroup)paneTreeModel.getRoot();
        this.pluginsGroup = new OptionGroup("plugins");
        this.pluginsGroup.setSort(true);
        EditPlugin[] plugins = jEdit.getPlugins();
        for (int i = 0; i < plugins.length; ++i) {
            EditPlugin ep = plugins[i];
            if (ep instanceof EditPlugin.Broken) continue;
            String className = ep.getClassName();
            if (jEdit.getProperty("plugin." + className + ".activate") == null) continue;
            String optionPane = jEdit.getProperty("plugin." + className + ".option-pane");
            if (optionPane != null) {
                this.pluginsGroup.addOptionPane(optionPane);
                continue;
            }
            String options = jEdit.getProperty("plugin." + className + ".option-group");
            if (options == null) continue;
            this.pluginsGroup.addOptionGroup(new OptionGroup("plugin." + className, jEdit.getProperty("plugin." + className + ".name"), options));
        }
        if (this.pluginsGroup.getMemberCount() == 0) {
            this.pluginsGroup.addOptionPane(new NoPluginsPane());
        }
        rootGroup.addOptionGroup(this.pluginsGroup);
        return paneTreeModel;
    }

    @Override
    protected OptionGroup getDefaultGroup() {
        return this.pluginsGroup;
    }

    public static class NoPluginsPane
    extends AbstractOptionPane {
        public NoPluginsPane() {
            super("no-plugins");
        }
    }
}

