/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.util.Log;

public class LastModifiedWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        LastModifiedWidget lastModifiedWidget = new LastModifiedWidget(view);
        return lastModifiedWidget;
    }

    public static class LastModifiedWidget
    implements Widget {
        private final JLabel lastModifiedLabel;
        private final View view;
        private static final SimpleDateFormat sdf = new SimpleDateFormat();
        private static final Date date = new Date();

        LastModifiedWidget(View view) {
            this.view = view;
            this.lastModifiedLabel = new JLabel(){

                @Override
                public void addNotify() {
                    super.addNotify();
                    LastModifiedWidget.this.update();
                    EditBus.addToBus(LastModifiedWidget.this);
                }

                @Override
                public void removeNotify() {
                    super.removeNotify();
                    EditBus.removeFromBus(LastModifiedWidget.this);
                }
            };
            this.lastModifiedLabel.setToolTipText(jEdit.getProperty("fileprop.lastmod"));
            this.update();
        }

        @Override
        public JComponent getComponent() {
            return this.lastModifiedLabel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update() {
            Buffer buffer = this.view.getBuffer();
            String path = buffer.getPath();
            VFS vfs = VFSManager.getVFSForPath(path);
            Object session = vfs.createVFSSession(path, this.view);
            try {
                VFSFile file = vfs._getFile(session, path, this.view);
                if (file == null) {
                    this.lastModifiedLabel.setText("");
                } else {
                    this.lastModifiedLabel.setText(file.getExtendedAttribute("modified"));
                }
            }
            catch (IOException e) {
                Log.log(9, this, e);
            }
            finally {
                try {
                    vfs._endVFSSession(session, this.view);
                }
                catch (IOException e) {}
            }
        }

        @Override
        public void propertiesChanged() {
        }

        @EditBus.EBHandler
        public void handleMessage(EditPaneUpdate message) {
            if (message.getWhat() == EditPaneUpdate.BUFFER_CHANGED && message.getEditPane().getView() == this.view) {
                this.update();
            }
        }

        @EditBus.EBHandler
        public void handleMessage(BufferUpdate message) {
            if (message.getBuffer() == this.view.getBuffer()) {
                this.update();
            }
        }
    }
}

