/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bufferio;

import java.io.BufferedOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.CharacterCodingException;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.Encoding;
import org.gjt.sp.jedit.io.EncodingServer;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IntegerArray;
import org.gjt.sp.util.SegmentBuffer;
import org.gjt.sp.util.WorkRequest;

public abstract class BufferIORequest
extends WorkRequest {
    public static final int IOBUFSIZE = 32768;
    public static final int PROGRESS_INTERVAL = 300;
    public static final String LOAD_DATA = "BufferIORequest__loadData";
    public static final String END_OFFSETS = "BufferIORequest__endOffsets";
    public static final String NEW_PATH = "BufferIORequest__newPath";
    public static final String ERROR_OCCURRED = "BufferIORequest__error";
    protected final View view;
    protected final Buffer buffer;
    protected final Object session;
    protected final VFS vfs;
    protected String path;
    protected final String markersPath;

    protected BufferIORequest(View view, Buffer buffer, Object session, VFS vfs, String path) {
        this.view = view;
        this.buffer = buffer;
        this.session = session;
        this.vfs = vfs;
        this.path = path;
        this.markersPath = Buffer.getMarkersPath(vfs, path);
    }

    public String toString() {
        return this.getClass().getName() + '[' + this.buffer + ']';
    }

    public static int getCharIOBufferSize() {
        return 32768;
    }

    public static int getByteIOBufferSize() {
        return 65536;
    }

    protected Reader autodetect(InputStream in) throws IOException {
        return MiscUtilities.autodetect(in, this.buffer);
    }

    protected SegmentBuffer read(Reader in, long length, boolean insert) throws IOException {
        char ch;
        int len;
        boolean trackProgress;
        IntegerArray endOffsets = new IntegerArray(Math.max(1, (int)(length / 50L)));
        boolean bl = trackProgress = !this.buffer.isTemporary() && length != 0L;
        if (trackProgress) {
            this.setMaximum(length);
            this.setValue(0L);
        }
        if (length == 0L) {
            length = 32768L;
        }
        SegmentBuffer seg = new SegmentBuffer((int)length + 1);
        char[] buf = new char[32768];
        boolean CRLF = false;
        boolean CROnly = false;
        boolean lastWasCR = false;
        int lineCount = 0;
        while ((len = in.read(buf, 0, buf.length)) != -1) {
            int lastLine = 0;
            block5: for (int i = 0; i < len; ++i) {
                switch (buf[i]) {
                    case '\r': {
                        if (lastWasCR) {
                            CROnly = true;
                            CRLF = false;
                        } else {
                            lastWasCR = true;
                        }
                        seg.append(buf, lastLine, i - lastLine);
                        seg.append('\n');
                        endOffsets.add(seg.count);
                        if (trackProgress && lineCount++ % 300 == 0) {
                            this.setValue(seg.count);
                        }
                        lastLine = i + 1;
                        continue block5;
                    }
                    case '\n': {
                        if (lastWasCR) {
                            CROnly = false;
                            CRLF = true;
                            lastWasCR = false;
                            lastLine = i + 1;
                            continue block5;
                        }
                        CROnly = false;
                        CRLF = false;
                        seg.append(buf, lastLine, i - lastLine);
                        seg.append('\n');
                        endOffsets.add(seg.count);
                        if (trackProgress && lineCount++ % 300 == 0) {
                            this.setValue(seg.count);
                        }
                        lastLine = i + 1;
                        continue block5;
                    }
                    default: {
                        if (!lastWasCR) continue block5;
                        CROnly = true;
                        CRLF = false;
                        lastWasCR = false;
                    }
                }
            }
            if (trackProgress) {
                this.setValue(seg.count);
            }
            seg.append(buf, lastLine, len - lastLine);
        }
        this.setAbortable(false);
        String lineSeparator = seg.count == 0 ? jEdit.getProperty("buffer.lineSeparator", System.getProperty("line.separator")) : (CRLF ? "\r\n" : (CROnly ? "\r" : "\n"));
        int bufferLength = seg.count--;
        if (bufferLength == 0 || (ch = seg.array[bufferLength - 1]) == '\u001a') {
            // empty if block
        }
        this.buffer.setBooleanProperty("trailingEOL", false);
        if (bufferLength != 0 && jEdit.getBooleanProperty("stripTrailingEOL") && (ch = seg.array[bufferLength - 1]) == '\n') {
            this.buffer.setBooleanProperty("trailingEOL", true);
            --seg.count;
            endOffsets.setSize(endOffsets.getSize() - 1);
        }
        endOffsets.add(seg.count + 1);
        if (!insert) {
            this.buffer.setProperty(LOAD_DATA, seg);
            this.buffer.setProperty(END_OFFSETS, endOffsets);
            this.buffer.setProperty(NEW_PATH, this.path);
            if (lineSeparator != null) {
                this.buffer.setProperty("lineSeparator", lineSeparator);
            }
        }
        return seg;
    }

    protected void write(Buffer buffer, OutputStream out) throws IOException {
        String encodingName = buffer.getStringProperty("encoding");
        Encoding encoding = EncodingServer.getEncoding(encodingName);
        Writer writer = encoding.getTextWriter(new BufferedOutputStream(out, BufferIORequest.getByteIOBufferSize()));
        Segment lineSegment = new Segment();
        String newline = buffer.getStringProperty("lineSeparator");
        if (newline == null) {
            newline = System.getProperty("line.separator");
        }
        int bufferLineCount = buffer.getLineCount();
        this.setMaximum(bufferLineCount / 300);
        this.setValue(0L);
        int i = 0;
        while (i < bufferLineCount) {
            buffer.getLineText(i, lineSegment);
            try {
                writer.write(lineSegment.array, lineSegment.offset, lineSegment.count);
                if (i < bufferLineCount - 1 || jEdit.getBooleanProperty("stripTrailingEOL") && buffer.getBooleanProperty("trailingEOL")) {
                    writer.write(newline);
                }
            }
            catch (CharacterCodingException e) {
                String message = BufferIORequest.getWriteEncodingErrorMessage(encodingName, encoding, lineSegment, i);
                CharConversionException wrapping = new CharConversionException(message);
                wrapping.initCause(e);
                throw wrapping;
            }
            if (++i % 300 != 0) continue;
            this.setValue(i / 300);
        }
        writer.flush();
    }

    private static String getWriteEncodingErrorMessage(String encodingName, Encoding encoding, Segment line, int lineIndex) {
        Object[] args = new String[]{encodingName, Integer.toString(lineIndex + 1), "UNKNOWN", "UNKNOWN"};
        try {
            int charIndex = BufferIORequest.getFirstGuiltyCharacterIndex(encoding, line);
            if (0 <= charIndex && charIndex < line.count) {
                char c = line.array[line.offset + charIndex];
                args[2] = Integer.toString(charIndex + 1);
                args[3] = "'" + c + "' (U+" + Integer.toHexString(c).toUpperCase() + ")";
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return jEdit.getProperty("ioerror.write-encoding-error", args);
    }

    private static int getFirstGuiltyCharacterIndex(Encoding encoding, Segment line) throws IOException {
        if (line.count < 1) {
            return -1;
        }
        if (line.count == 1) {
            return 0;
        }
        Writer tester = encoding.getTextWriter(new OutputStream(){

            @Override
            public void write(int b) {
            }
        });
        for (int i = 0; i < line.count; ++i) {
            try {
                tester.write(line.array[line.offset + i]);
                continue;
            }
            catch (CharacterCodingException e) {
                return i;
            }
        }
        return -1;
    }
}

