/*
 * Decompiled with CFR 0.152.
 */
package GraphBrowser;

import GraphBrowser.Vertex;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

class NormalVertex
extends Vertex {
    String label = "";
    String path = "";
    String dir = "";
    String ID = "";
    Vector up;
    Vector down;
    Vector inflate = null;

    public Object clone() {
        NormalVertex normalVertex = new NormalVertex(this.label);
        ((Vertex)normalVertex).setID(this.ID);
        normalVertex.setNumber(this.getNumber());
        ((Vertex)normalVertex).setUp(this.getUp());
        ((Vertex)normalVertex).setDown(this.getDown());
        normalVertex.setX(this.getX());
        normalVertex.setY(this.getY());
        ((Vertex)normalVertex).setPath(this.getPath());
        return normalVertex;
    }

    public NormalVertex(String string) {
        this.label = string;
    }

    public void setInflate(Vector vector) {
        this.inflate = vector;
    }

    public Vector getInflate() {
        return this.inflate;
    }

    public Vector getUp() {
        return this.up;
    }

    public void setUp(Vector vector) {
        this.up = vector;
    }

    public Vector getDown() {
        return this.down;
    }

    public void setDown(Vector vector) {
        this.down = vector;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setID(String string) {
        this.ID = string;
    }

    public String getID() {
        return this.ID;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String string) {
        this.dir = string;
    }

    public int leftX() {
        return this.getX() - this.box_width2();
    }

    public int rightX() {
        return this.getX() + this.box_width2();
    }

    public void drawBox(Graphics graphics, Color color) {
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        int n = fontMetrics.getAscent() + fontMetrics.getDescent();
        graphics.setColor(color);
        graphics.fillRect(this.getX() - this.box_width2(), this.getY(), this.box_width(), this.gra.box_height);
        graphics.setColor(Color.black);
        graphics.drawRect(this.getX() - this.box_width2(), this.getY(), this.box_width(), this.gra.box_height);
        if (this.getNumber() < 0) {
            graphics.setColor(Color.red);
        }
        graphics.drawString(this.label, (int)Math.round((double)(this.box_width() - fontMetrics.stringWidth(this.label)) / 2.0) + this.getX() - this.box_width2(), fontMetrics.getAscent() + (int)Math.round((double)(this.gra.box_height - n) / 2.0) + this.getY());
    }

    public void removeButtons(Graphics graphics) {
        this.drawBox(graphics, Color.lightGray);
    }

    public void draw(Graphics graphics) {
        this.drawBox(graphics, Color.lightGray);
        graphics.setColor(Color.black);
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (vertex.isDummy()) continue;
            graphics.drawLine(this.getX(), this.getY() + this.gra.box_height, vertex.getX(), vertex.getY());
        }
    }

    public boolean contains(int n, int n2) {
        return n >= this.leftX() && n <= this.rightX() && n2 >= this.getY() && n2 <= this.getY() + this.gra.box_height;
    }

    public boolean leftButton(int n, int n2) {
        return this.contains(n, n2) && n <= this.leftX() + this.gra.box_height && this.getParents().hasMoreElements() && this.getNumber() >= 0;
    }

    public boolean rightButton(int n, int n2) {
        return this.contains(n, n2) && n >= this.rightX() - this.gra.box_height && this.getChildren().hasMoreElements() && this.getNumber() >= 0;
    }

    public void drawButtons(Graphics graphics) {
        if (this.getNumber() < 0) {
            return;
        }
        int n = this.gra.box_height * 2 / 3;
        int n2 = this.gra.box_height / 6;
        int[] nArray = new int[]{this.leftX() + n2, this.leftX() + n2 + n / 2, this.leftX() + n2 + n};
        int[] nArray2 = new int[]{this.getY() + n2 + n, this.getY() + n2, this.getY() + n2 + n};
        int[] nArray3 = new int[]{this.rightX() - n2 - n, this.rightX() - n2 - n / 2, this.rightX() - n2};
        int[] nArray4 = new int[]{this.getY() + n2, this.getY() + n2 + n, this.getY() + n2};
        if (this.getParents().hasMoreElements()) {
            graphics.setColor(Color.gray);
            graphics.fillRect(this.leftX() + 1, this.getY() + 1, this.gra.box_height - 1, this.gra.box_height - 1);
            graphics.setColor(this.getUp() != null ? Color.red : Color.green);
            graphics.fillPolygon(nArray, nArray2, 3);
        }
        if (this.getChildren().hasMoreElements()) {
            graphics.setColor(Color.gray);
            graphics.fillRect(this.rightX() + 1 - this.gra.box_height, this.getY() + 1, this.gra.box_height, this.gra.box_height - 1);
            graphics.setColor(this.getDown() != null ? Color.red : Color.green);
            graphics.fillPolygon(nArray3, nArray4, 3);
        }
        graphics.setColor(Color.black);
    }

    public void PS(PrintWriter printWriter) {
        printWriter.print(this.leftX() + " " + this.getY() + " " + this.box_width() + " " + this.gra.box_height + " (");
        for (int i = 0; i < this.label.length(); ++i) {
            if ("()\\".indexOf(this.label.charAt(i)) >= 0) {
                printWriter.print("\\");
            }
            printWriter.print(this.label.charAt(i));
        }
        printWriter.println(") b");
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (vertex.isDummy()) continue;
            printWriter.println("n " + this.getX() + " " + (this.getY() + this.gra.box_height) + " m " + vertex.getX() + " " + vertex.getY() + " l s");
        }
    }
}

