/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.gjt.sp.jedit.jEdit;
import sidekick.AbstractModeOptionPane;
import sidekick.ModeOptionPaneController;
import sidekick.SideKickTree;

public class SideKickModeOptionsPane
extends AbstractModeOptionPane
implements ModeOptionPaneController.ModeOptionPaneDelegate {
    ModeOptionPaneController controller = new ModeOptionPaneController(this);
    JCheckBox showStatusWindow = new JCheckBox(jEdit.getProperty((String)"options.sidekick.showStatusWindow.label"));
    JCheckBox treeFollowsCaret;
    JComboBox autoExpandTreeDepth;
    JComboBox defaultParser;

    public SideKickModeOptionsPane() {
        super("sidekick.mode");
        this.addComponent(this.showStatusWindow);
        this.treeFollowsCaret = new JCheckBox(jEdit.getProperty((String)"options.sidekick.tree-follows-caret"));
        this.addComponent(this.treeFollowsCaret);
        this.autoExpandTreeDepth = new JComboBox();
        this.addComponent(jEdit.getProperty((String)"options.sidekick.auto-expand-tree-depth"), this.autoExpandTreeDepth);
        this.autoExpandTreeDepth.addItem("ALL");
        for (int i = 0; i <= 10; ++i) {
            this.autoExpandTreeDepth.addItem(String.valueOf(i));
        }
        this.addComponent(this.autoExpandTreeDepth);
        this.defaultParser = new JComboBox();
        this.defaultParser.setModel(new DefaultComboBoxModel<String>(SideKickTree.parserList().toArray()));
        this.addComponent(jEdit.getProperty((String)"options.sidekick.parser.parser"), this.defaultParser);
    }

    protected void _init() {
    }

    public Object createModeProps(String string) {
        Props props = new Props();
        props.treeFollowsCaret = SideKickModeOptionsPane.getBooleanProperty(string, "sidekick-tree.follows-caret");
        props.showStatusWindow = SideKickModeOptionsPane.getBooleanProperty(string, "sidekick.showStatusWindow.label");
        props.autoExpandTreeDepth = SideKickModeOptionsPane.getIntegerProperty(string, "sidekick-tree.auto-expand-tree-depth", 1);
        props.parser = SideKickModeOptionsPane.getProperty(string, "sidekick.parser");
        return props;
    }

    public void resetModeProps(String string) {
        SideKickModeOptionsPane.clearModeProperty(string, "sidekick-tree.follows-caret");
        SideKickModeOptionsPane.clearModeProperty(string, "sidekick-tree.auto-expand-tree-depth");
        SideKickModeOptionsPane.clearModeProperty(string, "sidekick.showStatusWindow.label");
        SideKickModeOptionsPane.clearModeProperty(string, "sidekick.parser");
    }

    public void saveModeProps(String string, Object object) {
        Props props = (Props)object;
        SideKickModeOptionsPane.setBooleanProperty(string, "sidekick-tree.follows-caret", props.treeFollowsCaret);
        SideKickModeOptionsPane.setBooleanProperty(string, "sidekick.showStatusWindow.label", props.showStatusWindow);
        SideKickModeOptionsPane.setIntegerProperty(string, "sidekick-tree.auto-expand-tree-depth", props.autoExpandTreeDepth);
        if (props.parser == "default parser") {
            SideKickModeOptionsPane.clearModeProperty(string, "sidekick.parser");
        } else {
            SideKickModeOptionsPane.setProperty(string, "sidekick.parser", props.parser);
        }
    }

    public void updatePropsFromUI(Object object) {
        Props props = (Props)object;
        props.treeFollowsCaret = this.treeFollowsCaret.isSelected();
        props.showStatusWindow = this.showStatusWindow.isSelected();
        String string = (String)this.autoExpandTreeDepth.getSelectedItem();
        String string2 = string.equals("ALL") ? "-1" : string;
        props.autoExpandTreeDepth = Integer.valueOf(string2);
        Object object2 = this.defaultParser.getSelectedItem();
        props.parser = object2 == null ? null : object2.toString();
    }

    public void updateUIFromProps(Object object) {
        Props props = (Props)object;
        this.treeFollowsCaret.setSelected(props.treeFollowsCaret);
        this.showStatusWindow.setSelected(props.showStatusWindow);
        this.autoExpandTreeDepth.setSelectedIndex(props.autoExpandTreeDepth + 1);
        this.defaultParser.setSelectedItem(props.parser);
    }

    public void modeSelected(String string) {
        this.controller.modeSelected(string);
    }

    public void cancel() {
        this.controller.cancel();
    }

    public void setUseDefaults(boolean bl) {
        this.controller.setUseDefaults(bl);
    }

    public boolean getUseDefaults(String string) {
        return this.controller.getUseDefaults(string);
    }

    public JComponent getUIComponent() {
        return this;
    }

    public boolean hasModeProps(String string) {
        return SideKickModeOptionsPane.modePropertyExists(string, "sidekick-tree.follows-caret") || SideKickModeOptionsPane.modePropertyExists(string, "sidekick-tree.auto-expand-tree-depth") || SideKickModeOptionsPane.modePropertyExists(string, "sidekick.showStatusWindow.label") || SideKickModeOptionsPane.modePropertyExists(string, "sidekick.parser");
    }

    public void _save() {
        this.controller.save();
    }

    class Props {
        boolean treeFollowsCaret;
        boolean showStatusWindow;
        int autoExpandTreeDepth;
        String parser;

        Props() {
        }
    }
}

