/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import org.gjt.sp.jedit.OptionGroup;
import org.gjt.sp.jedit.OptionPane;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.OptionsDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.StringList;
import sidekick.AbstractModeOptionPane;
import sidekick.ModeOptionPane;

public class ModeOptionsDialog
extends OptionsDialog {
    public static final String SERVICECLASS = "org.gjt.sp.jedit.options.ModeOptionPane";
    public static final String DEFAULT = jEdit.getProperty((String)"options.editing.global");
    public static final String ALL = "ALL";
    Vector<ModeOptionPane> panes;
    OptionsDialog.OptionTreeModel paneTreeModel;
    StringList modes;
    JComboBox modeCombo;
    JCheckBox useDefaultsCheck;

    public ModeOptionsDialog(View view) {
        super((Frame)view, "options.mode.settings", "sidekick.mode");
    }

    public String getMode() {
        return this.modeCombo.getSelectedItem().toString();
    }

    protected OptionsDialog.OptionTreeModel createOptionTreeModel() {
        this.modes = new StringList((Object[])jEdit.getModes());
        Collections.sort(this.modes, new StandardUtilities.StringCompare(true));
        this.modes.add(0, (Object)DEFAULT);
        this.modeCombo = new JComboBox<String>(this.modes.toArray());
        this.useDefaultsCheck = new JCheckBox(jEdit.getProperty((String)"options.editing.useDefaults"));
        JLabel jLabel = new JLabel(jEdit.getProperty((String)"buffer-options.mode"));
        GridLayout gridLayout = new GridLayout(1, 3);
        JPanel jPanel = new JPanel(gridLayout);
        jPanel.add(this.useDefaultsCheck);
        jPanel.add(jLabel);
        jPanel.add(this.modeCombo);
        JPanel jPanel2 = (JPanel)this.getContentPane();
        jPanel2.add((Component)jPanel, "North");
        this.paneTreeModel = new OptionsDialog.OptionTreeModel((OptionsDialog)this);
        OptionGroup optionGroup = (OptionGroup)this.paneTreeModel.getRoot();
        this.panes = new Vector();
        for (String string : ServiceManager.getServiceNames((String)SERVICECLASS)) {
            AbstractModeOptionPane abstractModeOptionPane = (AbstractModeOptionPane)ServiceManager.getService((String)SERVICECLASS, (String)string);
            optionGroup.addOptionPane((OptionPane)abstractModeOptionPane);
            this.panes.add(abstractModeOptionPane);
        }
        this.modeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ModeOptionsDialog.this.modeSelected();
            }
        });
        this.useDefaultsCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ModeOptionsDialog.this.useDefaultsChanged();
            }
        });
        String string = jEdit.getActiveView().getBuffer().getMode().getName();
        this.modeCombo.setSelectedItem(string);
        return this.paneTreeModel;
    }

    private void useDefaultsChanged() {
        if (this.currentPane instanceof AbstractModeOptionPane) {
            ((AbstractModeOptionPane)this.currentPane).setUseDefaults(this.useDefaultsCheck.isSelected());
        }
    }

    private void modeSelected() {
        String string;
        int n = this.modeCombo.getSelectedIndex();
        if (n == 0) {
            string = null;
            this.useDefaultsCheck.setEnabled(false);
        } else {
            string = (String)this.modeCombo.getItemAt(n);
            this.useDefaultsCheck.setEnabled(true);
        }
        if (this.currentPane instanceof AbstractModeOptionPane) {
            AbstractModeOptionPane abstractModeOptionPane = (AbstractModeOptionPane)this.currentPane;
            abstractModeOptionPane.modeSelected(string);
            this.useDefaultsCheck.setSelected(abstractModeOptionPane.getUseDefaults(string));
        } else {
            this.useDefaultsCheck.setSelected(false);
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        super.valueChanged(treeSelectionEvent);
        this.modeSelected();
    }

    private void load(Object object) {
        if (object instanceof OptionGroup) {
            OptionGroup optionGroup = (OptionGroup)object;
            Enumeration enumeration = optionGroup.getMembers();
            while (enumeration.hasMoreElements()) {
                this.load(enumeration.nextElement());
            }
        }
    }

    protected void load() {
        this.load(this.getDefaultGroup());
    }

    protected OptionGroup getDefaultGroup() {
        return (OptionGroup)this.paneTreeModel.getRoot();
    }

    public void cancel() {
        for (int i = 0; i < this.panes.size(); ++i) {
            this.panes.get(i).cancel();
        }
        super.cancel();
    }
}

