/*
 * Decompiled with CFR 0.152.
 */
package gatchan.jedit.hyperlinks;

import gatchan.jedit.hyperlinks.HyperlinkManager;
import gatchan.jedit.hyperlinks.HyperlinkTextAreaPainter;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class HyperlinksPlugin
extends EditPlugin {
    public void start() {
        EditBus.addToBus((Object)((Object)this));
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] panes = view.getEditPanes();
            for (int i = 0; i < panes.length; ++i) {
                JEditTextArea textArea = panes[i].getTextArea();
                HyperlinksPlugin.initTextArea(textArea);
            }
        }
    }

    public void stop() {
        EditBus.removeFromBus((Object)((Object)this));
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] panes = view.getEditPanes();
            for (int i = 0; i < panes.length; ++i) {
                JEditTextArea textArea = panes[i].getTextArea();
                HyperlinksPlugin.uninitTextArea(textArea);
            }
        }
    }

    private static void uninitTextArea(JEditTextArea textArea) {
        HyperlinkManager clientProperty = (HyperlinkManager)textArea.getClientProperty(HyperlinkManager.class);
        clientProperty.dispose();
        textArea.putClientProperty(HyperlinkManager.class, null);
    }

    private static void initTextArea(JEditTextArea textArea) {
        textArea.putClientProperty(HyperlinkManager.class, (Object)new HyperlinkManager(textArea));
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged message) {
        HyperlinkTextAreaPainter.color = jEdit.getColorProperty((String)"options.hyperlink.color.value");
    }

    @EditBus.EBHandler
    public void handleEditPaneMessage(EditPaneUpdate message) {
        JEditTextArea textArea = message.getEditPane().getTextArea();
        Object what = message.getWhat();
        if (what == EditPaneUpdate.CREATED) {
            HyperlinksPlugin.initTextArea(textArea);
        } else if (what == EditPaneUpdate.DESTROYED) {
            HyperlinksPlugin.uninitTextArea(textArea);
        }
    }
}

