/*
 * Decompiled with CFR 0.152.
 */
package gatchan.jedit.hyperlinks;

import gatchan.jedit.hyperlinks.FallbackHyperlinkSource;
import gatchan.jedit.hyperlinks.Hyperlink;
import gatchan.jedit.hyperlinks.HyperlinkSource;
import gatchan.jedit.hyperlinks.HyperlinkTextAreaPainter;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.LinkedList;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;

public class HyperlinkManager {
    private final JEditTextArea textArea;
    private HyperlinkTextAreaPainter painter;
    private MyMouseAdapter mouseAdapter;
    private MyMouseMotionAdapter mouseMotionAdapter;
    private MyFocusListener focusListener;

    public HyperlinkManager(JEditTextArea textArea) {
        this.textArea = textArea;
        this.painter = new HyperlinkTextAreaPainter(textArea);
        this.mouseAdapter = new MyMouseAdapter();
        textArea.getPainter().addExtension((TextAreaExtension)this.painter);
        textArea.getPainter().addMouseListener((MouseListener)this.mouseAdapter);
        this.mouseMotionAdapter = new MyMouseMotionAdapter();
        textArea.getPainter().addMouseMotionListener((MouseMotionListener)this.mouseMotionAdapter);
        this.focusListener = new MyFocusListener();
        textArea.addFocusListener((FocusListener)this.focusListener);
        EditBus.addToBus((Object)this);
    }

    @EditBus.EBHandler
    public void handlerEditPaneUpdate(EditPaneUpdate epu) {
        if (epu.getWhat() == EditPaneUpdate.BUFFER_CHANGED && epu.getEditPane().getTextArea() == this.textArea) {
            this.painter.setHyperLink(null);
        }
    }

    public void dispose() {
        EditBus.removeFromBus((Object)this);
        this.textArea.getPainter().removeExtension((TextAreaExtension)this.painter);
        this.textArea.getPainter().removeMouseListener((MouseListener)this.mouseAdapter);
        this.textArea.getPainter().removeMouseMotionListener((MouseMotionListener)this.mouseMotionAdapter);
        this.textArea.removeFocusListener((FocusListener)this.focusListener);
        this.painter = null;
        this.mouseAdapter = null;
        this.mouseMotionAdapter = null;
        this.focusListener = null;
    }

    private class MyMouseMotionAdapter
    extends MouseMotionAdapter {
        private MyMouseMotionAdapter() {
        }

        public void mouseMoved(MouseEvent e) {
            boolean control;
            boolean bl = control = OperatingSystem.isMacOS() && e.isMetaDown() || !OperatingSystem.isMacOS() && e.isControlDown();
            if (!control) {
                HyperlinkManager.this.painter.setHyperLink(null);
                return;
            }
            Buffer buffer = (Buffer)HyperlinkManager.this.textArea.getBuffer();
            if (!buffer.isLoaded()) {
                return;
            }
            HyperlinkSource hyperlinkSource = this.getHyperlinkSource((JEditBuffer)buffer);
            if (hyperlinkSource == null) {
                HyperlinkManager.this.painter.setHyperLink(null);
                return;
            }
            int offset = HyperlinkManager.this.textArea.xyToOffset(e.getX(), e.getY());
            Hyperlink link = hyperlinkSource.getHyperlink(buffer, offset);
            HyperlinkManager.this.painter.setHyperLink(link);
        }

        private HyperlinkSource getHyperlinkSource(JEditBuffer buffer) {
            String hyperlinkSourceName = buffer.getStringProperty("hyperlink.source");
            if (hyperlinkSourceName == null) {
                hyperlinkSourceName = jEdit.getProperty((String)("mode." + buffer.getMode() + '.' + "hyperlink.source"));
            }
            if (hyperlinkSourceName == null) {
                hyperlinkSourceName = jEdit.getProperty((String)"hyperlink.defaultSource");
            }
            if (hyperlinkSourceName == null) {
                return null;
            }
            String[] split = hyperlinkSourceName.split(",");
            if (split.length == 1) {
                return (HyperlinkSource)ServiceManager.getService((String)"gatchan.jedit.hyperlinks.HyperlinkSource", (String)hyperlinkSourceName);
            }
            LinkedList<HyperlinkSource> sources = new LinkedList<HyperlinkSource>();
            for (String s : split) {
                HyperlinkSource source = (HyperlinkSource)ServiceManager.getService((String)"gatchan.jedit.hyperlinks.HyperlinkSource", (String)hyperlinkSourceName.trim());
                if (source == null) continue;
                sources.add(source);
            }
            if (sources.isEmpty()) {
                return null;
            }
            if (sources.size() == 1) {
                return (HyperlinkSource)sources.get(0);
            }
            return new FallbackHyperlinkSource(sources);
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            boolean control;
            boolean bl = control = OperatingSystem.isMacOS() && e.isMetaDown() || !OperatingSystem.isMacOS() && e.isControlDown();
            if (!control) {
                HyperlinkManager.this.painter.setHyperLink(null);
                return;
            }
            Hyperlink hyperlink = HyperlinkManager.this.painter.getHyperLink();
            if (hyperlink != null) {
                hyperlink.click(HyperlinkManager.this.textArea.getView());
            }
        }
    }

    private class MyFocusListener
    extends FocusAdapter {
        private MyFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            HyperlinkManager.this.painter.setHyperLink(null);
        }
    }
}

