/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class Log {
    public static int MAXLINES = 500;
    public static final int DEBUG = 1;
    public static final int MESSAGE = 3;
    public static final int NOTICE = 5;
    public static final int WARNING = 7;
    public static final int ERROR = 9;
    private static final Object LOCK = new Object();
    private static final String[] log;
    private static int logLineCount;
    private static boolean wrap;
    private static int level;
    private static Writer stream;
    private static final String lineSep;
    private static final PrintStream realOut;
    private static final PrintStream realErr;
    private static final LogListModel listModel;
    private static final DateFormat timeFormat;
    private static final int MAX_THROWABLES = 10;
    public static final List<Throwable> throwables;

    public static void init(boolean stdio, int level) {
        if (stdio && System.out == realOut && System.err == realErr) {
            System.setOut(Log.createPrintStream(5, null));
            System.setErr(Log.createPrintStream(9, null));
        }
        Log.level = level;
        Log.log(3, Log.class, "When reporting bugs, please include the following information:");
        String[] props = new String[]{"java.version", "java.vm.version", "java.vm.name", "java.runtime.version", "java.runtime.name", "java.vendor", "java.compiler", "os.name", "os.version", "os.arch", "user.home", "java.home", "java.class.path"};
        for (int i = 0; i < props.length; ++i) {
            Log.log(3, Log.class, props[i] + '=' + System.getProperty(props[i]));
        }
    }

    public static void setLogWriter(Writer stream) {
        if (Log.stream == null && stream != null) {
            try {
                int i;
                if (wrap) {
                    for (i = logLineCount; i < log.length; ++i) {
                        stream.write(log[i]);
                        stream.write(lineSep);
                    }
                }
                for (i = 0; i < logLineCount; ++i) {
                    stream.write(log[i]);
                    stream.write(lineSep);
                }
                stream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Log.stream = stream;
    }

    public static void flushStream() {
        if (stream != null) {
            try {
                stream.flush();
            }
            catch (IOException io) {
                io.printStackTrace(realErr);
            }
        }
    }

    public static void closeStream() {
        if (stream != null) {
            try {
                stream.close();
                stream = null;
            }
            catch (IOException io) {
                io.printStackTrace(realErr);
            }
        }
    }

    public static ListModel getLogListModel() {
        return listModel;
    }

    public static void log(int urgency, Object source, Object message, Throwable exception) {
        Log.log(urgency, source, message);
        Log.log(urgency, source, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(int urgency, Object source, Object message) {
        int index;
        String _source;
        if (source == null) {
            _source = Thread.currentThread().getName();
            if (_source == null) {
                _source = Thread.currentThread().getClass().getName();
            }
        } else {
            _source = source instanceof Class ? ((Class)source).getName() : source.getClass().getName();
        }
        if ((index = _source.lastIndexOf(46)) != -1) {
            _source = _source.substring(index + 1);
        }
        if (message instanceof Throwable) {
            Log._logException(urgency, source, (Throwable)message);
        } else {
            String _message = String.valueOf(message);
            Object object = LOCK;
            synchronized (object) {
                StringTokenizer st = new StringTokenizer(_message, "\r\n");
                int lineCount = 0;
                boolean oldWrap = wrap;
                while (st.hasMoreTokens()) {
                    ++lineCount;
                    Log._log(urgency, _source, st.nextToken().replace('\t', ' '));
                }
                listModel.update(lineCount, oldWrap);
            }
        }
    }

    private static PrintStream createPrintStream(int urgency, Object source) {
        return new LogPrintStream(urgency, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _logException(int urgency, Object source, Throwable message) {
        Object object;
        PrintStream out = Log.createPrintStream(urgency, source);
        if (urgency >= level) {
            object = throwables;
            synchronized (object) {
                if (throwables.size() == 10) {
                    throwables.remove(0);
                }
                throwables.add(message);
            }
        }
        object = LOCK;
        synchronized (object) {
            message.printStackTrace(out);
        }
    }

    private static void _log(int urgency, String source, String message) {
        String fullMessage = timeFormat.format(new Date()) + " [" + Thread.currentThread().getName() + "] [" + Log.urgencyToString(urgency) + "] " + source + ": " + message;
        try {
            Log.log[Log.logLineCount] = fullMessage;
            if (++logLineCount >= log.length) {
                wrap = true;
                logLineCount = 0;
            }
            if (stream != null) {
                stream.write(fullMessage);
                stream.write(lineSep);
            }
        }
        catch (Exception e) {
            e.printStackTrace(realErr);
        }
        if (urgency >= level) {
            if (urgency == 9) {
                realErr.println(fullMessage);
            } else {
                realOut.println(fullMessage);
            }
        }
    }

    private static String urgencyToString(int urgency) {
        switch (urgency) {
            case 1: {
                return "debug";
            }
            case 3: {
                return "message";
            }
            case 5: {
                return "notice";
            }
            case 7: {
                return "warning";
            }
            case 9: {
                return "error";
            }
        }
        throw new IllegalArgumentException("Invalid urgency: " + urgency);
    }

    static {
        level = 7;
        realOut = System.out;
        realErr = System.err;
        log = new String[MAXLINES];
        lineSep = System.getProperty("line.separator");
        listModel = new LogListModel();
        timeFormat = DateFormat.getTimeInstance(2);
        throwables = Collections.synchronizedList(new ArrayList(10));
    }

    private static class LogOutputStream
    extends OutputStream {
        private final int urgency;
        private final Object source;

        LogOutputStream(int urgency, Object source) {
            this.urgency = urgency;
            this.source = source;
        }

        @Override
        public synchronized void write(int b) {
            byte[] barray = new byte[]{(byte)b};
            this.write(barray, 0, 1);
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) {
            String str = new String(b, off, len);
            Log.log(this.urgency, this.source, str);
        }
    }

    private static class LogPrintStream
    extends PrintStream {
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        private final OutputStream orig = this.out;

        LogPrintStream(int urgency, Object source) {
            super(new LogOutputStream(urgency, source));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PrintStream printf(String format, Object ... args) {
            OutputStream outputStream = this.orig;
            synchronized (outputStream) {
                this.buffer.reset();
                this.out = this.buffer;
                super.printf(format, args);
                try {
                    byte[] data = this.buffer.toByteArray();
                    this.orig.write(data, 0, data.length);
                    this.out = this.orig;
                }
                catch (IOException ioe) {
                }
                finally {
                    this.buffer.reset();
                }
            }
            return this;
        }
    }

    static class LogListModel
    implements ListModel {
        final List<ListDataListener> listeners = new ArrayList<ListDataListener>();

        LogListModel() {
        }

        private void fireIntervalAdded(int index1, int index2) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ListDataListener listener = this.listeners.get(i);
                listener.intervalAdded(new ListDataEvent(this, 1, index1, index2));
            }
        }

        private void fireIntervalRemoved(int index1, int index2) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ListDataListener listener = this.listeners.get(i);
                listener.intervalRemoved(new ListDataEvent(this, 2, index1, index2));
            }
        }

        @Override
        public void addListDataListener(ListDataListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeListDataListener(ListDataListener listener) {
            this.listeners.remove(listener);
        }

        public Object getElementAt(int index) {
            if (wrap) {
                if (index < MAXLINES - logLineCount) {
                    return log[index + logLineCount];
                }
                return log[index - MAXLINES + logLineCount];
            }
            return log[index];
        }

        @Override
        public int getSize() {
            if (wrap) {
                return MAXLINES;
            }
            return logLineCount;
        }

        void update(final int lineCount, final boolean oldWrap) {
            if (lineCount == 0 || this.listeners.isEmpty()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (wrap) {
                        if (oldWrap) {
                            LogListModel.this.fireIntervalRemoved(0, lineCount - 1);
                        } else {
                            LogListModel.this.fireIntervalRemoved(0, logLineCount);
                        }
                        LogListModel.this.fireIntervalAdded(MAXLINES - lineCount + 1, MAXLINES);
                    } else {
                        LogListModel.this.fireIntervalAdded(logLineCount - lineCount + 1, logLineCount);
                    }
                }
            });
        }
    }
}

