/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.IPropertyManager;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;

public class Chunk
extends Token {
    private static final char[] EMPTY_TEXT = new char[0];
    public boolean accessable;
    public boolean initialized;
    public SyntaxStyle style;
    public float width;
    private Color background;
    public String str;
    private List<GlyphVector> glyphs;
    private boolean visible;
    private static boolean fontSubstEnabled;
    private static Font[] preferredFonts;
    private static Font[] fontSubstList;

    public static float paintChunkList(Chunk chunks, Graphics2D gfx, float x, float y, boolean glyphVector) {
        Rectangle clipRect = gfx.getClipBounds();
        float _x = 0.0f;
        while (chunks != null) {
            if (x + _x + chunks.width > (float)clipRect.x && x + _x < (float)(clipRect.x + clipRect.width)) {
                if (Debug.CHUNK_PAINT_DEBUG) {
                    gfx.draw(new Rectangle2D.Float(x + _x, y - 10.0f, chunks.width, 10.0f));
                }
                if (chunks.accessable && chunks.visible) {
                    gfx.setFont(chunks.style.getFont());
                    gfx.setColor(chunks.style.getForegroundColor());
                    if (glyphVector && chunks.glyphs != null) {
                        chunks.drawGlyphs(gfx, x + _x, y);
                    } else if (chunks.str != null) {
                        gfx.drawString(chunks.str, (int)(x + _x), (int)y);
                    }
                }
            }
            _x += chunks.width;
            chunks = (Chunk)chunks.next;
        }
        return _x;
    }

    public static float paintChunkBackgrounds(Chunk chunks, Graphics2D gfx, float x, float y, int lineHeight) {
        Rectangle clipRect = gfx.getClipBounds();
        float _x = 0.0f;
        FontMetrics forBackground = gfx.getFontMetrics();
        int ascent = forBackground.getAscent();
        int height = lineHeight;
        while (chunks != null) {
            Color bgColor;
            if (x + _x + chunks.width > (float)clipRect.x && x + _x < (float)(clipRect.x + clipRect.width) && chunks.accessable && (bgColor = chunks.background) != null) {
                gfx.setColor(bgColor);
                gfx.fill(new Rectangle2D.Float(x + _x, y - (float)ascent, _x + chunks.width - _x, height));
            }
            _x += chunks.width;
            chunks = (Chunk)chunks.next;
        }
        return _x;
    }

    public static float offsetToX(Chunk chunks, int offset) {
        if (chunks != null && offset < chunks.offset) {
            throw new ArrayIndexOutOfBoundsException(offset + " < " + chunks.offset);
        }
        float x = 0.0f;
        while (chunks != null) {
            if (chunks.accessable && offset < chunks.offset + chunks.length) {
                return x + chunks.offsetToX(offset - chunks.offset);
            }
            x += chunks.width;
            chunks = (Chunk)chunks.next;
        }
        return x;
    }

    public static int xToOffset(Chunk chunks, float x, boolean round) {
        float _x = 0.0f;
        while (chunks != null) {
            if (chunks.accessable && x < _x + chunks.width) {
                return chunks.xToOffset(x - _x, round);
            }
            _x += chunks.width;
            chunks = (Chunk)chunks.next;
        }
        return -1;
    }

    public static void propertiesChanged(IPropertyManager props) {
        String family;
        fontSubstList = null;
        if (props == null) {
            fontSubstEnabled = false;
            preferredFonts = null;
        } else {
            fontSubstEnabled = Boolean.parseBoolean(props.getProperty("view.enableFontSubst"));
        }
        ArrayList<Font> userFonts = new ArrayList<Font>();
        int i = 0;
        while ((family = props.getProperty("view.fontSubstList." + i)) != null) {
            Font f = new Font(family, 0, 12);
            if (!"dialog".equalsIgnoreCase(f.getFamily()) || "dialog".equalsIgnoreCase(family)) {
                userFonts.add(f);
            }
            ++i;
        }
        preferredFonts = userFonts.toArray(new Font[userFonts.size()]);
    }

    public Chunk(float width, int offset, ParserRuleSet rules) {
        super((byte)0, offset, 0, rules);
        this.width = width;
    }

    public Chunk(byte id, int offset, int length, ParserRuleSet rules, SyntaxStyle[] styles, byte defaultID) {
        super(id, offset, length, rules);
        this.accessable = true;
        this.style = styles[id];
        this.background = this.style.getBackgroundColor();
        if (this.background == null) {
            this.background = styles[defaultID].getBackgroundColor();
        }
    }

    public final float offsetToX(int offset) {
        if (!this.visible || this.glyphs == null) {
            return 0.0f;
        }
        float x = 0.0f;
        for (GlyphVector gv : this.glyphs) {
            if (offset < gv.getNumGlyphs()) {
                return x += (float)gv.getGlyphPosition(offset).getX();
            }
            x += (float)gv.getLogicalBounds().getWidth();
            offset -= gv.getNumGlyphs();
        }
        assert (false) : "Shouldn't reach this.";
        return -1.0f;
    }

    public final int xToOffset(float x, boolean round) {
        if (!this.visible || this.glyphs == null) {
            if (round && this.width - x < x) {
                return this.offset + this.length;
            }
            return this.offset;
        }
        int off = this.offset;
        float myx = 0.0f;
        for (GlyphVector gv : this.glyphs) {
            float gwidth = (float)gv.getLogicalBounds().getWidth();
            if (myx + gwidth >= x) {
                float[] pos = gv.getGlyphPositions(0, gv.getNumGlyphs(), null);
                for (int i = 0; i < gv.getNumGlyphs(); ++i) {
                    float nextX;
                    float glyphX = myx + pos[i << 1];
                    float f = nextX = i == gv.getNumGlyphs() - 1 ? this.width : myx + pos[(i << 1) + 2];
                    if (!(nextX > x)) continue;
                    if (!round || nextX - x > x - glyphX) {
                        return off + i;
                    }
                    return off + i + 1;
                }
            }
            myx += gwidth;
            off += gv.getNumGlyphs();
        }
        assert (false) : "Shouldn't reach this.";
        return -1;
    }

    public void init(Segment seg, TabExpander expander, float x, FontRenderContext fontRenderContext, int physicalLineOffset) {
        this.initialized = true;
        if (this.accessable) {
            if (this.length == 1 && seg.array[seg.offset + this.offset] == '\t') {
                this.visible = false;
                float newX = expander.nextTabStop(x, physicalLineOffset + this.offset);
                this.width = newX - x;
            } else {
                this.visible = true;
                this.str = new String(seg.array, seg.offset + this.offset, this.length);
                char[] textArray = seg.array;
                int textStart = seg.offset + this.offset;
                this.width = this.layoutGlyphs(fontRenderContext, textArray, textStart, textStart + this.length);
            }
        }
    }

    private static Font[] getFontSubstList() {
        if (fontSubstList == null) {
            Font[] systemFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
            fontSubstList = new Font[preferredFonts.length + systemFonts.length];
            System.arraycopy(preferredFonts, 0, fontSubstList, 0, preferredFonts.length);
            System.arraycopy(systemFonts, 0, fontSubstList, preferredFonts.length, systemFonts.length);
        }
        return fontSubstList;
    }

    private static Font getSubstFont(int codepoint) {
        if (Character.isISOControl(codepoint)) {
            return null;
        }
        for (Font candidate : Chunk.getFontSubstList()) {
            if (!candidate.canDisplay(codepoint)) continue;
            return candidate;
        }
        return null;
    }

    private void drawGlyphs(Graphics2D gfx, float x, float y) {
        for (GlyphVector gv : this.glyphs) {
            gfx.drawGlyphVector(gv, x, y);
            x += (float)gv.getLogicalBounds().getWidth();
        }
    }

    private float addGlyphVector(Font font, FontRenderContext frc, char[] text, int start, int end) {
        int layoutFlags = 6;
        GlyphVector gv = font.layoutGlyphVector(frc, text, start, end, layoutFlags);
        font.layoutGlyphVector(frc, EMPTY_TEXT, 0, 0, layoutFlags);
        this.glyphs.add(gv);
        return (float)gv.getLogicalBounds().getWidth();
    }

    private float layoutGlyphs(FontRenderContext frc, char[] text, int start, int end) {
        float width = 0.0f;
        Font mainFont = this.style.getFont();
        this.glyphs = new LinkedList<GlyphVector>();
        while (start < end) {
            int substStart;
            int n = substStart = !fontSubstEnabled ? -1 : mainFont.canDisplayUpTo(text, start, end);
            if (substStart == -1) {
                width += this.addGlyphVector(mainFont, frc, text, start, end);
                break;
            }
            if (substStart > start) {
                width += this.addGlyphVector(mainFont, frc, text, start, substStart);
            }
            int nextChar = Character.codePointAt(text, substStart);
            Font substFont = Chunk.getSubstFont(nextChar);
            int substEnd = substStart + Character.charCount(nextChar);
            if (substFont != null) {
                while (substEnd < end && !mainFont.canDisplay(nextChar = Character.codePointAt(text, substEnd)) && substFont == Chunk.getSubstFont(nextChar)) {
                    substEnd += Character.charCount(nextChar);
                }
                width += this.addGlyphVector(substFont.deriveFont(mainFont.getStyle(), mainFont.getSize()), frc, text, substStart, substEnd);
            } else {
                width += this.addGlyphVector(mainFont, frc, text, substStart, substEnd);
            }
            start = substEnd;
        }
        return width;
    }
}

