/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.test;

import com.steadystate.css.parser.CSSOMParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.style.CSSUtilities;
import org.lobobrowser.html.test.SimpleHtmlRendererContext;
import org.lobobrowser.util.io.IORoutines;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;

public class CssParserTest
extends JFrame {
    private static final Logger logger = Logger.getLogger(CssParserTest.class.getName());
    private final HtmlPanel cssOutput;
    private final JTextArea textArea;

    public CssParserTest() throws HeadlessException {
        this("CSS Parser Test Tool");
    }

    public CssParserTest(String string) throws HeadlessException {
        super(string);
        JTextArea jTextArea;
        HtmlPanel htmlPanel;
        this.setDefaultCloseOperation(3);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        final JTextField jTextField = new JTextField();
        JButton jButton = new JButton("Parse & Render");
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.cssOutput = htmlPanel = new HtmlPanel();
        container.add((Component)jPanel, "North");
        container.add((Component)jPanel2, "Center");
        jPanel.add((Component)new JLabel("URL: "), "West");
        jPanel.add((Component)jTextField, "Center");
        jPanel.add((Component)jButton, "East");
        jPanel2.add((Component)jTabbedPane, "Center");
        this.textArea = jTextArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jTabbedPane.addTab("Parsed CSS", htmlPanel);
        jTabbedPane.addTab("Source Code", jScrollPane);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CssParserTest.this.process(jTextField.getText());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(String string) {
        try {
            byte[] byArray;
            Object object;
            URL uRL;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                int n = string.indexOf(58);
                if (n == -1 || n == 1) {
                    uRL = new URL("file:" + string);
                }
                throw malformedURLException;
            }
            logger.info("process(): Loading URI=[" + string + "].");
            long l = System.currentTimeMillis();
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible;) Cobra/0.96.1+");
            uRLConnection.setRequestProperty("Cookie", "");
            if (uRLConnection instanceof HttpURLConnection) {
                object = (HttpURLConnection)uRLConnection;
                ((HttpURLConnection)object).setInstanceFollowRedirects(true);
                int n = ((HttpURLConnection)object).getResponseCode();
                logger.info("process(): HTTP response code: " + n);
            }
            object = uRLConnection.getInputStream();
            try {
                byArray = IORoutines.load((InputStream)object, 8192);
            }
            finally {
                ((InputStream)object).close();
            }
            String string2 = new String(byArray, "ISO-8859-1");
            this.textArea.setText(string2);
            long l2 = System.currentTimeMillis();
            CSSOMParser cSSOMParser = new CSSOMParser();
            InputSource inputSource = CSSUtilities.getCssInputSourceForStyleSheet(string2, string);
            CSSStyleSheet cSSStyleSheet = cSSOMParser.parseStyleSheet(inputSource);
            long l3 = System.currentTimeMillis();
            logger.info("Parsed URI=[" + string + "]: Parse elapsed: " + (l3 - l2) + " ms. Load elapsed: " + (l2 - l) + " ms.");
            this.showStyleSheet(cSSStyleSheet);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Error trying to load URI=[" + string + "].", exception);
            this.clearCssOutput();
        }
    }

    private void clearCssOutput() {
        this.cssOutput.clearDocument();
    }

    private void showStyleSheet(CSSStyleSheet cSSStyleSheet) {
        Object object;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("<DL>");
        CSSRuleList cSSRuleList = cSSStyleSheet.getCssRules();
        int n = cSSRuleList.getLength();
        for (int i = 0; i < n; ++i) {
            object = cSSRuleList.item(i);
            printWriter.println("<DT><strong>Rule: type=" + object.getType() + ",class=" + object.getClass().getName() + "</strong></DT>");
            printWriter.println("<DD>");
            this.writeRuleInfo(printWriter, (CSSRule)object);
            printWriter.println("</DD>");
        }
        printWriter.println("</DL>");
        printWriter.flush();
        String string = stringWriter.toString();
        object = new SimpleHtmlRendererContext(this.cssOutput);
        this.cssOutput.setHtml(string, "about:css", (HtmlRendererContext)object);
    }

    private void writeRuleInfo(PrintWriter printWriter, CSSRule cSSRule) {
        if (cSSRule instanceof CSSStyleRule) {
            CSSStyleRule cSSStyleRule = (CSSStyleRule)cSSRule;
            printWriter.println("Selector: " + cSSStyleRule.getSelectorText());
            printWriter.println("<br>");
            printWriter.println("CSS Text: " + cSSStyleRule.getCssText());
        } else if (cSSRule instanceof CSSImportRule) {
            CSSImportRule cSSImportRule = (CSSImportRule)cSSRule;
            printWriter.println("HREF: " + cSSImportRule.getHref());
            printWriter.println("<br>");
            printWriter.println("CSS Text: " + cSSImportRule.getCssText());
        }
    }

    public static void main(String[] stringArray) {
        CssParserTest cssParserTest = new CssParserTest();
        cssParserTest.setSize(800, 400);
        cssParserTest.setExtendedState(6);
        cssParserTest.setVisible(true);
    }
}

