/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableCellElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableRowElementImpl;
import org.lobobrowser.html.domimpl.NodeFilter;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RTableCell;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.renderer.VirtualCell;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.lobobrowser.html.style.HtmlLength;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderThreadState;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLTableCellElement;
import org.w3c.dom.html2.HTMLTableRowElement;

class TableMatrix {
    private static final NodeFilter COLUMNS_FILTER = new ColumnsFilter();
    private final ArrayList ROWS = new ArrayList();
    private final ArrayList ALL_CELLS = new ArrayList();
    private final ArrayList ROW_ELEMENTS = new ArrayList();
    private final HTMLElementImpl tableElement;
    private final UserAgentContext parserContext;
    private final HtmlRendererContext rendererContext;
    private final FrameContext frameContext;
    private final RElement relement;
    private final RenderableContainer container;
    private SizeInfo[] columnSizes;
    private SizeInfo[] rowSizes;
    private int tableWidth;
    private int tableHeight;
    private int hasOldStyleBorder;
    private int cellSpacingY;
    private int cellSpacingX;
    private int widthsOfExtras;
    private int heightsOfExtras;
    private HtmlLength tableWidthLength;
    private BoundableRenderable armedRenderable;

    public TableMatrix(HTMLElementImpl hTMLElementImpl, UserAgentContext userAgentContext, HtmlRendererContext htmlRendererContext, FrameContext frameContext, RenderableContainer renderableContainer, RElement rElement) {
        this.tableElement = hTMLElementImpl;
        this.parserContext = userAgentContext;
        this.rendererContext = htmlRendererContext;
        this.frameContext = frameContext;
        this.relement = rElement;
        this.container = renderableContainer;
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public int getNumRows() {
        return this.ROWS.size();
    }

    public int getNumColumns() {
        return this.columnSizes.length;
    }

    public int getTableHeight() {
        return this.tableHeight;
    }

    public int getTableWidth() {
        return this.tableWidth;
    }

    public void reset(Insets insets, int n, int n2) {
        this.ROWS.clear();
        this.ALL_CELLS.clear();
        this.ROW_ELEMENTS.clear();
        String string = this.tableElement.getAttribute("border");
        int n3 = 0;
        if (string != null) {
            try {
                n3 = Integer.parseInt(string);
                if (n3 < 0) {
                    n3 = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String string2 = this.tableElement.getAttribute("cellspacing");
        int n4 = 1;
        if (string2 != null) {
            try {
                n4 = Integer.parseInt(string2);
                if (n4 < 0) {
                    n4 = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.cellSpacingX = n4;
        this.cellSpacingY = n4;
        this.tableWidthLength = TableMatrix.getWidthLength(this.tableElement, n);
        this.populateRows();
        this.adjustForCellSpans();
        this.createSizeArrays();
        SizeInfo[] sizeInfoArray = this.columnSizes;
        int n5 = sizeInfoArray.length;
        int n6 = insets.left + insets.right + (n5 + 1) * n4;
        if (n3 > 0) {
            n6 += n5 * 2;
        }
        this.widthsOfExtras = n6;
        SizeInfo[] sizeInfoArray2 = this.rowSizes;
        int n7 = sizeInfoArray2.length;
        int n8 = insets.top + insets.bottom + (n7 + 1) * n4;
        if (n3 > 0) {
            n8 += n7 * 2;
        }
        this.heightsOfExtras = n8;
        this.hasOldStyleBorder = n3 > 0 ? 1 : 0;
    }

    public void build(int n, int n2, boolean bl) {
        int n3 = this.hasOldStyleBorder;
        this.determineColumnSizes(n3, this.cellSpacingX, this.cellSpacingY, n);
        this.determineRowSizes(n3, this.cellSpacingY, n2, bl);
    }

    private final HTMLTableRowElementImpl getParentRow(HTMLTableCellElementImpl hTMLTableCellElementImpl) {
        Node node = hTMLTableCellElementImpl.getParentNode();
        while (!(node instanceof HTMLTableRowElementImpl)) {
            if (node instanceof HTMLTableElementImpl) {
                return null;
            }
            node = node.getParentNode();
        }
        return (HTMLTableRowElementImpl)node;
    }

    private static HtmlLength getWidthLength(HTMLElementImpl hTMLElementImpl, int n) {
        try {
            String string;
            AbstractCSS2Properties abstractCSS2Properties = hTMLElementImpl.getCurrentStyle();
            String string2 = string = abstractCSS2Properties == null ? null : abstractCSS2Properties.getWidth();
            if (string == null) {
                String string3 = hTMLElementImpl.getAttribute("width");
                if (string3 == null) {
                    return null;
                }
                return new HtmlLength(string3);
            }
            return new HtmlLength(HtmlValues.getPixelSize(string, hTMLElementImpl.getRenderState(), 0, n));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static HtmlLength getHeightLength(HTMLElementImpl hTMLElementImpl, int n) {
        try {
            String string;
            AbstractCSS2Properties abstractCSS2Properties = hTMLElementImpl.getCurrentStyle();
            String string2 = string = abstractCSS2Properties == null ? null : abstractCSS2Properties.getHeight();
            if (string == null) {
                String string3 = hTMLElementImpl.getAttribute("height");
                if (string3 == null) {
                    return null;
                }
                return new HtmlLength(string3);
            }
            return new HtmlLength(HtmlValues.getPixelSize(string, hTMLElementImpl.getRenderState(), 0, n));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void populateRows() {
        HTMLElementImpl hTMLElementImpl = this.tableElement;
        ArrayList arrayList = this.ROWS;
        ArrayList arrayList2 = this.ROW_ELEMENTS;
        ArrayList arrayList3 = this.ALL_CELLS;
        HashMap hashMap = new HashMap(2);
        ArrayList arrayList4 = hTMLElementImpl.getDescendents(COLUMNS_FILTER, false);
        ArrayList<VirtualCell> arrayList5 = null;
        for (HTMLTableCellElementImpl hTMLTableCellElementImpl : arrayList4) {
            RTableCell rTableCell;
            ArrayList<VirtualCell> arrayList6;
            HTMLTableRowElementImpl hTMLTableRowElementImpl = this.getParentRow(hTMLTableCellElementImpl);
            if (hTMLTableRowElementImpl != null && hTMLTableRowElementImpl.getRenderState().getDisplay() == 0) continue;
            if (hTMLTableRowElementImpl != null) {
                arrayList5 = null;
                arrayList6 = (ArrayList<VirtualCell>)hashMap.get(hTMLTableRowElementImpl);
                if (arrayList6 == null) {
                    arrayList6 = new ArrayList<VirtualCell>();
                    hashMap.put(hTMLTableRowElementImpl, arrayList6);
                    arrayList.add(arrayList6);
                    arrayList2.add(hTMLTableRowElementImpl);
                }
            } else if (arrayList5 != null) {
                arrayList6 = arrayList5;
            } else {
                arrayList5 = arrayList6 = new ArrayList<VirtualCell>();
                arrayList.add(arrayList6);
                arrayList2.add(null);
            }
            if ((rTableCell = (RTableCell)hTMLTableCellElementImpl.getUINode()) == null) {
                rTableCell = new RTableCell(hTMLTableCellElementImpl, this.parserContext, this.rendererContext, this.frameContext, this.container);
                rTableCell.setParent(this.relement);
                hTMLTableCellElementImpl.setUINode(rTableCell);
            }
            VirtualCell virtualCell = new VirtualCell(rTableCell, true);
            rTableCell.setTopLeftVirtualCell(virtualCell);
            arrayList6.add(virtualCell);
            arrayList3.add(rTableCell);
        }
    }

    private void adjustForCellSpans() {
        VirtualCell virtualCell;
        int n;
        int n2;
        ArrayList arrayList;
        int n3;
        ArrayList arrayList2 = this.ROWS;
        int n4 = arrayList2.size();
        for (n3 = 0; n3 < n4; ++n3) {
            arrayList = (ArrayList)arrayList2.get(n3);
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                int n5;
                int n6;
                virtualCell = (VirtualCell)arrayList.get(n);
                if (virtualCell == null || !virtualCell.isTopLeft()) continue;
                RTableCell rTableCell = virtualCell.getActualCell();
                int n7 = rTableCell.getColSpan();
                if (n7 < 1) {
                    n7 = 1;
                }
                if ((n6 = rTableCell.getRowSpan()) < 1) {
                    n6 = 1;
                }
                if (n4 < (n5 = n3 + n6)) {
                    n6 = n4 - n3;
                    rTableCell.setRowSpan(n6);
                }
                n4 = arrayList2.size();
                for (int i = 0; i < n6; ++i) {
                    int n8;
                    if (n7 <= 1 && i <= 0) continue;
                    int n9 = n3 + i;
                    ArrayList arrayList3 = (ArrayList)arrayList2.get(n9);
                    for (int j = n8 = i == 0 ? 1 : 0; j < n7; ++j) {
                        int n10 = n + j;
                        while (arrayList3.size() < n10) {
                            arrayList3.add(null);
                        }
                        arrayList3.add(n10, new VirtualCell(rTableCell, false));
                    }
                    if (arrayList != arrayList3) continue;
                    n2 = arrayList.size();
                }
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            arrayList = (ArrayList)arrayList2.get(n3);
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                virtualCell = (VirtualCell)arrayList.get(n);
                if (virtualCell == null) continue;
                virtualCell.setColumn(n);
                virtualCell.setRow(n3);
            }
        }
    }

    private void createSizeArrays() {
        HtmlLength htmlLength;
        Object object;
        Object object2;
        Object object3;
        SizeInfo sizeInfo;
        ArrayList arrayList = this.ROWS;
        int n = arrayList.size();
        SizeInfo[] sizeInfoArray = new SizeInfo[n];
        this.rowSizes = sizeInfoArray;
        int n2 = 0;
        ArrayList arrayList2 = this.ROW_ELEMENTS;
        for (int i = 0; i < n; ++i) {
            ArrayList arrayList3 = (ArrayList)arrayList.get(i);
            int n3 = arrayList3.size();
            if (n3 > n2) {
                n2 = n3;
            }
            sizeInfoArray[i] = sizeInfo = new SizeInfo();
            try {
                object3 = (HTMLTableRowElement)arrayList2.get(i);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                object3 = null;
            }
            object2 = object3 == null ? null : object3.getAttribute("height");
            object = null;
            if (object2 != null) {
                try {
                    object = new HtmlLength((String)object2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (object != null) {
                sizeInfo.htmlLength = object;
                continue;
            }
            htmlLength = null;
            for (int j = 0; j < n3; ++j) {
                HtmlLength htmlLength2;
                VirtualCell virtualCell = (VirtualCell)arrayList3.get(j);
                if (virtualCell == null || (htmlLength2 = virtualCell.getHeightLength()) == null || !htmlLength2.isPreferredOver(htmlLength)) continue;
                htmlLength = htmlLength2;
            }
            sizeInfo.htmlLength = htmlLength;
        }
        SizeInfo[] sizeInfoArray2 = new SizeInfo[n2];
        this.columnSizes = sizeInfoArray2;
        for (int i = 0; i < n2; ++i) {
            int n4;
            HtmlLength htmlLength3 = null;
            for (n4 = 0; n4 < n; ++n4) {
                object3 = (ArrayList)arrayList.get(n4);
                try {
                    object2 = (VirtualCell)((ArrayList)object3).get(i);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    object2 = null;
                }
                if (object2 == null || ((RTableCell)(object = ((VirtualCell)object2).getActualCell())).getColSpan() != 1 || (htmlLength = ((VirtualCell)object2).getWidthLength()) == null || !htmlLength.isPreferredOver(htmlLength3)) continue;
                htmlLength3 = htmlLength;
            }
            if (htmlLength3 == null) {
                for (n4 = 0; n4 < n; ++n4) {
                    object3 = (ArrayList)arrayList.get(n4);
                    try {
                        object2 = (VirtualCell)((ArrayList)object3).get(i);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        object2 = null;
                    }
                    if (object2 == null || ((RTableCell)(object = ((VirtualCell)object2).getActualCell())).getColSpan() <= 1 || (htmlLength = ((VirtualCell)object2).getWidthLength()) == null || !htmlLength.isPreferredOver(htmlLength3)) continue;
                    htmlLength3 = htmlLength;
                }
            }
            sizeInfo = new SizeInfo();
            sizeInfo.htmlLength = htmlLength3;
            sizeInfoArray2[i] = sizeInfo;
        }
    }

    private void determineColumnSizes(int n, int n2, int n3, int n4) {
        boolean bl;
        int n5;
        HtmlLength htmlLength = this.tableWidthLength;
        if (htmlLength != null) {
            n5 = htmlLength.getLength(n4);
            bl = true;
        } else {
            n5 = n4;
            bl = false;
        }
        SizeInfo[] sizeInfoArray = this.columnSizes;
        int n6 = this.widthsOfExtras;
        int n7 = n5 - n6;
        if (n7 < 0) {
            n5 += -n7;
            n7 = 0;
        }
        this.determineTentativeSizes(sizeInfoArray, n6, n7, bl);
        this.preLayout(n, n2, n3, bl);
        this.adjustForRenderWidths(sizeInfoArray, n, n2, bl);
        this.adjustWidthsForExpectedMax(sizeInfoArray, n7, bl);
    }

    private void determineTentativeSizes(SizeInfo[] sizeInfoArray, int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        int n6 = sizeInfoArray.length;
        int n7 = 0;
        for (n5 = 0; n5 < n6; ++n5) {
            SizeInfo sizeInfo = sizeInfoArray[n5];
            HtmlLength htmlLength = sizeInfo.htmlLength;
            if (htmlLength == null || htmlLength.getLengthType() != 2) continue;
            int n8 = htmlLength.getLength(n2);
            n7 += n8;
            sizeInfo.actualSize = n8;
        }
        n5 = 0;
        int n9 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            SizeInfo sizeInfo = sizeInfoArray[n4];
            HtmlLength htmlLength = sizeInfo.htmlLength;
            if (htmlLength != null && htmlLength.getLengthType() != 2) {
                int n10 = htmlLength.getRawValue();
                n5 += n10;
                sizeInfo.actualSize = n10;
                continue;
            }
            if (htmlLength != null) continue;
            ++n9;
        }
        if (n9 == 0 && (n3 = (n4 = n7 + n5) - n2) > 0) {
            int n11;
            int n12;
            HtmlLength htmlLength;
            SizeInfo sizeInfo;
            int n13;
            if (n5 > 0) {
                int n14 = n5 - n3;
                if (n14 < 0) {
                    n14 = 0;
                }
                double d = (double)n14 / (double)n5;
                for (n13 = 0; n13 < n6; ++n13) {
                    sizeInfo = sizeInfoArray[n13];
                    htmlLength = sizeInfoArray[n13].htmlLength;
                    if (htmlLength == null || htmlLength.getLengthType() == 2) continue;
                    n12 = sizeInfo.actualSize;
                    sizeInfo.actualSize = n11 = (int)Math.round((double)n12 * d);
                    n4 += n11 - n12;
                }
                n3 = n4 - n2;
            }
            if (n3 > 0 && n7 > 0) {
                int n15 = n7 - n3;
                if (n15 < 0) {
                    n15 = 0;
                }
                double d = (double)n15 / (double)n7;
                for (n13 = 0; n13 < n6; ++n13) {
                    sizeInfo = sizeInfoArray[n13];
                    htmlLength = sizeInfoArray[n13].htmlLength;
                    if (htmlLength == null || htmlLength.getLengthType() != 2) continue;
                    n12 = sizeInfo.actualSize;
                    sizeInfo.actualSize = n11 = (int)Math.round((double)n12 * d);
                    n4 += n11 - n12;
                }
            }
        }
    }

    private void adjustForRenderWidths(SizeInfo[] sizeInfoArray, int n, int n2, boolean bl) {
        for (SizeInfo sizeInfo : sizeInfoArray) {
            if (sizeInfo.actualSize >= sizeInfo.layoutSize) continue;
            sizeInfo.actualSize = sizeInfo.layoutSize;
        }
    }

    private void layoutColumn(SizeInfo[] sizeInfoArray, SizeInfo sizeInfo, int n, int n2, int n3) {
        SizeInfo[] sizeInfoArray2 = this.rowSizes;
        ArrayList arrayList = this.ROWS;
        int n4 = arrayList.size();
        int n5 = sizeInfo.actualSize;
        sizeInfo.layoutSize = 0;
        for (int i = 0; i < n4; ++i) {
            int n6;
            int n7;
            RTableCell rTableCell;
            ArrayList arrayList2 = (ArrayList)arrayList.get(i);
            VirtualCell virtualCell = null;
            try {
                virtualCell = (VirtualCell)arrayList2.get(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                virtualCell = null;
            }
            RTableCell rTableCell2 = rTableCell = virtualCell == null ? null : virtualCell.getActualCell();
            if (rTableCell == null || rTableCell.getVirtualRow() != i) continue;
            int n8 = rTableCell.getColSpan();
            if (n8 > 1) {
                int n9 = rTableCell.getVirtualColumn();
                n6 = n7 = (n8 - 1) * (n2 + 2 * n3);
                for (int j = 0; j < n8; ++j) {
                    n6 += sizeInfoArray[n9 + j].actualSize;
                }
                Dimension dimension = rTableCell.doCellLayout(n6, 0, true, true, true);
                int n10 = dimension.width;
                int n11 = n6 - n7;
                int n12 = n11 > 0 ? n5 * (n10 - n7) / n11 : (n10 - n7) / n8;
                if (n12 > sizeInfo.layoutSize) {
                    sizeInfo.layoutSize = n12;
                }
                int n13 = rTableCell.getRowSpan();
                int n14 = (dimension.height - (n13 - 1) * (this.cellSpacingY + 2 * n3)) / n13;
                for (int j = 0; j < n13; ++j) {
                    if (sizeInfoArray2[i + j].minSize >= n14) continue;
                    sizeInfoArray2[i + j].minSize = n14;
                }
                continue;
            }
            Dimension dimension = rTableCell.doCellLayout(n5, 0, true, true, true);
            if (dimension.width > sizeInfo.layoutSize) {
                sizeInfo.layoutSize = dimension.width;
            }
            n7 = rTableCell.getRowSpan();
            n6 = (dimension.height - (n7 - 1) * (this.cellSpacingY + 2 * n3)) / n7;
            for (int j = 0; j < n7; ++j) {
                if (sizeInfoArray2[i + j].minSize >= n6) continue;
                sizeInfoArray2[i + j].minSize = n6;
            }
        }
    }

    private int adjustWidthsForExpectedMax(SizeInfo[] sizeInfoArray, int n, boolean bl) {
        int n2;
        int n3 = this.hasOldStyleBorder;
        int n4 = this.cellSpacingX;
        int n5 = 0;
        int n6 = sizeInfoArray.length;
        for (n2 = 0; n2 < n6; ++n2) {
            n5 += sizeInfoArray[n2].actualSize;
        }
        n2 = n5 - n;
        if (n2 > 0 || n2 < 0 && bl) {
            int n7;
            int n8;
            SizeInfo sizeInfo;
            int n9;
            int n10;
            int n11 = 0;
            int n12 = 0;
            for (n10 = 0; n10 < n6; ++n10) {
                if (sizeInfoArray[n10].htmlLength != null) continue;
                ++n12;
                n11 += sizeInfoArray[n10].actualSize;
            }
            if (n11 > 0) {
                n10 = n11 - n2;
                if (n10 < 0) {
                    n10 = 0;
                }
                double d = (double)n10 / (double)n11;
                int n13 = 0;
                for (n9 = 0; n9 < n6; ++n9) {
                    sizeInfo = sizeInfoArray[n9];
                    if (sizeInfo.htmlLength != null) continue;
                    int n14 = sizeInfo.actualSize;
                    if (++n13 == n12) {
                        n8 = n5 - n;
                        n7 = n14 - n8;
                        if (n7 < 0) {
                            n7 = 0;
                        }
                    } else {
                        n7 = (int)Math.round((double)n14 * d);
                    }
                    sizeInfo.actualSize = n7;
                    if (n7 < sizeInfo.layoutSize) {
                        this.layoutColumn(sizeInfoArray, sizeInfo, n9, n4, n3);
                        if (n7 < sizeInfo.layoutSize) {
                            sizeInfo.actualSize = n7 = sizeInfo.layoutSize;
                        }
                    }
                    n5 += n7 - n14;
                }
                n2 = n5 - n;
            }
            if (n2 > 0 || n2 < 0 && bl) {
                int n15;
                n10 = 0;
                for (n15 = 0; n15 < n6; ++n15) {
                    HtmlLength htmlLength = sizeInfoArray[n15].htmlLength;
                    if (htmlLength == null || htmlLength.getLengthType() == 2) continue;
                    n10 += sizeInfoArray[n15].actualSize;
                }
                if (n10 > 0) {
                    n15 = n10 - n2;
                    if (n15 < 0) {
                        n15 = 0;
                    }
                    double d = (double)n15 / (double)n10;
                    for (n9 = 0; n9 < n6; ++n9) {
                        sizeInfo = sizeInfoArray[n9];
                        HtmlLength htmlLength = sizeInfoArray[n9].htmlLength;
                        if (htmlLength == null || htmlLength.getLengthType() == 2) continue;
                        n7 = sizeInfo.actualSize;
                        sizeInfo.actualSize = n8 = (int)Math.round((double)n7 * d);
                        if (n8 < sizeInfo.layoutSize) {
                            this.layoutColumn(sizeInfoArray, sizeInfo, n9, n4, n3);
                            if (n8 < sizeInfo.layoutSize) {
                                sizeInfo.actualSize = n8 = sizeInfo.layoutSize;
                            }
                        }
                        n5 += n8 - n7;
                    }
                    n2 = n5 - n;
                }
                if (n2 > 0 || n2 < 0 && bl) {
                    int n16;
                    n15 = 0;
                    for (n16 = 0; n16 < n6; ++n16) {
                        HtmlLength htmlLength = sizeInfoArray[n16].htmlLength;
                        if (htmlLength == null || htmlLength.getLengthType() != 2) continue;
                        n15 += sizeInfoArray[n16].actualSize;
                    }
                    if (n15 > 0) {
                        n16 = n15 - n2;
                        if (n16 < 0) {
                            n16 = 0;
                        }
                        double d = (double)n16 / (double)n15;
                        for (int i = 0; i < n6; ++i) {
                            int n17;
                            SizeInfo sizeInfo2 = sizeInfoArray[i];
                            HtmlLength htmlLength = sizeInfoArray[i].htmlLength;
                            if (htmlLength == null || htmlLength.getLengthType() != 2) continue;
                            n8 = sizeInfo2.actualSize;
                            sizeInfo2.actualSize = n17 = (int)Math.round((double)n8 * d);
                            if (n17 < sizeInfo2.layoutSize) {
                                this.layoutColumn(sizeInfoArray, sizeInfo2, i, n4, n3);
                                if (n17 < sizeInfo2.layoutSize) {
                                    sizeInfo2.actualSize = n17 = sizeInfo2.layoutSize;
                                }
                            }
                            n5 += n17 - n8;
                        }
                    }
                }
            }
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void preLayout(int n, int n2, int n3, boolean bl) {
        int n4;
        SizeInfo[] sizeInfoArray = this.columnSizes;
        SizeInfo[] sizeInfoArray2 = this.rowSizes;
        int n5 = sizeInfoArray2.length;
        for (n4 = 0; n4 < n5; ++n4) {
            sizeInfoArray2[n4].minSize = 0;
        }
        n4 = sizeInfoArray.length;
        for (int i = 0; i < n4; ++i) {
            sizeInfoArray[i].layoutSize = 0;
        }
        ArrayList arrayList = this.ALL_CELLS;
        int n6 = arrayList.size();
        for (int i = 0; i < n6; ++i) {
            int n7;
            int n8;
            int n9;
            int n10;
            Object object;
            int n11;
            Object object2;
            int n12;
            RTableCell rTableCell = (RTableCell)arrayList.get(i);
            int n13 = rTableCell.getVirtualColumn();
            int n14 = rTableCell.getColSpan();
            boolean bl2 = false;
            if (n14 > 1) {
                n12 = 0;
                for (int j = 0; j < n14; ++j) {
                    object2 = sizeInfoArray[n13 + j];
                    if (((SizeInfo)object2).htmlLength != null) {
                        bl2 = true;
                    }
                    n12 += ((SizeInfo)object2).actualSize;
                }
                n11 = n12 + (n14 - 1) * (n2 + 2 * n);
            } else {
                object = sizeInfoArray[n13];
                if (((SizeInfo)object).htmlLength != null) {
                    bl2 = true;
                }
                n12 = n11 = ((SizeInfo)object).actualSize;
            }
            object2 = RenderThreadState.getState();
            boolean bl3 = ((RenderThreadState)object2).overrideNoWrap;
            try {
                if (!bl3) {
                    ((RenderThreadState)object2).overrideNoWrap = !bl2;
                }
                object = rTableCell.doCellLayout(n11, 0, true, true, true);
            }
            finally {
                ((RenderThreadState)object2).overrideNoWrap = bl3;
            }
            int n15 = ((Dimension)object).width;
            if (n14 > 1) {
                if (n12 > 0) {
                    double d = (double)n15 / (double)n12;
                    for (n10 = 0; n10 < n14; ++n10) {
                        SizeInfo sizeInfo = sizeInfoArray[n13 + n10];
                        n9 = (int)Math.round((double)sizeInfo.actualSize * d);
                        if (sizeInfo.layoutSize >= n9) continue;
                        sizeInfo.layoutSize = n9;
                    }
                } else {
                    n8 = n15 / n14;
                    for (n7 = 0; n7 < n14; ++n7) {
                        SizeInfo sizeInfo = sizeInfoArray[n13 + n7];
                        if (sizeInfo.layoutSize >= n8) continue;
                        sizeInfo.layoutSize = n8;
                    }
                }
            } else {
                SizeInfo sizeInfo = sizeInfoArray[n13];
                if (sizeInfo.layoutSize < n15) {
                    sizeInfo.layoutSize = n15;
                }
            }
            n8 = ((Dimension)object).height;
            n7 = rTableCell.getVirtualRow();
            n10 = rTableCell.getRowSpan();
            if (n10 > 1) {
                int n16 = (n8 - (n10 - 1) * (n3 + 2 * n)) / n10;
                for (n9 = 0; n9 < n10; ++n9) {
                    if (sizeInfoArray2[n7 + n9].minSize >= n16) continue;
                    sizeInfoArray2[n7 + n9].minSize = n16;
                }
                continue;
            }
            if (sizeInfoArray2[n7].minSize >= n8) continue;
            sizeInfoArray2[n7].minSize = n8;
        }
    }

    private void determineRowSizes(int n, int n2, int n3, boolean bl) {
        HtmlLength htmlLength = TableMatrix.getHeightLength(this.tableElement, n3);
        SizeInfo[] sizeInfoArray = this.rowSizes;
        int n4 = sizeInfoArray.length;
        int n5 = this.heightsOfExtras;
        if (htmlLength != null) {
            int n6 = htmlLength.getLength(n3);
            this.determineRowSizesFixedTH(n, n2, n3, n6, bl);
        } else {
            int n7 = n5;
            for (int i = 0; i < n4; ++i) {
                n7 += sizeInfoArray[i].minSize;
            }
            this.determineRowSizesFlexibleTH(n, n2, n3, bl);
        }
    }

    private void determineRowSizesFixedTH(int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6;
        int n7;
        int n8;
        Object object;
        int n9;
        SizeInfo[] sizeInfoArray = this.rowSizes;
        int n10 = sizeInfoArray.length;
        int n11 = this.heightsOfExtras;
        int n12 = n4 - n11;
        if (n12 < 0) {
            n12 = 0;
        }
        int n13 = 0;
        int n14 = 0;
        for (n9 = 0; n9 < n10; ++n9) {
            SizeInfo sizeInfo = sizeInfoArray[n9];
            HtmlLength htmlLength = sizeInfo.htmlLength;
            if (htmlLength != null && htmlLength.getLengthType() == 2) {
                int n15 = htmlLength.getLength(n12);
                if (n15 < sizeInfo.minSize) {
                    n15 = sizeInfo.minSize;
                }
                n13 += n15;
                sizeInfo.actualSize = n15;
                continue;
            }
            n14 += sizeInfo.minSize;
        }
        if (n13 + n14 > n12) {
            double d = (double)(n12 - n14) / (double)n13;
            for (int i = 0; i < n10; ++i) {
                SizeInfo sizeInfo = sizeInfoArray[i];
                object = sizeInfo.htmlLength;
                if (object == null || ((HtmlLength)object).getLengthType() != 2) continue;
                int n16 = sizeInfo.actualSize;
                n8 = n16;
                int n17 = (int)Math.round((double)n8 * d);
                if (n17 < sizeInfo.minSize) {
                    n17 = sizeInfo.minSize;
                }
                n13 += n17 - n8;
                sizeInfo.actualSize = n17;
            }
        }
        n9 = 0;
        int n18 = 0;
        int n19 = 0;
        for (int i = 0; i < n10; ++i) {
            object = sizeInfoArray[i];
            HtmlLength htmlLength = ((SizeInfo)object).htmlLength;
            if (htmlLength != null && htmlLength.getLengthType() != 2) {
                n8 = htmlLength.getRawValue();
                if (n8 < ((SizeInfo)object).minSize) {
                    n8 = ((SizeInfo)object).minSize;
                }
                n9 += n8;
                ((SizeInfo)object).actualSize = n8;
                continue;
            }
            if (htmlLength != null) continue;
            ++n19;
            n18 += ((SizeInfo)object).minSize;
        }
        if (n9 + n13 + n18 > n12) {
            double d = (double)(n12 - n18 - n13) / (double)n9;
            for (int i = 0; i < n10; ++i) {
                SizeInfo sizeInfo = sizeInfoArray[i];
                HtmlLength htmlLength = sizeInfo.htmlLength;
                if (htmlLength == null || htmlLength.getLengthType() == 2) continue;
                n7 = sizeInfo.actualSize;
                int n20 = n7;
                n6 = (int)Math.round((double)n20 * d);
                if (n6 < sizeInfo.minSize) {
                    n6 = sizeInfo.minSize;
                }
                n9 += n6 - n20;
                sizeInfo.actualSize = n6;
            }
        }
        int n21 = n12 - n9 - n13;
        int n22 = 0;
        for (n5 = 0; n5 < n10; ++n5) {
            SizeInfo sizeInfo = sizeInfoArray[n5];
            HtmlLength htmlLength = sizeInfo.htmlLength;
            if (htmlLength != null) continue;
            n7 = n21 / n19;
            if (n7 < sizeInfo.minSize) {
                n7 = sizeInfo.minSize;
            }
            n22 += n7;
            sizeInfo.actualSize = n7;
        }
        n5 = n9 + n13 + n22;
        if (n5 >= n12) {
            this.tableHeight = n5 + n11;
        } else {
            double d = (double)n12 / (double)n5;
            for (n7 = 0; n7 < n10; ++n7) {
                SizeInfo sizeInfo = sizeInfoArray[n7];
                n6 = sizeInfo.actualSize;
                sizeInfo.actualSize = (int)Math.round((double)n6 * d);
            }
            this.tableHeight = n4;
        }
        this.finalRender(n, n2, bl);
    }

    private void determineRowSizesFlexibleTH(int n, int n2, int n3, boolean bl) {
        int n4;
        Object object;
        int n5;
        SizeInfo[] sizeInfoArray = this.rowSizes;
        int n6 = sizeInfoArray.length;
        int n7 = this.heightsOfExtras;
        int n8 = 0;
        int n9 = 0;
        for (n5 = 0; n5 < n6; ++n5) {
            SizeInfo sizeInfo = sizeInfoArray[n5];
            object = sizeInfo.htmlLength;
            if (object != null && ((HtmlLength)object).getLengthType() == 1) {
                int n10 = ((HtmlLength)object).getRawValue();
                if (n10 < sizeInfo.minSize) {
                    n10 = sizeInfo.minSize;
                }
                n8 += n10;
                sizeInfo.actualSize = n10;
                continue;
            }
            if (object == null || ((HtmlLength)object).getLengthType() != 2) continue;
            n9 += ((HtmlLength)object).getRawValue();
        }
        n5 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            object = sizeInfoArray[n4];
            HtmlLength htmlLength = ((SizeInfo)object).htmlLength;
            if (htmlLength != null) continue;
            int n11 = ((SizeInfo)object).minSize;
            n5 += n11;
            ((SizeInfo)object).actualSize = n11;
        }
        n4 = (int)Math.round((double)(n8 + n5) / (1.0 - (double)n9 / 100.0));
        int n12 = 0;
        for (int i = 0; i < n6; ++i) {
            SizeInfo sizeInfo = sizeInfoArray[i];
            HtmlLength htmlLength = sizeInfo.htmlLength;
            if (htmlLength == null || htmlLength.getLengthType() != 2) continue;
            int n13 = htmlLength.getLength(n4);
            if (n13 < sizeInfo.minSize) {
                n13 = sizeInfo.minSize;
            }
            n12 += n13;
            sizeInfo.actualSize = n13;
        }
        this.tableHeight = n8 + n5 + n12 + n7;
        this.finalRender(n, n2, bl);
    }

    private final void finalRender(int n, int n2, boolean bl) {
        ArrayList arrayList = this.ALL_CELLS;
        SizeInfo[] sizeInfoArray = this.columnSizes;
        SizeInfo[] sizeInfoArray2 = this.rowSizes;
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5;
            int n6;
            RTableCell rTableCell = (RTableCell)arrayList.get(i);
            int n7 = rTableCell.getVirtualColumn();
            int n8 = rTableCell.getColSpan();
            if (n8 > 1) {
                n6 = (n8 - 1) * (n2 + 2 * n);
                for (n5 = 0; n5 < n8; ++n5) {
                    n6 += sizeInfoArray[n7 + n5].actualSize;
                }
            } else {
                n6 = sizeInfoArray[n7].actualSize;
            }
            n5 = rTableCell.getVirtualRow();
            int n9 = rTableCell.getRowSpan();
            if (n9 > 1) {
                n4 = (n9 - 1) * (n2 + 2 * n);
                for (int j = 0; j < n9; ++j) {
                    n4 += sizeInfoArray2[n5 + j].actualSize;
                }
            } else {
                n4 = sizeInfoArray2[n5].actualSize;
            }
            Dimension dimension = rTableCell.doCellLayout(n6, n4, true, true, bl);
            if (dimension.width > n6) {
                sizeInfoArray[n7].actualSize = n8 == 1 ? dimension.width : (sizeInfoArray[n7].actualSize += dimension.width - n6);
            }
            if (dimension.height <= n4) continue;
            if (n9 == 1) {
                sizeInfoArray2[n5].actualSize = dimension.height;
                continue;
            }
            sizeInfoArray2[n5].actualSize += dimension.height - n4;
        }
    }

    public final void doLayout(Insets insets) {
        SizeInfo[] sizeInfoArray = this.rowSizes;
        int n = sizeInfoArray.length;
        int n2 = insets.top;
        int n3 = this.cellSpacingY;
        int n4 = this.hasOldStyleBorder;
        for (int i = 0; i < n; ++i) {
            n2 += n3;
            SizeInfo sizeInfo = sizeInfoArray[i];
            sizeInfo.offset = n2 += n4;
            n2 += sizeInfo.actualSize;
            n2 += n4;
        }
        this.tableHeight = n2 + n3 + insets.bottom;
        SizeInfo[] sizeInfoArray2 = this.columnSizes;
        int n5 = sizeInfoArray2.length;
        int n6 = insets.left;
        int n7 = this.cellSpacingX;
        for (int i = 0; i < n5; ++i) {
            n6 += n7;
            SizeInfo sizeInfo = sizeInfoArray2[i];
            sizeInfo.offset = n6 += n4;
            n6 += sizeInfo.actualSize;
            n6 += n4;
        }
        this.tableWidth = n6 + n7 + insets.right;
        ArrayList arrayList = this.ALL_CELLS;
        int n8 = arrayList.size();
        for (int i = 0; i < n8; ++i) {
            RTableCell rTableCell = (RTableCell)arrayList.get(i);
            rTableCell.setCellBounds(sizeInfoArray2, sizeInfoArray, n4, n7, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Graphics graphics, Dimension dimension) {
        RTableCell rTableCell;
        int n;
        ArrayList arrayList = this.ALL_CELLS;
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            rTableCell = (RTableCell)arrayList.get(n);
            Graphics graphics2 = graphics.create(rTableCell.x, rTableCell.y, rTableCell.width, rTableCell.height);
            try {
                rTableCell.paint(graphics2);
                continue;
            }
            finally {
                graphics2.dispose();
            }
        }
        if (this.hasOldStyleBorder > 0) {
            graphics.setColor(Color.GRAY);
            for (n = 0; n < n2; ++n) {
                rTableCell = (RTableCell)arrayList.get(n);
                int n3 = rTableCell.getX() - 1;
                int n4 = rTableCell.getY() - 1;
                int n5 = rTableCell.getWidth() + 1;
                int n6 = rTableCell.getHeight() + 1;
                graphics.drawRect(n3, n4, n5, n6);
            }
        }
    }

    public RenderableSpot getLowestRenderableSpot(int n, int n2) {
        ArrayList arrayList = this.ALL_CELLS;
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            RenderableSpot renderableSpot;
            RTableCell rTableCell = (RTableCell)arrayList.get(i);
            Rectangle rectangle = rTableCell.getBounds();
            if (!rectangle.contains(n, n2) || (renderableSpot = rTableCell.getLowestRenderableSpot(n - rectangle.x, n2 - rectangle.y)) == null) continue;
            return renderableSpot;
        }
        return null;
    }

    public boolean onMouseClick(MouseEvent mouseEvent, int n, int n2) {
        ArrayList arrayList = this.ALL_CELLS;
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            RTableCell rTableCell = (RTableCell)arrayList.get(i);
            Rectangle rectangle = rTableCell.getBounds();
            if (!rectangle.contains(n, n2)) continue;
            if (rTableCell.onMouseClick(mouseEvent, n - rectangle.x, n2 - rectangle.y)) break;
            return false;
        }
        return true;
    }

    public boolean onDoubleClick(MouseEvent mouseEvent, int n, int n2) {
        ArrayList arrayList = this.ALL_CELLS;
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            RTableCell rTableCell = (RTableCell)arrayList.get(i);
            Rectangle rectangle = rTableCell.getBounds();
            if (!rectangle.contains(n, n2)) continue;
            if (rTableCell.onDoubleClick(mouseEvent, n - rectangle.x, n2 - rectangle.y)) break;
            return false;
        }
        return true;
    }

    public boolean onMouseDisarmed(MouseEvent mouseEvent) {
        BoundableRenderable boundableRenderable = this.armedRenderable;
        if (boundableRenderable != null) {
            this.armedRenderable = null;
            return boundableRenderable.onMouseDisarmed(mouseEvent);
        }
        return true;
    }

    public boolean onMousePressed(MouseEvent mouseEvent, int n, int n2) {
        ArrayList arrayList = this.ALL_CELLS;
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            RTableCell rTableCell = (RTableCell)arrayList.get(i);
            Rectangle rectangle = rTableCell.getBounds();
            if (!rectangle.contains(n, n2)) continue;
            if (rTableCell.onMousePressed(mouseEvent, n - rectangle.x, n2 - rectangle.y)) break;
            this.armedRenderable = rTableCell;
            return false;
        }
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent, int n, int n2) {
        BoundableRenderable boundableRenderable;
        ArrayList arrayList = this.ALL_CELLS;
        int n3 = arrayList.size();
        boolean bl = false;
        for (int i = 0; i < n3; ++i) {
            RTableCell rTableCell = (RTableCell)arrayList.get(i);
            Rectangle rectangle = rTableCell.getBounds();
            if (!rectangle.contains(n, n2)) continue;
            bl = true;
            BoundableRenderable boundableRenderable2 = this.armedRenderable;
            if (boundableRenderable2 != null && rTableCell != boundableRenderable2) {
                boundableRenderable2.onMouseDisarmed(mouseEvent);
                this.armedRenderable = null;
            }
            if (rTableCell.onMouseReleased(mouseEvent, n - rectangle.x, n2 - rectangle.y)) break;
            return false;
        }
        if (!bl && (boundableRenderable = this.armedRenderable) != null) {
            boundableRenderable.onMouseDisarmed(mouseEvent);
            this.armedRenderable = null;
        }
        return true;
    }

    public Iterator getRenderables() {
        return this.ALL_CELLS.iterator();
    }

    public static class SizeInfo {
        public HtmlLength htmlLength;
        public int actualSize;
        public int layoutSize;
        public int minSize;
        public int offset;
    }

    private static class ColumnsFilter
    implements NodeFilter {
        private ColumnsFilter() {
        }

        public final boolean accept(Node node) {
            return node instanceof HTMLTableCellElement;
        }
    }

    private static class RowsFilter
    implements NodeFilter {
        private RowsFilter() {
        }

        public final boolean accept(Node node) {
            return node instanceof HTMLTableRowElement;
        }
    }
}

