/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.js;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import org.lobobrowser.js.AbstractScriptableDelegate;

public class Screen
extends AbstractScriptableDelegate {
    private final GraphicsEnvironment graphicsEnvironment;
    private final GraphicsDevice graphicsDevice;

    Screen() {
        if (GraphicsEnvironment.isHeadless()) {
            this.graphicsEnvironment = null;
            this.graphicsDevice = null;
        } else {
            this.graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.graphicsDevice = this.graphicsEnvironment.getDefaultScreenDevice();
        }
    }

    public int getHeight() {
        GraphicsDevice graphicsDevice = this.graphicsDevice;
        return graphicsDevice == null ? 0 : graphicsDevice.getDisplayMode().getHeight();
    }

    public int getPixelDepth() {
        return this.getColorDepth();
    }

    public int getWidth() {
        GraphicsEnvironment graphicsEnvironment = this.graphicsEnvironment;
        if (graphicsEnvironment == null) {
            return 0;
        }
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        return graphicsDevice.getDisplayMode().getWidth();
    }

    public int getAvailHeight() {
        GraphicsEnvironment graphicsEnvironment = this.graphicsEnvironment;
        if (graphicsEnvironment == null) {
            return 0;
        }
        return graphicsEnvironment.getMaximumWindowBounds().height;
    }

    public int getAvailWidth() {
        GraphicsEnvironment graphicsEnvironment = this.graphicsEnvironment;
        if (graphicsEnvironment == null) {
            return 0;
        }
        return graphicsEnvironment.getMaximumWindowBounds().width;
    }

    public int getColorDepth() {
        GraphicsDevice graphicsDevice = this.graphicsDevice;
        if (graphicsDevice == null) {
            return 0;
        }
        return graphicsDevice.getDisplayMode().getBitDepth();
    }
}

