/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.util.ArrayList;
import org.lobobrowser.html.domimpl.DescendentHTMLCollection;
import org.lobobrowser.html.domimpl.ElementFilter;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.lobobrowser.html.style.HtmlLength;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.TableRenderState;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLElement;
import org.w3c.dom.html2.HTMLTableCaptionElement;
import org.w3c.dom.html2.HTMLTableElement;
import org.w3c.dom.html2.HTMLTableSectionElement;

public class HTMLTableElementImpl
extends HTMLAbstractUIElement
implements HTMLTableElement {
    private HTMLTableCaptionElement caption;
    private HTMLTableSectionElement thead;
    private HTMLTableSectionElement tfoot;

    public HTMLTableElementImpl() {
        super("TABLE");
    }

    public HTMLTableElementImpl(String string) {
        super(string);
    }

    public HTMLTableCaptionElement getCaption() {
        return this.caption;
    }

    public void setCaption(HTMLTableCaptionElement hTMLTableCaptionElement) throws DOMException {
        this.caption = hTMLTableCaptionElement;
    }

    public HTMLTableSectionElement getTHead() {
        return this.thead;
    }

    public void setTHead(HTMLTableSectionElement hTMLTableSectionElement) throws DOMException {
        this.thead = hTMLTableSectionElement;
    }

    public HTMLTableSectionElement getTFoot() {
        return this.tfoot;
    }

    public void setTFoot(HTMLTableSectionElement hTMLTableSectionElement) throws DOMException {
        this.tfoot = hTMLTableSectionElement;
    }

    public HTMLCollection getRows() {
        return new DescendentHTMLCollection(this, new ElementFilter("TR"), this.treeLock, false);
    }

    public HTMLCollection getTBodies() {
        return new DescendentHTMLCollection(this, new ElementFilter("TBODY"), this.treeLock, false);
    }

    public String getAlign() {
        return this.getAttribute("align");
    }

    public void setAlign(String string) {
        this.setAttribute("align", string);
    }

    public String getBgColor() {
        return this.getAttribute("bgcolor");
    }

    public void setBgColor(String string) {
        this.setAttribute("bgcolor", string);
    }

    public String getBorder() {
        return this.getAttribute("border");
    }

    public void setBorder(String string) {
        this.setAttribute("border", string);
    }

    public String getCellPadding() {
        return this.getAttribute("cellpadding");
    }

    public void setCellPadding(String string) {
        this.setAttribute("cellpadding", string);
    }

    public String getCellSpacing() {
        return this.getAttribute("cellspacing");
    }

    public void setCellSpacing(String string) {
        this.setAttribute("cellspacing", string);
    }

    public String getFrame() {
        return this.getAttribute("frame");
    }

    public void setFrame(String string) {
        this.setAttribute("frame", string);
    }

    public String getRules() {
        return this.getAttribute("rules");
    }

    public void setRules(String string) {
        this.setAttribute("rules", string);
    }

    public String getSummary() {
        return this.getAttribute("summary");
    }

    public void setSummary(String string) {
        this.setAttribute("summary", string);
    }

    public String getWidth() {
        return this.getAttribute("width");
    }

    public void setWidth(String string) {
        this.setAttribute("width", string);
    }

    public HtmlLength getHeightLength(int n) {
        try {
            String string;
            AbstractCSS2Properties abstractCSS2Properties = this.getCurrentStyle();
            String string2 = string = abstractCSS2Properties == null ? null : abstractCSS2Properties.getHeight();
            if (string == null) {
                return new HtmlLength(this.getAttribute("height"));
            }
            return new HtmlLength(HtmlValues.getPixelSize(string, this.getRenderState(), 0, n));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public HtmlLength getWidthLength(int n) {
        try {
            String string;
            AbstractCSS2Properties abstractCSS2Properties = this.getCurrentStyle();
            String string2 = string = abstractCSS2Properties == null ? null : abstractCSS2Properties.getWidth();
            if (string == null) {
                return new HtmlLength(this.getAttribute("width"));
            }
            return new HtmlLength(HtmlValues.getPixelSize(string, this.getRenderState(), 0, n));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public HTMLElement createTHead() {
        Document document = this.document;
        return document == null ? null : (HTMLElement)document.createElement("thead");
    }

    public void deleteTHead() {
        this.removeChildren(new ElementFilter("THEAD"));
    }

    public HTMLElement createTFoot() {
        Document document = this.document;
        return document == null ? null : (HTMLElement)document.createElement("tfoot");
    }

    public void deleteTFoot() {
        this.removeChildren(new ElementFilter("TFOOT"));
    }

    public HTMLElement createCaption() {
        Document document = this.document;
        return document == null ? null : (HTMLElement)document.createElement("caption");
    }

    public void deleteCaption() {
        this.removeChildren(new ElementFilter("CAPTION"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTMLElement insertRow(int n) throws DOMException {
        Document document = this.document;
        if (document == null) {
            throw new DOMException(4, "Orphan element");
        }
        HTMLElement hTMLElement = (HTMLElement)document.createElement("TR");
        Object object = this.treeLock;
        synchronized (object) {
            if (n == -1) {
                this.appendChild(hTMLElement);
                return hTMLElement;
            }
            ArrayList arrayList = this.nodeList;
            if (arrayList != null) {
                int n2 = arrayList.size();
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    Node node = (Node)arrayList.get(i);
                    if (!"TR".equalsIgnoreCase(node.getNodeName())) continue;
                    if (n3 == n) {
                        this.insertAt(hTMLElement, i);
                        return hTMLElement;
                    }
                    ++n3;
                }
            } else {
                this.appendChild(hTMLElement);
                return hTMLElement;
            }
        }
        throw new DOMException(1, "Index out of range");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow(int n) throws DOMException {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList arrayList = this.nodeList;
            if (arrayList != null) {
                int n2 = arrayList.size();
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    Node node = (Node)arrayList.get(i);
                    if (!"TR".equalsIgnoreCase(node.getNodeName())) continue;
                    if (n3 == n) {
                        this.removeChildAt(i);
                        return;
                    }
                    ++n3;
                }
            }
        }
        throw new DOMException(1, "Index out of range");
    }

    protected RenderState createRenderState(RenderState renderState) {
        return new TableRenderState(renderState, this);
    }
}

