/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.net.MalformedURLException;
import org.lobobrowser.html.BrowserFrame;
import org.lobobrowser.html.domimpl.FrameNode;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.js.Window;
import org.lobobrowser.html.style.IFrameRenderState;
import org.lobobrowser.html.style.RenderState;
import org.w3c.dom.Document;
import org.w3c.dom.html2.HTMLIFrameElement;

public class HTMLIFrameElementImpl
extends HTMLAbstractUIElement
implements HTMLIFrameElement,
FrameNode {
    private volatile BrowserFrame browserFrame;

    public HTMLIFrameElementImpl(String string) {
        super(string);
    }

    public void setBrowserFrame(BrowserFrame browserFrame) {
        String string;
        this.browserFrame = browserFrame;
        if (browserFrame != null && (string = this.getAttribute("src")) != null) {
            try {
                browserFrame.loadURL(this.getFullURL(string));
            }
            catch (MalformedURLException malformedURLException) {
                this.warn("setBrowserFrame(): Unable to navigate to src.", malformedURLException);
            }
        }
    }

    public BrowserFrame getBrowserFrame() {
        return this.browserFrame;
    }

    public String getAlign() {
        return this.getAttribute("align");
    }

    public Document getContentDocument() {
        BrowserFrame browserFrame = this.browserFrame;
        if (browserFrame == null) {
            return null;
        }
        return browserFrame.getContentDocument();
    }

    public Window getContentWindow() {
        BrowserFrame browserFrame = this.browserFrame;
        if (browserFrame == null) {
            return null;
        }
        return Window.getWindow(browserFrame.getHtmlRendererContext());
    }

    public String getFrameBorder() {
        return this.getAttribute("frameborder");
    }

    public String getHeight() {
        return this.getAttribute("height");
    }

    public String getLongDesc() {
        return this.getAttribute("longdesc");
    }

    public String getMarginHeight() {
        return this.getAttribute("marginheight");
    }

    public String getMarginWidth() {
        return this.getAttribute("marginwidth");
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public String getScrolling() {
        return this.getAttribute("scrolling");
    }

    public String getSrc() {
        return this.getAttribute("src");
    }

    public String getWidth() {
        return this.getAttribute("width");
    }

    public void setAlign(String string) {
        this.setAttribute("align", string);
    }

    public void setFrameBorder(String string) {
        this.setAttribute("frameborder", string);
    }

    public void setHeight(String string) {
        this.setAttribute("height", string);
    }

    public void setLongDesc(String string) {
        this.setAttribute("longdesc", string);
    }

    public void setMarginHeight(String string) {
        this.setAttribute("marginHeight", string);
    }

    public void setMarginWidth(String string) {
        this.setAttribute("marginWidth", string);
    }

    public void setName(String string) {
        this.setAttribute("name", string);
    }

    public void setScrolling(String string) {
        this.setAttribute("scrolling", string);
    }

    public void setSrc(String string) {
        this.setAttribute("src", string);
    }

    public void setWidth(String string) {
        this.setAttribute("width", string);
    }

    protected void assignAttributeField(String string, String string2) {
        if ("src".equals(string)) {
            BrowserFrame browserFrame = this.browserFrame;
            if (browserFrame != null) {
                try {
                    browserFrame.loadURL(this.getFullURL(string2));
                }
                catch (MalformedURLException malformedURLException) {
                    this.warn("assignAttributeField(): Unable to navigate to src.", malformedURLException);
                }
            }
        } else {
            super.assignAttributeField(string, string2);
        }
    }

    protected RenderState createRenderState(RenderState renderState) {
        return new IFrameRenderState(renderState, this);
    }
}

