/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class IORoutines {
    public static final byte[] LINE_BREAK_BYTES = new byte[]{13, 10};

    public static String loadAsText(InputStream inputStream, String string) throws IOException {
        return IORoutines.loadAsText(inputStream, string, 4096);
    }

    public static String loadAsText(InputStream inputStream, String string, int n) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
        char[] cArray = new char[n];
        int n2 = 0;
        while (true) {
            int n3;
            int n4;
            if ((n4 = cArray.length - n2) <= 0) {
                char[] cArray2 = new char[cArray.length * 2];
                System.arraycopy(cArray, 0, cArray2, 0, n2);
                cArray = cArray2;
                n4 = cArray.length - n2;
            }
            if ((n3 = inputStreamReader.read(cArray, n2, n4)) == -1) break;
            n2 += n3;
        }
        return new String(cArray, 0, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] load(File file) throws IOException {
        long l = file.length();
        if (l > Integer.MAX_VALUE) {
            throw new IOException("File '" + file.getName() + "' too big");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            byte[] byArray = IORoutines.loadExact(fileInputStream, (int)l);
            return byArray;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public static byte[] load(InputStream inputStream) throws IOException {
        return IORoutines.load(inputStream, 4096);
    }

    public static byte[] load(InputStream inputStream, int n) throws IOException {
        if (n == 0) {
            n = 1;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (true) {
            int n3;
            int n4;
            if ((n4 = byArray.length - n2) <= 0) {
                n3 = byArray.length * 2;
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                byArray = byArray2;
                n4 = byArray.length - n2;
            }
            if ((n3 = inputStream.read(byArray, n2, n4)) == -1) break;
            n2 += n3;
        }
        if (n2 < byArray.length) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, 0, byArray3, 0, n2);
            byArray = byArray3;
        }
        return byArray;
    }

    public static byte[] loadExact(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        while ((n2 = n - n3) > 0) {
            int n4 = inputStream.read(byArray, n3, n2);
            if (n4 == -1) {
                throw new IOException("Reached EOF, read " + n3 + " expecting " + n);
            }
            n3 += n4;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean equalContent(File file, byte[] byArray) throws IOException {
        long l = file.length();
        if (l > Integer.MAX_VALUE) {
            throw new IOException("File '" + file + "' too big");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            byte[] byArray2 = IORoutines.loadExact(fileInputStream, (int)l);
            boolean bl = Arrays.equals(byArray, byArray2);
            return bl;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(File file, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            fileOutputStream.write(byArray);
        }
        finally {
            fileOutputStream.close();
        }
    }

    public static String readLine(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = null;
        block4: while ((n = inputStream.read()) != -1) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            switch (n) {
                case 10: {
                    break block4;
                }
                case 13: {
                    continue block4;
                }
                default: {
                    stringBuffer.append((char)n);
                    continue block4;
                }
            }
        }
        return stringBuffer == null ? null : stringBuffer.toString();
    }

    public static void touch(File file) {
        file.setLastModified(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveStrings(File file, Collection collection) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            PrintWriter printWriter = new PrintWriter(bufferedOutputStream);
            for (String string : collection) {
                printWriter.println(string);
            }
            printWriter.flush();
        }
        finally {
            bufferedOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List loadStrings(File file) throws IOException {
        LinkedList<String> linkedList = new LinkedList<String>();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            while ((string = bufferedReader.readLine()) != null) {
                linkedList.add(string);
            }
            LinkedList<String> linkedList2 = linkedList;
            return linkedList2;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }
}

