/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.io.IOException;
import java.io.InputStream;
import org.lobobrowser.util.EventDispatch;
import org.lobobrowser.util.InputProgressEvent;

public class MonitoredInputStream
extends InputStream {
    private final InputStream delegate;
    private int progress = 0;
    private final long minProgressEventGap;
    public final EventDispatch evtProgress = new EventDispatch();
    private long lastEvenPosted = 0L;

    public MonitoredInputStream(InputStream inputStream, int n) {
        this.delegate = inputStream;
        this.minProgressEventGap = n;
    }

    public MonitoredInputStream(InputStream inputStream) {
        this(inputStream, 200);
    }

    public int available() throws IOException {
        return this.delegate.available();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        int n = this.delegate.read();
        if (n != -1) {
            ++this.progress;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.delegate.read(byArray, n, n2);
        if (n3 != -1) {
            this.progress += n3;
            long l = System.currentTimeMillis();
            if (l - this.lastEvenPosted > this.minProgressEventGap) {
                this.evtProgress.fireEvent(new InputProgressEvent(this, this.progress));
                this.lastEvenPosted = l;
            }
        }
        return n3;
    }
}

