/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.lobobrowser.util.EventDispatch2;
import org.lobobrowser.util.RemovalEvent;
import org.lobobrowser.util.RemovalListener;

public class LRUCache
implements Serializable {
    private static final long serialVersionUID = 940427225784212823L;
    private int approxMaxSize;
    private final Map cacheMap = new HashMap();
    private volatile transient EventDispatch2 removalEvent;
    private final TreeSet timedSet = new TreeSet();
    private int currentSize = 0;

    public LRUCache(int n) {
        this.approxMaxSize = n;
        this.removalEvent = new RemovalDispatch();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.removalEvent = new RemovalDispatch();
    }

    public int getApproxMaxSize() {
        return this.approxMaxSize;
    }

    public void setApproxMaxSize(int n) {
        this.approxMaxSize = n;
    }

    public void put(Object object, Object object2, int n) {
        if (n > this.approxMaxSize) {
            return;
        }
        OrderedValue orderedValue = (OrderedValue)this.cacheMap.get(object);
        if (orderedValue != null) {
            if (orderedValue.value != object2) {
                this.removalEvent.fireEvent(new RemovalEvent(this, orderedValue.value));
            }
            this.currentSize += n - orderedValue.approximateSize;
            this.timedSet.remove(orderedValue);
            orderedValue.approximateSize = n;
            orderedValue.value = object2;
            orderedValue.touch();
            this.timedSet.add(orderedValue);
        } else {
            orderedValue = new OrderedValue(object, object2, n);
            this.cacheMap.put(object, orderedValue);
            this.timedSet.add(orderedValue);
            this.currentSize += n;
        }
        while (this.currentSize > this.approxMaxSize) {
            this.removeLRU();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void removeLRU() {
        OrderedValue orderedValue = (OrderedValue)this.timedSet.first();
        if (orderedValue == null) throw new IllegalStateException("Cannot remove LRU since the cache is empty.");
        this.removalEvent.fireEvent(new RemovalEvent(this, orderedValue.value));
        if (!this.timedSet.remove(orderedValue)) throw new IllegalStateException("Could not remove existing tree node.");
        this.cacheMap.remove(orderedValue.key);
        this.currentSize -= orderedValue.approximateSize;
    }

    public Object get(Object object) {
        OrderedValue orderedValue = (OrderedValue)this.cacheMap.get(object);
        if (orderedValue != null) {
            this.timedSet.remove(orderedValue);
            orderedValue.touch();
            this.timedSet.add(orderedValue);
            return orderedValue.value;
        }
        return null;
    }

    public Object remove(Object object) {
        OrderedValue orderedValue = (OrderedValue)this.cacheMap.get(object);
        if (orderedValue != null) {
            this.removalEvent.fireEvent(new RemovalEvent(this, orderedValue.value));
            this.currentSize -= orderedValue.approximateSize;
            this.timedSet.remove(orderedValue);
            return orderedValue.value;
        }
        return null;
    }

    public void addRemovalListener(RemovalListener removalListener) {
        this.removalEvent.addListener(removalListener);
    }

    public void removeRemovalListener(RemovalListener removalListener) {
        this.removalEvent.removeListener(removalListener);
    }

    public int getApproxSize() {
        return this.currentSize;
    }

    public int getNumEntries() {
        return this.cacheMap.size();
    }

    public List getEntryInfoList() {
        ArrayList<EntryInfo> arrayList = new ArrayList<EntryInfo>();
        for (OrderedValue orderedValue : this.cacheMap.values()) {
            Object object = orderedValue.value;
            Class<?> clazz = object == null ? null : object.getClass();
            arrayList.add(new EntryInfo(clazz, orderedValue.approximateSize));
        }
        return arrayList;
    }

    private class RemovalDispatch
    extends EventDispatch2 {
        private RemovalDispatch() {
        }

        protected void dispatchEvent(EventListener eventListener, EventObject eventObject) {
            ((RemovalListener)eventListener).removed((RemovalEvent)eventObject);
        }
    }

    private class OrderedValue
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = 340227625744215821L;
        private long timestamp;
        private int approximateSize;
        private Object value;
        private Object key;

        private OrderedValue(Object object, Object object2, int n) {
            this.key = object;
            this.value = object2;
            this.approximateSize = n;
            this.touch();
        }

        private final void touch() {
            this.timestamp = System.currentTimeMillis();
        }

        public int compareTo(Object object) {
            int n;
            if (this == object) {
                return 0;
            }
            OrderedValue orderedValue = (OrderedValue)object;
            long l = this.timestamp - orderedValue.timestamp;
            if (l > 0L) {
                return 1;
            }
            if (l < 0L) {
                return -1;
            }
            int n2 = System.identityHashCode(this);
            if (n2 == (n = System.identityHashCode(orderedValue))) {
                n2 = System.identityHashCode(this.value);
                n = System.identityHashCode(orderedValue.value);
            }
            return n2 - n;
        }
    }

    public static class EntryInfo {
        public final Class valueClass;
        public final int approximateSize;

        public EntryInfo(Class clazz, int n) {
            this.valueClass = clazz;
            this.approximateSize = n;
        }

        public String toString() {
            Class clazz = this.valueClass;
            String string = clazz == null ? "<none>" : clazz.getName();
            return "[class=" + string + ",approx-size=" + this.approximateSize + "]";
        }
    }
}

