/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.js;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.lobobrowser.js.JavaFunctionObject;
import org.lobobrowser.js.PropertyInfo;
import org.mozilla.javascript.Function;

public class JavaClassWrapper {
    private final Class javaClass;
    private final Map functions = new HashMap();
    private final Map properties = new HashMap();
    private PropertyInfo nameIndexer;
    private PropertyInfo integerIndexer;

    public JavaClassWrapper(Class clazz) {
        this.javaClass = clazz;
        this.scanMethods();
    }

    public Object newInstance() throws InstantiationException, IllegalAccessException {
        return this.javaClass.newInstance();
    }

    public String getClassName() {
        String string = this.javaClass.getName();
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(n + 1);
    }

    public Function getFunction(String string) {
        return (Function)this.functions.get(string);
    }

    public PropertyInfo getProperty(String string) {
        return (PropertyInfo)this.properties.get(string);
    }

    private void scanMethods() {
        for (Method method : this.javaClass.getMethods()) {
            String string = method.getName();
            if (this.isPropertyMethod(string, method)) {
                this.ensurePropertyKnown(string, method);
                continue;
            }
            if (this.isNameIndexer(string, method)) {
                this.updateNameIndexer(string, method);
            } else if (this.isIntegerIndexer(string, method)) {
                this.updateIntegerIndexer(string, method);
            }
            JavaFunctionObject javaFunctionObject = (JavaFunctionObject)((Object)this.functions.get(string));
            if (javaFunctionObject == null) {
                javaFunctionObject = new JavaFunctionObject(string);
                this.functions.put(string, javaFunctionObject);
            }
            javaFunctionObject.addMethod(method);
        }
    }

    private boolean isNameIndexer(String string, Method method) {
        return "namedItem".equals(string) && method.getParameterTypes().length == 1 || "setNamedItem".equals(string) && method.getParameterTypes().length == 2;
    }

    private boolean isIntegerIndexer(String string, Method method) {
        return "item".equals(string) && method.getParameterTypes().length == 1 || "setItem".equals(string) && method.getParameterTypes().length == 2;
    }

    private void updateNameIndexer(String string, Method method) {
        PropertyInfo propertyInfo;
        boolean bl = true;
        if (string.startsWith("set")) {
            bl = false;
        }
        if ((propertyInfo = this.nameIndexer) == null) {
            this.nameIndexer = propertyInfo = new PropertyInfo("$item", Object.class);
        }
        if (bl) {
            propertyInfo.setGetter(method);
        } else {
            propertyInfo.setSetter(method);
        }
    }

    private void updateIntegerIndexer(String string, Method method) {
        PropertyInfo propertyInfo;
        boolean bl = true;
        if (string.startsWith("set")) {
            bl = false;
        }
        if ((propertyInfo = this.integerIndexer) == null) {
            Class<?> clazz = bl ? method.getReturnType() : method.getParameterTypes()[1];
            this.integerIndexer = propertyInfo = new PropertyInfo("$item", clazz);
        }
        if (bl) {
            propertyInfo.setGetter(method);
        } else {
            propertyInfo.setSetter(method);
        }
    }

    public PropertyInfo getIntegerIndexer() {
        return this.integerIndexer;
    }

    public PropertyInfo getNameIndexer() {
        return this.nameIndexer;
    }

    private boolean isPropertyMethod(String string, Method method) {
        if (string.startsWith("get") || string.startsWith("is")) {
            return method.getParameterTypes().length == 0;
        }
        if (string.startsWith("set")) {
            return method.getParameterTypes().length == 1;
        }
        return false;
    }

    private String propertyUncapitalize(String string) {
        try {
            if (string.length() > 1 && Character.isUpperCase(string.charAt(1))) {
                return string;
            }
            return Character.toLowerCase(string.charAt(0)) + string.substring(1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return string;
        }
    }

    private void ensurePropertyKnown(String string, Method method) {
        String string2;
        boolean bl = false;
        if (string.startsWith("get")) {
            String string3 = string.substring(3);
            string2 = this.propertyUncapitalize(string3);
            bl = true;
        } else if (string.startsWith("set")) {
            String string4 = string.substring(3);
            string2 = this.propertyUncapitalize(string4);
        } else if (string.startsWith("is")) {
            String string5 = string.substring(2);
            string2 = this.propertyUncapitalize(string5);
            bl = true;
        } else {
            throw new IllegalArgumentException("methodName=" + string);
        }
        PropertyInfo propertyInfo = (PropertyInfo)this.properties.get(string2);
        if (propertyInfo == null) {
            Class<?> clazz = bl ? method.getReturnType() : method.getParameterTypes()[0];
            propertyInfo = new PropertyInfo(string2, clazz);
            this.properties.put(string2, propertyInfo);
        }
        if (bl) {
            propertyInfo.setGetter(method);
        } else {
            propertyInfo.setSetter(method);
        }
    }

    public String toString() {
        return this.javaClass.getName();
    }
}

