/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import com.steadystate.css.dom.CSSStyleSheetImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.style.CSS2PropertiesContext;
import org.lobobrowser.html.style.FontInfo;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.js.AbstractScriptableDelegate;
import org.lobobrowser.util.Urls;
import org.lobobrowser.util.gui.ColorFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSS2Properties;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;

public abstract class AbstractCSS2Properties
extends AbstractScriptableDelegate
implements CSS2Properties {
    private static final Logger logger = Logger.getLogger(AbstractCSS2Properties.class.getName());
    public static final String FLOAT = "float";
    public static final String AZIMUTH = "azimuth";
    public static final String BACKGROUND = "background";
    public static final String BACKGROUND_ATTACHMENT = "background-attachment";
    public static final String BACKGROUND_COLOR = "background-color";
    public static final String BACKGROUND_IMAGE = "background-image";
    public static final String BACKGROUND_POSITION = "background-position";
    public static final String BACKGROUND_REPEAT = "background-repeat";
    public static final String BORDER = "border";
    public static final String BORDER_BOTTOM = "border-bottom";
    public static final String BORDER_BOTTOM_COLOR = "border-bottom-color";
    public static final String BORDER_BOTTOM_STYLE = "border-bottom-style";
    public static final String BORDER_BOTTOM_WIDTH = "border-bottom-width";
    public static final String BORDER_COLLAPSE = "border-collapse";
    public static final String BORDER_COLOR = "border-color";
    public static final String BORDER_LEFT = "border-left";
    public static final String BORDER_LEFT_COLOR = "border-left-color";
    public static final String BORDER_LEFT_STYLE = "border-left-style";
    public static final String BORDER_LEFT_WIDTH = "border-left-width";
    public static final String BORDER_RIGHT = "border-right";
    public static final String BORDER_RIGHT_COLOR = "border-right-color";
    public static final String BORDER_RIGHT_STYLE = "border-right-style";
    public static final String BORDER_RIGHT_WIDTH = "border-right-width";
    public static final String BORDER_SPACING = "border-spacing";
    public static final String BORDER_STYLE = "border-style";
    public static final String BORDER_TOP = "border-top";
    public static final String BORDER_TOP_COLOR = "border-top-color";
    public static final String BORDER_TOP_STYLE = "border-top-style";
    public static final String BORDER_TOP_WIDTH = "border-top-width";
    public static final String BORDER_WIDTH = "border-width";
    public static final String BOTTOM = "bottom";
    public static final String CAPTION_SIDE = "caption-side";
    public static final String CLEAR = "clear";
    public static final String CLIP = "clip";
    public static final String COLOR = "color";
    public static final String CONTENT = "content";
    public static final String COUNTER_INCREMENT = "counter-increment";
    public static final String COUNTER_RESET = "counter-reset";
    public static final String CSS_FLOAT = "css-float";
    public static final String CUE = "cue";
    public static final String CUE_AFTER = "cue-after";
    public static final String CUE_BEFORE = "cue-before";
    public static final String CURSOR = "cursor";
    public static final String DIRECTION = "direction";
    public static final String DISPLAY = "display";
    public static final String ELEVATION = "elevation";
    public static final String EMPTY_CELLS = "empty-cells";
    public static final String FONT = "font";
    public static final String FONT_FAMILY = "font-family";
    public static final String FONT_SIZE = "font-size";
    public static final String FONT_SIZE_ADJUST = "font-size-adjust";
    public static final String FONT_STRETCH = "font-stretch";
    public static final String FONT_STYLE = "font-style";
    public static final String FONT_VARIANT = "font-variant";
    public static final String FONT_WEIGHT = "font-weight";
    public static final String HEIGHT = "height";
    public static final String LEFT = "left";
    public static final String LETTER_SPACING = "letter-spacing";
    public static final String LINE_HEIGHT = "line-height";
    public static final String LIST_STYLE = "list-style";
    public static final String LIST_STYLE_IMAGE = "list-style-image";
    public static final String LIST_STYLE_POSITION = "list-style-position";
    public static final String LIST_STYLE_TYPE = "list-style-type";
    public static final String MARGIN = "margin";
    public static final String MARGIN_BOTTOM = "margin-bottom";
    public static final String MARGIN_LEFT = "margin-left";
    public static final String MARGIN_RIGHT = "margin-right";
    public static final String MARGIN_TOP = "margin-top";
    public static final String MARKER_OFFSET = "marker-offset";
    public static final String MARKS = "marks";
    public static final String MAX_HEIGHT = "max-height";
    public static final String MAX_WIDTH = "max-width";
    public static final String MIN_HEIGHT = "min-height";
    public static final String MIN_WIDTH = "min-width";
    public static final String ORPHANS = "orphans";
    public static final String OUTLINE = "outline";
    public static final String OUTLINE_COLOR = "outline-color";
    public static final String OUTLINE_STYLE = "outline-style";
    public static final String OUTLINE_WIDTH = "outline-width";
    public static final String OVERFLOW = "overflow";
    public static final String PADDING = "padding";
    public static final String PADDING_BOTTOM = "padding-bottom";
    public static final String PADDING_LEFT = "padding-left";
    public static final String PADDING_RIGHT = "padding-right";
    public static final String PADDING_TOP = "padding-top";
    public static final String PAGE = "page";
    public static final String PAGE_BREAK_AFTER = "page-break-after";
    public static final String PAGE_BREAK_BEFORE = "page-break-before";
    public static final String PAGE_BREAK_INSIDE = "page-break-inside";
    public static final String PAUSE = "pause";
    public static final String PAUSE_AFTER = "pause-after";
    public static final String PAUSE_BEFORE = "pause-before";
    public static final String PITCH = "pitch";
    public static final String PITCH_RANGE = "pitch-range";
    public static final String PLAY_DURING = "play-during";
    public static final String POSITION = "position";
    public static final String QUOTES = "quotes";
    public static final String RICHNESS = "richness";
    public static final String RIGHT = "right";
    public static final String SIZE = "size";
    public static final String SPEAK = "speak";
    public static final String SPEAK_HEADER = "speak-header";
    public static final String SPEAK_NUMERAL = "speak-numeral";
    public static final String SPEAK_PUNCTUATION = "speak-puctuation";
    public static final String SPEECH_RATE = "speech-rate";
    public static final String STRESS = "stress";
    public static final String TABLE_LAYOUT = "table-layout";
    public static final String TEXT_ALIGN = "text-align";
    public static final String TEXT_DECORATION = "text-decoration";
    public static final String TEXT_INDENT = "text-indent";
    public static final String TEXT_SHADOW = "text-shadow";
    public static final String TEXT_TRANSFORM = "text-transform";
    public static final String TOP = "top";
    public static final String UNICODE_BIDI = "unicode-bidi";
    public static final String VERTICAL_ALIGN = "vertical-align";
    public static final String VISIBILITY = "visibility";
    public static final String VOICE_FAMILY = "voice-family";
    public static final String VOLUME = "volume";
    public static final String WHITE_SPACE = "white-space";
    public static final String WIDOWS = "widows";
    public static final String WIDTH = "width";
    public static final String WORD_SPACING = "word_spacing";
    public static final String Z_INDEX = "z-index";
    private static final Map SUB_SETTERS = new HashMap(20);
    private final CSS2PropertiesContext context;
    private AbstractCSS2Properties localStyleProperties;
    private Collection styleDeclarations;
    private Map valueMap = null;
    private String overlayColor;

    public AbstractCSS2Properties(CSS2PropertiesContext cSS2PropertiesContext) {
        this.context = cSS2PropertiesContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStyleDeclaration(CSSStyleDeclaration cSSStyleDeclaration) {
        AbstractCSS2Properties abstractCSS2Properties = this;
        synchronized (abstractCSS2Properties) {
            LinkedList<CSSStyleDeclaration> linkedList = this.styleDeclarations;
            if (linkedList == null) {
                this.styleDeclarations = linkedList = new LinkedList<CSSStyleDeclaration>();
            }
            linkedList.add(cSSStyleDeclaration);
            int n = cSSStyleDeclaration.getLength();
            for (int i = 0; i < n; ++i) {
                String string = cSSStyleDeclaration.item(i);
                String string2 = cSSStyleDeclaration.getPropertyValue(string);
                String string3 = cSSStyleDeclaration.getPropertyPriority(string);
                boolean bl = string3 != null && string3.length() != 0 && "important".equals(string3);
                this.setPropertyValueProcessed(string.toLowerCase(), string2, cSSStyleDeclaration, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalStyleProperties(AbstractCSS2Properties abstractCSS2Properties) {
        if (abstractCSS2Properties == this) {
            throw new IllegalStateException("setting same");
        }
        AbstractCSS2Properties abstractCSS2Properties2 = this;
        synchronized (abstractCSS2Properties2) {
            this.localStyleProperties = abstractCSS2Properties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCSS2Properties getLocalStyleProperties() {
        AbstractCSS2Properties abstractCSS2Properties = this;
        synchronized (abstractCSS2Properties) {
            return this.localStyleProperties;
        }
    }

    public final String getPropertyValue(String string) {
        return this.getPropertyValueLC(string.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getPropertyValueLC(String string) {
        Map map = this.valueMap;
        AbstractCSS2Properties abstractCSS2Properties = this;
        synchronized (abstractCSS2Properties) {
            Object object;
            AbstractCSS2Properties abstractCSS2Properties2 = this.localStyleProperties;
            if (abstractCSS2Properties2 != null && (object = abstractCSS2Properties2.getPropertyValueLC(string)) != null) {
                return object;
            }
            if (map != null) {
                object = (Property)map.get(string);
                String string2 = object == null ? null : ((Property)object).value;
                return string2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPropertyValueLC(String string, String string2) {
        HashMap<String, Property> hashMap = this.valueMap;
        AbstractCSS2Properties abstractCSS2Properties = this;
        synchronized (abstractCSS2Properties) {
            if (hashMap == null) {
                this.valueMap = hashMap = new HashMap<String, Property>(1);
            }
            hashMap.put(string, new Property(string2, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setPropertyValueLCAlt(String string, String string2, boolean bl) {
        HashMap<String, Property> hashMap = this.valueMap;
        AbstractCSS2Properties abstractCSS2Properties = this;
        synchronized (abstractCSS2Properties) {
            Property property;
            if (hashMap == null) {
                this.valueMap = hashMap = new HashMap<String, Property>(1);
            } else if (!bl && (property = (Property)hashMap.get(string)) != null && property.important) {
                return;
            }
            hashMap.put(string, new Property(string2, bl));
        }
    }

    protected final void setPropertyValueProcessed(String string, String string2, CSSStyleDeclaration cSSStyleDeclaration, boolean bl) {
        SubPropertySetter subPropertySetter = (SubPropertySetter)SUB_SETTERS.get(string);
        if (subPropertySetter != null) {
            subPropertySetter.changeValue(this, string2, cSSStyleDeclaration, bl);
        } else {
            this.setPropertyValueLCAlt(string, string2, bl);
        }
    }

    public String getOverlayColor() {
        return this.overlayColor;
    }

    public void setOverlayColor(String string) {
        this.overlayColor = string;
        this.context.informLookInvalid();
    }

    public String getFloat() {
        return this.getPropertyValueLC(FLOAT);
    }

    public void setFloat(String string) {
        this.setPropertyValueLC(FLOAT, string);
    }

    public String getAzimuth() {
        return this.getPropertyValueLC(AZIMUTH);
    }

    public String getBackground() {
        return this.getPropertyValueLC(BACKGROUND);
    }

    public String getBackgroundAttachment() {
        return this.getPropertyValueLC(BACKGROUND_ATTACHMENT);
    }

    public String getBackgroundColor() {
        return this.getPropertyValueLC(BACKGROUND_COLOR);
    }

    public String getBackgroundImage() {
        return this.getPropertyValueLC(BACKGROUND_IMAGE);
    }

    public String getBackgroundPosition() {
        return this.getPropertyValueLC(BACKGROUND_POSITION);
    }

    public String getBackgroundRepeat() {
        return this.getPropertyValueLC(BACKGROUND_REPEAT);
    }

    public String getBorder() {
        return this.getPropertyValueLC(BORDER);
    }

    public String getBorderBottom() {
        return this.getPropertyValueLC(BORDER_BOTTOM);
    }

    public String getBorderBottomColor() {
        return this.getPropertyValueLC(BORDER_BOTTOM_COLOR);
    }

    public String getBorderBottomStyle() {
        return this.getPropertyValueLC(BORDER_BOTTOM_STYLE);
    }

    public String getBorderBottomWidth() {
        return this.getPropertyValueLC(BORDER_BOTTOM_WIDTH);
    }

    public String getBorderCollapse() {
        return this.getPropertyValueLC(BORDER_COLLAPSE);
    }

    public String getBorderColor() {
        return this.getPropertyValueLC(BORDER_COLOR);
    }

    public String getBorderLeft() {
        return this.getPropertyValueLC(BORDER_LEFT);
    }

    public String getBorderLeftColor() {
        return this.getPropertyValueLC(BORDER_LEFT_COLOR);
    }

    public String getBorderLeftStyle() {
        return this.getPropertyValueLC(BORDER_LEFT_STYLE);
    }

    public String getBorderLeftWidth() {
        return this.getPropertyValueLC(BORDER_LEFT_WIDTH);
    }

    public String getBorderRight() {
        return this.getPropertyValueLC(BORDER_RIGHT);
    }

    public String getBorderRightColor() {
        return this.getPropertyValueLC(BORDER_RIGHT_COLOR);
    }

    public String getBorderRightStyle() {
        return this.getPropertyValueLC(BORDER_RIGHT_STYLE);
    }

    public String getBorderRightWidth() {
        return this.getPropertyValueLC(BORDER_RIGHT_WIDTH);
    }

    public String getBorderSpacing() {
        return this.getPropertyValueLC(BORDER_SPACING);
    }

    public String getBorderStyle() {
        return this.getPropertyValueLC(BORDER_STYLE);
    }

    public String getBorderTop() {
        return this.getPropertyValueLC(BORDER_TOP);
    }

    public String getBorderTopColor() {
        return this.getPropertyValueLC(BORDER_TOP_COLOR);
    }

    public String getBorderTopStyle() {
        return this.getPropertyValueLC(BORDER_TOP_STYLE);
    }

    public String getBorderTopWidth() {
        return this.getPropertyValueLC(BORDER_TOP_WIDTH);
    }

    public String getBorderWidth() {
        return this.getPropertyValueLC(BORDER_WIDTH);
    }

    public String getBottom() {
        return this.getPropertyValueLC(BOTTOM);
    }

    public String getCaptionSide() {
        return this.getPropertyValueLC(CAPTION_SIDE);
    }

    public String getClear() {
        return this.getPropertyValueLC(CLEAR);
    }

    public String getClip() {
        return this.getPropertyValueLC(CLIP);
    }

    public String getColor() {
        return this.getPropertyValueLC(COLOR);
    }

    public String getContent() {
        return this.getPropertyValueLC(CONTENT);
    }

    public String getCounterIncrement() {
        return this.getPropertyValueLC(COUNTER_INCREMENT);
    }

    public String getCounterReset() {
        return this.getPropertyValueLC(COUNTER_RESET);
    }

    public String getCssFloat() {
        return this.getPropertyValueLC(CSS_FLOAT);
    }

    public String getCue() {
        return this.getPropertyValueLC(CUE);
    }

    public String getCueAfter() {
        return this.getPropertyValueLC(CUE_AFTER);
    }

    public String getCueBefore() {
        return this.getPropertyValueLC(CUE_BEFORE);
    }

    public String getCursor() {
        return this.getPropertyValueLC(CURSOR);
    }

    public String getDirection() {
        return this.getPropertyValueLC(DIRECTION);
    }

    public String getDisplay() {
        return this.getPropertyValueLC(DISPLAY);
    }

    public String getElevation() {
        return this.getPropertyValueLC(ELEVATION);
    }

    public String getEmptyCells() {
        return this.getPropertyValueLC(EMPTY_CELLS);
    }

    public String getFont() {
        return this.getPropertyValueLC(FONT);
    }

    public String getFontFamily() {
        return this.getPropertyValueLC(FONT_FAMILY);
    }

    public String getFontSize() {
        return this.getPropertyValueLC(FONT_SIZE);
    }

    public String getFontSizeAdjust() {
        return this.getPropertyValueLC(FONT_SIZE_ADJUST);
    }

    public String getFontStretch() {
        return this.getPropertyValueLC(FONT_STRETCH);
    }

    public String getFontStyle() {
        return this.getPropertyValueLC(FONT_STYLE);
    }

    public String getFontVariant() {
        return this.getPropertyValueLC(FONT_VARIANT);
    }

    public String getFontWeight() {
        return this.getPropertyValueLC(FONT_WEIGHT);
    }

    public String getHeight() {
        return this.getPropertyValueLC(HEIGHT);
    }

    public String getLeft() {
        return this.getPropertyValueLC(LEFT);
    }

    public String getLetterSpacing() {
        return this.getPropertyValueLC(LETTER_SPACING);
    }

    public String getLineHeight() {
        return this.getPropertyValueLC(LINE_HEIGHT);
    }

    public String getListStyle() {
        return this.getPropertyValueLC(LIST_STYLE);
    }

    public String getListStyleImage() {
        return this.getPropertyValueLC(LIST_STYLE_IMAGE);
    }

    public String getListStylePosition() {
        return this.getPropertyValueLC(LIST_STYLE_POSITION);
    }

    public String getListStyleType() {
        return this.getPropertyValueLC(LIST_STYLE_TYPE);
    }

    public String getMargin() {
        return this.getPropertyValueLC(MARGIN);
    }

    public String getMarginBottom() {
        return this.getPropertyValueLC(MARGIN_BOTTOM);
    }

    public String getMarginLeft() {
        return this.getPropertyValueLC(MARGIN_LEFT);
    }

    public String getMarginRight() {
        return this.getPropertyValueLC(MARGIN_RIGHT);
    }

    public String getMarginTop() {
        return this.getPropertyValueLC(MARGIN_TOP);
    }

    public String getMarkerOffset() {
        return this.getPropertyValueLC(MARKER_OFFSET);
    }

    public String getMarks() {
        return this.getPropertyValueLC(MARKS);
    }

    public String getMaxHeight() {
        return this.getPropertyValueLC(MAX_HEIGHT);
    }

    public String getMaxWidth() {
        return this.getPropertyValueLC(MAX_WIDTH);
    }

    public String getMinHeight() {
        return this.getPropertyValueLC(MIN_HEIGHT);
    }

    public String getMinWidth() {
        return this.getPropertyValueLC(MIN_WIDTH);
    }

    public String getOrphans() {
        return this.getPropertyValueLC(ORPHANS);
    }

    public String getOutline() {
        return this.getPropertyValueLC(OUTLINE);
    }

    public String getOutlineColor() {
        return this.getPropertyValueLC(OUTLINE_COLOR);
    }

    public String getOutlineStyle() {
        return this.getPropertyValueLC(OUTLINE_STYLE);
    }

    public String getOutlineWidth() {
        return this.getPropertyValueLC(OUTLINE_WIDTH);
    }

    public String getOverflow() {
        return this.getPropertyValueLC(OVERFLOW);
    }

    public String getPadding() {
        return this.getPropertyValueLC(PADDING);
    }

    public String getPaddingBottom() {
        return this.getPropertyValueLC(PADDING_BOTTOM);
    }

    public String getPaddingLeft() {
        return this.getPropertyValueLC(PADDING_LEFT);
    }

    public String getPaddingRight() {
        return this.getPropertyValueLC(PADDING_RIGHT);
    }

    public String getPaddingTop() {
        return this.getPropertyValueLC(PADDING_TOP);
    }

    public String getPage() {
        return this.getPropertyValueLC(PAGE);
    }

    public String getPageBreakAfter() {
        return this.getPropertyValueLC(PAGE_BREAK_AFTER);
    }

    public String getPageBreakBefore() {
        return this.getPropertyValueLC(PAGE_BREAK_BEFORE);
    }

    public String getPageBreakInside() {
        return this.getPropertyValueLC(PAGE_BREAK_INSIDE);
    }

    public String getPause() {
        return this.getPropertyValueLC(PAUSE);
    }

    public String getPauseAfter() {
        return this.getPropertyValueLC(PAUSE_AFTER);
    }

    public String getPauseBefore() {
        return this.getPropertyValueLC(PAUSE_BEFORE);
    }

    public String getPitch() {
        return this.getPropertyValueLC(PITCH);
    }

    public String getPitchRange() {
        return this.getPropertyValueLC(PITCH_RANGE);
    }

    public String getPlayDuring() {
        return this.getPropertyValueLC(PLAY_DURING);
    }

    public String getPosition() {
        return this.getPropertyValueLC(POSITION);
    }

    public String getQuotes() {
        return this.getPropertyValueLC(QUOTES);
    }

    public String getRichness() {
        return this.getPropertyValueLC(RICHNESS);
    }

    public String getRight() {
        return this.getPropertyValueLC(RIGHT);
    }

    public String getSize() {
        return this.getPropertyValueLC(SIZE);
    }

    public String getSpeak() {
        return this.getPropertyValueLC(SPEAK);
    }

    public String getSpeakHeader() {
        return this.getPropertyValueLC(SPEAK_HEADER);
    }

    public String getSpeakNumeral() {
        return this.getPropertyValueLC(SPEAK_NUMERAL);
    }

    public String getSpeakPunctuation() {
        return this.getPropertyValueLC(SPEAK_PUNCTUATION);
    }

    public String getSpeechRate() {
        return this.getPropertyValueLC(SPEECH_RATE);
    }

    public String getStress() {
        return this.getPropertyValueLC(STRESS);
    }

    public String getTableLayout() {
        return this.getPropertyValueLC(TABLE_LAYOUT);
    }

    public String getTextAlign() {
        return this.getPropertyValueLC(TEXT_ALIGN);
    }

    public String getTextDecoration() {
        return this.getPropertyValueLC(TEXT_DECORATION);
    }

    public String getTextIndent() {
        return this.getPropertyValueLC(TEXT_INDENT);
    }

    public String getTextShadow() {
        return this.getPropertyValueLC(TEXT_SHADOW);
    }

    public String getTextTransform() {
        return this.getPropertyValueLC(TEXT_TRANSFORM);
    }

    public String getTop() {
        return this.getPropertyValueLC(TOP);
    }

    public String getUnicodeBidi() {
        return this.getPropertyValueLC(UNICODE_BIDI);
    }

    public String getVerticalAlign() {
        return this.getPropertyValueLC(VERTICAL_ALIGN);
    }

    public String getVisibility() {
        return this.getPropertyValueLC(VISIBILITY);
    }

    public String getVoiceFamily() {
        return this.getPropertyValueLC(VOICE_FAMILY);
    }

    public String getVolume() {
        return this.getPropertyValueLC(VOLUME);
    }

    public String getWhiteSpace() {
        return this.getPropertyValueLC(WHITE_SPACE);
    }

    public String getWidows() {
        return this.getPropertyValueLC(WIDOWS);
    }

    public String getWidth() {
        return this.getPropertyValueLC(WIDTH);
    }

    public String getWordSpacing() {
        return this.getPropertyValueLC(WORD_SPACING);
    }

    public String getZIndex() {
        return this.getPropertyValueLC(Z_INDEX);
    }

    public void setAzimuth(String string) throws DOMException {
        this.setPropertyValueLC(AZIMUTH, string);
    }

    public void setBackground(String string) throws DOMException {
        this.checkSetProperty();
        new BackgroundSetter().changeValue(this, string, null);
        this.context.informLookInvalid();
    }

    public void setBackgroundAttachment(String string) throws DOMException {
        this.setPropertyValueLC(BACKGROUND_ATTACHMENT, string);
        this.context.informLookInvalid();
    }

    public void setBackgroundColor(String string) throws DOMException {
        this.setPropertyValueLC(BACKGROUND_COLOR, string);
        this.context.informLookInvalid();
    }

    public void setBackgroundImage(String string) throws DOMException {
        this.checkSetProperty();
        new BackgroundImageSetter().changeValue(this, string, null);
        this.context.informLookInvalid();
    }

    public void setBackgroundPosition(String string) throws DOMException {
        this.setPropertyValueLC(BACKGROUND_POSITION, string);
        this.context.informLookInvalid();
    }

    public void setBackgroundRepeat(String string) throws DOMException {
        this.setPropertyValueLC(BACKGROUND_REPEAT, string);
        this.context.informLookInvalid();
    }

    public void setBorder(String string) throws DOMException {
        this.checkSetProperty();
        new BorderSetter1().changeValue(this, string, null);
        this.context.informInvalid();
    }

    public void setBorderBottom(String string) throws DOMException {
        this.checkSetProperty();
        new BorderSetter2(BORDER_BOTTOM).changeValue(this, string, null);
        this.context.informInvalid();
    }

    public void setBorderBottomColor(String string) throws DOMException {
        this.setPropertyValueLC(BORDER_BOTTOM_COLOR, string);
        this.context.informLookInvalid();
    }

    public void setBorderBottomStyle(String string) throws DOMException {
        this.setPropertyValueLC(BORDER_BOTTOM_STYLE, string);
        this.context.informLookInvalid();
    }

    public void setBorderBottomWidth(String string) throws DOMException {
        this.setPropertyValueLC(BORDER_BOTTOM_WIDTH, string);
        this.context.informInvalid();
    }

    public void setBorderCollapse(String string) throws DOMException {
        this.setPropertyValueLC(BORDER_COLLAPSE, string);
        this.context.informInvalid();
    }

    public void setBorderColor(String string) throws DOMException {
        this.checkSetProperty();
        new FourCornersSetter(BORDER_COLOR, "border-", "-color").changeValue(this, string, null);
        this.context.informLookInvalid();
    }

    public void setBorderLeft(String string) throws DOMException {
        this.checkSetProperty();
        new BorderSetter2(BORDER_LEFT).changeValue(this, string, null);
        this.context.informInvalid();
    }

    public void setBorderLeftColor(String string) throws DOMException {
        this.setPropertyValueLC(BORDER_LEFT_COLOR, string);
        this.context.informLookInvalid();
    }

    public void setBorderLeftStyle(String string) throws DOMException {
        this.setPropertyValueLC(BORDER_LEFT_STYLE, string);
        this.context.informLookInvalid();
    }

    public void setBorderLeftWidth(String string) throws DOMException {
        this.setPropertyValueLC(BORDER_LEFT_WIDTH, string);
        this.context.informInvalid();
    }

    public void setBorderRight(String string) throws DOMException {
        this.checkSetProperty();
        new BorderSetter2(BORDER_RIGHT).changeValue(this, string, null);
        this.context.informInvalid();
    }

    public void setBorderRightColor(String string) throws DOMException {
        this.setPropertyValueLC(BORDER_RIGHT_COLOR, string);
        this.context.informLookInvalid();
    }

    public void setBorderRightStyle(String string) throws DOMException {
        this.setPropertyValueLC(BORDER_RIGHT_STYLE, string);
        this.context.informLookInvalid();
    }

    public void setBorderRightWidth(String string) throws DOMException {
        this.setPropertyValueLC(BORDER_RIGHT_WIDTH, string);
        this.context.informInvalid();
    }

    public void setBorderSpacing(String string) throws DOMException {
        this.setPropertyValueLC(BORDER_SPACING, string);
        this.context.informInvalid();
    }

    public void setBorderStyle(String string) throws DOMException {
        this.checkSetProperty();
        new FourCornersSetter(BORDER_STYLE, "border-", "-style").changeValue(this, string, null);
        this.context.informLookInvalid();
    }

    public void setBorderTop(String string) throws DOMException {
        this.checkSetProperty();
        new BorderSetter2(BORDER_TOP).changeValue(this, string, null);
        this.context.informInvalid();
    }

    public void setBorderTopColor(String string) throws DOMException {
        this.setPropertyValueLC(BORDER_TOP_COLOR, string);
        this.context.informLookInvalid();
    }

    public void setBorderTopStyle(String string) throws DOMException {
        this.setPropertyValueLC(BORDER_TOP_STYLE, string);
        this.context.informLookInvalid();
    }

    public void setBorderTopWidth(String string) throws DOMException {
        this.setPropertyValueLC(BORDER_TOP_WIDTH, string);
        this.context.informInvalid();
    }

    public void setBorderWidth(String string) throws DOMException {
        this.checkSetProperty();
        new FourCornersSetter(BORDER_WIDTH, "border-", "-width").changeValue(this, string, null);
        this.context.informInvalid();
    }

    public void setBottom(String string) throws DOMException {
        this.setPropertyValueLC(BOTTOM, string);
        this.context.informPositionInvalid();
    }

    public void setCaptionSide(String string) throws DOMException {
        this.setPropertyValueLC(CAPTION_SIDE, string);
    }

    public void setClear(String string) throws DOMException {
        this.setPropertyValueLC(CLEAR, string);
        this.context.informInvalid();
    }

    public void setClip(String string) throws DOMException {
        this.setPropertyValueLC(CLIP, string);
    }

    public void setColor(String string) throws DOMException {
        this.setPropertyValueLC(COLOR, string);
        this.context.informLookInvalid();
    }

    public void setContent(String string) throws DOMException {
        this.setPropertyValueLC(CONTENT, string);
        this.context.informInvalid();
    }

    public void setCounterIncrement(String string) throws DOMException {
        this.setPropertyValueLC(COUNTER_INCREMENT, string);
        this.context.informLookInvalid();
    }

    public void setCounterReset(String string) throws DOMException {
        this.setPropertyValueLC(COUNTER_RESET, string);
        this.context.informLookInvalid();
    }

    public void setCssFloat(String string) throws DOMException {
        this.setPropertyValueLC(CSS_FLOAT, string);
        this.context.informInvalid();
    }

    public void setCue(String string) throws DOMException {
        this.setPropertyValueLC(CUE, string);
    }

    public void setCueAfter(String string) throws DOMException {
        this.setPropertyValueLC(CUE_AFTER, string);
    }

    public void setCueBefore(String string) throws DOMException {
        this.setPropertyValueLC(CUE_BEFORE, string);
    }

    public void setCursor(String string) throws DOMException {
        this.setPropertyValueLC(CURSOR, string);
        this.context.informLookInvalid();
    }

    public void setDirection(String string) throws DOMException {
        this.setPropertyValueLC(DIRECTION, string);
        this.context.informInvalid();
    }

    public void setDisplay(String string) throws DOMException {
        this.setPropertyValueLC(DISPLAY, string);
        this.context.informInvalid();
    }

    public void setElevation(String string) throws DOMException {
        this.setPropertyValueLC(ELEVATION, string);
        this.context.informInvalid();
    }

    public void setEmptyCells(String string) throws DOMException {
        this.setPropertyValueLC(EMPTY_CELLS, string);
    }

    public void setFont(String string) throws DOMException {
        this.checkSetProperty();
        new FontSetter().changeValue(this, string, null);
        this.context.informInvalid();
    }

    public void setFontFamily(String string) throws DOMException {
        this.setPropertyValueLC(FONT_FAMILY, string);
        this.context.informInvalid();
    }

    public void setFontSize(String string) throws DOMException {
        this.setPropertyValueLC(FONT_SIZE, string);
        this.context.informInvalid();
    }

    public void setFontSizeAdjust(String string) throws DOMException {
        this.setPropertyValueLC(FONT_SIZE_ADJUST, string);
        this.context.informInvalid();
    }

    public void setFontStretch(String string) throws DOMException {
        this.setPropertyValueLC(FONT_STRETCH, string);
        this.context.informInvalid();
    }

    public void setFontStyle(String string) throws DOMException {
        this.setPropertyValueLC(FONT_STYLE, string);
        this.context.informInvalid();
    }

    public void setFontVariant(String string) throws DOMException {
        this.setPropertyValueLC(FONT_VARIANT, string);
        this.context.informInvalid();
    }

    public void setFontWeight(String string) throws DOMException {
        this.setPropertyValueLC(FONT_WEIGHT, string);
        this.context.informInvalid();
    }

    public void setHeight(String string) throws DOMException {
        this.setPropertyValueLC(HEIGHT, string);
        this.context.informSizeInvalid();
    }

    public void setLeft(String string) throws DOMException {
        this.setPropertyValueLC(LEFT, string);
        this.context.informPositionInvalid();
    }

    public void setLetterSpacing(String string) throws DOMException {
        this.setPropertyValueLC(LETTER_SPACING, string);
        this.context.informInvalid();
    }

    public void setLineHeight(String string) throws DOMException {
        this.setPropertyValueLC(LINE_HEIGHT, string);
        this.context.informInvalid();
    }

    public void setListStyle(String string) throws DOMException {
        this.setPropertyValueLC(LIST_STYLE, string);
        this.context.informInvalid();
    }

    public void setListStyleImage(String string) throws DOMException {
        this.setPropertyValueLC(LIST_STYLE_IMAGE, string);
        this.context.informLookInvalid();
    }

    public void setListStylePosition(String string) throws DOMException {
        this.setPropertyValueLC(LIST_STYLE_POSITION, string);
        this.context.informInvalid();
    }

    public void setListStyleType(String string) throws DOMException {
        this.setPropertyValueLC(LIST_STYLE_TYPE, string);
        this.context.informLookInvalid();
    }

    public void setMargin(String string) throws DOMException {
        this.checkSetProperty();
        new FourCornersSetter(MARGIN, "margin-", "").changeValue(this, string, null);
        this.context.informInvalid();
    }

    public void setMarginBottom(String string) throws DOMException {
        this.setPropertyValueLC(MARGIN_BOTTOM, string);
        this.context.informInvalid();
    }

    public void setMarginLeft(String string) throws DOMException {
        this.setPropertyValueLC(MARGIN_LEFT, string);
        this.context.informInvalid();
    }

    public void setMarginRight(String string) throws DOMException {
        this.setPropertyValueLC(MARGIN_RIGHT, string);
        this.context.informInvalid();
    }

    public void setMarginTop(String string) throws DOMException {
        this.setPropertyValueLC(MARGIN_TOP, string);
        this.context.informInvalid();
    }

    public void setMarkerOffset(String string) throws DOMException {
        this.setPropertyValueLC(MARKER_OFFSET, string);
    }

    public void setMarks(String string) throws DOMException {
        this.setPropertyValueLC(MARKS, string);
    }

    public void setMaxHeight(String string) throws DOMException {
        this.setPropertyValueLC(MAX_HEIGHT, string);
        this.context.informSizeInvalid();
    }

    public void setMaxWidth(String string) throws DOMException {
        this.setPropertyValueLC(MAX_WIDTH, string);
        this.context.informSizeInvalid();
    }

    public void setMinHeight(String string) throws DOMException {
        this.setPropertyValueLC(MIN_HEIGHT, string);
        this.context.informSizeInvalid();
    }

    public void setMinWidth(String string) throws DOMException {
        this.setPropertyValueLC(MIN_WIDTH, string);
        this.context.informSizeInvalid();
    }

    public void setOrphans(String string) throws DOMException {
        this.setPropertyValueLC(ORPHANS, string);
    }

    public void setOutline(String string) throws DOMException {
        this.setPropertyValueLC(OUTLINE, string);
        this.context.informInvalid();
    }

    public void setOutlineColor(String string) throws DOMException {
        this.setPropertyValueLC(OUTLINE_COLOR, string);
        this.context.informLookInvalid();
    }

    public void setOutlineStyle(String string) throws DOMException {
        this.setPropertyValueLC(OUTLINE_STYLE, string);
        this.context.informLookInvalid();
    }

    public void setOutlineWidth(String string) throws DOMException {
        this.setPropertyValueLC(OUTLINE_WIDTH, string);
        this.context.informInvalid();
    }

    public void setOverflow(String string) throws DOMException {
        this.setPropertyValueLC(OVERFLOW, string);
        this.context.informInvalid();
    }

    public void setPadding(String string) throws DOMException {
        this.checkSetProperty();
        new FourCornersSetter(PADDING, "padding-", "").changeValue(this, string, null);
        this.context.informInvalid();
    }

    public void setPaddingBottom(String string) throws DOMException {
        this.setPropertyValueLC(PADDING_BOTTOM, string);
        this.context.informInvalid();
    }

    public void setPaddingLeft(String string) throws DOMException {
        this.setPropertyValueLC(PADDING_LEFT, string);
        this.context.informInvalid();
    }

    public void setPaddingRight(String string) throws DOMException {
        this.setPropertyValueLC(PADDING_RIGHT, string);
        this.context.informInvalid();
    }

    public void setPaddingTop(String string) throws DOMException {
        this.setPropertyValueLC(PADDING_TOP, string);
        this.context.informInvalid();
    }

    public void setPage(String string) throws DOMException {
        this.setPropertyValueLC(PAGE, string);
    }

    public void setPageBreakAfter(String string) throws DOMException {
        this.setPropertyValueLC(PAGE_BREAK_AFTER, string);
        this.context.informInvalid();
    }

    public void setPageBreakBefore(String string) throws DOMException {
        this.setPropertyValueLC(PAGE_BREAK_BEFORE, string);
        this.context.informInvalid();
    }

    public void setPageBreakInside(String string) throws DOMException {
        this.setPropertyValueLC(PAGE_BREAK_INSIDE, string);
        this.context.informInvalid();
    }

    public void setPause(String string) throws DOMException {
        this.setPropertyValueLC(PAUSE, string);
    }

    public void setPauseAfter(String string) throws DOMException {
        this.setPropertyValueLC(PAUSE_AFTER, string);
    }

    public void setPauseBefore(String string) throws DOMException {
        this.setPropertyValueLC(PAUSE_BEFORE, string);
    }

    public void setPitch(String string) throws DOMException {
        this.setPropertyValueLC(PITCH, string);
    }

    public void setPitchRange(String string) throws DOMException {
        this.setPropertyValueLC(PITCH_RANGE, string);
    }

    public void setPlayDuring(String string) throws DOMException {
        this.setPropertyValueLC(PLAY_DURING, string);
    }

    public void setPosition(String string) throws DOMException {
        this.setPropertyValueLC(POSITION, string);
        this.context.informPositionInvalid();
    }

    public void setQuotes(String string) throws DOMException {
        this.setPropertyValueLC(QUOTES, string);
    }

    public void setRichness(String string) throws DOMException {
        this.setPropertyValueLC(RICHNESS, string);
    }

    public void setRight(String string) throws DOMException {
        this.setPropertyValueLC(RIGHT, string);
        this.context.informPositionInvalid();
    }

    public void setSize(String string) throws DOMException {
        this.setPropertyValueLC(SIZE, string);
        this.context.informInvalid();
    }

    public void setSpeak(String string) throws DOMException {
        this.setPropertyValueLC(SPEAK, string);
    }

    public void setSpeakHeader(String string) throws DOMException {
        this.setPropertyValueLC(SPEAK_HEADER, string);
    }

    public void setSpeakNumeral(String string) throws DOMException {
        this.setPropertyValueLC(SPEAK_NUMERAL, string);
    }

    public void setSpeakPunctuation(String string) throws DOMException {
        this.setPropertyValueLC(SPEAK_PUNCTUATION, string);
    }

    public void setSpeechRate(String string) throws DOMException {
        this.setPropertyValueLC(SPEECH_RATE, string);
    }

    public void setStress(String string) throws DOMException {
        this.setPropertyValueLC(STRESS, string);
    }

    public void setTableLayout(String string) throws DOMException {
        this.setPropertyValueLC(TABLE_LAYOUT, string);
        this.context.informInvalid();
    }

    public void setTextAlign(String string) throws DOMException {
        this.setPropertyValueLC(TEXT_ALIGN, string);
        this.context.informLayoutInvalid();
    }

    public void setTextDecoration(String string) throws DOMException {
        this.setPropertyValueLC(TEXT_DECORATION, string);
        this.context.informLookInvalid();
    }

    public void setTextIndent(String string) throws DOMException {
        this.setPropertyValueLC(TEXT_INDENT, string);
        this.context.informLayoutInvalid();
    }

    public void setTextShadow(String string) throws DOMException {
        this.setPropertyValueLC(TEXT_SHADOW, string);
        this.context.informLookInvalid();
    }

    public void setTextTransform(String string) throws DOMException {
        this.setPropertyValueLC(TEXT_TRANSFORM, string);
        this.context.informInvalid();
    }

    public void setTop(String string) throws DOMException {
        this.setPropertyValueLC(TOP, string);
        this.context.informPositionInvalid();
    }

    public void setUnicodeBidi(String string) throws DOMException {
        this.setPropertyValueLC(UNICODE_BIDI, string);
        this.context.informInvalid();
    }

    public void setVerticalAlign(String string) throws DOMException {
        this.setPropertyValueLC(VERTICAL_ALIGN, string);
        this.context.informInvalid();
    }

    public void setVisibility(String string) throws DOMException {
        this.setPropertyValueLC(VISIBILITY, string);
        this.context.informLookInvalid();
    }

    public void setVoiceFamily(String string) throws DOMException {
        this.setPropertyValueLC(VOICE_FAMILY, string);
    }

    public void setVolume(String string) throws DOMException {
        this.setPropertyValueLC(VOLUME, string);
    }

    public void setWhiteSpace(String string) throws DOMException {
        this.setPropertyValueLC(WHITE_SPACE, string);
        this.context.informInvalid();
    }

    public void setWidows(String string) throws DOMException {
        this.setPropertyValueLC(WIDOWS, string);
    }

    public void setWidth(String string) throws DOMException {
        this.setPropertyValueLC(WIDTH, string);
        this.context.informSizeInvalid();
    }

    public void setWordSpacing(String string) throws DOMException {
        this.setPropertyValueLC(WORD_SPACING, string);
        this.context.informInvalid();
    }

    public void setZIndex(String string) throws DOMException {
        this.setPropertyValueLC(Z_INDEX, string);
        this.context.informPositionInvalid();
    }

    protected void checkSetProperty() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int n;
        AbstractCSS2Properties abstractCSS2Properties = this;
        synchronized (abstractCSS2Properties) {
            Map map = this.valueMap;
            n = map == null ? 0 : map.size();
        }
        return this.getClass().getSimpleName() + "[size=" + n + "]";
    }

    static {
        Map map = SUB_SETTERS;
        map.put(MARGIN, new FourCornersSetter(MARGIN, "margin-", ""));
        map.put(PADDING, new FourCornersSetter(PADDING, "padding-", ""));
        map.put(BORDER, new BorderSetter1());
        map.put(BORDER_TOP, new BorderSetter2(BORDER_TOP));
        map.put(BORDER_LEFT, new BorderSetter2(BORDER_LEFT));
        map.put(BORDER_BOTTOM, new BorderSetter2(BORDER_BOTTOM));
        map.put(BORDER_RIGHT, new BorderSetter2(BORDER_RIGHT));
        map.put(BORDER_COLOR, new FourCornersSetter(BORDER_COLOR, "border-", "-color"));
        map.put(BORDER_STYLE, new FourCornersSetter(BORDER_STYLE, "border-", "-style"));
        map.put(BORDER_WIDTH, new FourCornersSetter(BORDER_WIDTH, "border-", "-width"));
        map.put(BACKGROUND, new BackgroundSetter());
        map.put(BACKGROUND_IMAGE, new BackgroundImageSetter());
        map.put(FONT, new FontSetter());
    }

    private static class Property {
        public final String value;
        public final boolean important;

        public Property(String string, boolean bl) {
            this.value = string;
            this.important = bl;
        }
    }

    private static class FontSetter
    implements SubPropertySetter {
        private FontSetter() {
        }

        public void changeValue(AbstractCSS2Properties abstractCSS2Properties, String string, CSSStyleDeclaration cSSStyleDeclaration) {
            this.changeValue(abstractCSS2Properties, string, cSSStyleDeclaration, true);
        }

        public void changeValue(AbstractCSS2Properties abstractCSS2Properties, String string, CSSStyleDeclaration cSSStyleDeclaration, boolean bl) {
            abstractCSS2Properties.setPropertyValueLCAlt(AbstractCSS2Properties.FONT, string, bl);
            if (string != null && string.length() > 0) {
                int n;
                String string2 = string.toLowerCase();
                FontInfo fontInfo = (FontInfo)HtmlValues.SYSTEM_FONTS.get(string2);
                if (fontInfo != null) {
                    if (fontInfo.fontFamily != null) {
                        abstractCSS2Properties.setPropertyValueLCAlt(AbstractCSS2Properties.FONT_FAMILY, fontInfo.fontFamily, bl);
                    }
                    if (fontInfo.fontSize != null) {
                        abstractCSS2Properties.setPropertyValueLCAlt(AbstractCSS2Properties.FONT_SIZE, fontInfo.fontSize, bl);
                    }
                    if (fontInfo.fontStyle != null) {
                        abstractCSS2Properties.setPropertyValueLCAlt(AbstractCSS2Properties.FONT_STYLE, fontInfo.fontStyle, bl);
                    }
                    if (fontInfo.fontVariant != null) {
                        abstractCSS2Properties.setPropertyValueLCAlt(AbstractCSS2Properties.FONT_VARIANT, fontInfo.fontVariant, bl);
                    }
                    if (fontInfo.fontWeight != null) {
                        abstractCSS2Properties.setPropertyValueLCAlt(AbstractCSS2Properties.FONT_WEIGHT, fontInfo.fontWeight, bl);
                    }
                    return;
                }
                String[] stringArray = HtmlValues.splitCssValue(string2);
                String string3 = null;
                int n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    string3 = stringArray[n];
                    if (HtmlValues.isFontStyle(string3)) {
                        abstractCSS2Properties.setPropertyValueLCAlt(AbstractCSS2Properties.FONT_STYLE, string3, bl);
                        continue;
                    }
                    if (HtmlValues.isFontVariant(string3)) {
                        abstractCSS2Properties.setPropertyValueLCAlt(AbstractCSS2Properties.FONT_VARIANT, string3, bl);
                        continue;
                    }
                    if (!HtmlValues.isFontWeight(string3)) break;
                    abstractCSS2Properties.setPropertyValueLCAlt(AbstractCSS2Properties.FONT_WEIGHT, string3, bl);
                }
                if (string3 != null) {
                    String string4;
                    int n3 = string3.indexOf(47);
                    String string5 = n3 == -1 ? string3 : string3.substring(0, n3);
                    abstractCSS2Properties.setPropertyValueLCAlt(AbstractCSS2Properties.FONT_SIZE, string5, bl);
                    String string6 = string4 = n3 == -1 ? null : string3.substring(n3 + 1);
                    if (string4 != null) {
                        abstractCSS2Properties.setPropertyValueLCAlt(AbstractCSS2Properties.LINE_HEIGHT, string4, bl);
                    }
                    if (++n < n2) {
                        StringBuffer stringBuffer = new StringBuffer();
                        do {
                            string3 = stringArray[n];
                            stringBuffer.append(string3);
                            stringBuffer.append(' ');
                        } while (++n < n2);
                        abstractCSS2Properties.setPropertyValueLCAlt(AbstractCSS2Properties.FONT_FAMILY, stringBuffer.toString(), bl);
                    }
                }
            }
        }
    }

    private static class BackgroundSetter
    implements SubPropertySetter {
        private BackgroundSetter() {
        }

        public void changeValue(AbstractCSS2Properties abstractCSS2Properties, String string, CSSStyleDeclaration cSSStyleDeclaration) {
            this.changeValue(abstractCSS2Properties, string, cSSStyleDeclaration, true);
        }

        public void changeValue(AbstractCSS2Properties abstractCSS2Properties, String string, CSSStyleDeclaration cSSStyleDeclaration, boolean bl) {
            abstractCSS2Properties.setPropertyValueLCAlt(AbstractCSS2Properties.BACKGROUND, string, bl);
            if (string != null && string.length() > 0) {
                String[] stringArray = HtmlValues.splitCssValue(string);
                boolean bl2 = false;
                boolean bl3 = false;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string6 = stringArray[i];
                    if (ColorFactory.getInstance().isColor(string6)) {
                        string2 = string6;
                        continue;
                    }
                    if (HtmlValues.isUrl(string6)) {
                        string3 = string6;
                        continue;
                    }
                    if (HtmlValues.isBackgroundRepeat(string6)) {
                        string4 = string6;
                        continue;
                    }
                    if (!HtmlValues.isBackgroundPosition(string6)) continue;
                    if (bl2 && !bl3) {
                        string5 = string5 + " " + string6;
                        bl3 = true;
                        continue;
                    }
                    bl2 = true;
                    string5 = string6;
                }
                if (string2 != null) {
                    abstractCSS2Properties.setPropertyValueLCAlt(AbstractCSS2Properties.BACKGROUND_COLOR, string2, bl);
                }
                if (string3 != null) {
                    abstractCSS2Properties.setPropertyValueProcessed(AbstractCSS2Properties.BACKGROUND_IMAGE, string3, cSSStyleDeclaration, bl);
                }
                if (string4 != null) {
                    abstractCSS2Properties.setPropertyValueLCAlt(AbstractCSS2Properties.BACKGROUND_REPEAT, string4, bl);
                }
                if (string5 != null) {
                    abstractCSS2Properties.setPropertyValueLCAlt(AbstractCSS2Properties.BACKGROUND_POSITION, string5, bl);
                }
            }
        }
    }

    private static class BackgroundImageSetter
    implements SubPropertySetter {
        private BackgroundImageSetter() {
        }

        public void changeValue(AbstractCSS2Properties abstractCSS2Properties, String string, CSSStyleDeclaration cSSStyleDeclaration) {
            this.changeValue(abstractCSS2Properties, string, cSSStyleDeclaration, true);
        }

        public void changeValue(AbstractCSS2Properties abstractCSS2Properties, String string, CSSStyleDeclaration cSSStyleDeclaration, boolean bl) {
            String string2;
            CSSStyleSheet cSSStyleSheet;
            Object object;
            String string3 = null;
            if (cSSStyleDeclaration != null && (object = cSSStyleDeclaration.getParentRule()) != null && (cSSStyleSheet = object.getParentStyleSheet()) instanceof CSSStyleSheetImpl) {
                CSSStyleSheetImpl cSSStyleSheetImpl = (CSSStyleSheetImpl)cSSStyleSheet;
                string3 = cSSStyleSheetImpl.getHref();
            }
            if (string3 == null) {
                string3 = abstractCSS2Properties.context.getDocumentBaseURI();
            }
            object = "url(";
            if (string == null || !string.toLowerCase().startsWith((String)object)) {
                string2 = string;
            } else {
                int n = ((String)object).length();
                int n2 = string.lastIndexOf(41);
                if (n2 == -1) {
                    string2 = string;
                } else {
                    String string4 = string.substring(n, n2);
                    String string5 = HtmlValues.unquoteAndUnescape(string4);
                    if (string3 == null) {
                        string2 = string;
                    } else {
                        try {
                            URL uRL = Urls.createURL(null, string3);
                            string2 = "url(" + HtmlValues.quoteAndEscape(Urls.createURL(uRL, string5).toExternalForm()) + ")";
                        }
                        catch (MalformedURLException malformedURLException) {
                            logger.log(Level.WARNING, "Unable to create URL for URI=[" + string5 + "], with base=[" + string3 + "].", malformedURLException);
                            string2 = string;
                        }
                    }
                }
            }
            abstractCSS2Properties.setPropertyValueLCAlt(AbstractCSS2Properties.BACKGROUND_IMAGE, string2, bl);
        }
    }

    private static class FourCornersSetter
    implements SubPropertySetter {
        private final String prefix;
        private final String suffix;
        private final String property;

        public FourCornersSetter(String string, String string2, String string3) {
            this.prefix = string2;
            this.suffix = string3;
            this.property = string;
        }

        public void changeValue(AbstractCSS2Properties abstractCSS2Properties, String string, CSSStyleDeclaration cSSStyleDeclaration) {
            this.changeValue(abstractCSS2Properties, string, cSSStyleDeclaration, true);
        }

        public void changeValue(AbstractCSS2Properties abstractCSS2Properties, String string, CSSStyleDeclaration cSSStyleDeclaration, boolean bl) {
            abstractCSS2Properties.setPropertyValueLCAlt(this.property, string, bl);
            if (string != null && string.length() > 0) {
                String[] stringArray = HtmlValues.splitCssValue(string);
                int n = stringArray.length;
                if (n == 1) {
                    String string2 = this.prefix;
                    String string3 = this.suffix;
                    String string4 = stringArray[0];
                    abstractCSS2Properties.setPropertyValueLCAlt(string2 + AbstractCSS2Properties.TOP + string3, string4, bl);
                    abstractCSS2Properties.setPropertyValueLCAlt(string2 + AbstractCSS2Properties.RIGHT + string3, string4, bl);
                    abstractCSS2Properties.setPropertyValueLCAlt(string2 + AbstractCSS2Properties.BOTTOM + string3, string4, bl);
                    abstractCSS2Properties.setPropertyValueLCAlt(string2 + AbstractCSS2Properties.LEFT + string3, string4, bl);
                } else if (n >= 4) {
                    String string5 = this.prefix;
                    String string6 = this.suffix;
                    abstractCSS2Properties.setPropertyValueLCAlt(string5 + AbstractCSS2Properties.TOP + string6, stringArray[0], bl);
                    abstractCSS2Properties.setPropertyValueLCAlt(string5 + AbstractCSS2Properties.RIGHT + string6, stringArray[1], bl);
                    abstractCSS2Properties.setPropertyValueLCAlt(string5 + AbstractCSS2Properties.BOTTOM + string6, stringArray[2], bl);
                    abstractCSS2Properties.setPropertyValueLCAlt(string5 + AbstractCSS2Properties.LEFT + string6, stringArray[3], bl);
                } else if (n == 2) {
                    String string7 = this.prefix;
                    String string8 = this.suffix;
                    abstractCSS2Properties.setPropertyValueLCAlt(string7 + AbstractCSS2Properties.TOP + string8, stringArray[0], bl);
                    abstractCSS2Properties.setPropertyValueLCAlt(string7 + AbstractCSS2Properties.RIGHT + string8, stringArray[1], bl);
                    abstractCSS2Properties.setPropertyValueLCAlt(string7 + AbstractCSS2Properties.BOTTOM + string8, stringArray[0], bl);
                    abstractCSS2Properties.setPropertyValueLCAlt(string7 + AbstractCSS2Properties.LEFT + string8, stringArray[1], bl);
                } else if (n == 3) {
                    String string9 = this.prefix;
                    String string10 = this.suffix;
                    abstractCSS2Properties.setPropertyValueLCAlt(string9 + AbstractCSS2Properties.TOP + string10, stringArray[0], bl);
                    abstractCSS2Properties.setPropertyValueLCAlt(string9 + AbstractCSS2Properties.RIGHT + string10, stringArray[1], bl);
                    abstractCSS2Properties.setPropertyValueLCAlt(string9 + AbstractCSS2Properties.BOTTOM + string10, stringArray[2], bl);
                    abstractCSS2Properties.setPropertyValueLCAlt(string9 + AbstractCSS2Properties.LEFT + string10, stringArray[1], bl);
                }
            }
        }
    }

    private static class BorderSetter2
    implements SubPropertySetter {
        private final String name;

        public BorderSetter2(String string) {
            this.name = string;
        }

        public void changeValue(AbstractCSS2Properties abstractCSS2Properties, String string, CSSStyleDeclaration cSSStyleDeclaration) {
            this.changeValue(abstractCSS2Properties, string, cSSStyleDeclaration, true);
        }

        public void changeValue(AbstractCSS2Properties abstractCSS2Properties, String string, CSSStyleDeclaration cSSStyleDeclaration, boolean bl) {
            abstractCSS2Properties.setPropertyValueLCAlt(this.name, string, bl);
            if (string != null && string.length() > 0) {
                String[] stringArray = HtmlValues.splitCssValue(string);
                String string2 = null;
                String string3 = null;
                String string4 = null;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string5 = stringArray[i];
                    if (HtmlValues.isBorderStyle(string5)) {
                        string3 = string5;
                        continue;
                    }
                    if (ColorFactory.getInstance().isColor(string5)) {
                        string2 = string5;
                        continue;
                    }
                    string4 = string5;
                }
                String string6 = this.name;
                if (string2 != null) {
                    abstractCSS2Properties.setPropertyValueLCAlt(string6 + "-color", string2, bl);
                }
                if (string4 != null) {
                    abstractCSS2Properties.setPropertyValueLCAlt(string6 + "-width", string4, bl);
                }
                if (string3 != null) {
                    abstractCSS2Properties.setPropertyValueLCAlt(string6 + "-style", string3, bl);
                }
            }
        }
    }

    private static class BorderSetter1
    implements SubPropertySetter {
        private BorderSetter1() {
        }

        public void changeValue(AbstractCSS2Properties abstractCSS2Properties, String string, CSSStyleDeclaration cSSStyleDeclaration) {
            this.changeValue(abstractCSS2Properties, string, cSSStyleDeclaration, true);
        }

        public void changeValue(AbstractCSS2Properties abstractCSS2Properties, String string, CSSStyleDeclaration cSSStyleDeclaration, boolean bl) {
            abstractCSS2Properties.setPropertyValueLCAlt(AbstractCSS2Properties.BORDER, string, bl);
            abstractCSS2Properties.setPropertyValueProcessed(AbstractCSS2Properties.BORDER_TOP, string, cSSStyleDeclaration, bl);
            abstractCSS2Properties.setPropertyValueProcessed(AbstractCSS2Properties.BORDER_LEFT, string, cSSStyleDeclaration, bl);
            abstractCSS2Properties.setPropertyValueProcessed(AbstractCSS2Properties.BORDER_BOTTOM, string, cSSStyleDeclaration, bl);
            abstractCSS2Properties.setPropertyValueProcessed(AbstractCSS2Properties.BORDER_RIGHT, string, cSSStyleDeclaration, bl);
        }
    }

    private static interface SubPropertySetter {
        public void changeValue(AbstractCSS2Properties var1, String var2, CSSStyleDeclaration var3, boolean var4);
    }
}

