/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import org.lobobrowser.html.renderer.FloatingBounds;
import org.lobobrowser.util.Objects;

class ShiftedFloatingBounds
implements FloatingBounds {
    private final FloatingBounds prevBounds;
    private final int shiftLeft;
    private final int shiftRight;
    private final int shiftY;

    public ShiftedFloatingBounds(FloatingBounds floatingBounds, int n, int n2, int n3) {
        this.prevBounds = floatingBounds;
        this.shiftLeft = n;
        this.shiftRight = n2;
        this.shiftY = n3;
    }

    public int getClearY(int n) {
        return this.prevBounds.getClearY(n - this.shiftY) + this.shiftY;
    }

    public int getFirstClearY(int n) {
        return this.prevBounds.getFirstClearY(n - this.shiftY) + this.shiftY;
    }

    public int getLeft(int n) {
        return this.prevBounds.getLeft(n - this.shiftY) + this.shiftLeft;
    }

    public int getLeftClearY(int n) {
        return this.prevBounds.getLeftClearY(n - this.shiftY) + this.shiftY;
    }

    public int getRight(int n) {
        return this.prevBounds.getRight(n - this.shiftY) + this.shiftRight;
    }

    public int getRightClearY(int n) {
        return this.prevBounds.getRightClearY(n - this.shiftY) + this.shiftY;
    }

    public int getMaxY() {
        return this.prevBounds.getMaxY() + this.shiftY;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShiftedFloatingBounds)) {
            return false;
        }
        ShiftedFloatingBounds shiftedFloatingBounds = (ShiftedFloatingBounds)object;
        return this.shiftY == shiftedFloatingBounds.shiftY && this.shiftLeft == shiftedFloatingBounds.shiftLeft && this.shiftRight == shiftedFloatingBounds.shiftRight && Objects.equals(this.prevBounds, shiftedFloatingBounds.prevBounds);
    }

    public int hashCode() {
        return this.shiftY ^ this.shiftLeft ^ this.shiftRight;
    }
}

