/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import org.lobobrowser.html.BrowserFrame;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.RUIControl;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.renderer.UIControl;
import org.lobobrowser.html.style.HtmlInsets;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderState;
import org.w3c.dom.html2.HTMLElement;

class BrowserFrameUIControl
implements UIControl {
    private final Component component;
    private final HTMLElement element;
    private final BrowserFrame browserFrame;
    private RUIControl ruiControl;
    private int availWidth;
    private int availHeight;

    public BrowserFrameUIControl(HTMLElement hTMLElement, BrowserFrame browserFrame) {
        this.component = browserFrame.getComponent();
        this.browserFrame = browserFrame;
        this.element = hTMLElement;
    }

    public int getVAlign() {
        return 5;
    }

    public float getAlignmentY() {
        return 0.0f;
    }

    public Color getBackgroundColor() {
        return this.component.getBackground();
    }

    public Component getComponent() {
        return this.component;
    }

    public void reset(int n, int n2) {
        this.availWidth = n;
        this.availHeight = n2;
        RUIControl rUIControl = this.ruiControl;
        if (rUIControl != null) {
            int n3;
            ModelNode modelNode = rUIControl.getModelNode();
            HTMLElement hTMLElement = (HTMLElement)((Object)modelNode);
            RenderState renderState = modelNode.getRenderState();
            HtmlInsets htmlInsets = null;
            String string = hTMLElement.getAttribute("marginwidth");
            String string2 = hTMLElement.getAttribute("marginheight");
            if (string != null && string.length() != 0) {
                if (htmlInsets == null) {
                    htmlInsets = new HtmlInsets();
                }
                if ((string = string.trim()).endsWith("%")) {
                    try {
                        n3 = Integer.parseInt(string.substring(0, string.length() - 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        n3 = 0;
                    }
                    htmlInsets.left = n3;
                    htmlInsets.right = n3;
                    htmlInsets.leftType = 3;
                    htmlInsets.rightType = 3;
                } else {
                    try {
                        n3 = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n3 = 0;
                    }
                    htmlInsets.left = n3;
                    htmlInsets.right = n3;
                    htmlInsets.leftType = 1;
                    htmlInsets.rightType = 1;
                }
            }
            if (string2 != null && string2.length() != 0) {
                if (htmlInsets == null) {
                    htmlInsets = new HtmlInsets();
                }
                if ((string2 = string2.trim()).endsWith("%")) {
                    try {
                        n3 = Integer.parseInt(string2.substring(0, string2.length() - 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        n3 = 0;
                    }
                    htmlInsets.top = n3;
                    htmlInsets.bottom = n3;
                    htmlInsets.topType = 3;
                    htmlInsets.bottomType = 3;
                } else {
                    try {
                        n3 = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n3 = 0;
                    }
                    htmlInsets.top = n3;
                    htmlInsets.bottom = n3;
                    htmlInsets.topType = 1;
                    htmlInsets.bottomType = 1;
                }
            }
            Insets insets = htmlInsets == null ? null : htmlInsets.getSimpleAWTInsets(n, n2);
            int n4 = renderState.getOverflowX();
            int n5 = renderState.getOverflowY();
            if (insets != null) {
                this.browserFrame.setDefaultMarginInsets(insets);
            }
            if (n4 != 0) {
                this.browserFrame.setDefaultOverflowX(n4);
            }
            if (n5 != 0) {
                this.browserFrame.setDefaultOverflowY(n5);
            }
        }
    }

    public Dimension getPreferredSize() {
        int n = HtmlValues.getOldSyntaxPixelSize(this.element.getAttribute("width"), this.availWidth, 100);
        int n2 = HtmlValues.getOldSyntaxPixelSize(this.element.getAttribute("height"), this.availHeight, 100);
        return new Dimension(n, n2);
    }

    public void invalidate() {
        this.component.invalidate();
    }

    public void paint(Graphics graphics) {
        this.component.paint(graphics);
    }

    public boolean paintSelection(Graphics graphics, boolean bl, RenderableSpot renderableSpot, RenderableSpot renderableSpot2) {
        return false;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.component.setBounds(n, n2, n3, n4);
    }

    public void setRUIControl(RUIControl rUIControl) {
        this.ruiControl = rUIControl;
    }
}

