/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.ChildHTMLCollection;
import org.lobobrowser.html.domimpl.ElementImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.domimpl.NodeFilter;
import org.lobobrowser.html.domimpl.NodeListImpl;
import org.lobobrowser.html.domimpl.NodeVisitor;
import org.lobobrowser.html.domimpl.SkipVisitorException;
import org.lobobrowser.html.domimpl.StopVisitorException;
import org.lobobrowser.html.domimpl.TextFilter;
import org.lobobrowser.html.domimpl.TextImpl;
import org.lobobrowser.html.domimpl.UINode;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.StyleSheetRenderState;
import org.lobobrowser.js.AbstractScriptableDelegate;
import org.lobobrowser.util.Objects;
import org.lobobrowser.util.Strings;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public abstract class NodeImpl
extends AbstractScriptableDelegate
implements Node,
ModelNode {
    private static final NodeImpl[] EMPTY_ARRAY = new NodeImpl[0];
    private static final RenderState INVALID_RENDER_STATE = new StyleSheetRenderState(null);
    protected static final Logger logger = Logger.getLogger(NodeImpl.class.getName());
    protected UINode uiNode;
    protected ArrayList nodeList;
    protected volatile Document document;
    protected volatile Object treeLock = this;
    private ChildHTMLCollection childrenCollection;
    private Map userData;
    private Map userDataHandlers;
    protected volatile boolean notificationsSuspended = false;
    private volatile String prefix;
    protected volatile Node parentNode;
    private RenderState renderState = INVALID_RENDER_STATE;

    public void setUINode(UINode uINode) {
        this.uiNode = uINode;
    }

    public UINode getUINode() {
        return this.uiNode;
    }

    public UINode findUINode() {
        UINode uINode = this.uiNode;
        if (uINode != null) {
            return uINode;
        }
        NodeImpl nodeImpl = (NodeImpl)this.getParentNode();
        return nodeImpl == null ? null : nodeImpl.findUINode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node appendChild(Node node) throws DOMException {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList<Node> arrayList = this.nodeList;
            if (arrayList == null) {
                this.nodeList = arrayList = new ArrayList<Node>(3);
            }
            arrayList.add(node);
            if (node instanceof NodeImpl) {
                ((NodeImpl)node).setParentImpl(this);
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllChildren() {
        Object object = this.treeLock;
        synchronized (object) {
            this.removeAllChildrenImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllChildrenImpl() {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList arrayList = this.nodeList;
            if (arrayList != null) {
                arrayList.clear();
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeList getNodeList(NodeFilter nodeFilter) {
        ArrayList arrayList = new ArrayList();
        Object object = this.treeLock;
        synchronized (object) {
            this.appendChildrenToCollectionImpl(nodeFilter, arrayList);
        }
        return new NodeListImpl(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeImpl[] getChildrenArray() {
        ArrayList arrayList = this.nodeList;
        Object object = this.treeLock;
        synchronized (object) {
            return arrayList == null ? null : arrayList.toArray(EMPTY_ARRAY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getChildCount() {
        ArrayList arrayList = this.nodeList;
        Object object = this.treeLock;
        synchronized (object) {
            return arrayList == null ? 0 : arrayList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChildHTMLCollection getChildren() {
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            ChildHTMLCollection childHTMLCollection = this.childrenCollection;
            if (childHTMLCollection == null) {
                this.childrenCollection = childHTMLCollection = new ChildHTMLCollection(this);
            }
            return childHTMLCollection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getDescendents(NodeFilter nodeFilter, boolean bl) {
        ArrayList arrayList = new ArrayList();
        Object object = this.treeLock;
        synchronized (object) {
            this.extractDescendentsArrayImpl(nodeFilter, arrayList, bl);
        }
        return arrayList;
    }

    private void extractDescendentsArrayImpl(NodeFilter nodeFilter, ArrayList arrayList, boolean bl) {
        ArrayList arrayList2 = this.nodeList;
        if (arrayList2 != null) {
            for (NodeImpl nodeImpl : arrayList2) {
                if (nodeFilter.accept(nodeImpl)) {
                    arrayList.add(nodeImpl);
                    if (!bl) continue;
                    nodeImpl.extractDescendentsArrayImpl(nodeFilter, arrayList, bl);
                    continue;
                }
                if (nodeImpl.getNodeType() != 1) continue;
                nodeImpl.extractDescendentsArrayImpl(nodeFilter, arrayList, bl);
            }
        }
    }

    private void appendChildrenToCollectionImpl(NodeFilter nodeFilter, Collection collection) {
        ArrayList arrayList = this.nodeList;
        if (arrayList != null) {
            for (NodeImpl nodeImpl : arrayList) {
                if (nodeFilter.accept(nodeImpl)) {
                    collection.add(nodeImpl);
                }
                nodeImpl.appendChildrenToCollectionImpl(nodeFilter, collection);
            }
        }
    }

    protected abstract Node createSimilarNode();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node cloneNode(boolean bl) {
        try {
            Object object;
            Node node = this.createSimilarNode();
            NodeList nodeList = this.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                object = nodeList.item(i);
                Node node2 = bl ? object.cloneNode(bl) : object;
                node.appendChild(node2);
            }
            if (node instanceof Element) {
                Element element = (Element)node;
                object = this.getAttributes();
                if (object != null) {
                    int n2 = object.getLength();
                    for (int i = 0; i < n2; ++i) {
                        Attr attr = (Attr)object.item(i);
                        element.setAttributeNode((Attr)attr.cloneNode(true));
                    }
                }
            }
            NodeImpl nodeImpl = this;
            synchronized (nodeImpl) {
                if (this.userDataHandlers != null && this.userData != null) {
                    for (Map.Entry entry : this.userDataHandlers.entrySet()) {
                        UserDataHandler userDataHandler = (UserDataHandler)entry.getValue();
                        userDataHandler.handle((short)1, (String)entry.getKey(), this.userData.get(entry.getKey()), this, node);
                    }
                }
            }
            return node;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception.getMessage());
        }
    }

    private int getNodeIndex() {
        NodeImpl nodeImpl = (NodeImpl)this.getParentNode();
        return nodeImpl == null ? -1 : nodeImpl.getChildIndex(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getChildIndex(Node node) {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList arrayList = this.nodeList;
            return arrayList == null ? -1 : arrayList.indexOf(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node getChildAtIndex(int n) {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList arrayList = this.nodeList;
            try {
                return arrayList == null ? null : (Node)arrayList.get(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.warn("getChildAtIndex(): Bad index=" + n + " for node=" + this + ".");
                return null;
            }
        }
    }

    private boolean isAncestorOf(Node node) {
        NodeImpl nodeImpl = (NodeImpl)node.getParentNode();
        if (nodeImpl == this) {
            return true;
        }
        if (nodeImpl == null) {
            return false;
        }
        return this.isAncestorOf(nodeImpl);
    }

    public short compareDocumentPosition(Node node) throws DOMException {
        Node node2 = this.getParentNode();
        if (!(node instanceof NodeImpl)) {
            throw new DOMException(9, "Unknwon node implementation");
        }
        if (node2 != null && node2 == node.getParentNode()) {
            int n = this.getNodeIndex();
            int n2 = ((NodeImpl)node).getNodeIndex();
            if (n == -1 || n2 == -1) {
                return 32;
            }
            if (n < n2) {
                return 4;
            }
            return 2;
        }
        if (this.isAncestorOf(node)) {
            return 16;
        }
        if (((NodeImpl)node).isAncestorOf(this)) {
            return 8;
        }
        return 1;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Document getOwnerDocument() {
        return this.document;
    }

    void setOwnerDocument(Document document) {
        this.document = document;
        this.treeLock = document == null ? this : document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOwnerDocument(Document document, boolean bl) {
        this.document = document;
        Object object = this.treeLock = document == null ? this : document;
        if (bl) {
            Object object2 = this.treeLock;
            synchronized (object2) {
                ArrayList arrayList = this.nodeList;
                if (arrayList != null) {
                    for (NodeImpl nodeImpl : arrayList) {
                        nodeImpl.setOwnerDocument(document, bl);
                    }
                }
            }
        }
    }

    void visitImpl(NodeVisitor nodeVisitor) {
        try {
            nodeVisitor.visit(this);
        }
        catch (SkipVisitorException skipVisitorException) {
            return;
        }
        catch (StopVisitorException stopVisitorException) {
            throw stopVisitorException;
        }
        ArrayList arrayList = this.nodeList;
        if (arrayList != null) {
            for (NodeImpl nodeImpl : arrayList) {
                nodeImpl.visit(nodeVisitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visit(NodeVisitor nodeVisitor) {
        Object object = this.treeLock;
        synchronized (object) {
            this.visitImpl(nodeVisitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node insertBefore(Node node, Node node2) throws DOMException {
        Object object = this.treeLock;
        synchronized (object) {
            int n;
            ArrayList arrayList = this.nodeList;
            int n2 = n = arrayList == null ? -1 : arrayList.indexOf(node2);
            if (n == -1) {
                throw new DOMException(8, "refChild not found");
            }
            arrayList.add(n, node);
            if (node instanceof NodeImpl) {
                ((NodeImpl)node).setParentImpl(this);
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node insertAt(Node node, int n) throws DOMException {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList<Node> arrayList = this.nodeList;
            if (arrayList == null) {
                this.nodeList = arrayList = new ArrayList<Node>();
            }
            arrayList.add(n, node);
            if (node instanceof NodeImpl) {
                ((NodeImpl)node).setParentImpl(this);
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node replaceChild(Node node, Node node2) throws DOMException {
        Object object = this.treeLock;
        synchronized (object) {
            int n;
            ArrayList arrayList = this.nodeList;
            int n2 = n = arrayList == null ? -1 : arrayList.indexOf(node2);
            if (n == -1) {
                throw new DOMException(8, "oldChild not found");
            }
            arrayList.set(n, node);
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node removeChild(Node node) throws DOMException {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList arrayList = this.nodeList;
            if (arrayList == null || !arrayList.remove(node)) {
                throw new DOMException(8, "oldChild not found");
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node removeChildAt(int n) throws DOMException {
        try {
            Object object = this.treeLock;
            synchronized (object) {
                ArrayList arrayList = this.nodeList;
                if (arrayList == null) {
                    throw new DOMException(1, "Empty list of children");
                }
                Node node = (Node)arrayList.remove(n);
                if (node == null) {
                    throw new DOMException(1, "No node with that index");
                }
                Node node2 = node;
                return node2;
            }
        }
        finally {
            if (!this.notificationsSuspended) {
                this.informStructureInvalid();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChildNodes() {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList arrayList = this.nodeList;
            return arrayList != null && !arrayList.isEmpty();
        }
    }

    public String getBaseURI() {
        Document document = this.document;
        return document == null ? null : document.getBaseURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeList getChildNodes() {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList arrayList = this.nodeList;
            return new NodeListImpl(arrayList == null ? Collections.EMPTY_LIST : arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getFirstChild() {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList arrayList = this.nodeList;
            try {
                return arrayList == null ? null : (Node)arrayList.get(0);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getLastChild() {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList arrayList = this.nodeList;
            try {
                return arrayList == null ? null : (Node)arrayList.get(arrayList.size() - 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getPreviousTo(Node node) {
        Object object = this.treeLock;
        synchronized (object) {
            int n;
            ArrayList arrayList = this.nodeList;
            int n2 = n = arrayList == null ? -1 : arrayList.indexOf(node);
            if (n == -1) {
                throw new DOMException(8, "node not found");
            }
            try {
                return (Node)arrayList.get(n - 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getNextTo(Node node) {
        Object object = this.treeLock;
        synchronized (object) {
            int n;
            ArrayList arrayList = this.nodeList;
            int n2 = n = arrayList == null ? -1 : arrayList.indexOf(node);
            if (n == -1) {
                throw new DOMException(8, "node not found");
            }
            try {
                return (Node)arrayList.get(n + 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }
    }

    public Node getPreviousSibling() {
        NodeImpl nodeImpl = (NodeImpl)this.getParentNode();
        return nodeImpl == null ? null : nodeImpl.getPreviousTo(this);
    }

    public Node getNextSibling() {
        NodeImpl nodeImpl = (NodeImpl)this.getParentNode();
        return nodeImpl == null ? null : nodeImpl.getNextTo(this);
    }

    public Object getFeature(String string, String string2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        if ("cobra.suspend".equals(string)) {
            boolean bl;
            this.notificationsSuspended = bl = Boolean.TRUE == object;
            if (!bl) {
                this.informNodeLoaded();
            }
        }
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            if (userDataHandler != null) {
                if (this.userDataHandlers == null) {
                    this.userDataHandlers = new HashMap();
                } else if (userDataHandler == null) {
                    this.userDataHandlers.remove(string);
                }
                if (userDataHandler != null) {
                    this.userDataHandlers.put(string, userDataHandler);
                }
            }
            HashMap<String, Object> hashMap = this.userData;
            if (object != null) {
                if (hashMap == null) {
                    this.userData = hashMap = new HashMap<String, Object>();
                }
                return hashMap.put(string, object);
            }
            if (hashMap != null) {
                return hashMap.remove(string);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getUserData(String string) {
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            Map map = this.userData;
            return map == null ? null : map.get(string);
        }
    }

    public abstract String getLocalName();

    public boolean hasAttributes() {
        return false;
    }

    public String getNamespaceURI() {
        return null;
    }

    public abstract String getNodeName();

    public abstract String getNodeValue() throws DOMException;

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) throws DOMException {
        this.prefix = string;
    }

    public abstract void setNodeValue(String var1) throws DOMException;

    public abstract short getNodeType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTextContent() throws DOMException {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList arrayList = this.nodeList;
            if (arrayList != null) {
                for (Node node : arrayList) {
                    short s = node.getNodeType();
                    switch (s) {
                        case 1: 
                        case 3: 
                        case 4: {
                            String string = node.getTextContent();
                            if (string == null) break;
                            stringBuffer.append(string);
                            break;
                        }
                    }
                }
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextContent(String string) throws DOMException {
        Object object = this.treeLock;
        synchronized (object) {
            this.removeChildrenImpl(new TextFilter());
            if (string != null && !"".equals(string)) {
                TextImpl textImpl = new TextImpl(string);
                textImpl.setOwnerDocument(this.document);
                textImpl.setParentImpl(this);
                ArrayList<TextImpl> arrayList = this.nodeList;
                if (arrayList == null) {
                    this.nodeList = arrayList = new ArrayList<TextImpl>();
                }
                arrayList.add(textImpl);
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeChildren(NodeFilter nodeFilter) {
        Object object = this.treeLock;
        synchronized (object) {
            this.removeChildrenImpl(nodeFilter);
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
    }

    protected void removeChildrenImpl(NodeFilter nodeFilter) {
        ArrayList arrayList = this.nodeList;
        if (arrayList != null) {
            int n;
            int n2 = n = arrayList.size();
            while (--n2 >= 0) {
                Node node = (Node)arrayList.get(n2);
                if (!nodeFilter.accept(node)) continue;
                arrayList.remove(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node insertAfter(Node node, Node node2) {
        Object object = this.treeLock;
        synchronized (object) {
            int n;
            ArrayList arrayList = this.nodeList;
            int n2 = n = arrayList == null ? -1 : arrayList.indexOf(node2);
            if (n == -1) {
                throw new DOMException(8, "refChild not found");
            }
            arrayList.add(n + 1, node);
            if (node instanceof NodeImpl) {
                ((NodeImpl)node).setParentImpl(this);
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Text replaceAdjacentTextNodes(Text text, String string) {
        try {
            Object object = this.treeLock;
            synchronized (object) {
                Object object2;
                ArrayList arrayList = this.nodeList;
                if (arrayList == null) {
                    throw new DOMException(8, "Node not a child");
                }
                int n = arrayList.indexOf(text);
                if (n == -1) {
                    throw new DOMException(8, "Node not a child");
                }
                int n2 = n;
                LinkedList linkedList = new LinkedList();
                int n3 = n;
                while (--n3 >= 0) {
                    Object e = this.nodeList.get(n3);
                    if (!(e instanceof Text)) continue;
                    n2 = n3;
                    linkedList.add(e);
                }
                n3 = this.nodeList.size();
                int n4 = n;
                while (++n4 < n3) {
                    object2 = this.nodeList.get(n4);
                    if (!(object2 instanceof Text)) continue;
                    linkedList.add(object2);
                }
                this.nodeList.removeAll(linkedList);
                TextImpl textImpl = new TextImpl(string);
                textImpl.setOwnerDocument(this.document);
                textImpl.setParentImpl(this);
                this.nodeList.add(n2, textImpl);
                object2 = textImpl;
                return object2;
            }
        }
        finally {
            if (!this.notificationsSuspended) {
                this.informStructureInvalid();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Text replaceAdjacentTextNodes(Text text) {
        try {
            Object object = this.treeLock;
            synchronized (object) {
                Object object2;
                ArrayList arrayList = this.nodeList;
                if (arrayList == null) {
                    throw new DOMException(8, "Node not a child");
                }
                int n = arrayList.indexOf(text);
                if (n == -1) {
                    throw new DOMException(8, "Node not a child");
                }
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = n;
                LinkedList linkedList = new LinkedList();
                int n3 = n;
                while (--n3 >= 0) {
                    Object e = this.nodeList.get(n3);
                    if (!(e instanceof Text)) continue;
                    n2 = n3;
                    linkedList.add(e);
                    stringBuffer.append(((Text)e).getNodeValue());
                }
                n3 = this.nodeList.size();
                int n4 = n;
                while (++n4 < n3) {
                    object2 = this.nodeList.get(n4);
                    if (!(object2 instanceof Text)) continue;
                    linkedList.add(object2);
                    stringBuffer.append(((Text)object2).getNodeValue());
                }
                this.nodeList.removeAll(linkedList);
                TextImpl textImpl = new TextImpl(stringBuffer.toString());
                textImpl.setOwnerDocument(this.document);
                textImpl.setParentImpl(this);
                this.nodeList.add(n2, textImpl);
                object2 = textImpl;
                return object2;
            }
        }
        finally {
            if (!this.notificationsSuspended) {
                this.informStructureInvalid();
            }
        }
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public boolean isSameNode(Node node) {
        return this == node;
    }

    public boolean isSupported(String string, String string2) {
        return "HTML".equals(string) && string2.compareTo("4.01") <= 0;
    }

    public String lookupNamespaceURI(String string) {
        return null;
    }

    public boolean equalAttributes(Node node) {
        return false;
    }

    public boolean isEqualNode(Node node) {
        return node instanceof NodeImpl && this.getNodeType() == node.getNodeType() && Objects.equals(this.getNodeName(), node.getNodeName()) && Objects.equals(this.getNodeValue(), node.getNodeValue()) && Objects.equals(this.getLocalName(), node.getLocalName()) && Objects.equals(this.nodeList, ((NodeImpl)node).nodeList) && this.equalAttributes(node);
    }

    public boolean isDefaultNamespace(String string) {
        return string == null;
    }

    public String lookupPrefix(String string) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void normalize() {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList arrayList = this.nodeList;
            if (arrayList != null) {
                Iterator iterator = arrayList.iterator();
                LinkedList<Node> linkedList = new LinkedList<Node>();
                boolean bl = false;
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    if (node.getNodeType() == 3) {
                        if (bl) continue;
                        bl = true;
                        linkedList.add(node);
                        continue;
                    }
                    bl = false;
                }
                for (Node node : linkedList) {
                    this.replaceAdjacentTextNodes((Text)node);
                }
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
    }

    public String toString() {
        return this.getNodeName();
    }

    public UserAgentContext getUserAgentContext() {
        Document document = this.document;
        if (document instanceof HTMLDocumentImpl) {
            return ((HTMLDocumentImpl)document).getUserAgentContext();
        }
        return null;
    }

    public HtmlRendererContext getHtmlRendererContext() {
        Document document = this.document;
        if (document instanceof HTMLDocumentImpl) {
            return ((HTMLDocumentImpl)document).getHtmlRendererContext();
        }
        return null;
    }

    final void setParentImpl(Node node) {
        this.parentNode = node;
    }

    public float getAlignmentX() {
        return 0.5f;
    }

    public float getAlignmentY() {
        return 0.5f;
    }

    public URL getFullURL(String string) throws MalformedURLException {
        Document document = this.document;
        if (document instanceof HTMLDocumentImpl) {
            return ((HTMLDocumentImpl)document).getFullURL(string);
        }
        return new URL(string);
    }

    public URL getDocumentURL() {
        Document document = this.document;
        if (document instanceof HTMLDocumentImpl) {
            return ((HTMLDocumentImpl)document).getDocumentURL();
        }
        return null;
    }

    public Object getDocumentItem(String string) {
        Document document = this.document;
        return document == null ? null : document.getUserData(string);
    }

    public void setDocumentItem(String string, Object object) {
        Document document = this.document;
        if (document == null) {
            return;
        }
        document.setUserData(string, object, null);
    }

    public final boolean isEqualOrDescendentOf(ModelNode modelNode) {
        if (modelNode == this) {
            return true;
        }
        Node node = this.getParentNode();
        if (node instanceof HTMLElementImpl) {
            return ((HTMLElementImpl)node).isEqualOrDescendentOf(modelNode);
        }
        return false;
    }

    public final ModelNode getParentModelNode() {
        return (ModelNode)((Object)this.parentNode);
    }

    public void warn(String string, Throwable throwable) {
        logger.log(Level.WARNING, string, throwable);
    }

    public void warn(String string) {
        logger.log(Level.WARNING, string);
    }

    public void informSizeInvalid() {
        HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)this.document;
        if (hTMLDocumentImpl != null) {
            hTMLDocumentImpl.sizeInvalidated(this);
        }
    }

    public void informLookInvalid() {
        this.forgetRenderState();
        HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)this.document;
        if (hTMLDocumentImpl != null) {
            hTMLDocumentImpl.lookInvalidated(this);
        }
    }

    public void informPositionInvalid() {
        HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)this.document;
        if (hTMLDocumentImpl != null) {
            hTMLDocumentImpl.positionInParentInvalidated(this);
        }
    }

    public void informInvalid() {
        this.forgetRenderState();
        HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)this.document;
        if (hTMLDocumentImpl != null) {
            hTMLDocumentImpl.invalidated(this);
        }
    }

    public void informStructureInvalid() {
        this.forgetRenderState();
        HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)this.document;
        if (hTMLDocumentImpl != null) {
            hTMLDocumentImpl.structureInvalidated(this);
        }
    }

    protected void informNodeLoaded() {
        this.forgetRenderState();
        HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)this.document;
        if (hTMLDocumentImpl != null) {
            hTMLDocumentImpl.nodeLoaded(this);
        }
    }

    protected void informExternalScriptLoading() {
        this.forgetRenderState();
        HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)this.document;
        if (hTMLDocumentImpl != null) {
            hTMLDocumentImpl.externalScriptLoading(this);
        }
    }

    public void informLayoutInvalid() {
        this.forgetRenderState();
        HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)this.document;
        if (hTMLDocumentImpl != null) {
            hTMLDocumentImpl.invalidated(this);
        }
    }

    public void informDocumentInvalid() {
        HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)this.document;
        if (hTMLDocumentImpl != null) {
            hTMLDocumentImpl.allInvalidated(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderState getRenderState() {
        Object object = this.treeLock;
        synchronized (object) {
            RenderState renderState = this.renderState;
            if (renderState != INVALID_RENDER_STATE) {
                return renderState;
            }
            Node node = this.parentNode;
            if (node != null || this instanceof Document) {
                RenderState renderState2 = this.getParentRenderState(node);
                this.renderState = renderState = this.createRenderState(renderState2);
                return renderState;
            }
            return null;
        }
    }

    protected final RenderState getParentRenderState(Object object) {
        if (object instanceof NodeImpl) {
            return ((NodeImpl)object).getRenderState();
        }
        return null;
    }

    protected RenderState createRenderState(RenderState renderState) {
        return renderState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forgetRenderState() {
        Object object = this.treeLock;
        synchronized (object) {
            if (this.renderState != INVALID_RENDER_STATE) {
                this.renderState = INVALID_RENDER_STATE;
                ArrayList arrayList = this.nodeList;
                if (arrayList != null) {
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        ((NodeImpl)iterator.next()).forgetRenderState();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInnerHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            this.appendInnerHTMLImpl(stringBuffer);
        }
        return stringBuffer.toString();
    }

    protected void appendInnerHTMLImpl(StringBuffer stringBuffer) {
        int n;
        ArrayList arrayList = this.nodeList;
        if (arrayList != null && (n = arrayList.size()) > 0) {
            for (int i = 0; i < n; ++i) {
                Node node = (Node)arrayList.get(i);
                if (node instanceof HTMLElementImpl) {
                    ((HTMLElementImpl)node).appendOuterHTMLImpl(stringBuffer);
                    continue;
                }
                if (node instanceof Comment) {
                    stringBuffer.append("<!--" + ((Comment)node).getTextContent() + "-->");
                    continue;
                }
                if (node instanceof Text) {
                    String string = ((Text)node).getTextContent();
                    String string2 = this.htmlEncodeChildText(string);
                    stringBuffer.append(string2);
                    continue;
                }
                if (!(node instanceof ProcessingInstruction)) continue;
                stringBuffer.append(node.toString());
            }
        }
    }

    protected String htmlEncodeChildText(String string) {
        return Strings.strictHtmlEncode(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInnerText() {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = this.treeLock;
        synchronized (object) {
            this.appendInnerTextImpl(stringBuffer);
        }
        return stringBuffer.toString();
    }

    protected void appendInnerTextImpl(StringBuffer stringBuffer) {
        ArrayList arrayList = this.nodeList;
        if (arrayList == null) {
            return;
        }
        int n = arrayList.size();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Node node = (Node)arrayList.get(i);
            if (node instanceof ElementImpl) {
                ((ElementImpl)node).appendInnerTextImpl(stringBuffer);
            }
            if (node instanceof Comment || !(node instanceof Text)) continue;
            stringBuffer.append(((Text)node).getTextContent());
        }
    }
}

