/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.util.HashMap;
import java.util.Map;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementBuilder;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.html2.HTMLElement;

class ElementFactory {
    private final Map builders = new HashMap(80);
    private static ElementFactory instance = new ElementFactory();

    private ElementFactory() {
        Map map = this.builders;
        map.put("HTML", new HTMLElementBuilder.Html());
        map.put("TITLE", new HTMLElementBuilder.Title());
        map.put("BASE", new HTMLElementBuilder.Base());
        HTMLElementBuilder.Div div = new HTMLElementBuilder.Div();
        map.put("DIV", div);
        map.put("DL", div);
        map.put("BODY", new HTMLElementBuilder.Body());
        map.put("CENTER", new HTMLElementBuilder.Center());
        map.put("CAPTION", new HTMLElementBuilder.Center());
        map.put("PRE", new HTMLElementBuilder.Pre());
        map.put("P", new HTMLElementBuilder.P());
        HTMLElementBuilder.Blockquote blockquote = new HTMLElementBuilder.Blockquote();
        map.put("BLOCKQUOTE", blockquote);
        map.put("DD", blockquote);
        map.put("SPAN", new HTMLElementBuilder.Span());
        map.put("SCRIPT", new HTMLElementBuilder.Script());
        map.put("IMG", new HTMLElementBuilder.Img());
        map.put("STYLE", new HTMLElementBuilder.Style());
        map.put("LINK", new HTMLElementBuilder.Link());
        map.put("A", new HTMLElementBuilder.Anchor());
        map.put("ANCHOR", new HTMLElementBuilder.Anchor());
        map.put("TABLE", new HTMLElementBuilder.Table());
        map.put("TD", new HTMLElementBuilder.Td());
        map.put("TH", new HTMLElementBuilder.Th());
        map.put("TR", new HTMLElementBuilder.Tr());
        map.put("FORM", new HTMLElementBuilder.Form());
        map.put("INPUT", new HTMLElementBuilder.Input());
        map.put("BUTTON", new HTMLElementBuilder.Button());
        map.put("TEXTAREA", new HTMLElementBuilder.Textarea());
        map.put("SELECT", new HTMLElementBuilder.Select());
        map.put("OPTION", new HTMLElementBuilder.Option());
        map.put("FRAMESET", new HTMLElementBuilder.Frameset());
        map.put("FRAME", new HTMLElementBuilder.Frame());
        map.put("IFRAME", new HTMLElementBuilder.IFrame());
        map.put("UL", new HTMLElementBuilder.Ul());
        map.put("OL", new HTMLElementBuilder.Ol());
        map.put("LI", new HTMLElementBuilder.Li());
        map.put("HR", new HTMLElementBuilder.Hr());
        map.put("BR", new HTMLElementBuilder.Br());
        map.put("OBJECT", new HTMLElementBuilder.HtmlObject());
        map.put("APPLET", new HTMLElementBuilder.Applet());
        map.put("EMBED", new HTMLElementBuilder.NonStandard());
        map.put("FONT", new HTMLElementBuilder.Font());
        map.put("BASEFONT", new HTMLElementBuilder.BaseFont());
        map.put("TT", new HTMLElementBuilder.Tt());
        map.put("CODE", new HTMLElementBuilder.Code());
        map.put("SMALL", new HTMLElementBuilder.Small());
        map.put("BIG", new HTMLElementBuilder.Big());
        map.put("B", new HTMLElementBuilder.Strong());
        map.put("STRONG", new HTMLElementBuilder.Strong());
        map.put("U", new HTMLElementBuilder.Underline());
        map.put("STRIKE", new HTMLElementBuilder.Strike());
        map.put("SUP", new HTMLElementBuilder.Sup());
        map.put("SUB", new HTMLElementBuilder.Sub());
        HTMLElementBuilder.Em em = new HTMLElementBuilder.Em();
        map.put("I", em);
        map.put("EM", em);
        map.put("CITE", em);
        HTMLElementBuilder.Heading heading = new HTMLElementBuilder.Heading();
        map.put("H1", heading);
        map.put("H2", heading);
        map.put("H3", heading);
        map.put("H4", heading);
        map.put("H5", heading);
        map.put("H6", heading);
    }

    public static ElementFactory getInstance() {
        return instance;
    }

    public final HTMLElement createElement(HTMLDocumentImpl hTMLDocumentImpl, String string) throws DOMException {
        String string2 = string.toUpperCase();
        HTMLElementBuilder hTMLElementBuilder = (HTMLElementBuilder)this.builders.get(string2);
        if (hTMLElementBuilder == null) {
            HTMLElementImpl hTMLElementImpl = new HTMLElementImpl(string);
            hTMLElementImpl.setOwnerDocument(hTMLDocumentImpl);
            return hTMLElementImpl;
        }
        return hTMLElementBuilder.create(hTMLDocumentImpl, string);
    }
}

