/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.gjt.sp.jedit.IPropertyManager;
import org.gjt.sp.jedit.JEditActionSet;
import org.gjt.sp.jedit.JEditBeanShellAction;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.buffer.DefaultFoldHandlerProvider;
import org.gjt.sp.jedit.buffer.DummyFoldHandler;
import org.gjt.sp.jedit.buffer.ExplicitFoldHandler;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.buffer.IndentFoldHandler;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.buffer.KillRing;
import org.gjt.sp.jedit.datatransfer.RichJEditTextTransferableService;
import org.gjt.sp.jedit.datatransfer.StringTransferableService;
import org.gjt.sp.jedit.datatransfer.TransferHandler;
import org.gjt.sp.jedit.input.AbstractInputHandler;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.syntax.ModeProvider;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.jedit.textarea.AntiAlias;
import org.gjt.sp.jedit.textarea.Gutter;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaMouseHandler;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.SyntaxUtilities;

public class StandaloneTextArea
extends TextArea {
    private final IPropertyManager propertyManager;

    public StandaloneTextArea(IPropertyManager propertyManager) {
        super(propertyManager, null);
        this.propertyManager = propertyManager;
        this.initInputHandler();
        this.setMouseHandler(new TextAreaMouseHandler(this));
        StandaloneActionSet actionSet = new StandaloneActionSet(propertyManager, this, TextArea.class.getResource("textarea.actions.xml"));
        this.addActionSet(actionSet);
        actionSet.load();
        actionSet.initKeyBindings();
        if (SyntaxUtilities.propertyManager == null) {
            SyntaxUtilities.propertyManager = propertyManager;
        }
        this.initTextArea();
        DefaultFoldHandlerProvider foldHandlerProvider = new DefaultFoldHandlerProvider();
        FoldHandler.foldHandlerProvider = foldHandlerProvider;
        foldHandlerProvider.addFoldHandler(new ExplicitFoldHandler());
        foldHandlerProvider.addFoldHandler(new IndentFoldHandler());
        foldHandlerProvider.addFoldHandler(new DummyFoldHandler());
        JEditBuffer buffer = new JEditBuffer();
        TokenMarker tokenMarker = new TokenMarker();
        tokenMarker.addRuleSet(new ParserRuleSet("text", "MAIN"));
        buffer.setTokenMarker(tokenMarker);
        this.setBuffer(buffer);
        String property = propertyManager.getProperty("buffer.undoCount");
        int undoCount = 100;
        if (property != null) {
            try {
                undoCount = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.buffer.setUndoLimit(undoCount);
        Mode mode = new Mode("text");
        mode.setTokenMarker(tokenMarker);
        ModeProvider.instance.addMode(mode);
        KillRing.setInstance(new KillRing());
        KillRing.getInstance().propertiesChanged(100);
    }

    private void initTextArea() {
        this.initPainter();
        this.initGutter();
        this.setCaretBlinkEnabled(this.getBooleanProperty("view.caretBlink"));
        this.setElectricScroll(this.getIntegerProperty("view.electricBorders", 0));
        if (this.buffer == null) {
            return;
        }
        String property = this.propertyManager.getProperty("buffer.undoCount");
        int undoCount = 100;
        if (property != null) {
            try {
                undoCount = Integer.parseInt(property);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.buffer.setUndoLimit(undoCount);
    }

    private void initGutter() {
        Gutter gutter = this.getGutter();
        gutter.setExpanded(this.getBooleanProperty("view.gutter.lineNumbers"));
        int interval = this.getIntegerProperty("view.gutter.highlightInterval", 5);
        gutter.setHighlightInterval(interval);
        gutter.setCurrentLineHighlightEnabled(this.getBooleanProperty("view.gutter.highlightCurrentLine"));
        gutter.setStructureHighlightEnabled(this.getBooleanProperty("view.gutter.structureHighlight"));
        gutter.setStructureHighlightColor(this.getColorProperty("view.gutter.structureHighlightColor"));
        gutter.setBackground(this.getColorProperty("view.gutter.bgColor"));
        gutter.setForeground(this.getColorProperty("view.gutter.fgColor"));
        gutter.setHighlightedForeground(this.getColorProperty("view.gutter.highlightColor"));
        gutter.setFoldColor(this.getColorProperty("view.gutter.foldColor"));
        gutter.setCurrentLineForeground(this.getColorProperty("view.gutter.currentLineColor"));
        String alignment = this.getProperty("view.gutter.numberAlignment");
        if ("right".equals(alignment)) {
            gutter.setLineNumberAlignment(4);
        } else if ("center".equals(alignment)) {
            gutter.setLineNumberAlignment(0);
        } else {
            gutter.setLineNumberAlignment(2);
        }
        gutter.setFont(this.getFontProperty("view.gutter.font"));
        int width = this.getIntegerProperty("view.gutter.borderWidth", 3);
        gutter.setBorder(width, this.getColorProperty("view.gutter.focusBorderColor"), this.getColorProperty("view.gutter.noFocusBorderColor"), this.painter.getBackground());
    }

    private void initPainter() {
        TextAreaPainter painter = this.getPainter();
        painter.setBlockCaretEnabled(false);
        painter.setFont(this.getFontProperty("view.font"));
        painter.setStructureHighlightEnabled(this.getBooleanProperty("view.structureHighlight"));
        painter.setStructureHighlightColor(this.getColorProperty("view.structureHighlightColor"));
        painter.setEOLMarkersPainted(this.getBooleanProperty("view.eolMarkers"));
        painter.setEOLMarkerColor(this.getColorProperty("view.eolMarkerColor"));
        painter.setWrapGuidePainted(this.getBooleanProperty("view.wrapGuide"));
        painter.setWrapGuideColor(this.getColorProperty("view.wrapGuideColor"));
        painter.setCaretColor(this.getColorProperty("view.caretColor"));
        painter.setSelectionColor(this.getColorProperty("view.selectionColor"));
        painter.setMultipleSelectionColor(this.getColorProperty("view.multipleSelectionColor"));
        painter.setBackground(this.getColorProperty("view.bgColor"));
        painter.setForeground(this.getColorProperty("view.fgColor"));
        painter.setBlockCaretEnabled(this.getBooleanProperty("view.blockCaret"));
        painter.setThickCaretEnabled(this.getBooleanProperty("view.thickCaret"));
        painter.setLineHighlightEnabled(this.getBooleanProperty("view.lineHighlight"));
        painter.setLineHighlightColor(this.getColorProperty("view.lineHighlightColor"));
        painter.setAntiAlias(new AntiAlias(this.getProperty("view.antiAlias")));
        painter.setFractionalFontMetricsEnabled(this.getBooleanProperty("view.fracFontMetrics"));
        painter.setSelectionFgColor(this.getColorProperty("view.selectionFgColor"));
        painter.setSelectionFgColorEnabled(this.getBooleanProperty("view.selectionFg"));
        String defaultFont = this.getProperty("view.font");
        int defaultFontSize = this.getIntegerProperty("view.fontsize", 12);
        painter.setStyles(SyntaxUtilities.loadStyles(defaultFont, defaultFontSize));
        SyntaxStyle[] foldLineStyle = new SyntaxStyle[4];
        for (int i = 0; i <= 3; ++i) {
            foldLineStyle[i] = SyntaxUtilities.parseStyle(this.getProperty("view.style.foldLine." + i), defaultFont, defaultFontSize, true);
        }
        painter.setFoldLineStyle(foldLineStyle);
    }

    public String getProperty(String name) {
        return this.propertyManager.getProperty(name);
    }

    private boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, false);
    }

    private boolean getBooleanProperty(String name, boolean def) {
        String value = this.getProperty(name);
        if (value == null) {
            return def;
        }
        if ("true".equals(value) || "yes".equals(value) || "on".equals(value)) {
            return true;
        }
        if ("false".equals(value) || "no".equals(value) || "off".equals(value)) {
            return false;
        }
        return def;
    }

    private int getIntegerProperty(String name, int def) {
        String value = this.getProperty(name);
        if (value == null) {
            return def;
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException nf) {
            return def;
        }
    }

    private Font getFontProperty(String name) {
        return this.getFontProperty(name, null);
    }

    private Font getFontProperty(String name, Font def) {
        int style;
        int size;
        String family = this.getProperty(name);
        String sizeString = this.getProperty(name + "size");
        String styleString = this.getProperty(name + "style");
        if (family == null || sizeString == null || styleString == null) {
            return def;
        }
        try {
            size = Integer.parseInt(sizeString);
        }
        catch (NumberFormatException nf) {
            return def;
        }
        try {
            style = Integer.parseInt(styleString);
        }
        catch (NumberFormatException nf) {
            return def;
        }
        return new Font(family, style, size);
    }

    private Color getColorProperty(String name) {
        return this.getColorProperty(name, Color.black);
    }

    private Color getColorProperty(String name, Color def) {
        String value = this.getProperty(name);
        if (value == null) {
            return def;
        }
        return SyntaxUtilities.parseColor(value, def);
    }

    @Override
    public void propertiesChanged() {
        JEditActionSet[] actionSets;
        this.getInputHandler().removeAllKeyBindings();
        for (JEditActionSet actionSet : actionSets = this.getActionContext().getActionSets()) {
            actionSet.initKeyBindings();
        }
        Chunk.propertiesChanged(this.propertyManager);
        this.initBuffer();
        this.initTextArea();
        super.propertiesChanged();
    }

    private void initBuffer() {
        String[] bufferProperties = new String[]{"lineSeparator", "encodingAutodetect", "tabSize", "indentSize", "noTabs", "defaultMode", "undoCount", "wrap", "maxLineLen", "wordBreakChars", "noWordSep", "camelCasedWords", "folding", "collapseFolds"};
        for (int i = 0; i < bufferProperties.length; ++i) {
            String value = this.getProperty("buffer." + bufferProperties[i]);
            if (value == null) {
                this.buffer.unsetProperty(bufferProperties[i]);
                continue;
            }
            this.buffer.setProperty(bufferProperties[i], value);
        }
        this.buffer.propertiesChanged();
    }

    @Override
    public void createPopupMenu(MouseEvent evt) {
        this.popup = new JPopupMenu();
        this.addMenuItem("undo", "Undo");
        this.addMenuItem("redo", "Redo");
        this.popup.addSeparator();
        this.addMenuItem("cut", "Cut");
        this.addMenuItem("copy", "Copy");
        this.addMenuItem("paste", "Paste");
    }

    public JMenuItem addMenuItem(String action, String label) {
        final JEditBeanShellAction shellAction = this.getActionContext().getAction(action);
        if (shellAction == null) {
            return null;
        }
        JMenuItem item = new JMenuItem();
        item.setAction(new AbstractAction(label){

            @Override
            public void actionPerformed(ActionEvent e) {
                shellAction.invoke(StandaloneTextArea.this);
            }
        });
        this.popup.add(item);
        return item;
    }

    public static StandaloneTextArea createTextArea() {
        final Properties props = new Properties();
        props.putAll((Map<?, ?>)StandaloneTextArea.loadProperties("/org/gjt/sp/jedit/jedit_keys.props"));
        props.putAll((Map<?, ?>)StandaloneTextArea.loadProperties("/org/gjt/sp/jedit/jedit.props"));
        StandaloneTextArea textArea = new StandaloneTextArea(new IPropertyManager(){

            @Override
            public String getProperty(String name) {
                return props.getProperty(name);
            }
        });
        textArea.getBuffer().setProperty("folding", "explicit");
        return textArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String fileName) {
        Properties props = new Properties();
        InputStream in = TextArea.class.getResourceAsStream(fileName);
        try {
            props.load(in);
        }
        catch (IOException e) {
            Log.log(9, TextArea.class, e);
        }
        finally {
            IOUtilities.closeQuietly(in);
        }
        return props;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        StandaloneTextArea text = StandaloneTextArea.createTextArea();
        Mode mode = new Mode("xml");
        mode.setProperty("file", "modes/xml.xml");
        ModeProvider.instance.addMode(mode);
        text.getBuffer().setMode(mode);
        frame.getContentPane().add(text);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    static {
        TransferHandler.getInstance().registerTransferableService(new RichJEditTextTransferableService());
        TransferHandler.getInstance().registerTransferableService(new StringTransferableService());
    }

    protected static class StandaloneActionSet
    extends JEditActionSet<JEditBeanShellAction> {
        private final IPropertyManager iPropertyManager;
        private final TextArea textArea;

        public StandaloneActionSet(IPropertyManager iPropertyManager, TextArea textArea, URL url) {
            super(null, url);
            this.iPropertyManager = iPropertyManager;
            this.textArea = textArea;
        }

        protected JEditBeanShellAction[] getArray(int size) {
            return new JEditBeanShellAction[size];
        }

        @Override
        protected String getProperty(String name) {
            return this.iPropertyManager.getProperty(name);
        }

        @Override
        public AbstractInputHandler getInputHandler() {
            return this.textArea.getInputHandler();
        }

        @Override
        protected JEditBeanShellAction createBeanShellAction(String actionName, String code, String selected, boolean noRepeat, boolean noRecord, boolean noRememberLast) {
            return new JEditBeanShellAction(actionName, code, selected, noRepeat, noRecord, noRememberLast);
        }
    }
}

