/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.browser.VFSFileChooserDialog;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.help.HelpViewer;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.pluginmgr.KeyboardCommand;
import org.gjt.sp.jedit.pluginmgr.PluginDetailPanel;
import org.gjt.sp.jedit.pluginmgr.PluginManager;
import org.gjt.sp.jedit.pluginmgr.Roster;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ManagePanel
extends JPanel {
    private final JCheckBox hideLibraries;
    private final JTable table;
    private final JScrollPane scrollpane;
    private final PluginDetailPanel pluginDetailPanel;
    private final PluginTableModel pluginModel;
    private final PluginManager window;
    private JPopupMenu popup;
    private Set<String> selectedPlugins;
    private Set<String> jarNames;

    public ManagePanel(PluginManager window) {
        super(new BorderLayout(12, 12));
        this.window = window;
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        Box topBox = new Box(0);
        this.hideLibraries = new HideLibrariesButton();
        topBox.add(this.hideLibraries);
        this.add("North", topBox);
        this.pluginModel = new PluginTableModel();
        this.table = new JTable(this.pluginModel);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setRowHeight(this.table.getRowHeight() + 2);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 300));
        this.table.setDefaultRenderer(Object.class, new TextRenderer((DefaultTableCellRenderer)this.table.getDefaultRenderer(Object.class)));
        this.table.addFocusListener(new TableFocusHandler());
        this.table.getSelectionModel().addListSelectionListener(new TableSelectionListener());
        InputMap tableInputMap = this.table.getInputMap(0);
        ActionMap tableActionMap = this.table.getActionMap();
        tableInputMap.put(KeyStroke.getKeyStroke(9, 0), "tabOutForward");
        tableActionMap.put("tabOutForward", new KeyboardAction(KeyboardCommand.TAB_OUT_FORWARD));
        tableInputMap.put(KeyStroke.getKeyStroke(9, 1), "tabOutBack");
        tableActionMap.put("tabOutBack", new KeyboardAction(KeyboardCommand.TAB_OUT_BACK));
        tableInputMap.put(KeyStroke.getKeyStroke(32, 0), "editPlugin");
        tableActionMap.put("editPlugin", new KeyboardAction(KeyboardCommand.EDIT_PLUGIN));
        tableInputMap.put(KeyStroke.getKeyStroke(10, 0), "closePluginManager");
        tableActionMap.put("closePluginManager", new KeyboardAction(KeyboardCommand.CLOSE_PLUGIN_MANAGER));
        TableColumn col1 = this.table.getColumnModel().getColumn(0);
        TableColumn col2 = this.table.getColumnModel().getColumn(1);
        TableColumn col3 = this.table.getColumnModel().getColumn(2);
        TableColumn col4 = this.table.getColumnModel().getColumn(3);
        col1.setPreferredWidth(30);
        col1.setMinWidth(30);
        col1.setMaxWidth(30);
        col1.setResizable(false);
        col2.setPreferredWidth(300);
        col3.setPreferredWidth(100);
        col4.setPreferredWidth(100);
        JTableHeader header = this.table.getTableHeader();
        header.setReorderingAllowed(false);
        HeaderMouseHandler mouseHandler = new HeaderMouseHandler();
        header.addMouseListener(mouseHandler);
        this.table.addMouseListener(mouseHandler);
        this.scrollpane = new JScrollPane(this.table);
        this.scrollpane.getViewport().setBackground(this.table.getBackground());
        this.pluginDetailPanel = new PluginDetailPanel();
        this.scrollpane.setPreferredSize(new Dimension(400, 400));
        JSplitPane split = new JSplitPane(0, true, this.scrollpane, this.pluginDetailPanel);
        this.add("Center", split);
        split.setResizeWeight(0.75);
        Box buttons = new Box(0);
        buttons.add(new RemoveButton());
        buttons.add(new SaveButton());
        buttons.add(new RestoreButton());
        buttons.add(new FindOrphan());
        buttons.add(Box.createGlue());
        buttons.add(new HelpButton());
        this.add("South", buttons);
        this.pluginModel.update();
    }

    public void update() {
        this.pluginModel.update();
    }

    boolean loadPluginSet(String path) {
        VFS vfs = VFSManager.getVFSForPath(path);
        Object session = vfs.createVFSSession(path, this);
        try {
            InputStream is = vfs._createInputStream(session, path, false, this);
            XMLUtilities.parseXML(is, new ManagePanelRestoreHandler());
            is.close();
            int rowCount = this.pluginModel.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                Entry ent = this.pluginModel.getEntry(i);
                String name = ent.name;
                if (name != null) {
                    this.pluginModel.setValueAt(this.selectedPlugins.contains(name), i, 0);
                    continue;
                }
                String jarPath = ent.jar;
                String jarName = jarPath.substring(1 + jarPath.lastIndexOf(File.separatorChar));
                try {
                    this.pluginModel.setValueAt(this.jarNames.contains(jarName), i, 0);
                    continue;
                }
                catch (Exception e) {
                    Log.log(7, this, "Exception thrown loading: " + jarName, e);
                }
            }
        }
        catch (Exception e) {
            Log.log(9, this, "Loading Pluginset Error", e);
            return false;
        }
        this.pluginModel.update();
        return true;
    }

    private static Collection<String> getDeclaredJars(String jarName) throws IOException {
        Properties cachedProperties;
        String jars;
        ArrayList<String> jarList = new ArrayList<String>();
        PluginJAR pluginJAR = new PluginJAR(new File(jarName));
        PluginJAR.PluginCacheEntry pluginCacheEntry = PluginJAR.getPluginCache(pluginJAR);
        if (pluginCacheEntry == null) {
            pluginCacheEntry = pluginJAR.generateCache();
        }
        if ((jars = (cachedProperties = pluginCacheEntry.cachedProperties).getProperty("plugin." + pluginCacheEntry.pluginClass + ".jars")) != null) {
            String dir2 = MiscUtilities.getParentOfPath(pluginJAR.getPath());
            StringTokenizer st = new StringTokenizer(jars);
            while (st.hasMoreTokens()) {
                String _jarPath = MiscUtilities.constructPath(dir2, st.nextToken());
                if (!new File(_jarPath).exists()) continue;
                jarList.add(_jarPath);
            }
        }
        jarList.add(jarName);
        return jarList;
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int row = ManagePanel.this.table.getSelectedRow();
            if (row != -1) {
                Entry entry = ManagePanel.this.pluginModel.getEntry(row);
                ManagePanel.this.pluginDetailPanel.setPlugin(entry);
            }
        }
    }

    private class TableFocusHandler
    extends FocusAdapter {
        private TableFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent fe) {
            if (ManagePanel.this.table.getSelectedRow() == -1) {
                ManagePanel.this.table.setRowSelectionInterval(0, 0);
                JScrollBar scrollbar = ManagePanel.this.scrollpane.getVerticalScrollBar();
                scrollbar.setValue(scrollbar.getMinimum());
            }
            if (ManagePanel.this.table.getSelectedColumn() == -1) {
                ManagePanel.this.table.setColumnSelectionInterval(0, 0);
            }
        }
    }

    private class KeyboardAction
    extends AbstractAction {
        private KeyboardCommand command = KeyboardCommand.NONE;

        KeyboardAction(KeyboardCommand command) {
            this.command = command;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            switch (this.command) {
                case TAB_OUT_FORWARD: {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    break;
                }
                case TAB_OUT_BACK: {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                    break;
                }
                case EDIT_PLUGIN: {
                    int[] rows = ManagePanel.this.table.getSelectedRows();
                    for (int i = 0; i < rows.length; ++i) {
                        Object st = ManagePanel.this.pluginModel.getValueAt(rows[i], 0);
                        ManagePanel.this.pluginModel.setValueAt(st.equals(Boolean.FALSE), rows[i], 0);
                    }
                    break;
                }
                case CLOSE_PLUGIN_MANAGER: {
                    ManagePanel.this.window.ok();
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }
    }

    private class HeaderMouseHandler
    extends MouseAdapter {
        private HeaderMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getSource() == ManagePanel.this.table.getTableHeader()) {
                switch (ManagePanel.this.table.getTableHeader().columnAtPoint(evt.getPoint())) {
                    case 1: {
                        ManagePanel.this.pluginModel.setSortType(1);
                        break;
                    }
                    case 3: {
                        ManagePanel.this.pluginModel.setSortType(2);
                        break;
                    }
                }
            } else if (GUIUtilities.isPopupTrigger(evt)) {
                int row = ManagePanel.this.table.rowAtPoint(evt.getPoint());
                if (row != -1 && !ManagePanel.this.table.isRowSelected(row)) {
                    ManagePanel.this.table.setRowSelectionInterval(row, row);
                }
                if (ManagePanel.this.popup == null) {
                    ManagePanel.this.popup = new JPopupMenu();
                    JMenuItem item = GUIUtilities.loadMenuItem("plugin-manager.cleanup");
                    item.addActionListener(new CleanupActionListener());
                    ManagePanel.this.popup.add(item);
                }
                GUIUtilities.showPopupMenu(ManagePanel.this.popup, ManagePanel.this.table, evt.getX(), evt.getY());
            }
        }

        private class CleanupActionListener
        implements ActionListener {
            private CleanupActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] ints = ManagePanel.this.table.getSelectedRows();
                ArrayList<String> list = new ArrayList<String>(ints.length);
                ArrayList<Entry> entries = new ArrayList<Entry>(ints.length);
                for (int i = 0; i < ints.length; ++i) {
                    Entry entry = ManagePanel.this.pluginModel.getEntry(ints[i]);
                    if (entry.plugin == null) continue;
                    list.add(entry.name);
                    entries.add(entry);
                }
                Object[] strings = list.toArray(new String[list.size()]);
                int ret = GUIUtilities.listConfirm(ManagePanel.this, "plugin-manager.cleanup", null, strings);
                if (ret != 0) {
                    return;
                }
                for (int i = 0; i < entries.size(); ++i) {
                    Entry entry = (Entry)entries.get(i);
                    File path = entry.plugin.getPluginHome();
                    Log.log(5, this, "Removing data of plugin " + entry.name + " home=" + path);
                    FileVFS.recursiveDelete(path);
                    entry.dataSize = null;
                }
                ManagePanel.this.table.repaint();
            }
        }
    }

    private static class EntryCompare
    implements Comparator<Entry> {
        public static final int NAME = 1;
        public static final int STATUS = 2;
        private final int type;

        EntryCompare(int type) {
            this.type = type;
        }

        @Override
        public int compare(Entry e1, Entry e2) {
            if (this.type == 1) {
                return EntryCompare.compareNames(e1, e2);
            }
            int result = e1.status.compareToIgnoreCase(e2.status);
            if (result == 0) {
                return EntryCompare.compareNames(e1, e2);
            }
            return result;
        }

        private static int compareNames(Entry e1, Entry e2) {
            String s1 = e1.name == null ? MiscUtilities.getFileName(e1.jar) : e1.name;
            String s2 = e2.name == null ? MiscUtilities.getFileName(e2.jar) : e2.name;
            return s1.compareToIgnoreCase(s2);
        }
    }

    private class HelpButton
    extends JButton
    implements ListSelectionListener,
    ActionListener {
        private URL docURL;

        HelpButton() {
            super(jEdit.getProperty("manage-plugins.help"));
            ManagePanel.this.table.getSelectionModel().addListSelectionListener(this);
            this.addActionListener(this);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new HelpViewer(this.docURL);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (ManagePanel.this.table.getSelectedRowCount() == 1) {
                try {
                    Entry entry = ManagePanel.this.pluginModel.getEntry(ManagePanel.this.table.getSelectedRow());
                    String label = entry.clazz;
                    String docs = entry.docs;
                    if (label != null) {
                        URL url;
                        EditPlugin plug = jEdit.getPlugin(label, false);
                        PluginJAR jar = null;
                        if (plug != null) {
                            jar = plug.getPluginJAR();
                        }
                        if (jar != null && docs != null && (url = jar.getClassLoader().getResource(docs)) != null) {
                            this.docURL = url;
                            this.setEnabled(true);
                            return;
                        }
                    }
                }
                catch (Exception ex) {
                    Log.log(9, this, "ManagePanel HelpButton Update", ex);
                }
            }
            this.setEnabled(false);
        }
    }

    private class FindOrphan
    extends JButton
    implements ActionListener {
        private FindOrphan() {
            super(jEdit.getProperty("plugin-manager.findOrphan.label"));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList mustRemove;
            PluginJAR[] pluginJARs = jEdit.getPluginJARs();
            HashSet<String> neededJars = new HashSet<String>();
            HashMap<String, String> jarlibs = new HashMap<String, String>();
            for (PluginJAR pluginJAR : pluginJARs) {
                EditPlugin plugin = pluginJAR.getPlugin();
                if (plugin == null) {
                    jarlibs.put(new File(pluginJAR.getPath()).getName(), pluginJAR.getPath());
                    continue;
                }
                Set<String> strings = plugin.getPluginJAR().getRequiredJars();
                for (String string : strings) {
                    neededJars.add(new File(string).getName());
                }
            }
            String[] notLoadedJars = jEdit.getNotLoadedPluginJARs();
            for (int i = 0; i < notLoadedJars.length; ++i) {
                PluginJAR pluginJAR = new PluginJAR(new File(notLoadedJars[i]));
                PluginJAR.PluginCacheEntry pluginCacheEntry = PluginJAR.getPluginCache(pluginJAR);
                try {
                    if (pluginCacheEntry == null) {
                        pluginCacheEntry = pluginJAR.generateCache();
                    }
                    if (pluginCacheEntry.pluginClass == null) {
                        jarlibs.put(new File(notLoadedJars[i]).getName(), notLoadedJars[i]);
                        continue;
                    }
                    Properties cachedProperties = pluginCacheEntry.cachedProperties;
                    String jars = cachedProperties.getProperty("plugin." + pluginCacheEntry.pluginClass + ".jars");
                    if (jars == null) continue;
                    StringTokenizer st = new StringTokenizer(jars);
                    while (st.hasMoreTokens()) {
                        neededJars.add(st.nextToken());
                    }
                    continue;
                }
                catch (IOException e1) {
                    Log.log(9, this, e);
                }
            }
            ArrayList<String> removingJars = new ArrayList<String>();
            Set jarlibsKeys = jarlibs.keySet();
            for (String jar : jarlibsKeys) {
                if (neededJars.contains(jar)) continue;
                removingJars.add(jar);
                Log.log(3, this, "It seems that this jar do not belong to any plugin " + jar);
            }
            if (removingJars.isEmpty()) {
                GUIUtilities.message(ManagePanel.this, "plugin-manager.noOrphan", null);
                return;
            }
            Object[] strings = removingJars.toArray(new String[removingJars.size()]);
            int ret = GUIUtilities.listConfirm(ManagePanel.this, "plugin-manager.findOrphan", null, strings, mustRemove = new ArrayList());
            if (ret != 0 || mustRemove.isEmpty()) {
                return;
            }
            Roster roster = new Roster();
            for (int i = 0; i < mustRemove.size(); ++i) {
                String entry = (String)mustRemove.get(i);
                roster.addRemove((String)jarlibs.get(entry));
            }
            roster.performOperationsInAWTThread(ManagePanel.this.window);
            ManagePanel.this.pluginModel.update();
            if (ManagePanel.this.table.getRowCount() != 0) {
                ManagePanel.this.table.setRowSelectionInterval(0, 0);
            }
            ManagePanel.this.table.setColumnSelectionInterval(0, 0);
            JScrollBar scrollbar = ManagePanel.this.scrollpane.getVerticalScrollBar();
            scrollbar.setValue(scrollbar.getMinimum());
            ManagePanel.this.table.repaint();
        }
    }

    private class RemoveButton
    extends JButton
    implements ListSelectionListener,
    ActionListener {
        RemoveButton() {
            super(jEdit.getProperty("manage-plugins.remove"));
            ManagePanel.this.table.getSelectionModel().addListSelectionListener(this);
            this.addActionListener(this);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int[] selected = ManagePanel.this.table.getSelectedRows();
            LinkedList<String> listModel = new LinkedList<String>();
            Roster roster = new Roster();
            HashSet<String> jarsToRemove = new HashSet<String>();
            HashSet<String> loadedJarsToRemove = new HashSet<String>();
            for (int i = 0; i < selected.length; ++i) {
                Entry entry = ManagePanel.this.pluginModel.getEntry(selected[i]);
                if (entry.status.equals("not-loaded")) {
                    if (entry.jar != null) {
                        try {
                            Collection jarList = ManagePanel.getDeclaredJars(entry.jar);
                            jarsToRemove.addAll(jarList);
                        }
                        catch (IOException e) {
                            Log.log(9, this, e);
                        }
                    }
                } else {
                    jarsToRemove.addAll(entry.jars);
                    loadedJarsToRemove.addAll(entry.jars);
                }
                ManagePanel.this.table.getSelectionModel().removeSelectionInterval(selected[i], selected[i]);
            }
            for (String jar : jarsToRemove) {
                listModel.add(jar);
                roster.addRemove(jar);
            }
            int button = GUIUtilities.listConfirm(ManagePanel.this.window, "plugin-manager.remove-confirm", null, listModel.toArray());
            if (button == 0) {
                ArrayList<String> closureSet = new ArrayList<String>();
                PluginJAR.transitiveClosure(loadedJarsToRemove.toArray(new String[loadedJarsToRemove.size()]), closureSet);
                closureSet.removeAll(listModel);
                if (closureSet.isEmpty()) {
                    button = 0;
                } else {
                    button = GUIUtilities.listConfirm(ManagePanel.this.window, "plugin-manager.remove-dependencies", null, closureSet.toArray());
                    Collections.sort(closureSet, new StandardUtilities.StringCompare(true));
                }
                if (button == 0) {
                    for (String jarName : closureSet) {
                        PluginJAR pluginJAR = jEdit.getPluginJAR(jarName);
                        jEdit.removePluginJAR(pluginJAR, false);
                    }
                    roster.performOperationsInAWTThread(ManagePanel.this.window);
                    ManagePanel.this.pluginModel.update();
                    if (ManagePanel.this.table.getRowCount() != 0) {
                        ManagePanel.this.table.setRowSelectionInterval(0, 0);
                    }
                    ManagePanel.this.table.setColumnSelectionInterval(0, 0);
                    JScrollBar scrollbar = ManagePanel.this.scrollpane.getVerticalScrollBar();
                    scrollbar.setValue(scrollbar.getMinimum());
                }
            }
            PluginManager.getInstance().pluginRemoved();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (ManagePanel.this.table.getSelectedRowCount() == 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class SaveButton
    extends RolloverButton
    implements ActionListener {
        SaveButton() {
            this.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("manage-plugins.save.icon")));
            this.setToolTipText("Save Currently Checked Plugins Set");
            this.addActionListener(this);
            this.setEnabled(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void saveState(String vfsURL, List<Entry> pluginList) {
            StringBuilder sb = new StringBuilder("<pluginset>\n ");
            for (Entry entry : pluginList) {
                String jarName = entry.jar.substring(1 + entry.jar.lastIndexOf(File.separatorChar));
                sb.append("   <plugin name=\"").append(entry.name).append("\" jar=\"");
                sb.append(jarName).append("\" />\n ");
            }
            sb.append("</pluginset>\n");
            VFS vfs = VFSManager.getVFSForPath(vfsURL);
            Object session = vfs.createVFSSession(vfsURL, ManagePanel.this);
            BufferedWriter writer = null;
            try {
                OutputStream os = vfs._createOutputStream(session, vfsURL, ManagePanel.this);
                writer = new BufferedWriter(new OutputStreamWriter(os));
                writer.write(sb.toString());
                IOUtilities.closeQuietly(writer);
            }
            catch (Exception e) {
                Log.log(9, this, "Saving State Error", e);
            }
            finally {
                IOUtilities.closeQuietly(writer);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PluginJAR[] jars;
            String path = jEdit.getProperty("plugin-manager.pluginset.path", jEdit.getSettingsDirectory() + File.separator);
            VFSFileChooserDialog fileChooser = new VFSFileChooserDialog(ManagePanel.this.window, jEdit.getActiveView(), path, 1, false, true);
            String[] fileselections = fileChooser.getSelectedFiles();
            ArrayList<Entry> pluginSelections = new ArrayList<Entry>();
            if (fileselections == null || fileselections.length != 1) {
                return;
            }
            for (PluginJAR jar : jars = jEdit.getPluginJARs()) {
                if (jar.getPlugin() == null) continue;
                Entry entry = new Entry(jar);
                pluginSelections.add(entry);
            }
            this.saveState(fileselections[0], pluginSelections);
            jEdit.setProperty("plugin-manager.pluginset.path", fileselections[0]);
            EditBus.send(new PropertiesChanged(PluginManager.getInstance()));
        }
    }

    private class RestoreButton
    extends RolloverButton
    implements ActionListener {
        RestoreButton() {
            this.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("manage-plugins.restore.icon")));
            this.addActionListener(this);
            this.setToolTipText("Choose a PluginSet, select/deselect plugins based on set.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String path = jEdit.getProperty("plugin-manager.pluginset.path", jEdit.getSettingsDirectory() + File.separator);
            String[] selectedFiles = GUIUtilities.showVFSFileDialog(ManagePanel.this.window, jEdit.getActiveView(), path, 0, false);
            if (selectedFiles == null || selectedFiles.length != 1) {
                return;
            }
            path = selectedFiles[0];
            boolean success = ManagePanel.this.loadPluginSet(path);
            if (success) {
                jEdit.setProperty("plugin-manager.pluginset.path", path);
                EditBus.send(new PropertiesChanged(PluginManager.getInstance()));
            }
        }
    }

    private class HideLibrariesButton
    extends JCheckBox
    implements ActionListener {
        HideLibrariesButton() {
            super(jEdit.getProperty("plugin-manager.hide-libraries"));
            this.setSelected(jEdit.getBooleanProperty("plugin-manager.hide-libraries.toggle"));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            jEdit.setBooleanProperty("plugin-manager.hide-libraries.toggle", this.isSelected());
            ManagePanel.this.update();
        }
    }

    private class TextRenderer
    extends DefaultTableCellRenderer {
        private final DefaultTableCellRenderer tcr;

        TextRenderer(DefaultTableCellRenderer tcr) {
            this.tcr = tcr;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Entry entry = ManagePanel.this.pluginModel.getEntry(row);
            if (entry.status.equals("error")) {
                this.tcr.setForeground(Color.red);
            } else {
                this.tcr.setForeground(UIManager.getColor("Table.foreground"));
            }
            return this.tcr.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        }
    }

    private class PluginTableModel
    extends AbstractTableModel {
        private final List<Entry> entries = new ArrayList<Entry>();
        private int sortType = 1;
        private ConcurrentHashMap<String, Object> unloaded;

        PluginTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return jEdit.getProperty("manage-plugins.info.name");
                }
                case 2: {
                    return jEdit.getProperty("manage-plugins.info.version");
                }
                case 3: {
                    return jEdit.getProperty("manage-plugins.info.status");
                }
                case 4: {
                    return jEdit.getProperty("manage-plugins.info.data");
                }
            }
            throw new Error("Column out of range");
        }

        public Entry getEntry(int rowIndex) {
            return this.entries.get(rowIndex);
        }

        @Override
        public int getRowCount() {
            return this.entries.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Entry entry = this.entries.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return !entry.status.equals("not-loaded");
                }
                case 1: {
                    if (entry.name == null) {
                        return MiscUtilities.getFileName(entry.jar);
                    }
                    return entry.name;
                }
                case 2: {
                    return entry.version;
                }
                case 3: {
                    return jEdit.getProperty("plugin-manager.status." + entry.status);
                }
                case 4: {
                    if (entry.dataSize == null && entry.plugin != null) {
                        File pluginDirectory = entry.plugin.getPluginHome();
                        if (null == pluginDirectory) {
                            return null;
                        }
                        entry.dataSize = pluginDirectory.exists() ? StandardUtilities.formatFileSize(IOUtilities.fileLength(pluginDirectory)) : (jEdit.getBooleanProperty("plugin." + entry.clazz + ".usePluginHome") ? StandardUtilities.formatFileSize(0L) : jEdit.getProperty("manage-plugins.data-size.unknown"));
                    }
                    return entry.dataSize;
                }
            }
            throw new Error("Column out of range");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            Entry entry = this.entries.get(rowIndex);
            if (columnIndex == 0) {
                PluginJAR jar = jEdit.getPluginJAR(entry.jar);
                if (jar == null) {
                    if (value.equals(Boolean.FALSE)) {
                        return;
                    }
                    PluginJAR.load(entry.jar, true);
                } else {
                    if (value.equals(Boolean.TRUE)) {
                        return;
                    }
                    this.unloadPluginJARWithDialog(jar);
                }
            }
            this.update();
        }

        public void setSortType(int type) {
            this.sortType = type;
            this.sort(type);
        }

        public void sort(int type) {
            ArrayList<String> savedSelection = new ArrayList<String>();
            this.saveSelection(savedSelection);
            Collections.sort(this.entries, new EntryCompare(type));
            this.fireTableChanged(new TableModelEvent(this));
            this.restoreSelection(savedSelection);
        }

        public void update() {
            Entry e;
            ArrayList<String> savedSelection = new ArrayList<String>();
            this.saveSelection(savedSelection);
            this.entries.clear();
            String systemJarDir = MiscUtilities.constructPath(jEdit.getJEditHome(), "jars");
            String settingsDirectory = jEdit.getSettingsDirectory();
            String userJarDir = settingsDirectory == null ? null : MiscUtilities.constructPath(settingsDirectory, "jars");
            PluginJAR[] plugins = jEdit.getPluginJARs();
            for (int i = 0; i < plugins.length; ++i) {
                String path = plugins[i].getPath();
                if (!path.startsWith(systemJarDir) && (userJarDir == null || !path.startsWith(userJarDir))) continue;
                e = new Entry(plugins[i]);
                if (ManagePanel.this.hideLibraries.isSelected() && e.clazz == null) continue;
                this.entries.add(e);
            }
            String[] newPlugins = jEdit.getNotLoadedPluginJARs();
            for (int i = 0; i < newPlugins.length; ++i) {
                e = new Entry(newPlugins[i]);
                this.entries.add(e);
            }
            this.sort(this.sortType);
            this.restoreSelection(savedSelection);
        }

        private void unloadPluginJARWithDialog(PluginJAR jar) {
            this.unloaded = new ConcurrentHashMap();
            String[] dependents = jar.getDependentPlugins();
            if (dependents.length == 0) {
                this.unloadPluginJAR(jar);
            } else {
                LinkedList<String> closureSet = new LinkedList<String>();
                PluginJAR.transitiveClosure(dependents, closureSet);
                ArrayList<String> listModel = new ArrayList<String>();
                listModel.addAll(closureSet);
                Collections.sort(listModel, new StandardUtilities.StringCompare(true));
                int button = GUIUtilities.listConfirm(ManagePanel.this.window, "plugin-manager.dependency", new String[]{jar.getFile().getName()}, listModel.toArray());
                if (button == 0) {
                    this.unloadPluginJAR(jar);
                }
            }
        }

        private void unloadPluginJAR(PluginJAR jar) {
            String[] dependents;
            for (String dependent : dependents = jar.getDependentPlugins()) {
                if (this.unloaded.containsKey(dependent)) continue;
                this.unloaded.put(dependent, Boolean.TRUE);
                PluginJAR _jar = jEdit.getPluginJAR(dependent);
                if (_jar == null) continue;
                this.unloadPluginJAR(_jar);
            }
            jEdit.removePluginJAR(jar, false);
            jEdit.setBooleanProperty("plugin-blacklist." + MiscUtilities.getFileName(jar.getPath()), true);
            jEdit.propertiesChanged();
        }

        public void saveSelection(List<String> savedSelection) {
            if (ManagePanel.this.table != null) {
                int[] rows = ManagePanel.this.table.getSelectedRows();
                for (int i = 0; i < rows.length; ++i) {
                    savedSelection.add(this.entries.get((int)rows[i]).jar);
                }
            }
        }

        public void restoreSelection(List<String> savedSelection) {
            if (null != ManagePanel.this.table) {
                ManagePanel.this.table.setColumnSelectionInterval(0, 0);
                if (!savedSelection.isEmpty()) {
                    int i;
                    int rowCount = this.getRowCount();
                    for (i = 0; i < rowCount; ++i) {
                        if (!savedSelection.contains(this.entries.get((int)i).jar)) continue;
                        ManagePanel.this.table.setRowSelectionInterval(i, i);
                        break;
                    }
                    ListSelectionModel lsm = ManagePanel.this.table.getSelectionModel();
                    while (i < rowCount) {
                        if (savedSelection.contains(this.entries.get((int)i).jar)) {
                            lsm.addSelectionInterval(i, i);
                        }
                        ++i;
                    }
                } else {
                    if (ManagePanel.this.table.getRowCount() != 0) {
                        ManagePanel.this.table.setRowSelectionInterval(0, 0);
                    }
                    JScrollBar scrollbar = ManagePanel.this.scrollpane.getVerticalScrollBar();
                    scrollbar.setValue(scrollbar.getMinimum());
                }
            }
        }
    }

    static class Entry {
        static final String ERROR = "error";
        static final String LOADED = "loaded";
        static final String NOT_LOADED = "not-loaded";
        final String status;
        final String jar;
        String clazz;
        String name;
        String version;
        String author;
        String docs;
        String description;
        EditPlugin plugin;
        final List<String> jars = new LinkedList<String>();
        String dataSize;

        Entry(String jar) {
            this.jar = jar;
            this.jars.add(this.jar);
            this.status = NOT_LOADED;
        }

        Entry(PluginJAR jar) {
            this.jar = jar.getPath();
            this.jars.add(this.jar);
            this.plugin = jar.getPlugin();
            if (this.plugin != null) {
                String filesProp;
                this.status = this.plugin instanceof EditPlugin.Broken ? ERROR : LOADED;
                this.clazz = this.plugin.getClassName();
                this.name = jEdit.getProperty("plugin." + this.clazz + ".name");
                this.version = jEdit.getProperty("plugin." + this.clazz + ".version");
                this.author = jEdit.getProperty("plugin." + this.clazz + ".author");
                this.docs = jEdit.getProperty("plugin." + this.clazz + ".docs");
                this.description = jEdit.getProperty("plugin." + this.clazz + ".description");
                String jarsProp = jEdit.getProperty("plugin." + this.clazz + ".jars");
                if (jarsProp != null) {
                    String directory = MiscUtilities.getParentOfPath(this.jar);
                    StringTokenizer st = new StringTokenizer(jarsProp);
                    while (st.hasMoreElements()) {
                        this.jars.add(MiscUtilities.constructPath(directory, st.nextToken()));
                    }
                }
                if ((filesProp = jEdit.getProperty("plugin." + this.clazz + ".files")) != null) {
                    String directory = MiscUtilities.getParentOfPath(this.jar);
                    StringTokenizer st = new StringTokenizer(filesProp);
                    while (st.hasMoreElements()) {
                        this.jars.add(MiscUtilities.constructPath(directory, st.nextToken()));
                    }
                }
            } else {
                this.status = LOADED;
            }
        }
    }

    private class ManagePanelRestoreHandler
    extends DefaultHandler {
        ManagePanelRestoreHandler() {
            ManagePanel.this.selectedPlugins = new HashSet();
            ManagePanel.this.jarNames = new HashSet();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (localName.equals("plugin")) {
                String jarName = attrs.getValue("jar");
                String name = attrs.getValue("name");
                ManagePanel.this.selectedPlugins.add(name);
                ManagePanel.this.jarNames.add(jarName);
            }
        }
    }
}

