/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.help.HelpIndex;
import org.gjt.sp.jedit.help.HelpViewerInterface;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;

public class HelpSearchPanel
extends JPanel {
    private HelpViewerInterface helpViewer;
    private HistoryTextField searchField;
    private JList results;
    private HelpIndex index;

    public HelpSearchPanel(HelpViewerInterface helpViewer) {
        super(new BorderLayout(6, 6));
        this.helpViewer = helpViewer;
        Box box = new Box(0);
        box.add(new JLabel(jEdit.getProperty("helpviewer.search.caption")));
        box.add(Box.createHorizontalStrut(6));
        this.searchField = new HistoryTextField("helpviewer.search");
        box.add(this.searchField);
        this.searchField.addActionListener(new ActionHandler());
        this.add("North", box);
        this.results = new JList();
        this.results.addMouseListener(new MouseHandler());
        this.results.setSelectionMode(0);
        this.results.setCellRenderer(new ResultRenderer());
        this.add("Center", new JScrollPane(this.results));
    }

    private HelpIndex getHelpIndex() {
        if (this.index == null) {
            this.index = new HelpIndex();
            try {
                this.index.indexEditorHelp();
            }
            catch (Exception e) {
                this.index = null;
                Log.log(9, this, e);
                GUIUtilities.error(this.helpViewer.getComponent(), "helpviewer.search.error", new String[]{e.toString()});
            }
        }
        return this.index;
    }

    public class MouseHandler
    extends MouseAdapter {
        @Override
        public void mouseReleased(MouseEvent evt) {
            int row = HelpSearchPanel.this.results.locationToIndex(evt.getPoint());
            if (row != -1) {
                Result result = (Result)HelpSearchPanel.this.results.getModel().getElementAt(row);
                HelpSearchPanel.this.helpViewer.gotoURL(result.file, true, 0);
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            final HelpIndex index = HelpSearchPanel.this.getHelpIndex();
            if (index == null) {
                return;
            }
            HelpSearchPanel.this.results.setListData(new String[]{jEdit.getProperty("helpviewer.searching")});
            final String text = HelpSearchPanel.this.searchField.getText();
            final Vector resultModel = new Vector();
            ThreadUtilities.runInBackground(new Runnable(){

                @Override
                public void run() {
                    StringTokenizer st = new StringTokenizer(text, ",.;:-? ");
                    int maxRank = 0;
                    while (st.hasMoreTokens()) {
                        String word = st.nextToken().toLowerCase();
                        HelpIndex.Word lookup = index.lookupWord(word);
                        if (lookup == null) continue;
                        for (int i = 0; i < lookup.occurCount; ++i) {
                            HelpIndex.Word.Occurrence occur = lookup.occurrences[i];
                            boolean ok = false;
                            HelpIndex.HelpFile file = index.getFile(occur.file);
                            for (int j = 0; j < resultModel.size(); ++j) {
                                Result result = (Result)resultModel.elementAt(j);
                                if (!result.file.equals(file.file)) continue;
                                result.rank += occur.count;
                                result.rank += 20;
                                maxRank = Math.max(result.rank, maxRank);
                                ok = true;
                                break;
                            }
                            if (ok) continue;
                            maxRank = Math.max(occur.count, maxRank);
                            resultModel.addElement(new Result(file, occur.count));
                        }
                    }
                    if (maxRank != 0) {
                        for (int i = 0; i < resultModel.size(); ++i) {
                            Result result = (Result)resultModel.elementAt(i);
                            result.rank = (int)Math.ceil((double)result.rank * 4.0 / (double)maxRank);
                        }
                        Collections.sort(resultModel, new ResultCompare());
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (resultModel.isEmpty()) {
                                HelpSearchPanel.this.results.setListData(new String[]{jEdit.getProperty("helpviewer.no-results")});
                                HelpSearchPanel.this.getToolkit().beep();
                            } else {
                                HelpSearchPanel.this.results.setListData(resultModel);
                            }
                        }
                    });
                }
            });
        }
    }

    static class ResultCompare
    implements Comparator<Result> {
        ResultCompare() {
        }

        @Override
        public int compare(Result r1, Result r2) {
            if (r1.rank == r2.rank) {
                return r1.title.compareTo(r2.title);
            }
            return r2.rank - r1.rank;
        }
    }

    static class Result {
        String file;
        String title;
        int rank;

        Result(HelpIndex.HelpFile file, int count) {
            this.file = file.file;
            this.title = file.title;
            this.rank = count;
        }
    }

    static class ResultRenderer
    extends DefaultListCellRenderer {
        ResultRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, (Object)null, index, isSelected, cellHasFocus);
            if (value instanceof String) {
                this.setIcon(null);
                this.setText((String)value);
            } else {
                Result result = (Result)value;
                this.setIcon(new ResultIcon(result.rank));
                this.setText(result.title);
            }
            return this;
        }
    }

    static class ResultIcon
    implements Icon {
        private static RenderingHints renderingHints;
        private int rank;

        ResultIcon(int rank) {
            this.rank = rank;
        }

        @Override
        public int getIconWidth() {
            return 40;
        }

        @Override
        public int getIconHeight() {
            return 9;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHints(renderingHints);
            for (int i = 0; i < 4; ++i) {
                if (this.rank > i) {
                    g2d.setColor(UIManager.getColor("Label.foreground"));
                } else {
                    g2d.setColor(UIManager.getColor("Label.disabledForeground"));
                }
                g2d.fillOval(x + i * 10, y, 9, 9);
            }
        }

        static {
            HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
            hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderingHints = new RenderingHints(hints);
        }
    }
}

